/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2005 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>

#include <qstring.h>
#include <qapplication.h>
#include <qfile.h>
#include <qmetaobject.h>

#include <kapplication.h>
#include <klocale.h>
#include <ktempfile.h>
#include <kdebug.h>
#include <kurl.h>
#include <kio/job.h>
#include <kio/scheduler.h>

#include "netaccess.h"

using namespace KIO;

QString * NetAccess::lastErrorMsg;
int NetAccess::lastErrorCode = 0;

bool NetAccess::download( const KURL &url, QString &target, QWidget * )
{
    if ( !url.isLocalFile() )
        return false;

    target = url.path();
    return true;
}

void NetAccess::removeTempFile( const QString & )
{
    // ###
}

QString NetAccess::lastErrorString()
{
    return QString::null;
}

bool NetAccess::synchronousRun( Job* job, QWidget* window, QByteArray* data,
                                KURL* finalURL, QMap<QString, QString>* metaData )
{
  NetAccess kioNet;
  return kioNet.synchronousRunInternal( job, window, data, finalURL, metaData );
}


#include "jobclasses.h"

bool NetAccess::synchronousRunInternal( Job* job, QWidget* window, QByteArray* data,
                                        KURL* finalURL, QMap<QString,QString>* metaData )
{
  job->setWindow( window );

  m_metaData = metaData;
  if ( m_metaData ) {
      for ( QMap<QString, QString>::iterator it = m_metaData->begin(); it != m_metaData->end(); ++it ) {
          job->addMetaData(it.key(), it.data() );
      }
  }

  if ( finalURL ) {
      SimpleJob *sj = dynamic_cast<SimpleJob*>( job );
      if ( sj ) {
          m_url = sj->url();
      }
  }

  connect( job, SIGNAL( result (KIO::Job *) ),
           this, SLOT( slotResult (KIO::Job *) ) );

  QMetaObject *meta = job->metaObject();

  static const char dataSignal[] = "data(KIO::Job*,const QByteArray&)";
  if ( meta->findSignal( dataSignal ) != -1 ) {
      connect( job, SIGNAL(data(KIO::Job*,const QByteArray&)),
               this, SLOT(slotData(KIO::Job*,const QByteArray&)) );
  }

  static const char redirSignal[] = "redirection(KIO::Job*,const KURL&)";
  if ( meta->findSignal( redirSignal ) != -1 ) {
      connect( job, SIGNAL(redirection(KIO::Job*,const KURL&)),
               this, SLOT(slotRedirection(KIO::Job*, const KURL&)) );
  }

  enter_loop();

  if ( finalURL )
      *finalURL = m_url;
  if ( data )
      *data = m_data;

  return bJobOK;
}

// If a troll sees this, he kills me
void qt_enter_modal( QWidget *widget );
void qt_leave_modal( QWidget *widget );

void NetAccess::enter_loop()
{
  QWidget dummy(0,0,WType_Dialog | WShowModal);
  dummy.setFocusPolicy( QWidget::NoFocus );
  qt_enter_modal(&dummy);
  qApp->enter_loop();
  qt_leave_modal(&dummy);
}

void NetAccess::slotResult( KIO::Job * job )
{
  lastErrorCode = job->error();
  bJobOK = !job->error();
  if ( !bJobOK )
  {
    if ( !lastErrorMsg )
      lastErrorMsg = new QString;
    *lastErrorMsg = job->errorString();
  }
  if ( job->isA("KIO::StatJob") )
    m_entry = static_cast<KIO::StatJob *>(job)->statResult();

  if ( m_metaData )
    *m_metaData = job->metaData();

  qApp->exit_loop();
}

void NetAccess::slotData( KIO::Job*, const QByteArray& data )
{
  if ( data.isEmpty() )
    return;

  unsigned offset = m_data.size();
  m_data.resize( offset + data.size() );
  memcpy( m_data.data() + offset, data.data(), data.size() );
}

void NetAccess::slotRedirection( KIO::Job*, const KURL& url )
{
  m_url = url;
}


#include "netaccess.moc"

