

#ifndef DESKTOP_VERSION
#include <qpe/qpeapplication.h>
#include <qpe/global.h>
#else
#include <qapplication.h>
#include <qstring.h>
#include <qwindowsstyle.h> 
#include <qplatinumstyle.h> 
#include <qsgistyle.h> 
#endif

#include <qdir.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <stdio.h>
#include "mainwindow.h"

int main( int argc, char **argv )
{
#ifndef DESKTOP_VERSION
  QPEApplication a( argc, argv );
  a.setKeepRunning ();
#else
  QApplication a( argc, argv ); 
  QApplication::setStyle( new QPlatinumStyle ());
#endif
  bool exitHelp = false;
  if ( argc > 1 ) {
      QString command = argv[1];
      if (  command == "-help" ){
          printf("KO/E command line commands:\n");
          printf("  no command: Start KO/E in usual way\n");
          printf("  -help: This output\n");
          printf("Next Option: Open or Show after start:\n");
          printf("  -newTodo: New Todo dialog\n");
          printf("  -newEvent: New Event dialog\n");
          printf("  -showList: List view\n");
          printf("  -showDay: Day view\n");
          printf("  -showWWeek: Work Week view\n");
          printf("  -showWeek: Week view\n");
          printf("  -showTodo: Todo view\n");
          printf("  -showJournal: Journal view\n");
          printf("  -showKO: Next Days view\n");
          printf("  -showWNext: What's Next view\n");  
          printf("  -showNextXView: Next X View\n");
          printf(" -new[Y] and -show[X] may be used togehther\n");
          printf(" KO/E is exiting now. Bye!\n");
          exitHelp = true;
      }
  }
  if ( ! exitHelp ) {
      KGlobal::setAppName( "korganizer" );
#ifndef DESKTOP_VERSION
      KStandardDirs::setAppDir( Global::applicationFileName( "korganizer", "" ) );  
#else
      QString appdir = QDir::homeDirPath();
      //appdir = "C:\\";
      if ( appdir.right(1) == "\\" ||   appdir.right(1) == "/" )
          appdir += "korganizer/";
      else
          appdir += "/korganizer/";
      KStandardDirs::setAppDir( QDir::convertSeparators( appdir ));
      //     qDebug(" %s  ",KStandardDirs::appDir().latin1() );
#endif 
       QDir app_dir;
       if ( !app_dir.exists(KStandardDirs::appDir()) )
           app_dir.mkdir (KStandardDirs::appDir());
       MainWindow m;
      QObject::connect( &a, SIGNAL (appMessage ( const QCString &, const QByteArray & )),&m, SLOT(recieve(  const QCString&, const QByteArray& )));

#ifndef DESKTOP_VERSION
      a.showMainWidget(&m );
#else
      a.setMainWidget(&m );
      m.show();
      //m.resize( 800, 600 );
      QObject::connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
#endif
      if ( argc > 1 ) {
          QCString command = argv[1];
          if ( argc > 2 )
              command += argv[2];
          qApp->processEvents();
          m.recieve(command,  QByteArray() );
          
      }
      a.exec();

  }
  qDebug("KO: Bye! ");
}
