#include <stdlib.h>

#include <qaction.h>
#include <qpopupmenu.h>
#include <qpainter.h>
#include <qwhatsthis.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qfile.h>
#include <qdir.h>
#include <qapp.h>
#include <qfileinfo.h>
#include <qlabel.h>
#include <qwmatrix.h> 
#include <qtextbrowser.h> 
#include <qtextstream.h> 
#ifndef DESKTOP_VERSION
#include <qpe/global.h>
#include <qpe/qpemenubar.h>
#include <qpe/qpetoolbar.h>
#include <qpe/resource.h>
#include <qpe/qpeapplication.h>
#include <qtopia/alarmserver.h> 
#include <qtopia/qcopenvelope_qws.h> 
#else
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qapplication.h>
//#include <resource.h>

#endif
#include <libkcal/calendarlocal.h>
#include <libkcal/todo.h>
#include <libkdepim/ksyncprofile.h>
#include <libkdepim/kincidenceformatter.h>

#include "calendarview.h"
#include "koviewmanager.h"
#include "datenavigator.h"
#include "koagendaview.h"
#include "koagenda.h"
#include "kodialogmanager.h"
#include "kdialogbase.h"
#include "kstandarddirs.h"
#include "koprefs.h"
#include "kfiledialog.h"
#include "koglobals.h"
#include "kglobal.h"
#include "klocale.h"
#include "kconfig.h"
#include "simplealarmclient.h"

using namespace KCal; 
#ifndef _WIN32_
#include <unistd.h>
#endif
#include "mainwindow.h"

int globalFlagBlockStartup;
MainWindow::MainWindow( QWidget *parent, const char *name, QString msg) :
    QMainWindow( parent, name )
{

#ifdef DESKTOP_VERSION
    setFont( QFont("Arial"), 14 );
#endif 

    QString confFile = KStandardDirs::appDir() + "config_korganizerrc";
    QFileInfo finf ( confFile ); 
    bool showWarning =  !finf.exists();
    setIcon(SmallIcon( "ko24" )  );
    mBlockAtStartup = true;
    mFlagKeyPressed = false;
    setCaption("KOrganizer/Pi");
    KOPrefs *p = KOPrefs::instance();
   //  if ( QApplication::desktop()->height() > 480 ) {
//         if ( p->mHourSize == 4 )
//             p->mHourSize = 6;
//     }  
    if ( p->mHourSize >  18 )
        p->mHourSize = 18;
    QMainWindow::ToolBarDock tbd;
    if ( p->mToolBarHor ) {
        if ( p->mToolBarUp )
            tbd = Bottom;
        else
            tbd = Top;
    }
    else {
        if ( p->mToolBarUp )
            tbd = Right;
        else
            tbd = Left;
    }
    if ( KOPrefs::instance()->mUseAppColors )
        QApplication::setPalette( QPalette (KOPrefs::instance()->mAppColor1, KOPrefs::instance()->mAppColor2), true );
    globalFlagBlockStartup = 1;
    iconToolBar = new QPEToolBar( this );
    addToolBar (iconToolBar , tbd );
    mBlockSaveFlag = false;
    mCalendarModifiedFlag = false;  
 
    QLabel* splash  = new QLabel(i18n("KO/Pi is starting ... "), this );
    splash->setAlignment ( AlignCenter );
    setCentralWidget( splash );
#ifndef DESKTOP_VERSION
    showMaximized();
#endif
    //qDebug("Mainwidget x %d y %d w %d  h %d",  x(), y(), width(), height ());
    setDefaultPreferences();
    mCalendar = new CalendarLocal();
    mView = new CalendarView( mCalendar, this,"mCalendar " );
    mView->hide();
    //mView->resize(splash->size() );
    initActions(); 
#ifndef DESKTOP_VERSION
    iconToolBar->show(); 
    qApp->processEvents();
#endif
    //qDebug("Splashwidget x %d y %d w %d  h %d", splash-> x(), splash->y(), splash->width(),splash-> height ());
    int vh = height() ;
    int vw = width();
    //qDebug("Toolbar hei %d ",iconToolBar->height() );
    if ( iconToolBar->orientation () == Qt:: Horizontal ) {
        vh -=  iconToolBar->height();
    } else {
        vw -= iconToolBar->height();
    }
    //mView->setMaximumSize( splash->size() );
    //mView->resize( splash->size() );
    //qDebug("MainView x %d y %d w %d  h %d",  mView->x(),mView-> y(), mView->width(), mView->height ());
    mView->readSettings(); 
    bool newFile = false;
    if( !QFile::exists( defaultFileName() ) ) {
        mView->saveCalendar( defaultFileName() );
        newFile = true;
    }

    QTime neededSaveTime = QDateTime::currentDateTime().time();
    mView->openCalendar( defaultFileName() );
    int msNeeded = neededSaveTime.msecsTo( QDateTime::currentDateTime().time() );
    qDebug("KO: Calendar loading time: %d ms",msNeeded );

    if ( KOPrefs::instance()->mLanguageChanged ) {
        KOPrefs::instance()->setCategoryDefaults();
        int count = mView->addCategories();
        KOPrefs::instance()->mLanguageChanged = false;
    }
    processIncidenceSelection( 0 );
    connect( mView, SIGNAL( incidenceSelected( Incidence * ) ),
             SLOT( processIncidenceSelection( Incidence * ) ) );
    connect( mView, SIGNAL( modifiedChanged( bool ) ),
             SLOT( slotModifiedChanged( bool ) ) );
   

    connect( &mSaveTimer, SIGNAL( timeout() ), SLOT( save() ) );
    mView->setModified( false );
    mBlockAtStartup = false;
    mView->setModified( false );
    setCentralWidget( mView );
    globalFlagBlockStartup = 0;
    mView->show();
    delete splash; 
    if ( newFile )
        mView->updateConfig();
    // qApp->processEvents();
    //qDebug("MainView x %d y %d w %d  h %d",  mView->x(),mView-> y(), mView->width(), mView->height ());
    fillSyncMenu(); 
    mView->viewManager()->agendaView()->setStartHour( KOPrefs::instance()->mDayBegins  );
    if ( showWarning ) {
        KMessageBox::information( this, 
                         "You are starting KO/Pi for the first time.\nPlease choose your timezone\nin the Configure Dialog\nTAB Time Zone!\nPlease choose your language in the\nTAB Locale!\nYou get the Configure Dialog\nvia Menu: Actions - Configure....\nClick OK to show the Configure Dialog!\n", "KO/Pi information");
        mView->dialogManager()->showSyncOptions();
    }
}
MainWindow::~MainWindow()
{
    //qDebug("MainWindow::~MainWindow() ");
    //save toolbar location 
    KOPrefs *p = KOPrefs::instance();
    p->mToolBarHor = ( iconToolBar->orientation () == Qt:: Horizontal );
    p->mToolBarUp = iconToolBar->x() > width()/2 ||
        iconToolBar->y() > height()/2;
    mView->writeSettings();

    if ( mCalendarModifiedFlag || mView->checkFileChanged( defaultFileName()))
        save();
    delete mCalendar;  
    delete KOPrefs::instance();
    delete KIncidenceFormatter::instance();
   
   
}
void MainWindow::closeEvent( QCloseEvent* ce )
{
    if ( ! KOPrefs::instance()->mAskForQuit ) {

        ce->accept();
        return;

    }

    switch( QMessageBox::information( this, "KO/Pi",
                                      i18n("Do you really want\nto close KO/Pi?"),
                                      i18n("Close"), i18n("No"), 
                                      0, 0 ) ) {
    case 0:
        ce->accept();
        break;
    case 1:
        ce->ignore(); 
        break;
    case 2:
       
    default:
        break;
    }


}

void MainWindow::recieve( const QCString& cmsg, const QByteArray& data )
{
    QDataStream stream( data, IO_ReadOnly );
    // QMessageBox::about( this, "About KOrganizer/Pi", "*" +msg +"*" );
      
    if ( cmsg == "-writeFile" ) {
        // I made from the "-writeFile" an "-writeAlarm"
        mView->viewManager()->showWhatsNextView(); 
        mCalendar->checkAlarmForIncidence( 0, true);
        showMaximized();
        raise();
        return;
       
    }
    if ( cmsg == "-writeFileSilent" ) {
        // I made from the "-writeFile" an "-writeAlarm"
        // mView->viewManager()->showWhatsNextView(); 
        mCalendar->checkAlarmForIncidence( 0, true);
        //showMaximized();
        //raise();
        hide();
        return;
    }
    if ( cmsg == "-newCountdown" ) {
        qDebug("newCountdown ");
       
    }
    QString msg ;
    QString allmsg = cmsg;
    while ( allmsg.length() > 0 ) {
        int nextC = allmsg.find( "-", 1 );
        if ( nextC == -1 ) {
            msg = allmsg;
            allmsg = "";
        } else{
            msg = allmsg.left( nextC );
            allmsg = allmsg.mid( nextC,  allmsg.length()-nextC );
        }
        //qDebug("msg: %s  all: %s ", msg.latin1(), allmsg.latin1() );
        if ( msg == "-newEvent" ) {
            mView->newEvent();
        }
        if ( msg == "-newTodo" ) {
            mView->newTodo();
            
        } 
        if ( msg == "-showWN" ) {
            mView->viewManager()->showWhatsNextView();
        }
        if ( msg == "-showTodo" ) {
            mView->viewManager()->showTodoView();
        }
        if ( msg == "-showList"  ) {
            mView->viewManager()->showListView();
        }
        else if ( msg == "-showDay" ) {
            mView->viewManager()->showDayView();
        }
        else if ( msg == "-showWWeek"  ) {
            mView->viewManager()->showWorkWeekView();
        }
        else if ( msg == "-showWeek" ) {
            mView->viewManager()->showWeekView();
        }
        else if ( msg == "-showTodo" ) {
            mView->viewManager()->showTodoView();
        }
        else if ( msg == "-showJournal"  ) {
            mView->dateNavigator()->selectDates( 1 );
            mView->dateNavigator()->selectToday();
            mView->viewManager()->showJournalView();
        }
        else if ( msg == "-showKO" ) {
            mView->viewManager()->showNextXView();
        }
        else if ( msg == "-showWNext" ) {
            mView->viewManager()->showWhatsNextView();
        } 
        else if ( msg == "-showNextXView" ) {
            mView->viewManager()->showNextXView();
        }
        

    }

    showMaximized();
    raise();
}

QPixmap MainWindow::loadPixmap( QString name )
{

#ifdef DESKTOP_VERSION
    return SmallIcon( name );
#else
    return Resource::loadPixmap( name ); 
#endif
}
void MainWindow::initActions()
{
    //KOPrefs::instance()->mShowFullMenu
    iconToolBar->clear();
    KOPrefs *p = KOPrefs::instance();
    //QPEMenuBar *menuBar1;// = new QPEMenuBar( iconToolBar );

    QPopupMenu *viewMenu = new QPopupMenu( this );
    QPopupMenu *actionMenu = new QPopupMenu( this );
    QPopupMenu *importMenu = new QPopupMenu( this );

    syncMenu = new QPopupMenu( this );
    configureAgendaMenu = new QPopupMenu( this );
    configureToolBarMenu = new QPopupMenu( this );
    QPopupMenu *helpMenu = new QPopupMenu( this );
    if ( KOPrefs::instance()->mShowFullMenu ) {
        QMenuBar *menuBar1;
        menuBar1 = menuBar();
        menuBar1->insertItem( i18n("File"), importMenu );
        menuBar1->insertItem( i18n("View"), viewMenu );
        menuBar1->insertItem( i18n("Actions"), actionMenu );
        menuBar1->insertItem( i18n("Synchronize"), syncMenu );
        menuBar1->insertItem( i18n("AgendaSize"),configureAgendaMenu  ); 
        //menuBar1->insertItem( i18n("Toolbar"),configureToolBarMenu ); 
        menuBar1->insertItem( i18n("Help"), helpMenu );  
    } else { 
        QPEMenuBar *menuBar1;
        menuBar1 = new QPEMenuBar( iconToolBar );
        QPopupMenu *menuBar = new QPopupMenu( this );
        menuBar1->insertItem( i18n("ME"), menuBar);
        menuBar->insertItem( i18n("File"), importMenu );
        menuBar->insertItem( i18n("View"), viewMenu );
        menuBar->insertItem( i18n("Actions"), actionMenu );
        menuBar->insertItem( i18n("Synchronize"), syncMenu );
        menuBar->insertItem( i18n("AgendaSize"),configureAgendaMenu  ); 
        menuBar->insertItem( i18n("Toolbar"),configureToolBarMenu ); 
        menuBar->insertItem( i18n("Help"), helpMenu );  
        //menuBar1->setMaximumWidth( menuBar1->sizeHint().width() ); 
        menuBar1->setMaximumSize( menuBar1->sizeHint( ));
    }
    connect ( syncMenu, SIGNAL( activated ( int )  ), this, SLOT (slotSyncMenu( int ) ) );
    // ******************
    QAction *action;
    QIconSet icon;
    // QPopupMenu *configureMenu= new QPopupMenu( menuBar );
    configureToolBarMenu->setCheckable( true );
#ifdef DESKTOP_VERSION
    QString pathString = ""; 
#else
    QString pathString = "korganizer/"; 
#endif
    if ( !p->mToolBarMiniIcons ) {
    if ( QApplication::desktop()->width() < 480 ) 
        pathString += "icons16/";
    } else
        pathString += "iconsmini/";
    configureAgendaMenu->setCheckable( true );
    configureAgendaMenu->insertItem(i18n("Toggle Allday"), 1 ); 
    configureAgendaMenu->insertSeparator(); 
    configureAgendaMenu->insertItem(i18n("Tiny"), 4 ); 
    configureAgendaMenu->insertItem(i18n("Small"), 6 );
    configureAgendaMenu->insertItem(i18n("Medium"), 8 );
    configureAgendaMenu->insertItem(i18n("Normal"), 10 );  
    configureAgendaMenu->insertItem(i18n("Large"), 12 );  
    configureAgendaMenu->insertItem(i18n("Big"), 14 );    
    configureAgendaMenu->insertItem(i18n("Bigger"), 16 );   
    configureAgendaMenu->insertItem(i18n("Biggest"), 18 );   
    //configureMenu->insertItem( "AgendaSize",configureAgendaMenu  ); 
    
    icon = loadPixmap( pathString + "configure" );  
    action = new QAction( i18n("Configure"),icon, i18n("Configure..."), 0, this );
    action->addTo( actionMenu );
    connect( action, SIGNAL( activated() ),
             mView, SLOT( edit_options() ) );
    actionMenu->insertSeparator();
    icon = loadPixmap( pathString + "newevent" );  
    icon = loadPixmap( pathString + "newevent" ); 
    configureToolBarMenu->insertItem(i18n("Stretched TB"), 5 ); 
    configureToolBarMenu->insertSeparator(); 
    configureToolBarMenu->insertItem(icon, i18n("New Event..."), 10 );
    QAction* ne_action = new QAction( i18n("New Event..."), icon, i18n("New Event..."), 0, this );
    ne_action->addTo( actionMenu );
    connect( ne_action, SIGNAL( activated() ),
             mView, SLOT( newEvent() ) );
    icon = loadPixmap( pathString + "newtodo" ); 
    configureToolBarMenu->insertItem(icon, i18n("New Todo..."), 20 ); 
    QAction* nt_action = new QAction( i18n("New Todo..."), icon, i18n("New Todo..."), 0, this );
    nt_action->addTo( actionMenu );
    connect( nt_action, SIGNAL( activated() ),
             mView, SLOT( newTodo() ) );
    icon = loadPixmap( pathString + "navi" ); 
    action = new QAction( i18n("Toggle DateNavigator"), icon, i18n("Toggle DateNavigator"), 0, this );
    action->addTo( viewMenu );
    connect( action, SIGNAL( activated() ),
             mView, SLOT( toggleDateNavigatorWidget() ) );
    icon = loadPixmap( pathString + "filter" ); 
    action = new QAction( i18n("Toggle FilterView"), icon, i18n("Toggle FilterView"), 0, this );
    action->addTo( viewMenu );
    connect( action, SIGNAL( activated() ),
             mView, SLOT( toggleFilter() ) );
  

    viewMenu->insertSeparator();
    icon = loadPixmap( pathString + "picker" );
    action = new QAction( i18n("Date Picker"), icon, i18n("Date Picker"), 0, this );
    action->addTo( viewMenu );
    connect( action, SIGNAL( activated() ),
             mView, SLOT( showDatePicker() ) );
    action->addTo( iconToolBar  );
    viewMenu->insertSeparator();
    icon = loadPixmap( pathString + "list" );  
    configureToolBarMenu->insertItem(icon, i18n("List View"), 30 ); 
    QAction* showlist_action = new QAction( i18n("List View"), icon, i18n("List View"), 0, this );
    showlist_action->addTo( viewMenu );
    connect( showlist_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showListView() ) );


    icon = loadPixmap( pathString + "day" );  
    configureToolBarMenu->insertItem(icon, i18n("Day View"), 40 ); 
    QAction* day1_action = new QAction( i18n("Day View"), icon, i18n("Day View"), 0, this );
    day1_action->addTo( viewMenu );
    //  action->addTo( toolBar );
    connect( day1_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showDayView() ) );

    icon = loadPixmap( pathString + "workweek" ); 
    configureToolBarMenu->insertItem(icon, i18n("Work Week"), 50 );  
    QAction* day5_action = new QAction( i18n("Work Week"), icon, i18n("Work Week"), 0, this );
    day5_action->addTo( viewMenu );
    connect( day5_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showWorkWeekView() ) );

    icon = loadPixmap( pathString + "week" );
    configureToolBarMenu->insertItem(icon, i18n("Week"), 60 );    
    QAction* day7_action = new QAction( i18n("Week"), icon, i18n("Week"), 0, this );
    day7_action->addTo( viewMenu );
    connect( day7_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showWeekView() ) );

    icon = loadPixmap( pathString + "month" ); 
    configureToolBarMenu->insertItem(icon, i18n("Month"), 70 );  
    QAction* month_action = new QAction( i18n("Month"), icon, i18n("Month"), 0, this );
    month_action->addTo( viewMenu );
    connect( month_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showMonthView() ) );

    icon = loadPixmap( pathString + "todo" );  
    configureToolBarMenu->insertItem(icon, i18n("Todo View"), 80 );  
    QAction* todoview_action = new QAction( i18n("Todo View"), icon, i18n("Todo View"), 0, this );
    todoview_action->addTo( viewMenu );
    connect( todoview_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showTodoView() ) );

    icon = loadPixmap( pathString + "journal" );  
    configureToolBarMenu->insertItem(icon, i18n("Journal"), 90 );  
    QAction* viewjournal_action = new QAction( i18n("Journal"), icon, i18n("Journal"), 0, this );
    viewjournal_action->addTo( viewMenu );
    connect( viewjournal_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showJournalView() ) );

    icon = loadPixmap( pathString + "xdays" );  
    configureToolBarMenu->insertItem(icon, i18n("Next days"), 100,4 );  
    QAction* xdays_action = new QAction( i18n("Next days"), icon, i18n("Next days"), 0, this );
    xdays_action->addTo( viewMenu );
    connect( xdays_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showNextXView() ) );

    icon = loadPixmap( pathString + "whatsnext" );  
    configureToolBarMenu->insertItem(icon, i18n("What's Next"), 110, 4 );  
    QAction* whatsnext_action = new QAction( i18n("What's Next"), icon, i18n("What's Next"), 0, this ); 
    whatsnext_action->addTo( viewMenu );
    connect( whatsnext_action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showWhatsNextView() ) );
   
#if 0
    action = new QAction( "view_timespan", "Time Span", 0, this );
    action->addTo( viewMenu );
    connect( action, SIGNAL( activated() ),
             mView->viewManager(), SLOT( showTimeSpanView() ) );
#endif

    mNewSubTodoAction = new QAction( "new_subtodo", i18n("New Sub-Todo..."), 0,
                                     this );
    mNewSubTodoAction->addTo( actionMenu );
    connect( mNewSubTodoAction, SIGNAL( activated() ),
             mView, SLOT( newSubTodo() ) );

    actionMenu->insertSeparator();

    mShowAction = new QAction( "show_incidence", i18n("Show..."), 0, this );
    mShowAction->addTo( actionMenu );
    connect( mShowAction, SIGNAL( activated() ),
             mView, SLOT( showIncidence() ) );

    mEditAction = new QAction( "edit_incidence", i18n("Edit..."), 0, this );
    mEditAction->addTo( actionMenu );
    connect( mEditAction, SIGNAL( activated() ),
             mView, SLOT( editIncidence() ) );

    mDeleteAction = new QAction( "delete_incidence", i18n("Delete..."), 0, this );
    mDeleteAction->addTo( actionMenu );
    connect( mDeleteAction, SIGNAL( activated() ),
             mView, SLOT( deleteIncidence() ) );

    actionMenu->insertSeparator();

    action = new QAction( "purge_completed", i18n("Purge Completed"), 0,
                          this );
    action->addTo( actionMenu );
    connect( action, SIGNAL( activated() ), mView, SLOT( purgeCompleted() ) );

    icon = loadPixmap( pathString + "search" );  
    QAction* search_action = new QAction( i18n("Search"), icon, i18n("Search..."), 0, this );
    configureToolBarMenu->insertItem(icon, i18n("Search"), 120 , 4);  
    search_action->addTo( actionMenu );
    connect( search_action, SIGNAL( activated() ),
             mView->dialogManager(), SLOT( showSearchDialog() ) );

    icon = loadPixmap( pathString + "today" );  
    configureToolBarMenu->insertItem(icon, i18n("Go to Today"), 130);  
    QAction* today_action = new QAction( i18n("Go to Today"), icon, i18n("Go to Today"), 0, this );
    today_action->addTo( actionMenu );
    connect( today_action, SIGNAL( activated() ),
             mView, SLOT( goToday() ) );

 
   

   

    if ( KOPrefs::instance()->mShowFullMenu ) {
        actionMenu->insertSeparator();
        actionMenu->insertItem( i18n("Configure Toolbar"),configureToolBarMenu ); 
        
    }
    // actionMenu->insertSeparator();
    action = new QAction( "import_qtopia", i18n("Import (*.ics/*.vcs) file"), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), SLOT( importIcal() ) );
    action = new QAction( "import_quick", i18n("Import last file"), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), SLOT( quickImportIcal() ) );
#ifndef DESKTOP_VERSION
    importMenu->insertSeparator();
    action = new QAction( "import_qtopia", i18n("Import Opie/Qtopia Cal."), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), SLOT( importQtopia() ) );
#endif

    importMenu->insertSeparator();
    action = new QAction( "load_cal", i18n("Load Calendar Backup"), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), SLOT( loadCalendar() ) );

    action = new QAction( "save_cal", i18n("Save Calendar Backup"), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), SLOT( saveCalendar() ) );

    importMenu->insertSeparator();
    action = new QAction( "import_qtopia", i18n("Export VCalendar"), 0,
                          this );
    action->addTo( importMenu );    connect( action, SIGNAL( activated() ), SLOT( exportVCalendar() ) );
    importMenu->insertSeparator();
    action = new QAction( "manage cat", i18n("Manage new categories..."), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), mView, SLOT( manageCategories() ) );
#ifndef DESKTOP_VERSION
    importMenu->insertSeparator();
    action = new QAction( "beam all", i18n("Beam complete calendar..."), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), mView, SLOT( beamCalendar() ) );
   
    action = new QAction( "beam all", i18n("Beam filtered calendar..."), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), mView, SLOT( beamFilteredCalendar()) );
#else
 importMenu->insertSeparator(); 
 icon = loadPixmap( pathString + "print" ); 
    action = new QAction( i18n("Print calendar..."),icon,i18n("Print calendar..."), 0, this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ),
             this, SLOT( printCal() ) );
    
    icon = loadPixmap( pathString + "print" ); 
    action = new QAction( i18n("Print agenda selection..."),icon,i18n("Print agenda selection..."), 0, this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ),
             this, SLOT( printSel() ) );
#endif
    importMenu->insertSeparator();
    action = new QAction( "beam all", i18n("Save"), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), this, SLOT( save() ) );
    action = new QAction( "beam all", i18n("Exit (+save)"), 0,
                          this );
    action->addTo( importMenu );
    connect( action, SIGNAL( activated() ), this, SLOT( close() ) );
   
    //menuBar->insertItem( "Configure",configureMenu );
    //configureMenu->insertItem( "Toolbar",configureToolBarMenu  );
    icon = loadPixmap( "korganizer/korganizer" ); 
    action = new QAction( "Keys + Colors", i18n("Keys + Colors..."), 0, this );
    action->addTo( helpMenu );
    connect( action, SIGNAL( activated() ),
             SLOT( keyBindings() ) );   
    action = new QAction( "featureHowto", i18n("Features + hints..."), 0,this );
    action->addTo( helpMenu );
    connect( action, SIGNAL( activated() ),
             SLOT( features() ) ); 
    action = new QAction( "Auto saving", i18n("Auto saving..."), 0, this );
    action->addTo( helpMenu );
    connect( action, SIGNAL( activated() ),
             SLOT( aboutAutoSaving() ) ); 
    action = new QAction( "Problemd", i18n("Known Problems..."), 0,this );
    action->addTo( helpMenu );
    connect( action, SIGNAL( activated() ),
             SLOT( aboutKnownBugs() ) );  
    action = new QAction( "Translate Howto", i18n("User translation..."), 0,this );
    action->addTo( helpMenu );
    connect( action, SIGNAL( activated() ),
             SLOT( usertrans() ) ); 
    action = new QAction( "Sync Howto", i18n("Sync HowTo..."), 0,this );
    action->addTo( helpMenu );
    connect( action, SIGNAL( activated() ),
             SLOT( synchowto() ) ); 

    action = new QAction( "Frequently asked questions", i18n("FAQ..."), 0,this );
    action->addTo( helpMenu );
    connect( action, SIGNAL( activated() ),
             SLOT( faq() ) );

    action = new QAction( "about", i18n("About..."), 0, this );
    action->addTo( helpMenu );
    connect( action, SIGNAL( activated() ),
             SLOT( about() ) );
    //menuBar->insertSeparator();

    // ******************************************************
    // menubar icons 
    
    
    iconToolBar->setHorizontalStretchable (true ); 
    //menuBar->insertItem( iconToolBar );
    //xdays_action
    if (p-> mShowIconNewEvent)
        ne_action->addTo( iconToolBar  );
    if (p->mShowIconNewTodo )
        nt_action->addTo( iconToolBar  );
    if (p-> mShowIconSearch)
        search_action->addTo( iconToolBar  );
    if (p-> mShowIconNext)
        whatsnext_action->addTo( iconToolBar  );
    if (p-> mShowIconNextDays)
        xdays_action->addTo( iconToolBar  );
    if (p-> mShowIconList)
        showlist_action->addTo( iconToolBar  );
    if (p-> mShowIconDay1)
        day1_action->addTo( iconToolBar  );
    if (p-> mShowIconDay5)
        day5_action->addTo( iconToolBar  );
    if (p-> mShowIconDay7)
        day7_action->addTo( iconToolBar  );
    if (p-> mShowIconMonth)
        month_action->addTo( iconToolBar  );
    if (p-> mShowIconTodoview)
        todoview_action->addTo( iconToolBar  );
    if (p-> mShowIconJournal)
        viewjournal_action->addTo( iconToolBar  );
    icon = loadPixmap( pathString + "2leftarrowB" );
    configureToolBarMenu->insertItem(icon, i18n("Prev. month"), 200, 14);  
    if (p-> mShowIconBackFast) {
        action = new QAction( i18n("Prev. month"), icon, i18n("Prev. month"),0 , this );
        connect( action, SIGNAL( activated() ),
                 mView, SLOT( goPreviousMonth() ) );
        action->addTo( iconToolBar  );
    }
    icon = loadPixmap( pathString + "1leftarrowB" );
    configureToolBarMenu->insertItem(icon, i18n("Go backward"), 210,15);  
    if (p-> mShowIconBack) {
        action = new QAction( i18n("Go backward"), icon, i18n("Go backward"),0 , this );
        connect( action, SIGNAL( activated() ),
                 mView, SLOT( goPrevious() ) );
        action->addTo( iconToolBar  );
    }
    if (p-> mShowIconToday) 
        today_action->addTo( iconToolBar  );
    icon = loadPixmap( pathString + "1rightarrowB" );
    configureToolBarMenu->insertItem(icon, i18n("Go forward"), 220); 
    if (p-> mShowIconForward) {
        action = new QAction( i18n("Go forward"), icon, i18n("Go forward"),0 , this );
        connect( action, SIGNAL( activated() ),
                 mView, SLOT( goNext() ) );
        action->addTo( iconToolBar  );
    }
    icon = loadPixmap( pathString + "2rightarrowB" );
    configureToolBarMenu->insertItem(icon, i18n("Next month"), 230);  
    if (p-> mShowIconForwardFast) {
        action = new QAction( i18n("Next month"), icon, i18n("Next month"),0 , this );
        connect( action, SIGNAL( activated() ),
                 mView, SLOT( goNextMonth() ) );
        action->addTo( iconToolBar  );
    }
  
   
    configureToolBarMenu->insertItem(i18n("What's This?"), 300); 

    if (p-> mShowIconNewEvent)
        configureToolBarMenu->setItemChecked( 10, true );
    if (p->mShowIconNewTodo )
        configureToolBarMenu->setItemChecked( 20, true );
    if (p-> mShowIconSearch)
        configureToolBarMenu->setItemChecked( 120, true );
    if (p-> mShowIconList)
        configureToolBarMenu->setItemChecked( 30, true );
    if (p-> mShowIconDay1)
        configureToolBarMenu->setItemChecked( 40, true );
    if (p-> mShowIconDay5)
        configureToolBarMenu->setItemChecked( 50, true );
    if (p-> mShowIconDay7)
        configureToolBarMenu->setItemChecked( 60, true );
    if (p-> mShowIconMonth)
        configureToolBarMenu->setItemChecked( 70, true );
    if (p-> mShowIconTodoview)
        configureToolBarMenu->setItemChecked( 80, true );
    if (p-> mShowIconBackFast)
        configureToolBarMenu->setItemChecked( 200, true );
    if (p-> mShowIconBack) 
        configureToolBarMenu->setItemChecked( 210, true );
    if (p-> mShowIconToday)
        configureToolBarMenu->setItemChecked( 130, true ); 
    if (p-> mShowIconForward)
        configureToolBarMenu->setItemChecked( 220, true );
    if (p-> mShowIconForwardFast)
        configureToolBarMenu->setItemChecked( 230, true );
    if (p-> mShowIconNextDays)
        configureToolBarMenu->setItemChecked( 100, true );
    if (p-> mShowIconNext)
        configureToolBarMenu->setItemChecked( 110, true );
    if (p-> mShowIconJournal)
        configureToolBarMenu->setItemChecked( 90, true );
    if (p-> mShowIconWhatsThis)
        configureToolBarMenu->setItemChecked( 300, true );

    QLabel* dummy = new QLabel( iconToolBar );
    dummy->setBackgroundColor( iconToolBar->backgroundColor() );
    if (!p-> mShowIconStretch)
        iconToolBar->setStretchableWidget ( dummy ) ;
    else
        configureToolBarMenu->setItemChecked( 5, true );
    if (p-> mShowIconWhatsThis)
        QWhatsThis::whatsThisButton (  iconToolBar );
    connect( configureToolBarMenu, SIGNAL( activated( int ) ),this,  SLOT(configureToolBar( int ) ) ); 
    configureAgenda( p->mHourSize );
    connect( configureAgendaMenu, SIGNAL( activated( int ) ),this,  SLOT(configureAgenda( int ) ) );
}
void MainWindow::fillSyncMenu()
{
    syncMenu->clear();
    syncMenu->insertItem( i18n("Configure..."), 0 );
    syncMenu->insertSeparator();
    syncMenu->insertItem( i18n("Multiple sync"), 1 );
    syncMenu->insertSeparator();

    QStringList prof = KOPrefs::instance()->mSyncProfileNames;

    if ( prof.count() < 3 ) {
        KConfig *config = KOGlobals::config();
        prof.clear();
        prof << i18n("Sharp-DTM");
        prof << i18n("Local file");
        prof << i18n("Last file");
        KSyncProfile* temp = new KSyncProfile ();
        temp->setName( prof[0] );
        temp->writeConfig(config);
        temp->setName( prof[1] );
        temp->writeConfig(config);
        temp->setName( prof[2] );
        temp->writeConfig(config);
        config->sync();
        delete temp; 
        KOPrefs::instance()->mSyncProfileNames = prof;
    }

    int i;
    for ( i = 0; i < prof.count(); ++i ) {

        syncMenu->insertItem(  prof[i], 1000+i );
        if ( i == 2 )
            syncMenu->insertSeparator();
    }
    QDir app_dir;
    if ( !app_dir.exists(QDir::homeDirPath()+"/Applications/dtm" ) ) {
        syncMenu->setItemEnabled( false , 1000 );
    }
} 

void MainWindow::ringSync()
{
   
    int i;  
    QTime timer;
    KConfig *config = KOGlobals::config();
    QStringList syncProfileNames = KOPrefs::instance()->mSyncProfileNames;
    KSyncProfile* temp = new KSyncProfile ();
    KOPrefs::instance()->mAskForPreferences = false;
    for ( i = 0; i < syncProfileNames.count(); ++i ) {
        mCurrentSyncProfile = i;
        temp->setName(syncProfileNames[mCurrentSyncProfile]);
        temp->readConfig(config);
        if ( temp->getIncludeInRingSync() && ( i < 1 || i > 2  )) {
            setCaption(i18n("Profile ")+syncProfileNames[mCurrentSyncProfile]+ i18n(" is synced ... "));
            // KOPrefs::instance()->mAskForPreferences = temp->getAskForPreferences();
            KOPrefs::instance()->mWriteBackFile = temp->getWriteBackFile();
            KOPrefs::instance()->mWriteBackExistingOnly = temp->getWriteBackExisting();
            KOPrefs::instance()->mShowSyncSummary = false;
            mView->setSyncDevice(syncProfileNames[i] );
            mView->setSyncName( KOPrefs::instance()->mLocalMachineName );
            if ( i == 0 ) {
                syncSharp();
            } else {
                if ( temp->getIsLocalFileSync() ) {
                    if ( syncWithFile( temp->getRemoteFileName( ), true ) ) 
                        KOPrefs::instance()->mLastSyncedLocalFile = temp->getRemoteFileName();
                } else {
                    syncRemote( temp, false );
                    
                }
            }
            timer.start();
            setCaption(i18n("Multiple sync in progress ... please wait!") );
            while ( timer.elapsed () < 2000 ) {
                qApp->processEvents();
#ifndef _WIN32_
                sleep (1);
#endif
            }
 
        }

    }
    delete temp;
}
void MainWindow::slotSyncMenu( int action )
{
    //qDebug("syncaction %d ", action);
    if ( action == 0 ) {
        confSync();
        return;
    } 
    if ( action == 1 ) { 
        if (mBlockSaveFlag)
            return;
        mBlockSaveFlag = true;  
        QString question;
        question = i18n("Do you really want\nto multiple sync\nwith all checked profiles?\nSyncing takes some\ntime - all profiles\nare synced twice!");
        if ( QMessageBox::information( this, i18n("KO/Pi Sync"),
                                       question,
                                       i18n("Yes"), i18n("No"), 
                                       0, 0 ) != 0 ) {
            mBlockSaveFlag = false;
            return;
        }
        mView->setSyncDevice(i18n("Multiple profiles") );
        KOPrefs::instance()->mSyncAlgoPrefs = KOPrefs::instance()->mRingSyncAlgoPrefs;
        mView->edit_sync_options();
        KOPrefs::instance()->mRingSyncAlgoPrefs = KOPrefs::instance()->mSyncAlgoPrefs;
        setCaption(i18n("Multiple sync started.") );
        qApp->processEvents();
        ringSync();
        ringSync();
        mBlockSaveFlag = false;
        save();
        setCaption(i18n("Multiple sync completed!") );
        return;
    } 

    if (mBlockSaveFlag)
        return;
    mBlockSaveFlag = true;
    mCurrentSyncProfile = action - 1000 ;
    mView->setSyncDevice(KOPrefs::instance()->mSyncProfileNames[mCurrentSyncProfile] );
    mView->setSyncName( KOPrefs::instance()->mLocalMachineName );
    KConfig *config = KOGlobals::config();
    KSyncProfile* temp = new KSyncProfile ();
    temp->setName(KOPrefs::instance()->mSyncProfileNames[mCurrentSyncProfile]);
    temp->readConfig(config);
    KOPrefs::instance()->mAskForPreferences = temp->getAskForPreferences();
    KOPrefs::instance()->mSyncAlgoPrefs = temp->getSyncPrefs();
    KOPrefs::instance()->mWriteBackFile = temp->getWriteBackFile();
    KOPrefs::instance()->mWriteBackExistingOnly = temp->getWriteBackExisting();
    KOPrefs::instance()->mShowSyncSummary = temp->getShowSummaryAfterSync();
    if ( action == 1000  ) {
        syncSharp();

    } else if ( action == 1001 ) {
        syncLocalFile();

    } else if ( action == 1002 ) {
        quickSyncLocalFile();

    } else if ( action >= 1003  ) {
        if ( temp->getIsLocalFileSync() ) {
            if ( syncWithFile( temp->getRemoteFileName( ), false ) ) 
                KOPrefs::instance()->mLastSyncedLocalFile = temp->getRemoteFileName();
        } else {
            syncRemote( temp );

        }
    }
    delete temp;
    mBlockSaveFlag = false;
}
void MainWindow::setDefaultPreferences()
{
    KOPrefs *p = KOPrefs::instance();

    p->mCompactDialogs = true;
    p->mConfirm = true;
    // p->mEnableQuickTodo = false;
}

QString MainWindow::resourcePath()
{
    QString fileName ;
#ifdef DESKTOP_VERSION
#ifndef _WIN32_
    fileName  = qApp->applicationDirPath () + "/pics/";
#else
    fileName   = qApp->applicationDirPath () + "\\pics\\";
#endif
#else
    fileName = getenv("QPEDIR");
    fileName += "/pics/korganizer/";
#endif
    return fileName;

}

void MainWindow::displayText( QString text ,QString cap  )
{
    QDialog dia( this, "name", true ); ;
    dia.setCaption( cap );
    QVBoxLayout* lay = new QVBoxLayout( &dia );
    lay->setSpacing( 3 );
    lay->setMargin( 3 );
    QTextBrowser tb ( &dia );
    lay->addWidget( &tb ); 
    tb.setText( text );
#ifdef DESKTOP_VERSION
    dia.resize( 640, 480);
#else
    dia.showMaximized();
#endif
    dia.exec();
}
void MainWindow::displayFile( QString fn, QString cap )
{
 QString fileName =  resourcePath() + fn;
 QString text; 
    QFile file( fileName );
    if (!file.open( IO_ReadOnly ) ) {
        return ;
        
    } 
    QTextStream ts( &file );
    text = ts.read();
    file.close();  
    displayText( text, cap);
}
void MainWindow::features()
{

    displayFile( "featuresKOPI.txt",i18n("KO/Pi Features and hints") );
}

void MainWindow::usertrans()
{

    displayFile( "usertranslationHOWTO.txt",i18n("KO/Pi User translation HowTo") );
}
void MainWindow::synchowto()
{

    displayFile( "howtoSYNC.txt",i18n("KO/Pi Synchronization HowTo") );
}   
void  MainWindow::faq()
{
    displayFile( "kopiFAQ.txt",i18n("KO/Pi FAQ") );

}
void MainWindow::about()
{
    QMessageBox::about( this, i18n("About KOrganizer/Pi"),
                        i18n("KOrganizer/Platform-independent\n") +
                        "(KO/Pi) 1.7.8 - " +
#ifdef DESKTOP_VERSION
                        i18n("Desktop Edition\n") +
#else
                        i18n("PDA-Edition\nfor: Zaurus 5x00 / 7x0 / 8x0\n") +
#endif
                        i18n("(c) 2004 Lutz Rogowski\nEmail:lutz@pi-sync.net\nKO/Pi is based on KOrganizer\n(c) 2002,2003 Cornelius Schumacher\nEmail: schumacher@kde.org\nKOrganizer/Pi is licensed\nunder the GPL.\nKO/Pi can be compiled for\nLinux, Zaurus-PDA and Windows\nwww.korganizer.org\nwww.pi-sync.net\n") );
}
void MainWindow::keyBindings()
{
    QString cap = i18n("Key bindings  KOrganizer/Pi");
    QString text =  i18n("<p><h2>KO/Pi key shortcuts:</h2></p>\n") +
        i18n("<p><b>H</b>: This help dialog | <b>S</b>: Search dialog</p>\n")+
        i18n("<p><b>I</b>: Show info for selected event/todo</p>\n") +
        i18n("<p><b>Space</b>: Toggle fullscreen | <b>P</b>: Date picker</p>\n")+
        i18n("<p><b>F</b>: Toggle filterview |<b>F+ctrl</b>: Edit filter </p>\n")+
        i18n("<p><b>O</b>: Filter On/Off | <b>J</b>: Journal view</p>\n")+
        i18n("<p><b>1-0</b> (+<b>ctrl</b>): Select filter 1-10 (11-20)</p>\n")+
        i18n("<p><b>N</b>: Next days view| <b>W</b>: What's next view\n ")+
        i18n("<p><b>V</b>: Todo view | <b>L</b>: Event list view</p>\n")+
        i18n("<p><b>Z,Y</b>: Work week view | <b>U</b>: Week view</p>\n")+
        i18n("<p><b>D</b>: One day view | <b>M</b>: Month view</p>\n")+
        i18n("<p><b>E</b>: Edit selected item |<b> E+ctrl</b>: New Event</p>\n")+
        i18n("<p><b>T</b>: Goto today | <b>T+ctrl</b>: New Todo</p>\n")+
        i18n("<p><b>S+ctrl</b>: Add sub-todo | <b>X</b>: Toggle datenavigator</p>\n")+
        i18n("<p><b>+,-</b> : Zoom in/out agenda | <b>A</b>: Toggle allday agenda height</p>\n")+
        i18n("<p><b>C</b>: Show current time in agenda view</p>\n")+
        i18n("<p><b>B</b>: Edit description (details) of selected item</p>\n")+
        i18n("<p><b>right</b>: Next week | <b>right+ctrl</b>: Next month</p>\n")+
        i18n("<p><b>left</b>: Prev. week | <b>left+ctrl</b>: Prev. month</p>\n")+
        i18n("<p><b>del,backspace</b>: Delete selected item</p>\n")+
        i18n("<p><h3>In agenda view:</h3></p>\n") +
        i18n("<p><b>up/down</b>: Scroll agenda view</p>\n")+
        i18n("<p><b>ctrl+up/down</b>: Scroll small todo view</p>\n")+
        i18n("<p><h3>In todo view:</h3></p>\n") +
        i18n("<p><b>Q</b>: Toggle quick todo line edit.</p>\n")+
        i18n("<p><b>I</b>: Show info of current item+one step down.</p>\n")+
        i18n("<p><b>return</b>: Mark item as completed+one step down.</p>\n")+
        i18n("<p><b>return+shift</b>:  Mark item as not completed+one step down</p>\n")+
        i18n("<p><h3>In list view:</h3></p>\n") +
        i18n("<p><b>I</b>: Show info of current item+one step down.</p>\n")+
        i18n("<p><b>return</b>: Select item+one step down</p>\n")+
        i18n("<p><b>return+shift</b>: Deselect item+one step down</p>\n")+
        i18n("<p><b>up/down</b>: Next/prev item</p>\n")+
        i18n("<p><b>ctrl+up/down</b>:  Goto up/down by 20% of items</p>\n")+
        i18n("<p><b>shift+up/down</b>: Goto first/last item</p>\n")+
        i18n("<p><h3>In event/todo viewer:</h3></p>\n") +
        i18n("<p><b>I,C</b>: Close dialog.</p>\n")+
        i18n("<p><b>A</b>: Show agenda view.</p>\n")+
        i18n("<p><b>E</b>:  Edit item</p>\n") +
        i18n("<p><h2>KO/Pi icon colors:</h2></p>\n") +
        i18n("<p><b>(for square icons in agenda and month view)</b></p>\n") +
        i18n("<p><b>Cross</b>: Item cancelled.([c] in Whats'Next view)</p>\n")+
        i18n("<p><b>Red</b>: Alarm set.([a] in Whats'Next view)</p>\n")+
        i18n("<p><b>Blue</b>: Recurrent event.([r] in Whats'Next view)</p>\n")+
        i18n("<p><b>Dark green</b>: Information(description) available.([i] in WN view)</p>\n")+
        i18n("<p><b>Black</b>: Event/todo with attendees. You are the organizer!</p>\n")+
        i18n("<p><b>Dark yellow</b>:  Event/todo with attendees.</p>\n") +
        i18n("<p><b>White</b>: Item readonly</p>\n");
   displayText( text, cap);
  
}
void MainWindow::aboutAutoSaving()
{
    QMessageBox* msg;
    msg = new QMessageBox(  i18n("Auto Saving in  KOrganizer/Pi"),
                            i18n("After changing something, the data is\nautomatically saved to the file\n~/Applications/korganizer/mycalendar.ics\nafter (configureable) three minutes.\nFor safety reasons there is  one autosaving\nafter 10 minutes (of idle time) again. The \ndata is saved automatically when closing KO/Pi\nYou can create a backup file \nwith: File - Save Calendar Backup\n"), QMessageBox::NoIcon,
                            QMessageBox::Ok,
                            QMessageBox::NoButton,
                            QMessageBox::NoButton);
    msg->exec();
    delete msg;
  
                          
}
void MainWindow::aboutKnownBugs()
{
    QMessageBox* msg;
    msg = new QMessageBox(  i18n("Known Problems in  KOrganizer/Pi"),
                            i18n("1) Importing *.vcs or *.ics files from\nother applications may not work properly,\nif there are events with properties\nKO/Pi does not support.\n")+
                            i18n("2) Audio alarm daemon\nfor Zaurus is available!\nas an additional small application\n")+
                            i18n("\nPlease report unexpected behaviour to\nlutz@pi-sync.net\n"),
                            QMessageBox::NoIcon,
                            QMessageBox::Ok,
                            QMessageBox::NoButton,
                            QMessageBox::NoButton);
    msg->exec();
    delete msg;
  
}

QString MainWindow::defaultFileName()
{
#ifndef DESKTOP_VERSION
    return Global::applicationFileName( "korganizer", "mycalendar.ics" );
#else
    QString file;
    file = KStandardDirs::appDir()+"/mycalendar.ics";
    return QDir::convertSeparators( file );
#endif
}

void MainWindow::processIncidenceSelection( Incidence *incidence )
{
    if ( !incidence ) {
        enableIncidenceActions( false );
  
        mNewSubTodoAction->setEnabled( false );  
        setCaptionToDates();
        return;
        
    }
 
    //KGlobal::locale()->formatDateTime(nextA, true);
    QString startString = "";
    if ( incidence->type() != "Todo" ) { 
        if ( incidence->dtStart().date() < incidence->dtEnd().date()   ) { 
            if ( incidence->doesFloat() ) {
            startString += ": "+incidence->dtStartDateStr( true ); 
            startString += " --- "+((Event*)incidence)->dtEndDateStr( true ); 

            } else {
            startString = ": "+incidence->dtStartStr(true); 
            startString += " --- "+((Event*)incidence)->dtEndStr(true);

            }
      
        } else {
            if ( incidence->dtStart().time() != incidence->dtEnd().time() )
                startString = ": "+KGlobal::locale()->formatTime(incidence->dtStart().time())+
                    "-"+KGlobal::locale()->formatTime(incidence->dtEnd().time());
            startString +=" "+KGlobal::locale()->formatDate( incidence->dtStart().date(), true); 
        }
       
    }
    else 
        startString = i18n(": (Prio ") +QString::number( (( KCal::Todo*)incidence)->priority() ) +") "+QString::number( (( KCal::Todo*)incidence)->percentComplete() ) +i18n("\% completed");
    if ( !incidence->location().isEmpty() )
        startString += " (" +incidence->location()+")";
    setCaption( incidence->summary()+startString);
   
    enableIncidenceActions( true );
  
    if ( incidence->type() == "Event" ) {
        mShowAction->setText( i18n("Show Event...") );
        mEditAction->setText( i18n("Edit Event...") );
        mDeleteAction->setText( i18n("Delete Event...") );

        mNewSubTodoAction->setEnabled( false );
    } else if ( incidence->type() == "Todo" ) {
        mShowAction->setText( i18n("Show Todo...") );
        mEditAction->setText( i18n("Edit Todo...") );
        mDeleteAction->setText( i18n("Delete Todo...") );

        mNewSubTodoAction->setEnabled( true );
    } else {
        mShowAction->setText( i18n("Show...") );
        mShowAction->setText( i18n("Edit...") );
        mShowAction->setText( i18n("Delete...") );

        mNewSubTodoAction->setEnabled( false );
    }
}

void MainWindow::enableIncidenceActions( bool enabled )
{
    mShowAction->setEnabled( enabled );
    mEditAction->setEnabled( enabled );
    mDeleteAction->setEnabled( enabled );
}

void MainWindow::importQtopia()
{
#ifndef DESKTOP_VERSION
    int result = QMessageBox::warning( this, i18n("KO/Pi: Warning!"),
                                       i18n("When importing a calendar twice\nduplicated events will be ignored!\nYou can create a backup file with\nFile - Save Calendar Backup\nto revert importing"),
                                       i18n("Import!"), i18n("Cancel"), 0,
                                       0, 1 );
    if ( result == 0 ) {
        QString datebook = Global::applicationFileName( "datebook", "datebook.xml");
        QString todolist = Global::applicationFileName( "todolist", "todolist.xml");
        QString categories = QString( getenv( "HOME" ) ) + "/Settings/Categories.xml";
        mView->importQtopia( categories, datebook, todolist );
    }
#else
    int result = QMessageBox::warning( this, i18n("KO/Pi: Warning!"),
                                       i18n("Not supported \non desktop!\n"),
                                       i18n("Ok"), i18n("Cancel"), 0,
                                       0, 1 );

#endif 
}
 
void MainWindow::slotModifiedChanged( bool changed )
{
    if ( mBlockAtStartup )
        return;
    int msec;
    // we store the changes after 1 minute, 
    // and for safety reasons after 10 minutes again
    if ( !mBlockSaveFlag )
        msec = (1000 * 60*KOPrefs::instance()->mAutoSaveInterval) +1000;
    else
        msec = 1000 * 600;
    mSaveTimer.start( msec, true ); // 1 minute
    qDebug("KO: Saving File in %d secs!", msec/1000);
    mCalendarModifiedFlag = true;
}
#include <qfileinfo.h>
void MainWindow::save()
{
    if ( mBlockSaveFlag ) 
        return;
    bool store = mBlockSaveFlag;
    mBlockSaveFlag = true;
    if ( mView->checkFileVersion( defaultFileName()) ) {

        QTime neededSaveTime = QDateTime::currentDateTime().time();
        setCaption(i18n("KO/Pi:Saving Data to File ..." ));
        qDebug("KO: Start saving data to file!");
        mView->saveCalendar( defaultFileName() );

        int msNeeded = neededSaveTime.msecsTo( QDateTime::currentDateTime().time() );
        mView->setLoadedFileVersion(QDateTime::currentDateTime());
        qDebug("KO: Needed %d ms for saving.",msNeeded );
        QString savemes;
        savemes.sprintf(i18n("KO/Pi:File Saved. Needed %d sec, %d ms"),(msNeeded/1000)%100,msNeeded%1000  );
        setCaption(savemes); 
    } else
        setCaption(i18n("Saving cancelled!")); 
    mCalendarModifiedFlag = false;
    mBlockSaveFlag = store;
}

void MainWindow::keyReleaseEvent ( QKeyEvent * e) 
{
    if ( !e->isAutoRepeat() ) {
        mFlagKeyPressed = false;
    }
}
void MainWindow::keyPressEvent ( QKeyEvent * e ) 
{
    qApp->processEvents();
    if ( e->isAutoRepeat() && !mFlagKeyPressed ) {
        e->ignore();
        // qDebug("  ignore  %d",e->isAutoRepeat()  );
        return;
    }
    if (! e->isAutoRepeat() )
        mFlagKeyPressed = true;
    KOPrefs *p = KOPrefs::instance();
    bool showSelectedDates = false;
    int size;
    int pro = 0;
    //qDebug("MainWindow::keyPressEvent ");
    switch ( e->key() ) {
    case Qt::Key_Right:
        if ( e->state() == Qt::ControlButton ||  e->state() == Qt::ShiftButton)
            mView->goNextMonth();
        else
            mView->goNext();
        showSelectedDates = true;
        break;
    case Qt::Key_Left:
        if ( e->state() == Qt::ControlButton||  e->state() == Qt::ShiftButton )
            mView->goPreviousMonth();
        else
            mView->goPrevious();
        showSelectedDates = true;
        break;
    case Qt::Key_Down:
        mView->viewManager()->agendaView()->scrollOneHourDown();
        break;
    case Qt::Key_Up:
        mView->viewManager()->agendaView()->scrollOneHourUp();
        break;             
    case Qt::Key_I:
        mView->showIncidence();
        break;
    case Qt::Key_Delete:
    case Qt::Key_Backspace:
        mView->deleteIncidence();
        break;
    case Qt::Key_D:
        mView->viewManager()->showDayView();
        showSelectedDates = true;
        break;
    case Qt::Key_O:
        mView->toggleFilerEnabled( );
        break;
    case Qt::Key_0:
    case Qt::Key_1:
    case Qt::Key_2:
    case Qt::Key_3:
    case Qt::Key_4:
    case Qt::Key_5:
    case Qt::Key_6:
    case Qt::Key_7: 
    case Qt::Key_8:
    case Qt::Key_9:
        pro =  e->key()-48;
        if ( pro == 0 )
            pro = 10;
        if ( e->state() == Qt::ControlButton)
            pro += 10;
        break;
    case Qt::Key_M:
        mView->viewManager()->showMonthView();
        showSelectedDates = true;
        break;
    case Qt::Key_Insert:
        mView->newEvent();
        break;
    case Qt::Key_S :
        if ( e->state() == Qt::ControlButton ||  e->state() == Qt::ShiftButton)
            mView->newSubTodo();
        else 
            mView->dialogManager()->showSearchDialog();
        break;
    case Qt::Key_Y :
    case Qt::Key_Z :
        mView->viewManager()->showWorkWeekView();
        showSelectedDates = true;
        break;
    case Qt::Key_U :
        mView->viewManager()->showWeekView();
        showSelectedDates = true;
        break;
    case Qt::Key_H :
        keyBindings();
        break;
    case Qt::Key_W:
        mView->viewManager()->showWhatsNextView();
        break; 
    case Qt::Key_L:
        mView->viewManager()->showListView();
        break; 
    case Qt::Key_N:
        mView->viewManager()->showNextXView();
        showSelectedDates = true;
        break; 
    case Qt::Key_V:
        mView->viewManager()->showTodoView();
        break; 
    case Qt::Key_C:
        mView->viewManager()->agendaView()->setStartHour( QTime::currentTime ().hour() );
        break;       
    case Qt::Key_P:
        mView->showDatePicker( );
        break;      
    case Qt::Key_F: 
        if ( e->state() == Qt::ControlButton||  e->state() == Qt::ShiftButton )
            mView->editFilters();
        else
            mView->toggleFilter();
        break;          
    case Qt::Key_X:
        mView->toggleDateNavigatorWidget();
        break;          
    case Qt::Key_Space:
        mView->toggleExpand();
        break;     
    case Qt::Key_A:
        mView->toggleAllDaySize();
        break; 
    case Qt::Key_T:
        if ( e->state() == Qt::ControlButton||  e->state() == Qt::ShiftButton )
            mView->newTodo();
        else {
            mView->goToday();
            showSelectedDates = true;
        }
        break;
    case Qt::Key_J:
        mView->viewManager()->showJournalView();
        break;
    case Qt::Key_B:
        mView->editIncidenceDescription();;
        break;
        // case Qt::Key_Return:  
    case Qt::Key_E:  
        if ( e->state() == Qt::ControlButton||  e->state() == Qt::ShiftButton )
            mView->newEvent();
        else
            mView->editIncidence();
        break;
    case Qt::Key_Plus:
        size = p->mHourSize +2;
        if ( size <= 18 )
            configureAgenda( size );
        break;
    case Qt::Key_Minus:
        size = p->mHourSize - 2;
        if ( size >= 4 )
            configureAgenda( size );
        break;
       

    default:
        e->ignore();
    }
    if ( pro > 0 ) {
        mView->selectFilter(  pro-1 );
    }
    if ( showSelectedDates ) {
        ;//  setCaptionToDates();
    }

}

void MainWindow::configureToolBar( int item  )
{

    configureToolBarMenu->setItemChecked( item, !configureToolBarMenu-> isItemChecked ( item ) );
    KOPrefs *p = KOPrefs::instance();
    p-> mShowIconStretch= configureToolBarMenu->isItemChecked( 5 );
    p-> mShowIconNewEvent= configureToolBarMenu->isItemChecked( 10 );
    p->mShowIconNewTodo = configureToolBarMenu->isItemChecked( 20 );
    p-> mShowIconSearch= configureToolBarMenu->isItemChecked( 120 );
    p-> mShowIconList= configureToolBarMenu->isItemChecked( 30 );
    p-> mShowIconDay1= configureToolBarMenu->isItemChecked( 40 );
    p-> mShowIconDay5= configureToolBarMenu->isItemChecked( 50 );
    p-> mShowIconDay7= configureToolBarMenu->isItemChecked( 60 );
    p-> mShowIconMonth= configureToolBarMenu->isItemChecked( 70 );
    p-> mShowIconTodoview= configureToolBarMenu->isItemChecked( 80 );
    p-> mShowIconBackFast= configureToolBarMenu->isItemChecked( 200 );
    p-> mShowIconBack = configureToolBarMenu->isItemChecked( 210 );
    p-> mShowIconToday= configureToolBarMenu->isItemChecked( 130 ); 
    p-> mShowIconForward= configureToolBarMenu->isItemChecked( 220 );
    p-> mShowIconForwardFast= configureToolBarMenu->isItemChecked( 230 );
    p-> mShowIconNextDays= configureToolBarMenu->isItemChecked( 100 );
    p-> mShowIconNext= configureToolBarMenu->isItemChecked( 110 );
    p-> mShowIconJournal= configureToolBarMenu->isItemChecked( 90 );
    p-> mShowIconWhatsThis= configureToolBarMenu->isItemChecked( 300 ); 
    // initActions();
}

void MainWindow::setCaptionToDates()
{
    QString selDates;
    selDates = KGlobal::locale()->formatDate(mView->startDate(), true);
    if  (mView->startDate() < mView->endDate() )
        selDates += " - " + KGlobal::locale()->formatDate(mView->endDate(), true);
    setCaption( i18n("Dates: ") + selDates );
    
}
// parameter item == 0: reinit
void MainWindow::configureAgenda( int item )
{  

    KOPrefs *p = KOPrefs::instance();

    int i;
    if ( item == 1 ) {
        mView->toggleAllDaySize();
        return;
    }
    // do not allow 4 for widgets higher than 480
 //    if ( QApplication::desktop()->height() > 480 ) {
//         if ( item == 4 )
//             item = 6;
//     }
    for ( i = 4; i <= 18; i= i+2 )
        configureAgendaMenu->setItemChecked( i, false );
    configureAgendaMenu->setItemChecked( item, true );
    if ( p->mHourSize == item )
        return;
    p->mHourSize=item;
    mView->viewManager()->agendaView()->updateConfig();
}

void  MainWindow::saveCalendar()
{ 
    QString fn =  KOPrefs::instance()->mLastSaveFile;
    fn =  KFileDialog::getSaveFileName( fn, i18n("Save backup filename"), this );

    if ( fn == "" )
        return;
    QFileInfo info;
    info.setFile( fn );
    QString mes;
    bool createbup = true;
    if ( info. exists() ) { 
        mes =  i18n("Backup file\nalready exists!\nOld backup file from:\n%1\nOverwrite?\n").arg(KGlobal::locale()->formatDateTime(info.lastModified (), true, false )) ;
        int result = QMessageBox::warning( this, i18n("KO/Pi: Warning!"),mes,
                                           i18n("Overwrite!"), i18n("Cancel"), 0,
                                           0, 1 );
        if ( result != 0 ) {
            createbup = false;
        }
    }
    if ( createbup ) {
        mView->saveCalendar( fn ); 
        mes = i18n("KO/Pi:Saved %1").arg(fn);
        KOPrefs::instance()->mLastSaveFile = fn;
        setCaption(mes);
    }
}
void  MainWindow::loadCalendar()
{
   
    QString fn =   KOPrefs::instance()->mLastLoadFile;
    fn =  KFileDialog::getOpenFileName( fn, i18n("Load backup filename"), this );
    
    if ( fn == "" )
        return;
    QFileInfo info;
    info.setFile( fn );
    QString mess;
    bool loadbup = true;
    if ( info. exists() ) {
        mess =   i18n("Backup file from:\n%1\nLoading  backup\nfile will delete\nyour current Data!\n").arg(KGlobal::locale()->formatDateTime(info.lastModified (), true, false ));
        int result = QMessageBox::warning( this, "KO/Pi: Warning!",
                                           mess,
                                           i18n("Load!"), i18n("Cancel"), 0,
                                           0, 1 );
        if ( result != 0 ) {
            loadbup = false;
        }
    } else {
        QMessageBox::warning( this, i18n("KO/Pi: Warning!"),
                              i18n("Backup file\ndoes not exist!\nNothing loaded!"), 0, 0,
                              0, 1 );

        return;
    }
    if ( loadbup ) {
        mView->openCalendar( fn );
        KOPrefs::instance()->mLastLoadFile = fn;
        mess = i18n("KO/Pi:Loaded %1").arg(fn) ;
        setCaption(mess);
    }

}
void  MainWindow::quickImportIcal()
{
    importFile( KOPrefs::instance()->mLastImportFile, false );
}
void MainWindow::importFile( QString  fn, bool quick )
{
    QFileInfo info;
    info.setFile( fn );
    QString mess;
    bool loadbup = true;
    if ( !info. exists() ) {
        mess =  i18n("Import file \n...%1\ndoes not exist!\nNothing imported!\n").arg(fn.right( 30));
        int result = QMessageBox::warning( this, i18n("KO/Pi: Warning!"),
                                           mess );
        return;
    } 
    int result = 0;
    if ( !quick ) { 
        mess = i18n(  "Import file \n...%1\nfrom:\n%2\nDuplicated entries\nwill not be imported!\n").arg(fn.right( 25)).arg(KGlobal::locale()->formatDateTime(info.lastModified (), true, false ));
        result = QMessageBox::warning( this, "KO/Pi: Warning!",
                                       mess,
                                       "Import", "Cancel", 0,
                                       0, 1 );
    }
    if ( result == 0 ) {
        if ( mView->openCalendar( fn, true )) {
            KOPrefs::instance()->mLastImportFile = fn;
            setCaption(i18n("Imported file successfully"));
        } else {
            setCaption(i18n("Error importing file"));
        }
    }
}

void   MainWindow::importIcal()
{
 
    QString fn =KOPrefs::instance()->mLastImportFile;

    fn =KFileDialog:: getOpenFileName( fn, i18n("Import filename(*.ics/*.vcs)"), this );
    if ( fn == "" )
        return;
    importFile(  fn, true );
        
}

void MainWindow::exportVCalendar()
{
    QString fn =  KOPrefs::instance()->mLastVcalFile;
    fn =  KFileDialog::getSaveFileName( fn, i18n("Export vcal filename(*.vcs)"), this );
    if ( fn == "" )
        return;
    QFileInfo info;
    info.setFile( fn );
    QString mes;
    bool createbup = true;
    if ( info. exists() ) { 
        mes = i18n("Save file\nalready exists!\nOld save file from:\n%1\nOverwrite?\n").arg (KGlobal::locale()->formatDateTime(info.lastModified (), true, false ) );
        int result = QMessageBox::warning( this, i18n("KO/Pi: Warning!"),mes,
                                           i18n("Overwrite!"), i18n("Cancel"), 0,
                                           0, 1 );
        if ( result != 0 ) {
            createbup = false;
        }
    }
    if ( createbup ) {
        if ( mView->exportVCalendar( fn ) ) { 
            KOPrefs::instance()->mLastVcalFile = fn; 
            if ( fn.length() > 20 )
                mes = i18n("KO/Pi:Exported to ...%1").arg(fn.right(20)) ;
            else
                mes = i18n("KO/Pi:Exported to %1").arg(fn );
            setCaption(mes);
        }
    }

}
#include <qpushbutton.h> 
QString  MainWindow::getPassword( )
{ 
    QString retfile = "";
    QDialog dia ( this, "input-dialog", true ); 
    QLineEdit lab ( &dia ); 
    lab.setEchoMode( QLineEdit::Password );
    QVBoxLayout lay( &dia );
    lay.setMargin(7); 
    lay.setSpacing(7); 
    lay.addWidget( &lab);
    dia.setFixedSize( 230,50 );
    dia.setCaption( i18n("Enter password") );
    QPushButton pb ( "OK",  &dia); 
    lay.addWidget( &pb );
    connect(&pb, SIGNAL( clicked() ), &dia, SLOT ( accept() ) );
    dia.show();
    int res = dia.exec();
    if ( res )
        retfile = lab.text();
    dia.hide();
    qApp->processEvents();
    return retfile;

}

void MainWindow::syncLocalFile()
{

    QString fn =KOPrefs::instance()->mLastSyncedLocalFile;

    fn =KFileDialog:: getOpenFileName( fn, i18n("Sync filename(*.ics/*.vcs)"), this );
    if ( fn == "" )
        return;
    //mView->setSyncDevice("local-file" );
    if (  syncWithFile(  fn, false ) ) {
       //  Event* e = mView->getLastSyncEvent();
//         e->setReadOnly( false );
//         e->setLocation( i18n("Local file: ")+ KOPrefs::instance()->mLastSyncedLocalFile);
//         e->setReadOnly( true );
    }

}

bool  MainWindow::syncWithFile( QString fn , bool quick )
{
    bool ret = false;
    QFileInfo info;
    info.setFile( fn );
    QString mess;
    bool loadbup = true;
    if ( !info. exists() ) {
        mess =  i18n( "Sync file \n...%1\ndoes not exist!\nNothing synced!\n").arg(fn.right( 30) );
        int result = QMessageBox::warning( this, i18n("KO/Pi: Warning!"),
                                           mess );
        return ret;
    } 
    int result = 0;
    if ( !quick ) { 
        mess =  i18n("Sync with file \n...%1\nfrom:\n%2\n").arg(fn.right( 25)).arg(KGlobal::locale()->formatDateTime(info.lastModified (), true, false ));
        result = QMessageBox::warning( this, i18n("KO/Pi: Warning!"),
                                       mess,
                                       i18n("Sync"), i18n("Cancel"), 0,
                                       0, 1 );
        if ( result ) 
            return false;
    }
    if ( KOPrefs::instance()->mAskForPreferences )
        mView->edit_sync_options(); 
    if ( result == 0 ) {
        //qDebug("Now sycing ... ");
        if ( ret = mView->syncCalendar( fn, KOPrefs::instance()->mSyncAlgoPrefs ) )
            setCaption( i18n("Synchronization successful") );
        else
            setCaption( i18n("Sync cancelled or failed. Nothing synced.") );
        if ( ! quick )
            KOPrefs::instance()->mLastSyncedLocalFile = fn;
        slotModifiedChanged( true );
    }
    return ret;
}
void MainWindow::quickSyncLocalFile()
{
    //mView->setSyncDevice("local-file" );
    //qDebug("quickSyncLocalFile() ");
    if ( syncWithFile( KOPrefs::instance()->mLastSyncedLocalFile, false ) ) {
       //  Event* e = mView->getLastSyncEvent();
//         e->setReadOnly( false );
//         e->setLocation( i18n("Quick with file: ")+ KOPrefs::instance()->mLastSyncedLocalFile);
//         e->setReadOnly( true );

    }
}

void MainWindow::confSync()
{
    mView->confSync();
    fillSyncMenu();
    mView->writeSettings();
    

}
void MainWindow::syncRemote( KSyncProfile* prof,  bool ask)
{
    QString question;
    if ( ask ) {
    question = i18n("Do you really want\nto remote sync\nwith profile \n")+ prof->getName()+" ?\n";
    if ( QMessageBox::information( this, i18n("KO/Pi Sync"),
                                   question,
                                   i18n("Yes"), i18n("No"), 
                                   0, 0 ) != 0 )
        return;
    }
    QString command = prof->getPreSyncCommand();
    int fi;
    if ( (fi = command.find("$PWD$")) > 0 ) {
        QString pwd = getPassword();
        command = command.left( fi )+ pwd + command.mid( fi+5 );

    } 
    int maxlen = 30;
    if ( QApplication::desktop()->width() > 320 ) 
        maxlen += 25;
    setCaption ( i18n( "Copy remote file to local machine..." ) );
    int fileSize = 0;
    int result = system ( command );
    // 0 : okay
    // 256: no such file or dir
    //
    qDebug("KO: Remote copy result(0 = okay): %d ",result );
    if ( result != 0 ) {
        int len = maxlen;
        while ( len <  command.length() ) {
            command.insert( len , "\n" );
            len += maxlen +2;
        }
        question = i18n("Sorry, the copy command failed!\nCommand was:\n%1\n \nTry command on console to get more\ndetailed info about the reason.\n").arg (command) ;
        QMessageBox::information( this, i18n("KO/Pi Sync - ERROR"),
                                  question,
                                  i18n("Okay!")) ;
        setCaption ("KO/Pi"); 
        return;
    }
    setCaption ( i18n( "Copying succeed." ) );
    //qDebug(" file **%s** ",prof->getLocalTempFile().latin1() );
    if ( syncWithFile( prof->getLocalTempFile(), true ) ) {
//         Event* e = mView->getLastSyncEvent();
//         e->setReadOnly( false );
//         e->setLocation( KOPrefs::instance()->mSyncProfileNames[mCurrentSyncProfile]);
//         e->setReadOnly( true );
        if ( KOPrefs::instance()->mWriteBackFile ) {
            command =  prof->getPostSyncCommand();   
            setCaption ( i18n( "Writing back file ..." ) );
            result = system ( command );
            qDebug("KO: Writing back file result: %d ", result);
            if ( result != 0 ) {
                setCaption ( i18n( "Writing back file result: " )+QString::number( result ) );
                return;
            } else {
                setCaption ( i18n( "Syncronization sucessfully completed" ) );
            }
        }
    }
    return;
}
void MainWindow::syncSSH()
{   
    // not used anymore
    QTime timer; 
    timer.start();
    //qDebug("MainWindow::syncssh() ");
    KOPrefs *p = KOPrefs::instance();
    QString localFile =  p->mLocalTempFile;
    QString remoteIP = p->mRemoteIP;
    QString remoteUser = p->mRemoteUser;
    QString remoteFile = p->mRemoteFile;
    if ( p->mUsePassWd &&  p->mRemotePassWd.length() > 0  )
        remoteUser += ":" + p->mRemotePassWd;

    QString question = i18n("Do you really want\nto remote sync?\n \n") +
        i18n("IP: " ) +remoteIP  +"\n" +
        i18n("User: " ) + remoteUser +"\n" ;
    int maxlen = 30;
    if ( QApplication::desktop()->width() > 320 ) 
        maxlen += 25;
    if ( remoteFile.length() > maxlen )
        question  +=   i18n("Remote file:\n..." ) + remoteFile.right(maxlen) +"\n";
    else
        question  +=   i18n("Remote file:\n " ) + remoteFile +"\n";
    if ( localFile.length() > maxlen )
        question  +=   i18n("Local temp file:\n..." ) + localFile.right(maxlen) +"\n";
    else
        question  +=   i18n("Local temp file:\n " ) + localFile +"\n";
        
    if ( QMessageBox::information( this, i18n("KO/Pi Sync"),
                                   question,
                                   i18n("Yes"), i18n("No"), 
                                   0, 0 ) != 0 )
        return;
    // if ( !p->mUsePassWd ) {
    //         QString pass = getPassword();
    //         if ( pass.length() > 0 )
    //             remoteUser += ":" + pass;
    // }
    QString command = "scp " + remoteUser + "@" + remoteIP +":" + remoteFile +"  " +localFile;
    setCaption ( i18n( "Copy remote file to local machine..." ) );
    int fileSize = 0;
    int result = system ( command );
    // 0 : okay
    // 256: no such file or dir
    //
    qDebug("KO: Remote copy result(0 = okay): %d ",result );
    if ( result != 0 ) {
        int len = maxlen;
        while ( len <  command.length() ) {
            command.insert( len , "\n" );
            len += maxlen +2;
        }
        question = i18n("Sorry, the copy command failed!\nCommand was:\n%1\n \nTry command on console to get more\ndetailed info about the reason.\n").arg (command) ;
        QMessageBox::information( this, i18n("KO/Pi Sync - ERROR"),
                                  question,
                                  i18n("Okay!")) ;
        setCaption ("KO/Pi"); 
        return;
    }


    setCaption ( i18n( "Copying succeed." ) );
    //mView->setSyncDevice("ssh-scp" );
    if ( syncWithFile(localFile , true ) ) {
//         Event* e = mView->getLastSyncEvent();
//         e->setReadOnly( false );
//         e->setLocation( KOPrefs::instance()->mSyncProfileNames[mCurrentSyncProfile]);
//         e->setReadOnly( true );
        if ( KOPrefs::instance()->mWriteBackFile ) {
            command = "scp " + localFile +" " +remoteUser + "@" + remoteIP +":" + remoteFile ;   
            setCaption ( i18n( "Writing back file ..." ) );
            result = system ( command );
            if ( result != 0 ) {
                int len = maxlen;
                while ( len <  command.length() ) {
                    command.insert( len , "\n" );
                    len += maxlen +2;
                }
                question = i18n("Sorry, the copy back command failed!\nCommand was:\n%1\n \nTry command on console to get more\ndetailed info about the reason.\n").arg (command) ;
                QMessageBox::information( this, i18n("KO/Pi Sync - ERROR"),
                                          question,
                                          i18n("Okay!")) ;
                setCaption ("KO/Pi"); 
                return;
            } else {
                setCaption ( i18n( "Syncronization sucessfully completed" ) );
            }
        }
    }
    return;
#if 0
    system ("scp zaurus@192.168.0.65:/home/zaurus/Applications/korganizer/mycalendar.ics /home/polo/Applications/korganizer/z_sync.ics");
    while ( timer.elapsed() < 5000 )
        qApp->processEvents();

    qDebug("MainWindow::merging) ");
    mView->syncCalendar( "/home/polo/Applications/korganizer/z_sync.ics", 0 );
    while ( mBlockSaveFlag ) 
        qApp->processEvents();
    save();
    system ("scp /home/polo/Applications/korganizer/mycalendar.ics zaurus@192.168.0.65:/home/zaurus/Applications/korganizer/mycalendar.ics");
#endif

}


void MainWindow::syncSharp()
{
    if ( mCalendarModifiedFlag )
        save();
    mView->syncSharp();
    slotModifiedChanged( true );
   
}

void MainWindow::printSel( )
{
    mView->viewManager()->agendaView()->agenda()->printSelection();
}

void MainWindow::printCal()
{
    mView->print();//mCp->showDialog();
}
