#ifndef KORGE_MAINWINDOW_H
#define KORGE_MAINWINDOW_H

#include <qmainwindow.h>
#include <qtimer.h>
#include <qdict.h>

#include <libkcal/incidence.h>
#include "simplealarmclient.h"

class QAction;
class CalendarView;
class KSyncProfile;
#ifdef DESKTOP_VERSION

#define QPEToolBar QToolBar
#define QPEMenuBar QMenuBar
#endif
class QPEToolBar;

namespace KCal {
class CalendarLocal;
}

using namespace KCal;

class MainWindow : public QMainWindow
{
    Q_OBJECT
  public:
    MainWindow( QWidget *parent = 0, const char *name = 0, QString command = "");
    ~MainWindow();
 public  slots:  
     void configureAgenda( int );
    void recieve( const QCString& msg, const QByteArray& data );
    static  QString defaultFileName();
    static QString resourcePath();
    protected slots:  
    void setCaptionToDates();
    void ringSync();
    void about(); 
    void faq(); 
    void usertrans(); 
    void features(); 
    void synchowto();       
    void keyBindings();
    void aboutAutoSaving();;
    void aboutKnownBugs();

    void processIncidenceSelection( Incidence * );

    void importQtopia();
    void importIcal();
    void importFile( QString, bool );
    void quickImportIcal();
    
    void slotModifiedChanged( bool );
    
    void save();
    void configureToolBar( int );
    void printSel();
    void printCal();
    void saveCalendar();
    void loadCalendar();
    void exportVCalendar();

    void slotSyncMenu( int );
    void syncSSH();
    void confSync();
    void syncSharp();
    void syncLocalFile();
    bool syncWithFile( QString, bool );
    void quickSyncLocalFile();
    
    
  protected:
    void displayText( QString, QString);
    void displayFile( QString, QString);
    
    void enableIncidenceActions( bool );
    
  private:
    int mCurrentSyncProfile;
    void syncRemote( KSyncProfile* , bool ask = true);
    void fillSyncMenu();
    bool  mFlagKeyPressed;
    bool  mBlockAtStartup;
    QPEToolBar *iconToolBar;
    void initActions();
    void setDefaultPreferences(); 
    void keyPressEvent ( QKeyEvent * ) ;
    void keyReleaseEvent ( QKeyEvent * ) ;
    QPopupMenu *configureToolBarMenu;
    QPopupMenu *configureAgendaMenu, *syncMenu;
    CalendarLocal *mCalendar;
    CalendarView *mView;
    QString  getPassword();
    QAction *mNewSubTodoAction;
    
    QAction *mShowAction;
    QAction *mEditAction;
    QAction *mDeleteAction;
    void closeEvent( QCloseEvent* ce );
    SimpleAlarmClient mAlarmClient;
    QTimer mSaveTimer;
    bool mBlockSaveFlag;
    bool mCalendarModifiedFlag;
    QPixmap loadPixmap( QString );
};

#endif
