#include <stdio.h>
#include <qtopia/qlibrary.h>
#include <qpe/qpeapplication.h>
#include "kabc/koaddressbookpluginloader.h"

KOAddressBookInterface *KOAddressBookPluginLoader::iface = 0;
KABC::Addressee::List KOAddressBookPluginLoader::addresseeList;

KOAddressBookInterface *KOAddressBookPluginLoader::getInterface() {

    if (!iface) {

        const QString & qpeDir = QPEApplication::qpeDir();
        QLibrary *lib = new QLibrary( qpeDir + "/plugins/korganizer/libdtmkabc.so", QLibrary::Immediately );
        QRESULT q = lib->queryInterface( IID_QUnknown, (QUnknownInterface**)&iface );
        if ( q != QS_OK ) {
            QLibrary *lib = new QLibrary( qpeDir + "/plugins/korganizer/libopiekabc.so", QLibrary::Immediately );
            QRESULT q = lib->queryInterface( IID_QUnknown, (QUnknownInterface**)&iface );
            if ( q != QS_OK ) {
                lib = new QLibrary( qpeDir + "/plugins/korganizer/libqtopiakabc.so", QLibrary::Immediately ); 
                QRESULT q = lib->queryInterface( IID_QUnknown, (QUnknownInterface**)&iface );
            }
        }
    }
  
    return iface;
  
}

KABC::Addressee::List KOAddressBookPluginLoader::getAddresseesFromPlugin() {

    //addresseeList.clear();
    if (!(addresseeList.count() > 0)) {
        if (!iface) {
            iface = getInterface();
            if (iface) {
                qDebug("KOAddressBookPluginLoader interface loaded: %s", iface->name().latin1() );
            }
        }
        if (iface) {
            addresseeList = iface->getAddressees();
        } else {
            qDebug("KOAddressBookPluginLoader::getAddresseesFromPlugin: No interface found!");
        }
    }
    //qDebug("End: KOAddressBookPluginLoader::getAddresseesFromPlugin");
    return addresseeList; 

}
