#ifndef MICROKDE_KLISTVIEW_H
#define MICROKDE_KLISTVIEW_H

#include <qlistview.h>
#include <qpoint.h>
#include <qstring.h>
#include <qheader.h>
#include <kconfig.h>

class KConfig;

class KListView : public QListView
{
    Q_OBJECT
        public:
    KListView( QWidget *parent=0, const char *name=0 )
        : QListView( parent, name ) {}

    void saveLayout( KConfig *config, const QString & group) {
        config->setGroup( group );
        QStringList widths, order;
        for (int i = 0; i < columns(); ++i)
            {
                widths << QString::number(columnWidth(i));
                order << QString::number(header()->mapToIndex(i));
            }
        config->writeEntry("ColumnWidths", widths);
        config->writeEntry("ColumnOrder", order);
 
    }
    void restoreLayout( KConfig *config, const QString & group ) {
        config->setGroup( group );
 
        QStringList cols = config->readListEntry("ColumnWidths");
        int i = 0;
        for (QStringList::ConstIterator it = cols.begin(); it != cols.end(); ++it)
            setColumnWidth(i++, (*it).toInt());
 
        cols = config->readListEntry("ColumnOrder");
        i = 0;
        for (QStringList::ConstIterator it = cols.begin(); it != cols.end(); ++it)
            header()->moveSection(i++, (*it).toInt());
 
    }

    void setItemsRenameable (const bool &) {}
    void setRenameable (int) {}

    void repaintContents( bool erase = true )
        {
            QScrollView::repaintContents( contentsX(), contentsY(),
                                          visibleWidth(), visibleHeight(), erase );
        }

 signals:
    void doubleClicked( QListViewItem *, QPoint, int );
};

class KListViewItem : public QListViewItem
{
 public:
    KListViewItem( QListView *parent ) : QListViewItem( parent ) {};
};

#endif
