/*
 * linux/include/asm-arm/arch-dbmx2/pll.h
 *
 * Copyright (C) 2003 Lineo Solutions, Inc.
 *
 * Based on:
 *  linux/include/asm-arm/arch-mx2ads/pll.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright (C) 2003 Motorola Semiconductors SuZhou Ltd
 *
 */

#ifndef __ASM_ARCH_PLL_H
#define __ASM_ARCH_PLL_H

#include "asm/arch/mx2.h"

/*Set the MPLL SPLL output*/
#define CLK_MPLL
#define CLK_SPLL

/* Setting for CSCR 0x10027000*/
#define CSCR_CLKO_SEL
#define CSCR_USB_DIV
#define CSCR_SD_CNT
#define CSCR_SSI2_SEL
#define CSCR_SSI1_SEL
#define CSCR_FIR_SEL
#define CSCR_SP_SEL
#define CSCR_MCU_SEL
#define CSCR_PRESC
#define CSCR_BCLKDIV
#define CSCR_CLKO_SEL
#define CSCR_IPDIV

/*Setting for SPCDR 0x10027018*/
#define SPCDR_SSI2DIV
#define SPCDR_PERDIV2
#define SPCDR_SSI1DIV
#define SPCDR_NFCDIV
#define SPCDR_PERDIV1
#define SPCDR_CLKO_48DIV
#define SPCDR_FIRI_MIRDIV

/* From the setting above, caculating the following frequency*/

#define CLK_FCLK	(CLK_MPLL)/(CSCR_PRESC+1)
#define CLK_HCLK	(CLK_FCLK)/(CSCR_BCLKDIV+1)
#define CLK_NFCCLK	(CLK_FCLK)/(SPCDR_NFCDIV+1)
#define CLK_PERDIV1	(CLK_FCLK)/(SPCDR_PERDIV1+1)
#define CLK_PERDIV2	(CLK_FCLK)/(SPCDR_PERDIV2+1)
#define CLK_PERCLK	(CLK_HCLK)/(CSCR_IPDIV+1)

#define CLK_FIRICLK	(CLK_SPLL)/(SPCDR_FIRI_MIRDIV+1)
#define CLK_CLK48M	(CLK_SPLL)/(CSCR_USB_DIV+1)
#define CLK_SSI1CLK	(CLK_SPLL)/(SPCDR_SSI1DIV+1)
#define CLK_SSI2CLK	(CLK_SPLL)/(SPCDR_SSI2DIV+1)

/* The following clk source are generated by PLL*/

#define GATE_HCLK_MODULE_CSI		0x80000000
#define GATE_HCLK_MODULE_DMA		0x40000000
#define GATE_HCLK_MODULE_SAHARA		0x20000000
#define GATE_HCLK_MODULE_BROM 		0x10000000
#define GATE_HCLK_MODULE_EMMA		0x08000000
#define GATE_HCLK_MODULE_LCDC 		0x04000000
#define GATE_HCLK_MODULE_SLCDC		0x02000000
#define GATE_HCLK_MODULE_USBOTG		0x01000000
#define GATE_HCLK_MODULE_BMI 		0x00800000
#define GATE_IPG_MODULE_SLCDC 		0x00200000
#define GATE_IPG_MODULE_FIR_BUAD	0x00100000
#define GATE_IPG_MODULE_NFC 		0x00080000
#define GATE_IPG_MODULE_LCDC_PIXCLK	0x00040000
#define GATE_IPG_MODULE_SSI1_BAUD 	0x00020000
#define GATE_IPG_MODULE_SSI2_BAUD	0x00010000
#define GATE_IPG_MODULE_EMMA		0x00008000
#define GATE_IPG_MODULE_USBOTG 		0x00004000
#define GATE_IPG_MODULE_DMA 		0x00002000
#define GATE_IPG_MODULE_I2C 		0x00001000
#define GATE_IPG_MODULE_GPIO 		0x00000800
#define GATE_IPG_MODULE_SDHC2		0x00000400
#define GATE_IPG_MODULE_SDHC1		0x00000200
#define GATE_IPG_MODULE_FIR		0x00000100
#define GATE_IPG_MODULE_SSI2 		0x00000080
#define GATE_IPG_MODULE_SSI1		0x00000040
#define GATE_IPG_MODULE_CSPI2		0x00000020
#define GATE_IPG_MODULE_CSPI1		0x00000010
#define GATE_IPG_MODULE_UART1		0x00000008
#define GATE_IPG_MODULE_UART2		0x00000004
#define GATE_IPG_MODULE_UART3		0x00000002
#define GATE_IPG_MODULE_UART4		0x00000001
#define GATE_IPG_MODULE_OWIRE		0x80000000
#define GATE_IPG_MODULE_KPP		0x40000000
#define GATE_IPG_MODULE_RTC		0x20000000
#define GATE_IPG_MODULE_PWM		0x10000000
#define GATE_IPG_MODULE_GPT3		0x08000000
#define GATE_IPG_MODULE_GPT2		0x04000000
#define GATE_IPG_MODULE_GPT1		0x02000000
#define GATE_IPG_MODULE_WDT		0x01000000

/* caculate the frequency of clock source*/

#define CLK_IPG_MODULE_SLCDC 		CLK_PERCLK
#define CLK_IPG_MODULE_FIR_BUAD		CLK_FIRICLK
#define CLK_IPG_MODULE_NFC 		CLK_NFCCLK
#define CLK_IPG_MODULE_LCDC_PIXCLK	CLK_PERDIV2
#define CLK_IPG_MODULE_SSI1_BAUD 	CLK_SSI1CLK
#define CLK_IPG_MODULE_SSI2_BAUD	CLK_SSI2CLK
#define CLK_IPG_MODULE_EMMA		CLK_PERCLK
#define CLK_IPG_MODULE_USBOTG 		CLK_CLK48M
#define CLK_IPG_MODULE_DMA 		CLK_PERCLK
#define CLK_IPG_MODULE_I2C 		CLK_PERCLK
#define CLK_IPG_MODULE_GPIO 		CLK_PERCLK
#define CLK_IPG_MODULE_SDHC2		CLK_PERDIV2
#define CLK_IPG_MODULE_SDHC1		CLK_PERDIV2
#define CLK_IPG_MODULE_FIR		CLK_PERCLK
#define CLK_IPG_MODULE_SSI2 		CLK_PERCLK
#define CLK_IPG_MODULE_SSI1		CLK_PERCLK
#define CLK_IPG_MODULE_CSPI2		CLK_PERDIV2
#define CLK_IPG_MODULE_CSPI1		CLK_PERDIV2
#define CLK_IPG_MODULE_UART1		CLK_PERDIV1
#define CLK_IPG_MODULE_UART2		CLK_PERDIV1
#define CLK_IPG_MODULE_UART3		CLK_PERDIV1
#define CLK_IPG_MODULE_UART4		CLK_PERDIV1
#define CLK_IPG_MODULE_OWIRE		CLK_PERCLK
#define CLK_IPG_MODULE_KPP		CLK_PERCLK
#define CLK_IPG_MODULE_RTC		CLK_PERCLK
#define CLK_IPG_MODULE_PWM		CLK_PERDIV1
#define CLK_IPG_MODULE_GPT3		CLK_PERDIV1
#define CLK_IPG_MODULE_GPT2		CLK_PERDIV1
#define CLK_IPG_MODULE_GPT1		CLK_PERDIV1
#define CLK_IPG_MODULE_WDT		CLK_PERCLK

/* define the clock gate register */

#define GATE_REG_HCLK_MODULE_CSI		_reg_CRM_PCCR0
#define GATE_REG_HCLK_MODULE_DMA		_reg_CRM_PCCR0
#define GATE_REG_HCLK_MODULE_SAHARA		_reg_CRM_PCCR0
#define GATE_REG_HCLK_MODULE_BROM 		_reg_CRM_PCCR0
#define GATE_REG_HCLK_MODULE_EMMA		_reg_CRM_PCCR0
#define GATE_REG_HCLK_MODULE_LCDC 		_reg_CRM_PCCR0
#define GATE_REG_HCLK_MODULE_SLCDC		_reg_CRM_PCCR0
#define GATE_REG_HCLK_MODULE_USBOTG		_reg_CRM_PCCR0
#define GATE_REG_HCLK_MODULE_BMI 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_SLCDC 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_FIR_BUAD		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_NFC 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_LCDC_PIXCLK		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_SSI1_BAUD 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_SSI2_BAUD		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_EMMA		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_USBOTG 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_DMA 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_I2C 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_GPIO 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_SDHC2		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_SDHC1		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_FIR			_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_SSI2 		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_SSI1		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_CSPI2		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_CSPI1		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_UART1		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_UART2		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_UART3		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_UART4		_reg_CRM_PCCR0
#define GATE_REG_IPG_MODULE_OWIRE		_reg_CRM_PCCR1
#define GATE_REG_IPG_MODULE_KPP			_reg_CRM_PCCR1
#define GATE_REG_IPG_MODULE_RTC			_reg_CRM_PCCR1
#define GATE_REG_IPG_MODULE_PWM			_reg_CRM_PCCR1
#define GATE_REG_IPG_MODULE_GPT3		_reg_CRM_PCCR1
#define GATE_REG_IPG_MODULE_GPT2		_reg_CRM_PCCR1
#define GATE_REG_IPG_MODULE_GPT1		_reg_CRM_PCCR1
#define GATE_REG_IPG_MODULE_WDT			_reg_CRM_PCCR1


#define  mx_module_get_clk(module)	CLK_IPG_##module
#define  mx_module_clk_open(module)	GATE_REG_##module |= GATE_##module
#define  mx_module_clk_close(module)	GATE_REG_##module &= ~GATE_##module
#endif

