/*
 * linux/include/asm-sh/sh7710.h
 *
 * Copyright (c) 2004 Lineo Solutions, Inc.
 * Copyright (c) 2002 Lineo Japan, Inc.
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Hitachi SH7710 support.
 */
#ifndef __ASM_SH_SH7710_H
#define __ASM_SH_SH7710_H 1

#define MMUCR		0xFFFFFFE0
#define PTEH		0xFFFFFFF0
#define PTEL		0xFFFFFFF4
#define TTB		0xFFFFFFF8
#define TEA		0xFFFFFFFC

#define CCR1		0xFFFFFFEC
#define CCR2		0xA40000B0
#define CCR3		0xA40000B4

#define INTEVT2		0xA4000000
#define TRA		0xFFFFFFD0
#define EXPEVT		0xFFFFFFD4

#define IPRA		0xA414FEE2
#define IPRB		0xA414FEE4
#define IPRC		0xA4140016
#define IPRD		0xA4140018
#define IPRE		0xA414001A
#define IPRF		0xA4080000
#define IPRG		0xA4080002
#define IPRH		0xA4080004
#define IPRI		0xA4080006
#if 0
#define IMR0		0xA4080040
#define IMR1		0xA4080042
#define IMR2		0xA4080044
#define IMR3		0xA4080046
#define IMR4		0xA4080048
#define IMR5		0xA408004A
#define IMR6		0xA408004C
#define IMR7		0xA408004E
#define IMR8		0xA4080050
#define IMR9		0xA4080052

#define IMCR0		0xA4080060
#define IMCR1		0xA4080062
#define IMCR2		0xA4080064
#define IMCR3		0xA4080066
#define IMCR4		0xA4080068
#define IMCR5		0xA408006A
#define IMCR6		0xA408006C
#define IMCR7		0xA408006E
#define IMCR8		0xA4080070
#define IMCR9		0xA4080072
#endif

#define ICR0		0xA414FEE0
#define ICR1		0xA4140010
#define ICR2		0xA4140020

#define IRR0		0xA4140004

#define CMNCR		0xA4FD0000
#define CS0BCR		0xA4FD0004
#define CS2BCR		0xA4FD0008
#define CS3BCR		0xA4FD000C
#define CS4BCR		0xA4FD0010
#define CS5ABCR		0xA4FD0014
#define CS5BBCR		0xA4FD0018
#define CS6ABCR		0xA4FD001C
#define CS6BBCR		0xA4FD0020
#define CS0WCR		0xA4FD0024
#define CS2WCR		0xA4FD0028
#define CS3WCR		0xA4FD002C
#define CS4WCR		0xA4FD0030
#define CS5AWCR		0xA4FD0034
#define CS5BWCR		0xA4FD0038
#define CS6AWCR		0xA4FD003C
#define CS6BWCR		0xA4FD0040

#define SAR0		0xA4010020
#define DAR0		0xA4010024
#define DMATCR0		0xA4010028
#define CHCR0		0xA401002C
#define SAR1		0xA4010030
#define DAR1		0xA4010034
#define DMATCR1		0xA4010038
#define CHCR1		0xA401003C
#define SAR2		0xA4010040
#define DAR2		0xA4010044
#define DMATCR2		0xA4010048
#define CHCR2		0xA401004C
#define SAR3		0xA4010050
#define DAR3		0xA4010054
#define DMATCR3		0xA4010058
#define CHCR3		0xA401005C
#define SAR4		0xA4010070
#define DAR4		0xA4010074
#define DMATCR4		0xA4010078
#define CHCR4		0xA401007C
#define SAR5		0xA4010080
#define DAR5		0xA4010084
#define DMATCR5		0xA4010088
#define CHCR5		0xA401008C

#define DMAOR		0xA4010060
#define DMARS0		0xA4090000
#define DMARS1		0xA4090004
#define DMARS2		0xA4090008

#if 0
#define UCLKCR		0xA40A0008
#define FCLKCR		0xA40A000C
#endif

#define FRQCR		0xA415FF80

#define BARA		0xA4FFFFB0
#define BAMRA		0xA4FFFFB4
#define BBRA		0xA4FFFFB8

#define BARB		0xA4FFFFA0
#define BAMRB		0xA4FFFFA4
#define BBRB		0xA4FFFFA8
#define BDRB		0xA4FFFF90
#define BDMRB		0xA4FFFF94
#define BRCR		0xA4FFFF98

#define BETR		0xA4FFFF9C
#define BRSR		0xA4FFFFAC
#define BRDR		0xA4FFFFBC
#define BASRA		0xFFFFFFE4
#define BASRB		0xFFFFFFE8

#define WTCNT		0xA415FF84
#define WTCSR		0xA415FF86

#if 0
#define RWTCNT		0xA4520000
#define RWTCSR		0xA4520004
#endif

#define STBCR		0xA415FF82
#define STBCR2		0xA415FF88
#define STBCR3		0xA40A0000

#if 0
#define STBCR4		0xA40A0004
#define STBCR5		0xA40A0010
#endif

#define TMU_TSTR	0xA412FE92
#define TMU_TCOR0	0xA412FE94
#define TMU_TCNT0	0xA412FE98
#define TMU_TCR0	0xA412FE9C
#define TMU_TCOR1	0xA412FEA0
#define TMU_TCNT1	0xA412FEA4
#define TMU_TCR1	0xA412FEA8
#define TMU_TCOR2	0xA412FEAC
#define TMU_TCNT2	0xA412FEB0
#define TMU_TCR2	0xA412FEB4

#define SCSMR0		0xA4400000
#define SCBRR0		0xA4400004
#define SCSCR0		0xA4400008
#define SCFTDR0		0xA440000C
#define SCFSR0		0xA4400010
#define SCFRDR		0xA4400014
#define SCFCR0		0xA4400018
#define SCFDR0		0xA440001C
#define SCLSR0		0xA4400024

#define SCSMR1		0xA4410000
#define SCBRR1		0xA4410004
#define SCSCR1		0xA4410008
#define SCFTDR1		0xA441000C
#define SCFSR1		0xA4410010
#define SCFRDR1		0xA4410014
#define SCFCR1		0xA4410018
#define SCFDR1		0xA441001C
#define SCLSR1		0xA4410024

#define SIOF_SIMDR0	0xA4420000
#define SIOF_SISCR0	0xA4420002
#define SIOF_SITDAR0	0xA4420004
#define SIOF_SIRDAR0	0xA4420006
#define SIOF_SICDAR0	0xA4420008
#define SIOF_SICTR0	0xA442000C
#define SIOF_SIFCTR0	0xA4420010
#define SIOF_SISTR0	0xA4420014
#define SIOF_SIIER0	0xA4420016
#define SIOF_SITDR0	0xA4420020
#define SIOF_SIRDR0	0xA4420024
#define SIOF_SITCR0	0xA4420028
#define SIOF_SIRCR0	0xA442002C

#define SIOF_SIMDR1	0xA4430000
#define SIOF_SISCR1	0xA4430002
#define SIOF_SITDAR1	0xA4430004
#define SIOF_SIRDAR1	0xA4430006
#define SIOF_SICDAR1	0xA4430008
#define SIOF_SICTR1	0xA443000C
#define SIOF_SIFCTR1	0xA4430010
#define SIOF_SISTR1	0xA4430014
#define SIOF_SIIER1	0xA4430016
#define SIOF_SITDR1	0xA4430020
#define SIOF_SIRDR1	0xA4430024
#define SIOF_SITCR1	0xA4430028
#define SIOF_SIRCR1	0xA443002C

#if 0
#define SIO_SIMDR0	0xA4500000
#define SIO_SICTR0	0xA4500004
#define SIO_SISTBCR00	0xA4500008
#define SIO_SISTBCR10	0xA450000C
#define SIO_SITDR0	0xA4500014
#define SIO_SIRDR0	0xA4500018
#define SIO_SISTR0	0xA450001C
#define SIO_SIIER0	0xA4500020
#define SIO_SISCR0	0xA4500024

#define SIO_SIMDR1	0xA4510000
#define SIO_SICTR1	0xA4510004
#define SIO_SISTBCR01	0xA4510008
#define SIO_SISTBCR11	0xA451000C
#define SIO_SITDR1	0xA4510014
#define SIO_SIRDR1	0xA4510018
#define SIO_SISTR1	0xA451001C
#define SIO_SIIER1	0xA4510020
#define SIO_SISCR1	0xA4510024
#endif

#ifndef PACR
#define PACR		0xA4050100
#define PBCR		0xA4050102
#define PCCR		0xA4050104
#define PETCR		0xA4050106
#if 0
#define PDCR		0xA4050106
#define PECR		0xA4050108
#define PFCR		0xA405010A
#define PGCR		0xA405010C
#define PHCR		0xA405010E
#define PJCR		0xA4050110
#define PKCR		0xA4050112
#define PLCR		0xA4050114
#define SCPCR		0xA4050116
#define PMCR		0xA4050118
#define PNCR		0xA405011A
#define PQCR		0xA405011C
#define SCPCR2		0xA405011E
#endif
#endif

#if 0
#define PSELA		0xA4050140
#define HIZCRA		0xA4050146
#define HIZCRB		0xA4050148
#endif

#define PADR		0xA4050120
#define PBDR		0xA4050122
#define PCDR		0xA4050124
#if 0
#define PDDR		0xA4050126
#define PEDR		0xA4050128
#define PFDR		0xA405012A
#define PGDR		0xA405012C
#define PHDR		0xA405012E
#define PJDR		0xA4050130
#define PKDR		0xA4050132
#define PLDR		0xA4050134
#define SCPDR		0xA4050136
#define PMDR		0xA4050138
#define PNDR		0xA405013A
#define PQDR		0xA405013C
#define SCPDR2		0xA405013E

#define ADDRA		0xA44C0080
#define ADDRB		0xA44C0082
#define ADDRC		0xA44C0084
#define ADDRD		0xA44C0086
#define ADCSR		0xA44C0088

#define CMSTR		0xA44A0000
#define CMCSR0		0xA44A0010
#define CMCNT0		0xA44A0014
#define CMCOR0		0xA44A0018
#define CMCSR1		0xA44A0020
#define CMCNT1		0xA44A0024
#define CMCOR1		0xA44A0028
#define CMCSR2		0xA44A0030
#define CMCNT2		0xA44A0034
#define CMCOR2		0xA44A0038
#define CMCSR3		0xA44A0040
#define CMCNT3		0xA44A0044
#define CMCOR3		0xA44A0048
#define CMCSR4		0xA44A0050
#define CMCNT4		0xA44A0054
#define CMCOR4		0xA44A0058
#define CMCSR5		0xA44A0060
#define CMCNT5		0xA44A0064
#define CMCOR5		0xA44A0068

#define USBIFR0		0xA4480000
#define USBISR0		0xA4480010
#define USBIER0		0xA4480020
#define USBEPDR0I	0xA4480030
#define USBEPDR0O	0xA4480034
#define USBEPDR0S	0xA4480038
#define USBEPDR1	0xA448003C
#define USBEPDR2	0xA4480040
#define USBEPDR3	0xA4480044
#define USBEPDR4	0xA4480048
#define USBEPDR5	0xA448004C
#define USBEPDR6	0xA4480050
#define USBEPDR7	0xA4480054
#define USBEPDR8	0xA4480058
#define USBEPDR9	0xA448005C
#define USBEPSZ0O	0xA4480080
#define USBEPSZ3	0xA4480084
#define USBEPSZ6	0xA4480088
#define USBEPSZ9	0xA448008C
#define USBTRG		0xA44800A0
#define USBDASTS	0xA44800A4
#define USBFCLR		0xA44800A8
#define USBDMA		0xA44800AC
#define USBEPSTL	0xA44800B0
#define USBCVR		0xA44800B4
#define USBTSR		0xA44800C0
#define USBXVERCR	0xA44800D0

#define ICDR		0xA4470000
#define ICCR		0xA4470004
#define ICSR		0xA4470008
#define ICIC		0xA447000C
#define ICCL		0xA4470010 
#define ICCH		0xA4470014

#define SIM_SCSMR	0xA4490000
#define SIM_SCBRR	0xA4490002
#define SIM_SCSCR	0xA4490004
#define SIM_SCTDR	0xA4490006
#define SIM_SCSSR	0xA4490008
#define SIM_SCRDR	0xA449000A
#define SIM_SCSCMR	0xA449000C
#define SIM_SCSC2R	0xA449000E
#define SIM_SCWAIT	0xA4490010
#define SIM_SCGRD	0xA4490012
#define SIM_SCSMPL	0xA4490014

#define MMC_CMDR0	0xA45C0000
#define MMC_CMDR1	0xA45C0001
#define MMC_CMDR2	0xA45C0002
#define MMC_CMDR3	0xA45C0003
#define MMC_CMDR4	0xA45C0004
#define MMC_CMDR5	0xA45C0005
#define MMC_CMDR6	0xA45C0006
#define MMC_OPCR	0xA45C000A
#define MMC_CSTR	0xA45C000B
#define MMC_INTCR0	0xA45C000C
#define MMC_INTCR1	0xA45C000D
#define MMC_INTCR2	0xA45C0046
#define MMC_INTSTR0	0xA45C000E
#define MMC_INTSTR1	0xA45C000F
#define MMC_INTSTR2	0xA45C0048
#define MMC_CLKON	0xA45C0010
#define MMC_CTOCR	0xA45C0011
#define MMC_IOMCR	0xA45C0013
#define MMC_TBCR	0xA45C0014
#define MMC_MODER	0xA45C0016
#define MMC_CMDTYR	0xA45C0018
#define MMC_RSPTYR	0xA45C0019
#define MMC_TBNCR	0xA45C001A
#define MMC_RSPR0	0xA45C0020
#define MMC_RSPR1	0xA45C0021
#define MMC_RSPR2	0xA45C0022
#define MMC_RSPR3	0xA45C0023
#define MMC_RSPR4	0xA45C0024
#define MMC_RSPR5	0xA45C0025
#define MMC_RSPR6	0xA45C0026
#define MMC_RSPR7	0xA45C0027
#define MMC_RSPR8	0xA45C0028
#define MMC_RSPR9	0xA45C0029
#define MMC_RSPR10	0xA45C002A
#define MMC_RSPR11	0xA45C002B
#define MMC_RSPR12	0xA45C002C
#define MMC_RSPR13	0xA45C002D
#define MMC_RSPR14	0xA45C002E
#define MMC_RSPR15	0xA45C002F
#define MMC_RSPR16	0xA45C0030
#define MMC_DMACR	0xA45C0044
#define MMC_DTOUTR	0xA45C0032
#define MMC_DR		0xA45C0040
#define MMC_FIFOCLR	0xA45C0042

#define MFIIDX		0xA44D0000
#define MFIGSR		0xA44D0004
#define MFISCR		0xA44D0008
#define MFIMCR		0xA44D000C
#define MFIIICR		0xA44D0010
#define MFIEICR		0xA44D0014
#define MFIADR		0xA44D0018
#define MFIDATA		0xA44D001C
#define LCDCR		0xA44D0038
#define MFIBCR		0xA44D0040

#define CAPSR		0xA4401000
#define CAPCR		0xA4401004
#define CAPAR		0xA4401008
#define CAPDR		0xA440100C
#define CNVSR		0xA4401010
#define CNVCR		0xA4401014
#define CNVPR		0xA4401018
#define EVNTRCLR	0xA4401020
#define EVNTRSET	0xA4401024

#define FLCMNCR		0xA4530000
#define FLCMDCR		0xA4530004
#define FLCMCDR		0xA4530008
#define FLADR		0xA453000C
#define FLDATAR		0xA4530010
#define FLDTCNTR	0xA4530014
#define FLINTDMACR	0xA4530018
#define FLBSYTMR	0xA453001C
#define FLBSYCNT	0xA4530020
#define FLDTFIFO	0xA4530024
#define FLECFIFO	0xA4530028
#define FLTRCR		0xA453002C

#define KYCR1		0xA44B0000
#define KYCR2		0xA44B0004
#define KYINDR		0xA44B0008
#define KYOUTDR		0xA44B000C

#endif

/* EtherC(MAC-0) */
#define ECMR0		0xA7000160
#define ECSR0		0xA7000164
#define ECSIPR0		0xA7000168
#define PIR0		0xA700016C
#define MAHR0		0xA7000170
#define MALR0		0xA7000174
#define RFLR0		0xA7000178
#define PSR0		0xA700017C
#define TROCR0		0xA7000180
#define CDCR0		0xA7000184
#define LCCR0		0xA7000188
#define CNDCR0		0xA700018C
#define CEFCR0		0xA7000194

#define FRECR0		0xA7000198
#define TSFRCR0		0xA700019C
#define TLFRCR0		0xA70001A0
#define RFCR0		0xA70001A4
#define MAFCR0		0xA70001A8
#define IPGR0		0xA70001B4
/*  EtherC(MAC-1) */
#define ECMR1		0xA7000560
#define ECSR1		0xA7000564
#define ECSIPR1		0xA7000568
#define PIR1		0xA700056C
#define MAHR1		0xA7000570
#define MALR1		0xA7000574
#define RFLR1		0xA7000578
#define PSR1		0xA700057C
#define TROCR1		0xA7000580
#define CDCR1		0xA7000584
#define LCCR1		0xA7000588
#define CNDCR1		0xA700058C
#define CEFCR1		0xA7000594
#define FRECR1		0xA7000598
#define TSFRCR1		0xA700059C
#define TLFRCR1		0xA70005A0
#define RFCR1		0xA70005A4
#define MAFCR1		0xA70005A8
#define IPGR1		0xA70005B4
/* EtherC */
#define ARSTR		0xA7000800
/* EtherC(TSU) */
#define TSU_CTRST	0xA7000804
#define TSU_FWEN0	0xA7000810
#define TSU_FWEN1	0xA7000814
#define TSU_FCM		0xA7000818
#define TSU_BSYSL0	0xA7000820
#define TSU_BSYSL1	0xA7000824
#define TSU_PRISL0	0xA7000828
#define TSU_PRISL1	0xA700082C
#define TSU_FWSL0	0xA7000830
#define TSU_FWSL1	0xA7000834
#define TSU_FWSLC	0xA7000838

#define TSU_QTAGM0	0xA7000840
#define TSU_QTAGM1	0xA7000844
#define TSU_ADQT0	0xA7000848
#define TSU_ADQT1	0xA700084C
#define TSU_FWSR	0xA7000850
#define TSU_FWINMK	0xA7000854
#define TSU_ADSBSY	0xA7000860
#define TSU_TEN		0xA7000864
#define TSU_POST1	0xA7000870
#define TSU_POST2	0xA7000874
#define TSU_POST3	0xA7000878
#define TSU_POST4	0xA700087C
#define TXNLCR0		0xA7000880
#define TXALCR0		0xA7000884
#define RXNLCR0		0xA7000888
#define RXALCR0		0xA700088C
#define FWNLCR0		0xA7000890
#define FWALCR0		0xA7000894
#define TXNLCR1		0xA70008A0
#define TXALCR1		0xA70008A4
#define RXNLCR1		0xA70008A8
#define RXALCR1		0xA70008AC
#define FWNLCR1		0xA70008B0
#define FWALCR1		0xA70008B4
#define TSU_ADRH0	0xA7000900
#define TSU_ADRL0	0xA7000904
#define TSU_ADRH1	0xA7000908
#define TSU_ADRL1	0xA700090C
#define TSU_ADRH2	0xA7000910
#define TSU_ADRL2	0xA7000914
#define TSU_ADRH3	0xA7000918
#define TSU_ADRL3	0xA700091C
#define TSU_ADRH4	0xA7000920
#define TSU_ADRL4	0xA7000924
#define TSU_ADRH5	0xA7000928
#define TSU_ADRL5	0xA700092C
#define TSU_ADRH6	0xA7000930
#define TSU_ADRL6	0xA7000934
#define TSU_ADRH7	0xA7000938
#define TSU_ADRL7	0xA700093C
#define TSU_ADRH8	0xA7000940
#define TSU_ADRL8	0xA7000944
#define TSU_ADRH9	0xA7000948
#define TSU_ADRL9	0xA700094C
#define TSU_ADRH10	0xA7000950
#define TSU_ADRL10	0xA7000954
#define TSU_ADRH11	0xA7000958
#define TSU_ADRL11	0xA700095C
#define TSU_ADRH12	0xA7000960
#define TSU_ADRL12	0xA7000964
#define TSU_ADRH13	0xA7000968
#define TSU_ADRL13	0xA700096C
#define TSU_ADRH14	0xA7000970
#define TSU_ADRL14	0xA7000974
#define TSU_ADRH15	0xA7000978
#define TSU_ADRL15	0xA700097C
#define TSU_ADRH16	0xA7000980
#define TSU_ADRL16	0xA7000984
#define TSU_ADRH17	0xA7000988
#define TSU_ADRL17	0xA700098C
#define TSU_ADRH18	0xA7000990
#define TSU_ADRL18	0xA7000994
#define TSU_ADRH19	0xA7000998
#define TSU_ADRL19	0xA700099C
#define TSU_ADRH20	0xA70009A0
#define TSU_ADRL20	0xA70009A4
#define TSU_ADRH21	0xA70009A8
#define TSU_ADRL21	0xA70009AC
#define TSU_ADRH22	0xA70009B0
#define TSU_ADRL22	0xA70009B4
#define TSU_ADRH23	0xA70009B8
#define TSU_ADRL23	0xA70009BC
#define TSU_ADRH24	0xA70009C0
#define TSU_ADRL24	0xA70009C4
#define TSU_ADRH25	0xA70009C8
#define TSU_ADRL25	0xA70009CC
#define TSU_ADRH26	0xA70009D0
#define TSU_ADRL26	0xA70009D4
#define TSU_ADRH27	0xA70009D8
#define TSU_ADRL27	0xA70009DC
#define TSU_ADRH28	0xA70009E0
#define TSU_ADRL28	0xA70009E4
#define TSU_ADRH29	0xA70009E8
#define TSU_ADRL29	0xA70009EC
#define TSU_ADRH30	0xA70009F0
#define TSU_ADRL30	0xA70009F4
#define TSU_ADRH31	0xA70009F8
#define TSU_ADRL31	0xA70009FC
/* E-DMAC0 */
#define EDMR0		0xA7000000
#define EDTRR0		0xA7000004
#define EDRRR0		0xA7000008
#define TDLAR0		0xA700000C
#define RDLAR0		0xA7000010
#define EESR0		0xA7000014
#define EESIPR0		0xA7000018
#define TRSCER0		0xA700001C
#define RMFCR0		0xA7000020
#define TFTR0		0xA7000024
#define FDR0		0xA7000028
#define RMCR0		0xA700002C
#define EDOCR0		0xA7000030
#define FCFTR0		0xA7000034
#define RPADIR0		0xA7000038
#define TRIMD0		0xA700003C
#define RBWAR0		0xA7000040
#define RDFAR0		0xA7000044
#define TBRAR0		0xA700004C
#define TDFAR0		0xA7000050
/* E-DMAC1 */
#define EDMR1		0xA7000400
#define EDTRR1		0xA7000404
#define EDRRR1		0xA7000408
#define TDLAR1		0xA700040C
#define RDLAR1		0xA7000410
#define EESR1		0xA7000414
#define EESIPR1		0xA7000418
#define TRSCER1		0xA700041C
#define RMFCR1		0xA7000420
#define TFTR1		0xA7000424
#define FDR1		0xA7000428
#define RMCR1		0xA700042C
#define EDOCR1		0xA7000430
#define FCFTR1		0xA7000434
#define RPADIR1		0xA7000438
#define TRIMD1		0xA700043C
#define RBWAR1		0xA7000440
#define RDFAR1		0xA7000444
#define TBRAR1		0xA700044C
#define TDFAR1		0xA7000450

#endif /* __ASM_SH_SH7710_H */
