#include <linux/config.h>
#include <linux/module.h>

static int hdpower;
static int displaybrightness;
static int coprocactive;
static int display;
static int cfpower;

#define HD_POWER		2300	/* hd power 2300 mW 			*/
#define COPROC_POWER		200	/* DM270 power 200mW 			*/
#define BACKL_POWER		2	/* display backlight 2 mW per step 	*/
#define DISPL_POWER		300	/* display unit power 300mW		*/
#define IDLE_POWER		500	/* Idle power 500 mW			*/
#define WIFI_POWER		520	/* WiFi module power 520 mW		*/
		
void av500_report_cfpower(int state)
{
	if (state)
		cfpower = 1;
	else
		cfpower = 0;
} 

void av500_report_hdpower(int state)
{
	if (state)
		hdpower = 1;
	else
		hdpower = 0;
}

void av500_report_display(int state)
{
	if (state)
		display = 1;
	else
		display = 0;
}

void av500_report_displaybrightness(int level)
{
	if (level < 0)
		level = 0;
	else
	if (level > 255)
		level = 255;
		
	displaybrightness = level;
}

void av500_report_coprocactive(int state)
{
	if (state)
		coprocactive = 1;
	else
		coprocactive = 0;
}

// estimate power consumption in Milliwatts
int av500_compute_power(void)
{
	int power;
	
	power = IDLE_POWER;
	power += displaybrightness * BACKL_POWER;
	
	if (hdpower)
		power += HD_POWER;
	if (coprocactive)
		power += COPROC_POWER;
	if (display)
		power += DISPL_POWER;
	if (cfpower)
		power += WIFI_POWER; 

	return power;
}

EXPORT_SYMBOL(av500_report_hdpower);
EXPORT_SYMBOL(av500_report_display);
EXPORT_SYMBOL(av500_report_displaybrightness);
EXPORT_SYMBOL(av500_report_coprocactive);
EXPORT_SYMBOL(av500_compute_power);
EXPORT_SYMBOL(av500_report_cfpower);
