#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/init.h>

#include <asm/hardware.h>

extern spinlock_t rtc_lock;

extern int (*set_rtc)(void);

static int sa1100_set_rtc(void)
{
	spin_lock_irq(&rtc_lock);	
	RCNR = xtime.tv_sec;
	spin_unlock_irq(&rtc_lock);
	return 1;
}
static int sa1100_rtc_init(void)
{
	RTAR = 0xFFFFFFFF;	

	/* Initilize RTC Status register */
	RTSR = (RTSR_AL| RTSR_HZ) & (~RTSR_HZE) & (~RTSR_ALE); 

	/* Configure clock divider counter so that 
	 * RCNR can increase at every 1 Hz 
	 * See section 9.3.5 in SA1100 Developer's manual */
	RTTR = 0x8000; 
	spin_lock_irq(&rtc_lock);
	xtime.tv_sec = RCNR; /* RCNR remains valid after software reset */
	xtime.tv_usec = 0;
	spin_unlock_irq(&rtc_lock);

	set_rtc = sa1100_set_rtc;
	return 0;
}

__initcall(sa1100_rtc_init);
