/**************************************************************
 * PCMCIA Driver Header File for the SDG Systems MobiliScan
 * Bard Code Reader
 *
 *  Copyright 2002, 2003 SDG Systems, LLC
 *
 *   This file is part of sdgmhsgpl_cs.
 *
 *   sdgmhsgpl_cs is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   sdgmhsgpl_cs is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with sdgmhsgpl_cs; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *   USA
 *
 * This version of the driver is distributed under the terms of the GNU
 * Public License and comes with no support. A full-featured, fully
 * supported version of this driver is distributed under the terms of a
 * different license and provides accompanying software including GUI
 * configuration, audio support for good-scan notification, and optional
 * any-key device triggering. See our website for details:
 * http://sdsystems.com/
 *
 **************************************************************/

#ifndef _SDGMHSGPL_CS_H
#define _SDGMHSGPL_CS_H

#include <linux/ioctl.h>

/* ioctl Defines */
#define SDGMHS_IOCTL    0xab
#define SDGMHS_MAX_STRING 32

/* Get and set Baud Rate */
#define SDGMHS_SET_BAUD _IOW(SDGMHS_IOCTL, 0, int)
#define SDGMHS_GET_BAUD _IOR(SDGMHS_IOCTL, 0, int *)

/* Get and set Prefix */
#define SDGMHS_SET_PRE  _IOW(SDGMHS_IOCTL, 1, char [SDGMHS_MAX_STRING])
#define SDGMHS_GET_PRE  _IOR(SDGMHS_IOCTL, 1, char [SDGMHS_MAX_STRING])

/* Get and set Suffix */
#define SDGMHS_SET_SUFF _IOW(SDGMHS_IOCTL, 2, char [SDGMHS_MAX_STRING])
#define SDGMHS_GET_SUFF _IOR(SDGMHS_IOCTL, 2, char [SDGMHS_MAX_STRING])

/* Set Keyboard Sim. 1 = on, 0 = off. */
#define SDGMHS_SET_KBDSIM _IOW(SDGMHS_IOCTL, 3, int)
#define SDGMHS_GET_KBDSIM _IOR(SDGMHS_IOCTL, 3, int *)

/* Get and set the Baud Base */
#define SDGMHS_SET_BAUDBASE _IOW(SDGMHS_IOCTL, 4, int)
#define SDGMHS_GET_BAUDBASE _IOR(SDGMHS_IOCTL, 4, int *)

/* Get Hardware Version and Driver Version */
#define SDGMHS_GET_VERSIONS _IOR(SDGMHS_IOCTL, 6, sdgmhs_versions_t *)

/* Is alive ioctl */
#define SDGMHS_ISALIVE _IO(SDGMHS_IOCTL, 7)

/* ISC Commands */
#define SDGMHS_START_DECODE     _IO(SDGMHS_IOCTL, 15)

/* END OF IOCTLS */

typedef struct sdgmhs_versions {
    int hw_version;
    char hw_string1[SDGMHS_MAX_STRING];
    char hw_string2[SDGMHS_MAX_STRING];
    int driver_version;
} sdgmhs_versions_t;

#endif
