/*
 *
 * AK4535 codec driver
 *
 * Copyright (c) 2002 Hewlett-Packard Company
 *
 * Copyright (c) 2000 Nicolas Pitre <nico@cam.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 */

#define AK4535_NAME "ak4535"

struct ak4535_cfg {
	unsigned int fs:16;
	unsigned int format:3;
	unsigned int mic_connected:1;
	unsigned int line_connected:1;
};

#define FMT_I2S		0
#define FMT_LSB16	1
#define FMT_LSB18	2
#define FMT_LSB20	3
#define FMT_MSB		5

#define I2C_AK4535_CONFIGURE	0x13800001
#define I2C_AK4535_OPEN		0x13800002
#define I2C_AK4535_CLOSE	0x13800003

struct i2c_gain {
	unsigned int	left:8;
	unsigned int	right:8;
};

#define I2C_SET_PCM		0x13800010
#define I2C_SET_TREBLE		0x13800011
#define I2C_SET_BASS		0x13800012
#define I2C_SET_LINE_GAIN	0x13800013
#define I2C_SET_MIC_GAIN	0x13800014

struct i2c_agc {
	unsigned int	level:8;
	unsigned int	enable:1;
	unsigned int	attack:7;
	unsigned int	decay:8;
	unsigned int	channel:8;
};

#define I2C_SET_AGC		0x1380015

/* Used internally to select recording source internal/external microphone */
#define I2C_SET_RECSRC_MIC		0x13800016
#define I2C_SET_RECSRC_LINE		0x13800017
#define I2C_SET_HEADPHONE_SWITCH	0x13800018
#define I2C_SET_HEADPHONE_OUTPUT	0x13800019
