/*
 *  linux/drivers/usb/usb-ohci-s3c2410.c
 *  SW.LEE <hitchcar@sec.samsung.com>
 *  Modified for S3C2410
 *
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/interrupt.h>
#include <linux/slab.h>
#include <linux/usb.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/io.h>
#include <asm/arch/s3c2410.h>

#include "usb-ohci.h"

int __devinit
hc_add_ohci(struct pci_dev *dev, int irq, void *membase, unsigned long flags,
	    ohci_t **ohci, const char *name, const char *slot_name);
extern void hc_remove_ohci(ohci_t *ohci);

static ohci_t *s3c2410_ohci;

static void __init s3c2410_ohci_configure(void)
{

	/*
	 * Configure the power sense and control lines.  Place the USB
	 * host controller in reset.
	 * Now, carefully enable the USB clock, and take
	 * the USB host controller out of reset.
	 */

	/*      look for arch/arm/boot/compress/head-s3c2410.S 
 		rUPLLCON = head-s3c2410.S
		rCLKCON  = defalt value
	*/
}

static int __init s3c2410_ohci_init(void)
{
	int ret;

	if( !request_mem_region(VA_USB_BASE,SZ_1M,"usb-ohci")){
		printk(KERN_INFO " Failed to reqeust memory region for OHCI \n");
		return -EBUSY;
	}

	s3c2410_ohci_configure();

	/*
	 * Initialise the generic OHCI driver.
	 */
	ret = hc_add_ohci((struct pci_dev *)1, IRQ_USBH,
			  (void *)VA_USB_BASE, 0, &s3c2410_ohci,
			  "usb-ohci", "s3c2410");
	return ret;
}

static void __exit s3c2410_ohci_exit(void)
{
	hc_remove_ohci(s3c2410_ohci);

	/*
	 * Put the USB host controller into reset.
	 */

	/*
	 * Stop the USB clock.
	 */

	/*
	 * Release memory resources.
	 */
	release_mem_region(VA_USB_BASE,SZ_1M);

}

module_init(s3c2410_ohci_init);
module_exit(s3c2410_ohci_exit);
