/*
 * $Id: mq1100init.c,v 1.10 2003/11/22 13:34:21 pb Exp $
 *
 * Copyright © 2003 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include "mq1100.h"

#define	MQ_RESET_DELAY_US	10000

#define MQ_INIT_SET		0x1

#ifdef __arm__
#define MQ_INIT_PCI		0x0
#define MQ_INIT_ARM		MQ_INIT_SET
#else
#define MQ_INIT_PCI		MQ_INIT_SET
#define MQ_INIT_ARM		0x0
#endif

MqInitData  mqInitValid = {
    /* DC */
    {
	/* dc00 */		0x0,
	/* dc01 */		MQ_INIT_SET,
	/* dc02 */		MQ_INIT_SET,
	/* dc03 */		0x0,
	/* dc04 */		MQ_INIT_SET,
	/* dc05 */		MQ_INIT_SET,
    },
    /* CC */
    {
	/* cc00 */		MQ_INIT_SET,
	/* cc01 */		MQ_INIT_SET,
	/* cc02 */		MQ_INIT_SET,
	/* cc03 */		MQ_INIT_SET,
	/* cc04 */		MQ_INIT_SET,
    },
    /* MIU */
    {
	/* mm00 */		MQ_INIT_SET,
	/* mm01 */		MQ_INIT_SET,
	/* mm02 */		MQ_INIT_SET,
	/* mm03 */		MQ_INIT_SET,
	/* mm04 */		MQ_INIT_SET,
    },
    /* GC */
    {
	/* gc00 */		MQ_INIT_SET,
	/* gc01 */		MQ_INIT_SET,
	/* gc02 */		MQ_INIT_SET,
	/* gc03 */		MQ_INIT_SET,
	/* gc04 */		MQ_INIT_SET,
	/* gc05 */		MQ_INIT_SET,
	/* gc06 NOT SET */	0x0,
	/* gc07 NOT SET */	0x0,
	/* gc08 */		MQ_INIT_SET,
	/* gc09 */		MQ_INIT_SET,
	/* gc0a */		MQ_INIT_SET,
	/* gc0b */		MQ_INIT_SET,
	/* gc0c */		MQ_INIT_SET,
	/* gc0d */		MQ_INIT_SET,
	/* gc0e */		MQ_INIT_SET,
	/* gc0f NOT SET */	0x0,
	/* gc10 */		MQ_INIT_SET,
	/* gc11 */		MQ_INIT_SET,
	/* gc12 NOT SET */	0x0,
	/* gc13 NOT SET */	0x0,
	/* gc14 */		MQ_INIT_SET,
	/* gc15 */		MQ_INIT_SET,
	/* gc16 */		MQ_INIT_SET,
	/* gc17 */		MQ_INIT_SET,
	/* gc18 */		MQ_INIT_SET,
	/* gc19 */		MQ_INIT_SET,
	/* gc1a */		MQ_INIT_SET,
    },
    /* FP */
    {
	/* fp00 */		MQ_INIT_SET,
	/* fp01 */		MQ_INIT_SET,
	/* fp02 */		MQ_INIT_SET,
	/* fp03 */		MQ_INIT_SET,
	/* fp04 */		MQ_INIT_SET,
	/* fp05 */		MQ_INIT_SET,
	/* fp06 */		MQ_INIT_SET,
	/* fp07 */		MQ_INIT_SET,
	/* fp08 */		MQ_INIT_SET,
	/* fp09 NOT SET */	0x0,
	/* fp0a */		MQ_INIT_SET,
	/* fp0b */		MQ_INIT_SET,
	/* fp0c NOT SET */	0x0,
	/* fp0d NOT SET */	0x0,
	/* fp0e NOT SET */	0x0,
	/* fp0f */		MQ_INIT_SET,
	/* fp10 */		MQ_INIT_SET,
	/* fp11 */		MQ_INIT_SET,
	/* fp12 */		MQ_INIT_SET,
	/* fp13 */		MQ_INIT_SET,
	/* fp14 */		MQ_INIT_SET,
	/* fp15 */		MQ_INIT_SET,
	/* fp16 */		MQ_INIT_SET,
	/* fp17 */		MQ_INIT_SET,
	/* fp18 */		MQ_INIT_SET,
	/* fp19 */		MQ_INIT_SET,
	/* fp1a */		MQ_INIT_SET,
	/* fp1b */		MQ_INIT_SET,
	/* fp1c */		MQ_INIT_SET,
	/* fp1d */		MQ_INIT_SET,
	/* fp1e */		MQ_INIT_SET,
	/* fp1f */		MQ_INIT_SET,
	/* fp20 */		MQ_INIT_PCI,
	/* fp21 */		MQ_INIT_PCI,
	/* fp22 */		MQ_INIT_PCI,
	/* fp23 */		MQ_INIT_PCI,
	/* fp24 */		MQ_INIT_PCI,
	/* fp25 */		MQ_INIT_PCI,
	/* fp26 */		MQ_INIT_PCI,
	/* fp27 */		MQ_INIT_PCI,
	/* fp28 */		MQ_INIT_PCI,
	/* fp29 */		MQ_INIT_PCI,
	/* fp2a */		MQ_INIT_PCI,
	/* fp2b */		MQ_INIT_PCI,
	/* fp2c */		MQ_INIT_PCI,
	/* fp2d */		MQ_INIT_PCI,
	/* fp2e */		MQ_INIT_PCI,
	/* fp2f */		MQ_INIT_PCI,
	/* fp30 */		MQ_INIT_SET,
	/* fp31 */		MQ_INIT_SET,
	/* fp32 */		MQ_INIT_SET,
	/* fp33 */		MQ_INIT_SET,
	/* fp34 */		MQ_INIT_SET,
	/* fp35 */		MQ_INIT_SET,
	/* fp36 */		MQ_INIT_SET,
	/* fp37 */		MQ_INIT_SET,
	/* fp38 */		MQ_INIT_ARM,
	/* fp39 */		MQ_INIT_ARM,
	/* fp3a */		MQ_INIT_ARM,
	/* fp3b */		MQ_INIT_ARM,
	/* fp3c */		MQ_INIT_ARM,
	/* fp3d */		MQ_INIT_ARM,
	/* fp3e */		MQ_INIT_ARM,
	/* fp3f */		MQ_INIT_ARM,
	/* fp40 */		0x0,
	/* fp41 */		0x0,
	/* fp42 */		0x0,
	/* fp43 */		0x0,
	/* fp44 */		0x0,
	/* fp45 */		0x0,
	/* fp46 */		0x0,
	/* fp47 */		0x0,
	/* fp48 */		0x0,
	/* fp49 */		0x0,
	/* fp4a */		0x0,
	/* fp4b */		0x0,
	/* fp4c */		0x0,
	/* fp4d */		0x0,
	/* fp4e */		0x0,
	/* fp4f */		0x0,
	/* fp50 */		0x0,
	/* fp51 */		0x0,
	/* fp52 */		0x0,
	/* fp53 */		0x0,
	/* fp54 */		0x0,
	/* fp55 */		0x0,
	/* fp56 */		0x0,
	/* fp57 */		0x0,
	/* fp58 */		0x0,
	/* fp59 */		0x0,
	/* fp5a */		0x0,
	/* fp5b */		0x0,
	/* fp5c */		0x0,
	/* fp5d */		0x0,
	/* fp5e */		0x0,
	/* fp5f */		0x0,
	/* fp60 */		0x0,
	/* fp61 */		0x0,
	/* fp62 */		0x0,
	/* fp63 */		0x0,
	/* fp64 */		0x0,
	/* fp65 */		0x0,
	/* fp66 */		0x0,
	/* fp67 */		0x0,
	/* fp68 */		0x0,
	/* fp69 */		0x0,
	/* fp6a */		0x0,
	/* fp6b */		0x0,
	/* fp6c */		0x0,
	/* fp6d */		0x0,
	/* fp6e */		0x0,
	/* fp6f */		0x0,
	/* fp70 */		MQ_INIT_ARM,
	/* fp71 */		MQ_INIT_ARM,
	/* fp72 */		MQ_INIT_ARM,
	/* fp73 */		MQ_INIT_ARM,
	/* fp74 */		MQ_INIT_ARM,
	/* fp75 */		MQ_INIT_ARM,
	/* fp76 */		MQ_INIT_ARM,
	/* fp77 */		MQ_INIT_ARM,
    },
    /* GE */
    {
	/* ge00 NOT SET */	0x0,
	/* ge01 NOT SET */	0x0,
	/* ge02 NOT SET */	0x0,
	/* ge03 NOT SET */	0x0,
	/* ge04 NOT SET */	0x0,
	/* ge05 NOT SET */	0x0,
	/* ge06 NOT SET */	0x0,
	/* ge07 NOT SET */	0x0,
	/* ge08 NOT SET */	0x0,
	/* ge09 NOT SET */	0x0,
	/* ge0a */		MQ_INIT_SET,
	/* ge0b */		MQ_INIT_SET,
    },
};

static MqBool
MqLoad (char *name, volatile mq32 *reg, mq32 *src, mq32 *valid, int n)
{
    int	t;

    for (t = 0; t < n; t++)
	if (valid[t] & MQ_INIT_SET)
	{
	    int	tries;
	    for (tries = 0; tries < 10; tries++)
	    {
		reg[t] = src[t];
		if (reg[t] == src[t])
		    break;
		debug ("Check   %s%02x: set %08x got %08x\n", name, t, src[t], reg[t]);
#ifdef __KERNEL__
		mdelay (1);
#else
		usleep (1000);
#endif
	    }
	    if (tries == 10)
	    {
		output ("MqLoad %s%02x %08x FAILED\n", name, t, src[t]);
		return MqFalse;
	    }
	}
    return MqTrue;
}

/*
 * Device Control (DC) module
 */
static MqBool
MqInitDC (MqMap *mq, MqInitData *md)
{
#if 0
    mq32    v;
    
    v = md->dc[1];
    v |= MQ_CONFIG_SOFTWARE_CHIP_RESET;
    mq->reg->DC.s.config_1 = v;
    mq->reg->DC.s.config_2 = 0;
    usleep (MQ_RESET_DELAY_US);
    mq->reg->DC.s.config_1 = md->dc[1];
    mq->reg->DC.s.config_2 = md->dc[2];
#endif
    mq->reg->DC.s.config_1 = MQ_CONFIG_18_OSCILLATOR_INTERNAL;
    mdelay (1);
    mq->reg->DC.s.config_2 = MQ_CONFIG_CC_MODULE_ENABLE;
    mdelay (1);
    MqLoad ("dc", mq->reg->DC.a, md->dc, mqInitValid.dc, count (md->dc));

#if 0
    /* Reset the graphics engine */
    v = md->dc[4];
    v |= MQ_CONFIG_GE_FIFO_RESET | MQ_CONFIG_GE_SOURCE_FIFO_RESET;
    mq->reg->DC.s.config_4 = v;
    usleep (MQ_RESET_DELAY_US);
    v &= ~(MQ_CONFIG_GE_FIFO_RESET | MQ_CONFIG_GE_SOURCE_FIFO_RESET);
    mq->reg->DC.s.config_4 = v;
#endif
    
    return MqTrue;
}

/*
 * CPU Control (CC) module
 */
static MqBool
MqInitCC (MqMap *mq, MqInitData *md)
{
    return MqLoad ("cc", mq->reg->CC.a, md->cc, mqInitValid.cc, count (md->cc));
}

/*
 * Interrupt controller (IC) module
 */
static MqBool
MqInitIC (MqMap *mq, MqInitData *md)
{
#if 0
    /*
     * Disable interrupts (at least for now)
     */
    mq->reg->IC.s.global_interrupt_control = 0;
    mq->reg->IC.s.interrupt_mask = 0;
#endif
    return MqTrue;
}

/*
 * Memory Interface Unit (MIU)
 */

static MqBool
MqInitMIU (MqMap *mq, MqInitData *md)
{
    if (!MqLoad ("mm", mq->reg->MIU.a, md->miu, mqInitValid.miu, count (md->miu)))
	return MqFalse;
#if 0
    {
    mq16    *a;
    int	    r, c;
    int	    x, y;
    int	    i = 0;
    
    memset ((void*) mq->sync, 0x00, 256 * 1024);
#define BLOCK	32

    a = (mq16 *) mq->sync;
    for (r = 0; r < 320 / BLOCK; r ++)
	for (c = 0; c < 240 / BLOCK; c++)
	{
	    static mq16	colors[] = { 
		0x1000, 0x3000, 0x7000, 0xf000,
		0x0080, 0x0180, 0x0380, 0x0780,
		0x0002, 0x0006, 0x000e, 0x001e,
		0x1082, 0x3186, 0x738e, 0xf79e,
	    };

	    for (y = 0; y < BLOCK; y++)
		for (x = 0; x < BLOCK; x++)
		    a[(r * BLOCK + y) * 240 + (c * BLOCK + x)] = colors[i];
	    i++;
	    if (i == count(colors))
		i = 0;
	}
    }
#endif
    return MqTrue;
}

/*
 * Graphics Controller (GC)
 */
static MqBool
MqInitGC (MqMap *mq, MqInitData *md)
{
    return MqLoad ("gc", mq->reg->GC.a, md->gc, mqInitValid.gc, count (md->gc));
}

/*
 * When all of the registers are configured, power up the graphics controller
 * and flat panel interface
 */
MqBool
MqPowerGC (MqMap *mq, MqBool on)
{
    mq32    v = mq->reg->GC.s.control;
    
    if (on)
	v |= MQ_GC_CONTROL_ENABLE;
    else
	v &= ~MQ_GC_CONTROL_ENABLE;
    mq->reg->GC.s.control = v;
    return MqTrue;
}

/*
 * Flat Panel Interface (FP)
 */
static MqBool
MqInitFP (MqMap *mq, MqInitData *md)
{
    return MqLoad ("fp", mq->reg->FP.a, md->fp, mqInitValid.fp, count (md->fp));
}

static MqBool
MqInitGE (MqMap *mq, MqInitData *md)
{
    return MqLoad ("ge", mq->reg->GE.a, md->ge, mqInitValid.ge, count (md->ge));
}

MqBool
MqInit (MqMap *mq, MqInitData *md)
{
    if (!MqInitDC (mq, md))
	return MqFalse;
    if (!MqInitCC (mq, md))
	return MqFalse;
    if (!MqInitIC (mq, md))
	return MqFalse;
    if (!MqInitMIU (mq, md))
	return MqFalse;
    if (!MqInitGC (mq, md))
	return MqFalse;
    if (!MqInitFP (mq, md))
	return MqFalse;
    if (!MqInitGE (mq, md))
	return MqFalse;
    return MqTrue;
}

MqBool
MqDataToFormat (MqInitData *md, MqFormat *mf, mq16 ppm)
{
    mq32    control = md->gc[0];
    mq32    horizontal_width = md->gc[8];
    mq32    vertical_height = md->gc[9];
    mq32    window_stride = md->gc[0xe];
    mqs16   stride;
    
    switch (control & MQ_GC_DEPTH) {
    case MQ_GC_DEPTH_PSEUDO_1:
	mf->bpp = 1;
	mf->visual = MqVisualPseudo;
	break;
    case MQ_GC_DEPTH_PSEUDO_2:
	mf->bpp = 2;
	mf->visual = MqVisualPseudo;
	break;
    case MQ_GC_DEPTH_PSEUDO_4:
	mf->bpp = 4;
	mf->visual = MqVisualPseudo;
	break;
    case MQ_GC_DEPTH_PSEUDO_8:
	mf->bpp = 8;
	mf->visual = MqVisualPseudo;
	break;
    case MQ_GC_DEPTH_GRAY_1:
	mf->bpp = 1;
	mf->visual = MqVisualGray;
	break;
    case MQ_GC_DEPTH_GRAY_2:
	mf->bpp = 2;
	mf->visual = MqVisualGray;
	break;
    case MQ_GC_DEPTH_GRAY_4:
	mf->bpp = 4;
	mf->visual = MqVisualGray;
	break;
    case MQ_GC_DEPTH_GRAY_8:
	mf->bpp = 8;
	mf->visual = MqVisualGray;
	break;
    case MQ_GC_DEPTH_TRUE_16:
	mf->bpp = 16;
	mf->visual = MqVisualTrue;
	break;
    }
    mf->width = ((horizontal_width & MQ_GC_HORIZONTAL_WINDOW_WIDTH) >> 16) + 1;
    mf->height = ((vertical_height & MQ_GC_VERTICAL_WINDOW_HEIGHT) >> 16) + 1;
    stride = (mqs16) window_stride;
    if (stride < 0)
	mf->stride = -stride;
    else
	mf->stride = stride;
    switch (control & (MQ_GC_X_SCANNING_DIRECTION|MQ_GC_LINE_SCANNING_DIRECTION)) {
    case 0:
	if (stride >= 0)
	    mf->orient = MQ_Rotate_0;				    /* 000 */
	else
	    mf->orient |= MQ_Rotate_0 | MQ_Reflect_Y;		    /* 010 */
	break;
    case MQ_GC_X_SCANNING_DIRECTION:
	if (stride >= 0)
	    mf->orient = MQ_Rotate_0 | MQ_Reflect_X;		    /* 001 */
	else
	    mf->orient = MQ_Rotate_180;				    /* 011 */
	break;
    case MQ_GC_LINE_SCANNING_DIRECTION:
	if (stride >= 0)
	    mf->orient = MQ_Rotate_90 | MQ_Reflect_X;		    /* 100 */
	else
	    mf->orient = MQ_Rotate_90;				    /* 110 */
	break;
    case MQ_GC_LINE_SCANNING_DIRECTION|MQ_GC_X_SCANNING_DIRECTION:
	if (stride >= 0)
	    mf->orient = MQ_Rotate_270;				    /* 101 */
	else
	    mf->orient = MQ_Rotate_270 | MQ_Reflect_X;		    /* 111 */
	break;
    }
    mf->width_mm = mf->width * 1000 / ppm;
    mf->height_mm = mf->height * 1000 / ppm;
    return MqTrue;
}

MqBool
MqReorientData (MqInitData *src, MqInitData *dst, mq16 orient)
{
    return MqFalse;
}
