/*
 * linux/include/asm-arm/hardware/mq11xx.h
 *
 * This file contains some definitions for the MediaQ 1100/1132.
 */

#ifndef _ASM_ARCH_MEDIAQ
#define _ASM_ARCH_MEDIAQ

#include <asm/arch/bitfield.h>

extern unsigned *mq11xx_virt_base;

#define __REG_MQ11xx(x)		mq11xx_virt_base [x]

#define MQ11xx_CC00R		__REG_MQ11xx(0x000)
#define MQ11xx_CC01R		__REG_MQ11xx(0x004)
#define MQ11xx_CC02R		__REG_MQ11xx(0x008)
#define MQ11xx_CC03R		__REG_MQ11xx(0x00C)
#define MQ11xx_IN00R		__REG_MQ11xx(0x100)
#define MQ11xx_IN01R		__REG_MQ11xx(0x104)
#define MQ11xx_IN01R_GPIO2	(1<<7)

#define MQ11xx_IN02R		__REG_MQ11xx(0x108)
#define MQ11xx_SP08R		__REG_MQ11xx(0x320)


#endif  /* _ASM_ARCH_MEDIAQ */
