#!/usr/bin/env python
#
# Make gradient Horizontal work (Matchbox bug)
# More pretty save/load routines like network.py
#
#
import gtk,os
from xml.dom import minidom, Node

class LookFeel:

	if os.name == "nt":
		MATCHBOX_PREFS_PATH = "C:\\python24\\pdaxrom\\misc\\"
		CFG_FILENAME = ".\\looknfeel.cfg"
	else:
		MATCHBOX_PREFS_PATH = os.environ['HOME'] + "/.matchbox/"
		CFG_FILENAME = os.environ['HOME'] + "/Choices/looknfeel.cfg"
	
	MATCHBOX_PREFS_DESKTOP = "mb-desktop-background"
	MATCHBOX_PREFS_PANEL = "mb-panel-orientation"
	MATCHBOX_PREFS_MENU = "mb-menu"
	NOTINUPDATEMODE = True
	WALLPAPER_POS = ["img-centered","img-tiled","img-stretched"]
	WALLPAPER_POSNAMES = ["Center","Tile","Stretch"]

	GRADIENT_TYPES = ["horizontal","vertical"]
	GRADIENT_NAMES = ["Horizontal","Vertical"]

	def set_default_values(self,settingname):
		self.DEF_PAD = 5
		self.BACKGROUND_TYPE = "bgcolor"
		self.BACKGROUND_FILENAME = ""
		self.BACKGROUND_POS = "img-centered"
		self.BACKGROUND_COLOR = "6b81d9"
		self.BACKGROUND_COLOR1 = "2782e3"
		self.BACKGROUND_COLOR2 = "2864b2"
		self.GRADIENT_TYPE = "vertical"
		self.PANEL_ORIENT = "south"
		self.ICON_SIZE = 48
		self.ICON_PADDING = 24
		self.ICON_FONT = ""
		self.MENU_FONT = ""
		self.TITLE_FONT = ""
		self.FONT_COLOR = "ffffff"
		self.OUTLINE_FONTS = "True"
		self.SHOW_FOLDERTITLE = "True"
		self.PANEL_BGCOLOR = "dee3de"
		self.PANEL_BG_TYPE = "color"
		self.PANEL_BACKGROUND_FILE = ""
		self.PANEL_LEFT_MARGIN = 0
		self.PANEL_RIGHT_MARGIN = 0
		self.PANEL_SIZE = 36
		if (settingname == "default"):
			self.PROFILELIST = []
		self.SETTING_NAME = settingname
		self.DELETE_PROFILE_NAME = ""

	def __init__(self):
		self.set_default_values("default")
	        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
	        self.window.set_title("Look & Feel")
	        self.window.set_border_width(10)
		self.window.set_position(gtk.WIN_POS_CENTER)
	        self.window.set_resizable(gtk.FALSE)
	        self.load_prefs()
	        self.window.connect("delete_event", gtk.main_quit)
	        self.window.connect("destroy", gtk.main_quit)
	        MainBox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
	        self.window.add(MainBox)
	
		notebook = gtk.Notebook()
		notebook.set_tab_pos(gtk.POS_TOP)
		notebook.show()
		MainBox.pack_start(notebook, gtk.TRUE, gtk.TRUE, self.DEF_PAD)

# Background	        
	        Desktopframe = gtk.Frame()
	        label = gtk.Label("Background")
	        notebook.append_page(Desktopframe, label)

		vbox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
	        Desktopframe.add(vbox)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	        
	# wallpaper file
	        self.wallpaperbutton = gtk.RadioButton(None, "Wallpaper:")
	        self.wallpaperbutton.connect("clicked", self.change_background_type, "wallpaper")
	        hbox.pack_start(self.wallpaperbutton, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	        
	        self.filename = gtk.Entry(0)
	        self.filename.set_size_request(200,30)
	        self.filename.connect("changed", self.updatefilename)
	        hbox.pack_start(self.filename, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	        
	        openbutton = gtk.Button("Open", gtk.STOCK_OPEN)
	        openbutton.connect("clicked", self.fileselector)
	        hbox.pack_end(openbutton, gtk.FALSE, gtk.FALSE, self.DEF_PAD)
	        
	# walllpaper position
	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
        
	        label = gtk.Label("     Position:")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

		self.wallpaperpos = gtk.combo_box_new_text()
	      	for strtxt in self.WALLPAPER_POSNAMES:
	        	self.wallpaperpos.append_text(strtxt)    
	        self.wallpaperpos.connect('changed', self.wallpaper_position)
		self.wallpaperpos.set_size_request(120,30)
		hbox.pack_end(self.wallpaperpos, gtk.FALSE, gtk.FALSE, self.DEF_PAD)
		
		separator = gtk.HSeparator()
		vbox.pack_start(separator, gtk.FALSE, gtk.TRUE, 2)

	# BG Color
	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
        
        	self.bgcolorbutton = gtk.RadioButton(self.wallpaperbutton, "Single color background:")
        	self.bgcolorbutton.connect("clicked", self.change_background_type, "bgcolor")
	        hbox.pack_start(self.bgcolorbutton, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        colorbutton = gtk.Button("Color", gtk.STOCK_SELECT_COLOR)
	        colorbutton.connect("clicked", self.color_select,"1","Select background color")
	        hbox.pack_end(colorbutton, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

		self.bgcol_drawingarea = gtk.DrawingArea()
		self.bgcol_drawingarea.set_size_request(48, 8)
		hbox.pack_end(self.bgcol_drawingarea, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

		separator = gtk.HSeparator()
		vbox.pack_start(separator, gtk.FALSE, gtk.TRUE, 2)

	# BG gradient
	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
        
        	self.gradientbutton = gtk.RadioButton(self.wallpaperbutton, "Gradient color background:")
        	self.gradientbutton.connect("clicked", self.change_background_type, "bggradient")
	        hbox.pack_start(self.gradientbutton, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

		self.gradientoption = gtk.combo_box_new_text()
	      	for strtxt in self.GRADIENT_NAMES:
	        	self.gradientoption.append_text(strtxt)    
	        self.gradientoption.connect('changed', self.change_gradient_type)
		self.gradientoption.set_size_request(120,30)
		hbox.pack_end(self.gradientoption, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        colorbutton = gtk.Button("Color", gtk.STOCK_SELECT_COLOR)
	        colorbutton.connect("clicked", self.color_select,"2","Select start color for gradient")
	        hbox.pack_start(colorbutton, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

		self.gradient1_drawingarea = gtk.DrawingArea()
		self.gradient1_drawingarea.set_size_request(48, 8)
		hbox.pack_start(self.gradient1_drawingarea, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

        	self.gradient_swap_button = gtk.Button("< Swap >")
        	self.gradient_swap_button.connect("clicked", self.swap_gradients)
	        hbox.pack_start(self.gradient_swap_button, gtk.TRUE, gtk.TRUE, self.DEF_PAD)

	        colorbutton = gtk.Button("Color", gtk.STOCK_SELECT_COLOR)
	        colorbutton.connect("clicked", self.color_select,"3","Select end color for gradient")
	        hbox.pack_end(colorbutton, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

		self.gradient2_drawingarea = gtk.DrawingArea()
		self.gradient2_drawingarea.set_size_request(48, 8)
		hbox.pack_end(self.gradient2_drawingarea, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

# Panel position
	        Panelframe = gtk.Frame()
		label = gtk.Label("Panel/Taskbar")
	        notebook.append_page(Panelframe, label)

		vbox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
	        Panelframe.add(vbox)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	
	# Panel size
	        label = gtk.Label("Panel size (default is 36):")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        label = gtk.Label("px ")
	        hbox.pack_end(label, gtk.FALSE, gtk.TRUE, 0)
		
		self.panel_size_input = gtk.SpinButton(None)
	        self.panel_size_input.set_wrap(gtk.TRUE)
	        self.panel_size_input.connect("value-changed", self.panel_size_change)
	        hbox.pack_end(self.panel_size_input, gtk.FALSE, gtk.TRUE, 0)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

        # Panel background
        	self.panel_bgcolorbutton = gtk.RadioButton(None, "Panel background color:")
        	self.panel_bgcolorbutton.connect("clicked", self.change_bgpanel_type, "color")
	        hbox.pack_start(self.panel_bgcolorbutton, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        panel_colorbutton = gtk.Button("Color", gtk.STOCK_SELECT_COLOR)
	        panel_colorbutton.connect("clicked", self.color_select,"5","Select panel background color")
	        hbox.pack_end(panel_colorbutton, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

		self.panel_bgcol_drawingarea = gtk.DrawingArea()
		self.panel_bgcol_drawingarea.set_size_request(48, 8)
		hbox.pack_end(self.panel_bgcol_drawingarea, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

	# wallpaper panel file
	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        self.panel_wallpaperbutton = gtk.RadioButton(self.panel_bgcolorbutton, "Wallpaper:")
	        self.panel_wallpaperbutton.connect("clicked", self.change_bgpanel_type, "image")
	        hbox.pack_start(self.panel_wallpaperbutton, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	        
	        self.bgpanel_filename = gtk.Entry(0)
	        self.bgpanel_filename.set_size_request(200,30)
	        self.bgpanel_filename.connect("changed", self.bgpanel_updatefilename)
	        hbox.pack_start(self.bgpanel_filename, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	        
	        openbutton = gtk.Button("Open", gtk.STOCK_OPEN)
	        openbutton.connect("clicked", self.bgpanel_fileselector)
	        hbox.pack_end(openbutton, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

	# Panel Margin
	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

		label = gtk.Label("Panel left margin:")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE,  self.DEF_PAD)

		self.left_margin_input = gtk.SpinButton(None)
	        self.left_margin_input.set_wrap(gtk.TRUE)
	        self.left_margin_input.connect("value-changed", self.left_margin_change)
	        hbox.pack_start(self.left_margin_input, gtk.FALSE, gtk.TRUE,  self.DEF_PAD)

		self.right_margin_input = gtk.SpinButton(None)
	        self.right_margin_input.set_wrap(gtk.TRUE)
	        self.right_margin_input.connect("value-changed", self.right_margin_change)
	        hbox.pack_end(self.right_margin_input, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

		label = gtk.Label("Panel right margin:")
	        hbox.pack_end(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

		separator = gtk.HSeparator()
		vbox.pack_start(separator, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	
	# Panel orientation
	
 		label = gtk.Label(" Where should the panel/taskbar be placed on the screen. ")
		vbox.pack_start(label, gtk.FALSE, gtk.FALSE, self.DEF_PAD)
		hbox = gtk.HBox(gtk.TRUE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
		
		# orient_table = gtk.Table(3, 3, gtk.FALSE)		
		# vbox.pack_start(orient_table, gtk.FALSE, gtk.FALSE, 0)

	        self.west_button = gtk.ToggleButton()
		image = gtk.Image()
		image.set_from_stock(gtk.STOCK_GO_BACK,gtk.ICON_SIZE_BUTTON)
	        self.west_button.add(image)
	        self.west_button.set_size_request(30,30)
	        self.west_button.connect("released",self.panel_west)
	        hbox.pack_start(self.west_button, gtk.FALSE, gtk.FALSE, 0)
	        # orient_table.attach(self.west_button, 0, 1, 2, 3,gtk.FILL|gtk.EXPAND,gtk.FILL|gtk.EXPAND,2,2)

	        self.north_button = gtk.ToggleButton()
		image = gtk.Image()
		image.set_from_stock(gtk.STOCK_GO_UP,gtk.ICON_SIZE_BUTTON)
	        self.north_button.add(image)
	        self.north_button.set_size_request(30,30)
	        self.north_button.connect("released",self.panel_north)
	        hbox.pack_start(self.north_button, gtk.FALSE, gtk.FALSE, 0)
	        # orient_table.attach(self.north_button, 1, 2, 0, 1,gtk.FILL|gtk.EXPAND,gtk.FILL|gtk.EXPAND,2,2)

	        self.south_button = gtk.ToggleButton()
		image = gtk.Image()
		image.set_from_stock(gtk.STOCK_GO_DOWN,gtk.ICON_SIZE_BUTTON)
	        self.south_button.add(image)
	        self.south_button.set_size_request(30,30)
	        self.south_button.connect("released",self.panel_south)
	        hbox.pack_start(self.south_button, gtk.FALSE, gtk.FALSE, 0)
	        # orient_table.attach(self.south_button, 1, 2, 3, 4,gtk.FILL|gtk.EXPAND,gtk.FILL|gtk.EXPAND,2,2)

	        self.east_button = gtk.ToggleButton()
		image = gtk.Image()
		image.set_from_stock(gtk.STOCK_GO_FORWARD,gtk.ICON_SIZE_BUTTON)
	        self.east_button.add(image)
	        self.east_button.set_size_request(30,30)
	        self.east_button.connect("released",self.panel_east)
	        hbox.pack_start(self.east_button, gtk.FALSE, gtk.FALSE, 0)
	        # orient_table.attach(self.east_button, 2, 3, 2, 3,gtk.FILL|gtk.EXPAND,gtk.FILL|gtk.EXPAND,2,2)



# Icon & Text settings
	        Panelframe = gtk.Frame()
		label = gtk.Label("Icon & Text")
	        notebook.append_page(Panelframe, label)

		vbox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
	        Panelframe.add(vbox)
		
	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	# Icon size
	        label = gtk.Label("Icon size (default is 48):")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        label = gtk.Label("px ")
	        hbox.pack_end(label, gtk.FALSE, gtk.TRUE, 0)

	        self.icon_size_input = gtk.SpinButton(None)
	        self.icon_size_input.set_wrap(gtk.TRUE)
	        self.icon_size_input.connect("value-changed", self.icon_size_change)
	        hbox.pack_end(self.icon_size_input, gtk.FALSE, gtk.TRUE, 0)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

        # Icon padding
	        label = gtk.Label("Icon padding between icons (default is 24):")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        label = gtk.Label("px ")
	        hbox.pack_end(label, gtk.FALSE, gtk.TRUE,0)

	        self.icon_pad_input = gtk.SpinButton(None)
	        self.icon_pad_input.set_wrap(gtk.TRUE)
	        self.icon_pad_input.connect("value-changed", self.icon_pad_change)
	        hbox.pack_end(self.icon_pad_input, gtk.FALSE, gtk.TRUE, 0)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	# Icon font
 		label = gtk.Label("Icon font:")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	        
	        icon_font_button = gtk.Button("Icon font",gtk.STOCK_SELECT_FONT)
	        icon_font_button.connect("clicked", self.select_font, "Select icon font","icon")
	        hbox.pack_end(icon_font_button, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	# Menu font
 		label = gtk.Label("Menu font:")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	        
	        menu_font_button = gtk.Button("Menu font",gtk.STOCK_SELECT_FONT)
	        menu_font_button.connect("clicked", self.select_font, "Select menu font","menu")
	        hbox.pack_end(menu_font_button, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	# Title font
 		label = gtk.Label("Title font:")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	        
	        title_font_button = gtk.Button("Icon font",gtk.STOCK_SELECT_FONT)
	        title_font_button.connect("clicked", self.select_font, "Select title font","title")
	        hbox.pack_end(title_font_button, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	# Font color
 		label = gtk.Label("Font color:")
	        hbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        colorbutton = gtk.Button("Color", gtk.STOCK_SELECT_COLOR)
	        colorbutton.connect("clicked", self.color_select,"4","Select font color")
		hbox.pack_end(colorbutton, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

		self.fontcolor_drawingarea = gtk.DrawingArea()
		self.fontcolor_drawingarea.set_size_request(48, 8)
		hbox.pack_end(self.fontcolor_drawingarea, gtk.FALSE, gtk.FALSE, self.DEF_PAD)
		
	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
	
	# font styles
	        self.outline_fonts_check = gtk.CheckButton("Outline fonts") 
	        self.show_foldertitle_check = gtk.CheckButton("Show current folder title")

	        self.outline_fonts_check.connect("toggled", self.toogle_status,"outline")
	        hbox.pack_start(self.outline_fonts_check, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

	        self.show_foldertitle_check.connect("toggled", self.toogle_status,"showtitle")
	        hbox.pack_end(self.show_foldertitle_check, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

# Profiles
	        profileframe = gtk.Frame()

		label = gtk.Label("Look & feel profiles")
	        notebook.append_page(profileframe, label)

		vbox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
		vbox.set_border_width(10)
	        profileframe.add(vbox)

		label = gtk.Label("Load and save Look & Profile settings.") 
		vbox.pack_start(label, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

		label = gtk.Label("Select profile, when selecting the profile will be loaded:")
		vbox.pack_start(label, gtk.FALSE, gtk.FALSE,0)
		
		self.profilecombo = gtk.combo_box_new_text()
	        self.profilecombo.set_border_width(4)
		vbox.pack_start(self.profilecombo, gtk.FALSE, gtk.FALSE, self.DEF_PAD)

		hbox = gtk.HBox(gtk.TRUE, self.DEF_PAD)
	        vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        make_newprofile = gtk.Button("Create new")
		hbox.pack_start(make_newprofile, gtk.TRUE, gtk.TRUE, 2)
		make_newprofile.connect("clicked", self.make_new_profile)

	        profile_ok = gtk.Button("Rename")
		hbox.pack_start(profile_ok, gtk.TRUE, gtk.TRUE, 2)
		profile_ok.connect("clicked", self.rename_profile)

	        profile_save = gtk.Button("Save")
		hbox.pack_start(profile_save, gtk.TRUE, gtk.TRUE, 2)
		profile_save.connect("clicked", self.save_profile)
        
	        profile_remove = gtk.Button("Delete")
		hbox.pack_start(profile_remove, gtk.TRUE, gtk.TRUE, 2)
		profile_remove.connect("clicked", self.delete_profile)

# ok and cancel button
	        bbox = gtk.HButtonBox ()
	        MainBox.pack_start(bbox, gtk.FALSE, gtk.FALSE, 0)
	        bbox.set_layout(gtk.BUTTONBOX_END)

	        cancel_button = gtk.Button("Cancel",gtk.STOCK_CANCEL)
	        cancel_button.connect("clicked", gtk.main_quit)
	        bbox.add(cancel_button)

	        okbutton = gtk.Button("Ok",gtk.STOCK_OK)
	        okbutton.connect("clicked", self.close_and_update)
	        bbox.add(okbutton)
	        okbutton.set_flags(gtk.CAN_DEFAULT)
	        okbutton.grab_default()
 		self.set_loaded_values()
		n = 0
	      	for strtxt in self.PROFILELIST:
	        	self.profilecombo.append_text(strtxt)   
	        	if (self.SETTING_NAME == strtxt):
	        		self.profilecombo.set_active(n)
	        	n += 1

	        self.profilecombo.connect('changed', self.changed_profile)

		self.window.show_all()

	def set_loaded_values(self,updatelist = True):
		self.NOTINUPDATEMODE = False
	        adj = gtk.Adjustment(int(self.PANEL_SIZE), 2, 480, 1, 0, 0)
	        self.panel_size_input.set_adjustment(adj)
	        self.panel_size_input.set_value(int(self.PANEL_SIZE))
		
		adj = gtk.Adjustment(int(self.ICON_SIZE), 2, 128, 1, 0, 0)
		self.icon_size_input.set_adjustment(adj)
		self.icon_size_input.set_value(int(self.ICON_SIZE))

		adj = gtk.Adjustment(int(self.ICON_PADDING), 2, 128, 1, 0, 0)
		self.icon_pad_input.set_adjustment(adj)
		self.icon_pad_input.set_value(int(self.ICON_PADDING))

		adj = gtk.Adjustment(float(self.PANEL_LEFT_MARGIN), 0, 600, 1, 0, 0)
		self.left_margin_input.set_adjustment(adj)
		self.left_margin_input.set_value(float(self.PANEL_LEFT_MARGIN))

		adj = gtk.Adjustment(float(self.PANEL_RIGHT_MARGIN), 0, 600, 1, 0, 0)
		self.right_margin_input.set_adjustment(adj)
		self.right_margin_input.set_value(float(self.PANEL_RIGHT_MARGIN))
		
		if self.OUTLINE_FONTS == "True":
			self.outline_fonts_check.set_active(gtk.TRUE)
			self.OUTLINE_FONTS = "True"
		else:
			self.outline_fonts_check.set_active(gtk.FALSE)
			self.OUTLINE_FONTS = "False"

		if self.SHOW_FOLDERTITLE == "True":
			self.show_foldertitle_check.set_active(gtk.TRUE)
			self.SHOW_FOLDERTITLE = "True"
		else:
			self.show_foldertitle_check.set_active(gtk.FALSE)
			self.SHOW_FOLDERTITLE = "False"
		color = self.bgcol_drawingarea.get_colormap().alloc_color(eval("0x"+self.BACKGROUND_COLOR[0:2])*256, eval("0x"+self.BACKGROUND_COLOR[2:4])*256, eval("0x"+self.BACKGROUND_COLOR[4:6])*256)
		self.bgcol_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
		self.BACKGROUND_COLOR = color
		color = self.gradient1_drawingarea.get_colormap().alloc_color(eval("0x"+self.BACKGROUND_COLOR1[0:2])*256, eval("0x"+self.BACKGROUND_COLOR1[2:4])*256, eval("0x"+self.BACKGROUND_COLOR1[4:6])*256)
		self.gradient1_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
		self.BACKGROUND_COLOR1 = color
		color = self.gradient2_drawingarea.get_colormap().alloc_color(eval("0x"+self.BACKGROUND_COLOR2[0:2])*256, eval("0x"+self.BACKGROUND_COLOR2[2:4])*256, eval("0x"+self.BACKGROUND_COLOR2[4:6])*256)
		self.gradient2_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
		self.BACKGROUND_COLOR2 = color
		color = self.fontcolor_drawingarea.get_colormap().alloc_color(eval("0x"+self.FONT_COLOR[0:2])*256, eval("0x"+self.FONT_COLOR[2:4])*256, eval("0x"+self.FONT_COLOR[4:6])*256)
		self.fontcolor_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
		self.FONT_COLOR = color
		color = self.panel_bgcol_drawingarea.get_colormap().alloc_color(eval("0x"+self.PANEL_BGCOLOR[0:2])*256, eval("0x"+self.PANEL_BGCOLOR[2:4])*256, eval("0x"+self.PANEL_BGCOLOR[4:6])*256)
		self.panel_bgcol_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
		self.PANEL_BGCOLOR = color
		
		self.filename.set_text(self.BACKGROUND_FILENAME)
		self.bgpanel_filename.set_text(self.PANEL_BACKGROUND_FILE)
		if self.BACKGROUND_TYPE == "wallpaper":
			self.wallpaperbutton.set_active(gtk.TRUE)
		elif self.BACKGROUND_TYPE == "bggradient":
			self.gradientbutton.set_active(gtk.TRUE)
		else:
			self.bgcolorbutton.set_active(gtk.TRUE)
		
		if self.PANEL_BG_TYPE == "color":
			self.panel_bgcolorbutton.set_active(gtk.TRUE)
		elif self.PANEL_BG_TYPE == "image":
			self.panel_wallpaperbutton.set_active(gtk.TRUE)

		if self.BACKGROUND_POS == "img-centered":
			self.wallpaperpos.set_active(0)
		elif self.BACKGROUND_POS == "img-tiled":
			self.wallpaperpos.set_active(1)
		elif self.BACKGROUND_POS == "img-stretched":
			self.wallpaperpos.set_active(2)

		if self.GRADIENT_TYPE == "vertical":
			self.gradientoption.set_active(1)
		else:
			self.gradientoption.set_active(0)

 		if self.PANEL_ORIENT == "north":
			self.panel_north(self.north_button)
		elif self.PANEL_ORIENT == "south":
			self.panel_south(self.south_button)
		elif self.PANEL_ORIENT == "west":
			self.panel_west(self.west_button)
		elif self.PANEL_ORIENT == "east":
			self.panel_east(self.east_button)
		
		self.NOTINUPDATEMODE = True
		return True

	def make_new_profile(self,widget):
		dialog = gtk.Dialog("Create new profile",self.window,gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,(gtk.STOCK_OK, gtk.RESPONSE_ACCEPT,gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT))
		label = gtk.Label("Enter new profile name..")
		dialog.vbox.pack_start(label, gtk.FALSE, gtk.FALSE, 0)
		label.show()
	        newprofilename = gtk.Entry(0)
	        newprofilename.set_size_request(200,30)
	        dialog.vbox.pack_start(newprofilename, gtk.FALSE, gtk.FALSE, 0)
		newprofilename.show()
		result = dialog.run()
		dialog.destroy()
		if (result == gtk.RESPONSE_ACCEPT):
			if (newprofilename.get_text() != ""):
				isalready = False
				for strtxt in self.PROFILELIST:
					if (newprofilename.get_text().lower() == strtxt.lower()):
						isalready = True
						break
				if (newprofilename.get_text().isalnum() and isalready == False):
					self.set_default_values(newprofilename.get_text())
					self.set_loaded_values()
					self.PROFILELIST.append(newprofilename.get_text())
					self.SETTING_NAME = newprofilename.get_text()
					self.save_prefs()
					self.profilecombo.append_text(self.SETTING_NAME)
					self.profilecombo.set_active(len(self.PROFILELIST)-1)
				else:
					Warningdialog = gtk.MessageDialog(self.window,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"Illegal charactes in profile name or profilename is in use.")
					Warningdialog.run()
					Warningdialog.destroy()
		return

	def changed_profile(self, combobox):
		model = combobox.get_model()
		active = combobox.get_active()
		if (self.NOTINUPDATEMODE):
			if (model[active][0] != self.SETTING_NAME):
				self.load_profile(model[active][0])

	def find_profile_name(self):
		model = self.profilecombo.get_model()
		active = self.profilecombo.get_active()
		return model[active][0]

	def load_profile(self,profilename):
		self.SETTING_NAME = profilename
		self.load_prefs()
		self.set_loaded_values()
		return True

	def save_profile(self,widget):
		self.save_prefs()
		return True
		
	def rename_profile(self,widget):
		if ("default" != self.find_profile_name()):
			# Add the new name to profile list and set the old to be the one to be deleted..
			dialog = gtk.Dialog("Rename profile",self.window,gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,(gtk.STOCK_OK, gtk.RESPONSE_ACCEPT,gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT))
			label = gtk.Label("Enter profile name..")
			dialog.vbox.pack_start(label, gtk.FALSE, gtk.FALSE, 0)
			label.show()
		        newprofilename = gtk.Entry(0)
		        newprofilename.set_text(self.find_profile_name())
		        newprofilename.set_size_request(200,30)
		        dialog.vbox.pack_start(newprofilename, gtk.FALSE, gtk.FALSE, 0)
			newprofilename.show()
			result = dialog.run()
			dialog.destroy()
			if (result == gtk.RESPONSE_ACCEPT):
				if (newprofilename.get_text() != "" and newprofilename.get_text() != self.find_profile_name()):
					isalready = False
					for strtxt in self.PROFILELIST:
						if (newprofilename.get_text().lower() == strtxt.lower()):
							isalready = True
							break
					if (newprofilename.get_text().isalnum() and isalready == False):
						self.NOTINUPDATEMODE = False
						self.SETTING_NAME = newprofilename.get_text()
						self.DELETE_PROFILE_NAME = self.find_profile_name()
						self.save_prefs()
						self.profilecombo.remove_text(self.profilecombo.get_active())
						self.profilecombo.append_text(self.SETTING_NAME)
						self.DELETE_PROFILE_NAME = ""
						self.NOTINUPDATEMODE = True
						self.profilecombo.set_active(len(self.PROFILELIST)-1)
					else:
						Warningdialog = gtk.MessageDialog(self.window,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"Illegal charactes in profile name or profilename is in use.")
						Warningdialog.run()
						Warningdialog.destroy()
			return
		else:
			Warningdialog = gtk.MessageDialog(self.window,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"Can't rename the default profile.")
			Warningdialog.run()
			Warningdialog.destroy()
		return


	def delete_profile(self,widget):
		if ("default" != self.find_profile_name()):
			Warningdialog = gtk.MessageDialog(self.window,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_QUESTION,gtk.BUTTONS_YES_NO,"Are you sure you want to delete \""+self.SETTING_NAME+"\" profile?")
			result = Warningdialog.run()
			Warningdialog.destroy()
			if (result == gtk.RESPONSE_YES):		
				self.DELETE_PROFILE_NAME = self.find_profile_name()
				self.save_prefs()
				self.DELETE_PROFILE_NAME = ""
				self.profilecombo.remove_text(self.profilecombo.get_active())
				self.profilecombo.set_active(0)
		elif ("default" == self.find_profile_name()):
			Warningdialog = gtk.MessageDialog(self.window,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"Can't delete the default profile.")
			Warningdialog.run()
			Warningdialog.destroy()
		return
		
	def toogle_status(self,widget,data):
		if data == "outline":
			if self.OUTLINE_FONTS == "True":
				self.OUTLINE_FONTS = "False"
			else:
				self.OUTLINE_FONTS = "True"
		elif data == "showtitle":
			if self.SHOW_FOLDERTITLE == "True":
				self.SHOW_FOLDERTITLE = "False"
			else:
				self.SHOW_FOLDERTITLE = "True"

	def icon_size_change(self,widget):
		self.ICON_SIZE = int(self.icon_size_input.get_value())

	def panel_size_change(self,widget):
		self.PANEL_SIZE = int(self.panel_size_input.get_value())

	def left_margin_change(self,widget):
		self.PANEL_LEFT_MARGIN = int(self.left_margin_input.get_value())
		adj = gtk.Adjustment(float(self.PANEL_RIGHT_MARGIN), 0, float(600 - int(self.PANEL_LEFT_MARGIN)), 1, 0, 0)
		self.right_margin_input.set_adjustment(adj)

	def right_margin_change(self,widget):
		self.PANEL_RIGHT_MARGIN = int(self.right_margin_input.get_value())	
		adj = gtk.Adjustment(float(self.PANEL_LEFT_MARGIN), 0, float(600-int(self.PANEL_RIGHT_MARGIN)), 1, 0, 0)
		self.left_margin_input.set_adjustment(adj)

	def icon_pad_change(self,widget):
		self.ICON_PADDING = int(self.icon_pad_input.get_value())

	def swap_gradients(self,widget):
		temp = self.BACKGROUND_COLOR2
		self.BACKGROUND_COLOR2 = self.BACKGROUND_COLOR1
		self.BACKGROUND_COLOR1 = temp
		self.gradient2_drawingarea.modify_bg(gtk.STATE_NORMAL, self.BACKGROUND_COLOR2)
		self.gradient1_drawingarea.modify_bg(gtk.STATE_NORMAL, self.BACKGROUND_COLOR1)
		return True

	def change_gradient_type(self,combobox):
		if (self.NOTINUPDATEMODE):
			data = self.GRADIENT_TYPES[combobox.get_active()]
			if data == "horizontal":
				self.GRADIENT_TYPE = "horizontal"
				self.gradientbutton.set_active(gtk.TRUE)
			elif data == "vertical":
				self.GRADIENT_TYPE = "vertical"
				self.gradientbutton.set_active(gtk.TRUE)
		return True

	def wallpaper_position(self,combobox):
		data = self.WALLPAPER_POS[combobox.get_active()]
		if data == "img-centered":
			self.BACKGROUND_POS = "img-centered"
		elif data == "img-tiled":
			self.BACKGROUND_POS = "img-tiled"
		elif data == "img-stretched":
			self.BACKGROUND_POS = "img-stretched"

	def panel_south(self,widget):
		self.PANEL_ORIENT = "south"
		if widget.get_active():
			self.west_button.set_active(False)
			self.east_button.set_active(False)
			self.north_button.set_active(False)
		else:
			self.south_button.set_active(True)


	def panel_north(self,widget):
		self.PANEL_ORIENT = "north"
		if widget.get_active():
			self.west_button.set_active(False)
			self.east_button.set_active(False)
			self.south_button.set_active(False)
		else:
			self.north_button.set_active(True)

					
	def panel_west(self,widget):
		self.PANEL_ORIENT = "west"
		if widget.get_active():
			self.north_button.set_active(False)
			self.east_button.set_active(False)
			self.south_button.set_active(False)
		else:
			self.west_button.set_active(True)

	def panel_east(self,widget):
		self.PANEL_ORIENT = "east"
		if widget.get_active():
			self.north_button.set_active(False)
			self.west_button.set_active(False)
			self.south_button.set_active(False)
		else:
			self.east_button.set_active(True)

	def file_ok_sel(self,filename,dialogbox):
		if os.path.isfile(filename):
			filext = filename[filename.rfind(".")+1:].strip().lower()
			if filext == "png" or filext == "jpg" or filext == "jpeg" or filext == "gif":
				self.BACKGROUND_FILENAME = filename
				self.filename.set_text(filename)
				self.wallpaperbutton.set_active(gtk.TRUE)
				dialogbox.destroy()
			else:
				Warningdialog = gtk.MessageDialog(dialogbox,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"File must be jpeg, jpg, gif or png.")
				Warningdialog.run()
				Warningdialog.destroy()
				return

	def bg_file_ok_sel(self,filename,dialogbox):
		if os.path.isfile(filename):
			filext = filename[filename.rfind(".")+1:].strip().lower()
			if filext == "png" or filext == "jpg" or filext == "jpeg" or filext == "gif":
				self.PANEL_BACKGROUND_FILE = filename
				self.bgpanel_filename.set_text(filename)
				self.panel_wallpaperbutton.set_active(gtk.TRUE)
				dialogbox.destroy()
			else:
				Warningdialog = gtk.MessageDialog(dialogbox,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"File must be jpeg, jpg, gif or png.")
				Warningdialog.run()
				Warningdialog.destroy()
				return

	def load_prefs(self):
		if os.path.isfile(self.CFG_FILENAME):
			try:
				xmldoc = minidom.parse(self.CFG_FILENAME)
			except:
				return False
			else:
				self.PROFILELIST = []
				self.PROFILELIST.append(self.SETTING_NAME)
				tags = xmldoc.getElementsByTagName("LOOKANDFEELSETTINGS")
				for tag in tags:
					Desktop = tag.getElementsByTagName("Desktop")
					for Desktopset in Desktop:
						if (self.SETTING_NAME == Desktopset.getAttribute("SETTINGNAME")):
							self.BACKGROUND_TYPE = Desktopset.getAttribute("BACKGROUNDTYPE")
							self.BACKGROUND_FILENAME = Desktopset.getAttribute("BACKGROUNDFILENAME")
							self.BACKGROUND_POS = Desktopset.getAttribute("BACKGROUNDPOS")
							self.BACKGROUND_COLOR = Desktopset.getAttribute("BGCOLOR")
							self.BACKGROUND_COLOR1 = Desktopset.getAttribute("COLOR1")
							self.BACKGROUND_COLOR2 = Desktopset.getAttribute("COLOR2")
							self.GRADIENT_TYPE = Desktopset.getAttribute("GRADIENTTYPE")
							self.ICON_SIZE = Desktopset.getAttribute("ICONSIZE")
							self.ICON_PADDING = Desktopset.getAttribute("ICONPADDING")
							self.ICON_FONT = Desktopset.getAttribute("ICONFONT")
							self.MENU_FONT = Desktopset.getAttribute("MENUFONT")
							self.FONT_COLOR = Desktopset.getAttribute("FONTCOLOR")
							self.TITLE_FONT = Desktopset.getAttribute("TITLEFONT")
							self.OUTLINE_FONTS = Desktopset.getAttribute("OUTLINEFONT")
							self.SHOW_FOLDERTITLE = Desktopset.getAttribute("SHOWFOLDERTITLE")
						else:
							self.PROFILELIST.append(Desktopset.getAttribute("SETTINGNAME"))
	
					Panels = tag.getElementsByTagName("Panel")
					for Panelset in Panels:
						if (self.SETTING_NAME == Panelset.getAttribute("SETTINGNAME")):
							self.PANEL_ORIENT = Panelset.getAttribute("ORIENT")
							self.PANEL_SIZE = Panelset.getAttribute("SIZE")
							self.PANEL_BGCOLOR = Panelset.getAttribute("BGCOLOR")
							self.PANEL_BG_TYPE = Panelset.getAttribute("BGTYPE")
							self.PANEL_BACKGROUND_FILE = Panelset.getAttribute("BACKGROUNDFILE")
							self.PANEL_LEFT_MARGIN = Panelset.getAttribute("LEFTMARGIN")
							self.PANEL_RIGHT_MARGIN = Panelset.getAttribute("RIGHTMARGIN")

				return True
		else:
			return False

	def save_prefs(self,widget=None):
		conf_tree = minidom.Document()
		conf_tree.appendChild(conf_tree.createComment("pdaXrom settings file"))
		root_node = conf_tree.createElement("LOOKANDFEELSETTINGS")
		try:
			xmldoc = minidom.parse(self.CFG_FILENAME)
		except:
			look_node = conf_tree.createElement("Desktop")
			look_node.setAttribute("SETTINGNAME", self.SETTING_NAME)
			look_node.setAttribute("BACKGROUNDTYPE", self.BACKGROUND_TYPE)
			look_node.setAttribute("BACKGROUNDFILENAME", self.BACKGROUND_FILENAME)
			look_node.setAttribute("BACKGROUNDPOS", self.BACKGROUND_POS)
			look_node.setAttribute("BGCOLOR", self.return_color_hex(self.BACKGROUND_COLOR))
			look_node.setAttribute("COLOR1", self.return_color_hex(self.BACKGROUND_COLOR1))
			look_node.setAttribute("COLOR2",self.return_color_hex(self.BACKGROUND_COLOR2))
			look_node.setAttribute("GRADIENTTYPE", self.GRADIENT_TYPE)
			look_node.setAttribute("ICONSIZE", str(self.ICON_SIZE))
			look_node.setAttribute("ICONPADDING", str(self.ICON_PADDING))
			look_node.setAttribute("ICONFONT", self.ICON_FONT)
			look_node.setAttribute("MENUFONT", self.MENU_FONT)
			look_node.setAttribute("TITLEFONT", self.TITLE_FONT)
			look_node.setAttribute("FONTCOLOR", self.return_color_hex(self.FONT_COLOR))
			look_node.setAttribute("OUTLINEFONT", str(self.OUTLINE_FONTS))
			look_node.setAttribute("SHOWFOLDERTITLE", str(self.SHOW_FOLDERTITLE))
			root_node.appendChild(look_node)
			
			Panel_node = conf_tree.createElement("Panel")
			Panel_node.setAttribute("SETTINGNAME",self.SETTING_NAME)
			Panel_node.setAttribute("ORIENT", self.PANEL_ORIENT)
			Panel_node.setAttribute("BGCOLOR", self.return_color_hex(self.PANEL_BGCOLOR))
			Panel_node.setAttribute("BGTYPE", self.PANEL_BG_TYPE)
			Panel_node.setAttribute("SIZE", str(self.PANEL_SIZE))
			Panel_node.setAttribute("BACKGROUNDFILE", self.PANEL_BACKGROUND_FILE)
			Panel_node.setAttribute("LEFTMARGIN", str(self.PANEL_LEFT_MARGIN))
			Panel_node.setAttribute("RIGHTMARGIN", str(self.PANEL_RIGHT_MARGIN))
			root_node.appendChild(Panel_node)
			conf_tree.appendChild(root_node)
			FD = open(self.CFG_FILENAME, "w")
			FD.write(conf_tree.toprettyxml())
			FD.close()
		else:
			tags = xmldoc.getElementsByTagName("LOOKANDFEELSETTINGS")
			savedcurrent = False
			for tag in tags:
				Desktop = tag.getElementsByTagName("Desktop")
				for Desktopset in Desktop:
					if (self.DELETE_PROFILE_NAME != Desktopset.getAttribute("SETTINGNAME")):
						if (self.SETTING_NAME == Desktopset.getAttribute("SETTINGNAME")):
							look_node = conf_tree.createElement("Desktop")
							look_node.setAttribute("SETTINGNAME", self.SETTING_NAME)
							look_node.setAttribute("BACKGROUNDTYPE", self.BACKGROUND_TYPE)
							look_node.setAttribute("BACKGROUNDFILENAME", self.BACKGROUND_FILENAME)
							look_node.setAttribute("BACKGROUNDPOS", self.BACKGROUND_POS)
							look_node.setAttribute("BGCOLOR", self.return_color_hex(self.BACKGROUND_COLOR))
							look_node.setAttribute("COLOR1", self.return_color_hex(self.BACKGROUND_COLOR1))
							look_node.setAttribute("COLOR2",self.return_color_hex(self.BACKGROUND_COLOR2))
							look_node.setAttribute("GRADIENTTYPE", self.GRADIENT_TYPE)
							look_node.setAttribute("ICONSIZE", str(self.ICON_SIZE))
							look_node.setAttribute("ICONPADDING", str(self.ICON_PADDING))
							look_node.setAttribute("ICONFONT", self.ICON_FONT)
							look_node.setAttribute("MENUFONT", self.MENU_FONT)
							look_node.setAttribute("TITLEFONT", self.TITLE_FONT)
							look_node.setAttribute("FONTCOLOR", self.return_color_hex(self.FONT_COLOR))
							look_node.setAttribute("OUTLINEFONT", str(self.OUTLINE_FONTS))
							look_node.setAttribute("SHOWFOLDERTITLE", str(self.SHOW_FOLDERTITLE))
							root_node.appendChild(look_node)
							savedcurrent = True
						else:
							root_node.appendChild(Desktopset)

				Panels = tag.getElementsByTagName("Panel")
				for Panelset in Panels:
					if (self.DELETE_PROFILE_NAME != Panelset.getAttribute("SETTINGNAME")):
						if (self.SETTING_NAME == Panelset.getAttribute("SETTINGNAME")):
							Panel_node = conf_tree.createElement("Panel")
							Panel_node.setAttribute("SETTINGNAME", self.SETTING_NAME)
							Panel_node.setAttribute("ORIENT", self.PANEL_ORIENT)
							Panel_node.setAttribute("BGCOLOR", self.return_color_hex(self.PANEL_BGCOLOR))
							Panel_node.setAttribute("BGTYPE", self.PANEL_BG_TYPE)
							Panel_node.setAttribute("SIZE", str(self.PANEL_SIZE))
							Panel_node.setAttribute("BACKGROUNDFILE", self.PANEL_BACKGROUND_FILE)
							Panel_node.setAttribute("LEFTMARGIN", str(self.PANEL_LEFT_MARGIN))
							Panel_node.setAttribute("RIGHTMARGIN", str(self.PANEL_RIGHT_MARGIN))
							root_node.appendChild(Panel_node)
							savedcurrent = True
						else:
							root_node.appendChild(Panelset)
				conf_tree.appendChild(root_node)

			if (savedcurrent == False and self.DELETE_PROFILE_NAME != self.SETTING_NAME):
				look_node = conf_tree.createElement("Desktop")
				look_node.setAttribute("SETTINGNAME", self.SETTING_NAME)
				look_node.setAttribute("BACKGROUNDTYPE", self.BACKGROUND_TYPE)
				look_node.setAttribute("BACKGROUNDFILENAME", self.BACKGROUND_FILENAME)
				look_node.setAttribute("BACKGROUNDPOS", self.BACKGROUND_POS)
				look_node.setAttribute("BGCOLOR", self.return_color_hex(self.BACKGROUND_COLOR))
				look_node.setAttribute("COLOR1", self.return_color_hex(self.BACKGROUND_COLOR1))
				look_node.setAttribute("COLOR2",self.return_color_hex(self.BACKGROUND_COLOR2))
				look_node.setAttribute("GRADIENTTYPE", self.GRADIENT_TYPE)
				look_node.setAttribute("ICONSIZE", str(self.ICON_SIZE))
				look_node.setAttribute("ICONPADDING", str(self.ICON_PADDING))
				look_node.setAttribute("ICONFONT", self.ICON_FONT)
				look_node.setAttribute("MENUFONT", self.MENU_FONT)
				look_node.setAttribute("TITLEFONT", self.TITLE_FONT)
				look_node.setAttribute("FONTCOLOR", self.return_color_hex(self.FONT_COLOR))
				look_node.setAttribute("OUTLINEFONT", str(self.OUTLINE_FONTS))
				look_node.setAttribute("SHOWFOLDERTITLE", str(self.SHOW_FOLDERTITLE))
				root_node.appendChild(look_node)

				Panel_node = conf_tree.createElement("Panel")
				Panel_node.setAttribute("SETTINGNAME",self.SETTING_NAME)
				Panel_node.setAttribute("ORIENT", self.PANEL_ORIENT)
				Panel_node.setAttribute("BGCOLOR", self.return_color_hex(self.PANEL_BGCOLOR))
				Panel_node.setAttribute("BGTYPE", self.PANEL_BG_TYPE)
				Panel_node.setAttribute("SIZE", str(self.PANEL_SIZE))
				Panel_node.setAttribute("BACKGROUNDFILE", self.PANEL_BACKGROUND_FILE)
				Panel_node.setAttribute("LEFTMARGIN", str(self.PANEL_LEFT_MARGIN))
				Panel_node.setAttribute("RIGHTMARGIN", str(self.PANEL_RIGHT_MARGIN))
				root_node.appendChild(Panel_node)
				conf_tree.appendChild(root_node)

			FD = open(self.CFG_FILENAME, "w")
			FD.write(conf_tree.toprettyxml())
			FD.close()
			return True

	def close_and_update(self,widget):
		write_str = ""
		if self.ICON_SIZE != "" and int(self.ICON_SIZE) >= 2 and int(self.ICON_SIZE) <= 128:
			write_str = write_str + " --icon-size \"" + str(self.ICON_SIZE)+ "\""
			
		if self.ICON_PADDING != "" and int(self.ICON_PADDING) >= 2 and int(self.ICON_PADDING) <= 128:
			write_str = write_str + " --icon-padding \"" + str(self.ICON_PADDING)+ "\""

		if self.ICON_FONT != "":
			write_str = write_str + " --font \"" + str(self.ICON_FONT) +"\""

		if self.TITLE_FONT != "":
			write_str = write_str + " --titlefont \"" + str(self.TITLE_FONT) +"\""

		if self.FONT_COLOR != "":
			write_str = write_str + " --fontcol \"#" + self.return_color_hex(self.FONT_COLOR)+ "\""

		if self.OUTLINE_FONTS == "False":
			write_str = write_str + " --no-outline"

		if self.SHOW_FOLDERTITLE == "False":
			write_str = write_str + " --no-title"
			
		if self.BACKGROUND_TYPE == "wallpaper" and self.BACKGROUND_FILENAME != "" and self.BACKGROUND_POS != "":
				write_str = write_str + " --bg \"" + self.BACKGROUND_POS + ":" + self.BACKGROUND_FILENAME + "\""
		elif self.BACKGROUND_TYPE == "bggradient" and self.BACKGROUND_COLOR1 != "" and self.BACKGROUND_COLOR2 != "" and self.GRADIENT_TYPE !="" and (self.GRADIENT_TYPE=="horizontal" or self.GRADIENT_TYPE=="vertical"):
				write_str = write_str + " --bg \"col-gradient-"+ self.GRADIENT_TYPE + ":#" + self.return_color_hex(self.BACKGROUND_COLOR1) + ",#" + self.return_color_hex(self.BACKGROUND_COLOR2) + "\""
		elif self.BACKGROUND_COLOR != "":
				write_str = write_str + " --bg \"col-solid:#" + self.return_color_hex(self.BACKGROUND_COLOR) + "\""

		if write_str != "":
			write_str = write_str.strip()
			f=open(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_DESKTOP, 'w')
			f.write(write_str)
			# print "Wrote \"" + write_str + "\" to:\n" + self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_DESKTOP + "\n"
			f.close()

		elif os.path.isfile(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_DESKTOP):
			os.unlink(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_DESKTOP)

		write_str = ""
		if self.PANEL_SIZE != "" and int(self.PANEL_SIZE) >= 2 and int(self.PANEL_SIZE) <= 480:
			write_str = write_str + " --size \"" + str(self.PANEL_SIZE)+ "\""

		if self.PANEL_LEFT_MARGIN != "" and int(self.PANEL_LEFT_MARGIN) >= 1 and int(self.PANEL_LEFT_MARGIN) <= 600:
			write_str = write_str + " --margin-start \"" + str(self.PANEL_LEFT_MARGIN)+ "\""

		if self.PANEL_RIGHT_MARGIN != "" and int(self.PANEL_RIGHT_MARGIN) >= 1 and int(self.PANEL_RIGHT_MARGIN) <= 600:
			write_str = write_str + " --margin-end \"" + str(self.PANEL_RIGHT_MARGIN)+ "\""

		if self.PANEL_ORIENT != "":
			write_str = write_str + " --orientation \"" + self.PANEL_ORIENT+ "\""

		if self.PANEL_BG_TYPE == "image" and self.PANEL_BACKGROUND_FILE != "":
			write_str = write_str + " --bgpixmap \"" + self.PANEL_BACKGROUND_FILE+"\""
		elif self.PANEL_BG_TYPE == "color" and self.PANEL_BGCOLOR != "":
			write_str = write_str + " --bgcolor \"#" + self.return_color_hex(self.PANEL_BGCOLOR)+ "\""

		if write_str != "":
			write_str = write_str.strip()
			f=open(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_PANEL, 'w')
			f.write(write_str)
			# print "Wrote \"" + write_str + "\" to:\n" + self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_PANEL + "\n"
			f.close()

		elif os.path.isfile(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_PANEL):
			os.unlink(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_PANEL)

		write_str = ""
		if self.MENU_FONT != "":
			write_str = write_str + " font \"" + str(self.MENU_FONT) +"\""

		if write_str != "":
			write_str = write_str.strip()
			f=open(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_MENU, 'w')
			f.write(write_str)
			f.close()

		elif os.path.isfile(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_MENU):
			os.unlink(self.MATCHBOX_PREFS_PATH+self.MATCHBOX_PREFS_MENU)

		self.save_prefs()
		os.system("/bin/touch /tmp/.mb-restart")
		os.system("/bin/killall matchbox-panel")
		os.system("/bin/killall matchbox-desktop")
		gtk.main_quit()

	def update_preview_cb(self,file_chooser, preview):
		filename = file_chooser.get_preview_filename()
		try:
			pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename, 128, 128)
			preview.set_from_pixbuf(pixbuf)
			have_preview = True
		except:
			have_preview = False
		file_chooser.set_preview_widget_active(have_preview)
		file_chooser.resize(640,400)
		return

	def fileselector(self, widget):
		dialog = gtk.FileChooserDialog("Wallpaper",
		                               self.window,
		                               gtk.FILE_CHOOSER_ACTION_OPEN,
		                               (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
		                                gtk.STOCK_OPEN, gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
		dialog.resize(640,400)
		dialog.move(0,0)
		if os.path.isfile("/usr/share/pixmaps/Wallpapers/"):
			dialog.add_shortcut_folder("/usr/share/pixmaps/Wallpapers/")
		preview = gtk.Image()

		dialog.set_preview_widget(preview)
		dialog.connect("update-preview", self.update_preview_cb, preview)

		filter = gtk.FileFilter()
		filter.set_name("Images")
		filter.add_mime_type("image/png")
		filter.add_mime_type("image/jpeg")
		filter.add_mime_type("image/gif")
		filter.add_pattern("*.png")
		filter.add_pattern("*.jpg")
		filter.add_pattern("*.gif")
		filter.add_pattern("*.tif")
		filter.add_pattern("*.xpm")
		dialog.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		dialog.add_filter(filter)
		if (self.filename.get_text() != ""):
			dialog.set_filename(self.filename.get_text())

		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			self.file_ok_sel(dialog.get_filename(),dialog)
		elif response == gtk.RESPONSE_CANCEL:
			dialog.destroy()
		dialog.destroy()

	def bgpanel_fileselector(self, widget):
		dialog = gtk.FileChooserDialog("Panel wallpaper",
		                               self.window,
		                               gtk.FILE_CHOOSER_ACTION_OPEN,
		                               (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
		                                gtk.STOCK_OPEN, gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
		dialog.resize(640,400)
		dialog.move(0,0)
		if os.path.isfile("/usr/share/pixmaps/Panelbacks/"):
			dialog.add_shortcut_folder("/usr/share/pixmaps/Panelbacks/")
		preview = gtk.Image()

		dialog.set_preview_widget(preview)
		dialog.connect("update-preview", self.update_preview_cb, preview)

		filter = gtk.FileFilter()
		filter.set_name("Images")
		filter.add_mime_type("image/png")
		filter.add_mime_type("image/jpeg")
		filter.add_mime_type("image/gif")
		filter.add_pattern("*.png")
		filter.add_pattern("*.jpg")
		filter.add_pattern("*.gif")
		filter.add_pattern("*.tif")
		filter.add_pattern("*.xpm")
		dialog.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		dialog.add_filter(filter)
		if (self.bgpanel_filename.get_text() != ""):
			dialog.set_filename(self.bgpanel_filename.get_text())

		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			self.bg_file_ok_sel(dialog.get_filename(),dialog)
		elif response == gtk.RESPONSE_CANCEL:
			dialog.destroy()
		dialog.destroy()

	def updatefilename(self, widget):
		self.BACKGROUND_FILENAME = self.filename.get_text()

	def bgpanel_updatefilename(self, widget):
		self.PANEL_BACKGROUND_FILE = self.bgpanel_filename.get_text()

	def change_background_type(self, widget, data=None):
		self.BACKGROUND_TYPE = data
		return True

	def change_bgpanel_type(self, widget, data=None):
		self.PANEL_BG_TYPE = data
		return True

# Color stuff
	def color_select(self,widget,colorvariable,title):
		self.colorsel = gtk.ColorSelection()
		self.colorseldlg = gtk.ColorSelectionDialog(title)
		self.colorseldlg.set_modal(gtk.TRUE)
		self.colorseldlg.set_position(gtk.WIN_POS_CENTER)
		self.colorseldlg.show()
		self.colorsel = self.colorseldlg.colorsel
		if colorvariable != "":
			if colorvariable == "1" and self.BACKGROUND_COLOR != "":
				self.colorsel.set_current_color(self.BACKGROUND_COLOR)
				self.bgcolorbutton.set_active(gtk.TRUE)
			elif colorvariable == "2" and self.BACKGROUND_COLOR1 != "":
				self.colorsel.set_current_color(self.BACKGROUND_COLOR1)
				self.gradientbutton.set_active(gtk.TRUE)
			elif colorvariable == "3" and self.BACKGROUND_COLOR2 != "":
				self.colorsel.set_current_color(self.BACKGROUND_COLOR2)
				self.gradientbutton.set_active(gtk.TRUE)
			elif colorvariable == "4" and self.FONT_COLOR != "":
				self.colorsel.set_current_color(self.FONT_COLOR)
			elif colorvariable == "5" and self.PANEL_BGCOLOR != "":
				self.panel_bgcolorbutton.set_active(gtk.TRUE)
				self.colorsel.set_current_color(self.PANEL_BGCOLOR)

		self.colorseldlg.ok_button.connect("clicked",self.color_dlg_ok,colorvariable)
		self.colorseldlg.cancel_button.connect("clicked",self.color_dlg_cancel)
	
	def color_dlg_cancel(self,widget):
		self.colorseldlg.destroy()

	def color_dlg_ok(self,widget,colorvariable):
		color = self.colorsel.get_current_color()
		if colorvariable != "":
			if colorvariable == "1":
				self.BACKGROUND_COLOR = color
				self.bgcol_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
			elif colorvariable == "2":
				self.BACKGROUND_COLOR1 = color
				self.gradient1_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
			elif colorvariable == "3":
				self.BACKGROUND_COLOR2 = color
				self.gradient2_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
			elif colorvariable == "4":
				self.FONT_COLOR = color
				self.fontcolor_drawingarea.modify_bg(gtk.STATE_NORMAL, color)
			elif colorvariable == "5":
				self.PANEL_BGCOLOR = color
				self.panel_bgcol_drawingarea.modify_bg(gtk.STATE_NORMAL, color)

		self.colorseldlg.destroy()

	def return_color_hex(self,color):
		return hex((color.blue/256 + (color.green/256)*256 + (color.red/256)*65536)+256*256*256)[3:]

# color stuff end

# font stuff
	def select_font(self,widget,title,variableind):
		fontwindow = gtk.FontSelectionDialog(title)
		self.font_dialog = fontwindow
		self.font_dialog.set_modal(gtk.TRUE)
		fontwindow.set_position(gtk.WIN_POS_CENTER)
		if variableind == "icon" and self.ICON_FONT != "":
			self.font_dialog.set_font_name(self.ICON_FONT)
		if variableind == "title" and self.TITLE_FONT != "":
			self.font_dialog.set_font_name(self.TITLE_FONT)
		if variableind == "menu" and self.MENU_FONT != "":
			self.font_dialog.set_font_name(self.MENU_FONT)

		
		fontwindow.ok_button.connect("clicked",self.font_selection_ok,self.font_dialog,variableind)
		fontwindow.cancel_button.connect_object("clicked",self.font_selection_cancel,self.font_dialog)
		
		fontwindow = self.font_dialog
		if not (fontwindow.flags() & gtk.VISIBLE):
			fontwindow.show()
		else:
			fontwindow.destroy()

	def font_selection_ok(self, button,fontwindow,variableind):
		font = self.font_dialog.get_font_name()
		if font:
			if variableind == "icon":
				self.ICON_FONT = font
			if variableind == "title":
				self.TITLE_FONT = font
			if variableind == "menu":
				self.MENU_FONT = font
		self.font_dialog.destroy()
			

	def font_selection_cancel(self, fontwindow):
		fontwindow.destroy()
# font stuff end

	def main(self):
		gtk.main()

if __name__ == "__main__":
	LookFeel = LookFeel()
	LookFeel.main()
