
/*
 * MIXMOS - an oss mixer
 *
 * Copyright (C) 2003 Tomasz Mka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#define number_of_pixmaps	25

/* FIXME */

//#define THEME "classic"
#define THEME "transparent"


gint  m_idx[number_of_pixmaps] = { 

	SOUND_MIXER_VOLUME,	
	SOUND_MIXER_BASS,	
	SOUND_MIXER_TREBLE,
	SOUND_MIXER_SYNTH,	
	SOUND_MIXER_PCM,		
	SOUND_MIXER_SPEAKER,	
	SOUND_MIXER_LINE,	
	SOUND_MIXER_MIC,		
	SOUND_MIXER_CD,		
	SOUND_MIXER_IMIX,			/* Recording monitor */
	SOUND_MIXER_ALTPCM,	
	SOUND_MIXER_RECLEV,			/* Recording level */
	SOUND_MIXER_IGAIN,			/* Input gain */
	SOUND_MIXER_OGAIN,			/* Output gain */
	SOUND_MIXER_LINE1,			/* Input source 1  (aux1) */
	SOUND_MIXER_LINE2,			/* Input source 2  (aux2) */
	SOUND_MIXER_LINE3,			/* Input source 3  (line) */
	SOUND_MIXER_DIGITAL1,		/* Digital (input) 1 */
	SOUND_MIXER_DIGITAL2,		/* Digital (input) 2 */
	SOUND_MIXER_DIGITAL3,		/* Digital (input) 3 */
	SOUND_MIXER_PHONEIN,		/* Phone input */
	SOUND_MIXER_PHONEOUT,		/* Phone output */
	SOUND_MIXER_VIDEO,			/* Video/TV (audio) in */
	SOUND_MIXER_RADIO,			/* Radio in */
	SOUND_MIXER_MONITOR			/* Monitor (usually mic) volume */

};

/* DEFAULT PIXMAPS */
gchar *default_pixmaps[number_of_pixmaps] = { 

	PIXMAPS THEME"/volume.png",
	PIXMAPS THEME"/bass.png",
	PIXMAPS THEME"/treble.png",
	PIXMAPS THEME"/synth.png",
	PIXMAPS THEME"/pcm.png",
	PIXMAPS THEME"/speaker.png",
	PIXMAPS THEME"/line.png",
	PIXMAPS THEME"/mic.png",
	PIXMAPS THEME"/cd.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/pcm.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/gain.png",
	PIXMAPS THEME"/gainout.png",
	PIXMAPS THEME"/line.png",
	PIXMAPS THEME"/line.png",
	PIXMAPS THEME"/line.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/unknown.png",
	PIXMAPS THEME"/unknown.png"

};

/* REC PIXMAPS THEME */
gchar *rec_pixmaps[number_of_pixmaps] = { 

	PIXMAPS THEME"/volume_rec.png",
	PIXMAPS THEME"/bass.png",
	PIXMAPS THEME"/treble.png",
	PIXMAPS THEME"/synth_rec.png",
	PIXMAPS THEME"/pcm.png",
	PIXMAPS THEME"/speaker.png",
	PIXMAPS THEME"/line_rec.png",
	PIXMAPS THEME"/mic_rec.png",
	PIXMAPS THEME"/cd_rec.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/pcm.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/gain.png",
	PIXMAPS THEME"/gainout.png",
	PIXMAPS THEME"/line_rec.png",
	PIXMAPS THEME"/line_rec.png",
	PIXMAPS THEME"/line_rec.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/unknown_rec.png",
	PIXMAPS THEME"/unknown_rec.png"

};

/* MUTE PIXMAPS THEME */
gchar *mute_pixmaps[number_of_pixmaps] = { 

	PIXMAPS THEME"/volume_mute.png",
	PIXMAPS THEME"/bass_mute.png",
	PIXMAPS THEME"/treble_mute.png",
	PIXMAPS THEME"/synth_mute.png",
	PIXMAPS THEME"/pcm_mute.png",
	PIXMAPS THEME"/speaker_mute.png",
	PIXMAPS THEME"/line_mute.png",
	PIXMAPS THEME"/mic_mute.png",
	PIXMAPS THEME"/cd_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/pcm_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/gain_mute.png",
	PIXMAPS THEME"/gainout_mute.png",
	PIXMAPS THEME"/line_mute.png",
	PIXMAPS THEME"/line_mute.png",
	PIXMAPS THEME"/line_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/unknown_mute.png",
	PIXMAPS THEME"/unknown_mute.png"

};


