/*

  Copyright (C) 2000, The MITRE Corporation

  Use of this software is subject to the terms of the GNU General
  Public License version 2.

  Please read the file LICENSE for the exact terms.

*/

/*
 * Classes for the Border router protocol messages.
 *
 * Author: Kevin H. Grace, kgrace@mitre.org
 *         The MITRE Corporation
 *         202 Burlington Rd
 *         Bedford, MA  01730
 *         
 *
 * $Id: BoMsg.h,v 1.1.1.1 2003/10/24 10:34:57 br1 Exp $
 *   
 */
#ifndef __BoMsg_h
#define __BoMsg_h

#include <list.h>

#include <UtString.h>
#include <UtUtil.h>


class MsgTypes {
public:
  enum { Version = 1 };
  enum { tBorderAdvertisement=200 };
};


/*
  Format of Border Advertisement packets that are sent over the air:

  Members    := <Version><Msg Type>
  Version    := 1
  Msg Type   := 200

    0                   1                   2                   3
    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   | Version = 1   | Msg Type=200  |                               |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 
*/
class BorderAdvertisement {
public:
  BorderAdvertisement() {}

  // Extracts a Border Advertisement message from the given string
  bool Decode(String& s) {
    unsigned int offset = 0;
    bool ok = true;

    // Control structure...never loops
    do {
      Decode1(s,offset,ok);  if(!ok) break; // Skip Version
      Decode1(s,offset,ok);  if(!ok) break; // Skip Msg Type
      Decode2(s,offset,ok);  if(!ok) break; // Skip Pad
    } while(0);

    return(ok);
  }
  
  String Encode() const {
    String s;
    s += Encode1(MsgTypes::Version);
    s += Encode1(MsgTypes::tBorderAdvertisement);
    s += Encode2(0);
    return(s);
  }

  String Dump() const {
    String s;
    s += "[BorderAdvertisement] ";
    return(s);
  }
    
};


  
#endif




