#ifndef __IWQUAL_H
#define __IWQUAL_H


#include "EthAddr.h"

#include <arpa/inet.h>		// inet_addr, sockaddr_in
#include <asm/types.h> 		// __u32


#define SNR_HISTORY_SIZE 20

class IwQual {
private:
	struct sockaddr_in ip;
	EthAddr mac;

	int signal;
	int noise;
	int snr;
	int snr_old;

	int snrh[SNR_HISTORY_SIZE];
	int snrh_pos;

	void snr_history_add(int snr) {
		snrh[snrh_pos]=snr;

		snrh_pos++;
		if (snrh_pos==SNR_HISTORY_SIZE) {
			snrh_pos = 0;
		}
	}

	int snr_history_average() {
		int i;
		long sum=0;
		int anz=0;
		//printf("* avg ");
		for (i=0; i<SNR_HISTORY_SIZE; i++) {
			// break if history is not totally filled yet
			if (snrh[i] == -1) {
				break;
			}
			//printf("%d ",snrh[i]);
			sum += snrh[i];
			anz++;
		}
		if (anz>0 && sum>0) {
			//printf(": %d\n",sum/anz);
			return sum/anz;
		}
		return 0;
	}

public:
	IwQual() {
		snr=0;
		int i;
		// initialize history with "not used" markers
		for (i=0; i<SNR_HISTORY_SIZE; i++) {
			snrh[i]=-1;
		}
		snrh_pos=0;
	}

	void setIp( const struct sockaddr_in i ) {
		ip = i;
	}

	void setIp( const char* string ) {
		ip.sin_family = AF_INET;
		ip.sin_port = 0;
		ip.sin_addr.s_addr= inet_addr(string);
	}

	__u32 getIp() {
		return ntohl(ip.sin_addr.s_addr);
	}

	struct sockaddr_in getIpSockaddr() {
		return ip;
	}

	struct sockaddr* getIpSockaddrP() {
		struct sockaddr* sap;
		sap = (struct sockaddr *)&ip;
		return sap;
	}

	void setMAC( const struct sockaddr s ) {
		mac = s;
	}

	EthAddr getMac() {
		return mac;
	}

	struct sockaddr getMacSockaddr() {
		return mac.getSockaddr();
	}

	void setSignalNoise( int s, int n, bool updated ) {
		int sn;
		if (updated) {
			signal = s;
			noise =  n;
			sn = s-n;
			if (sn>0 && sn<100) {
				snr = sn;
				snr_history_add(snr);
			}
		}
	}

	int getSignal() {
		return signal;
	}

	int getNoise() {
		return noise;
	}

	int getSNR() {
		return signal-noise;
	}

	/* old
	int getAverageSNR() {
		//!todo: make average
		snr_old = snr;
		return snr;
	}
	*/

	int getAverageSNR() {
		snr_old = snr_history_average();
		return snr_old;
	}

	/* old
	unsigned int getDeltaSNR() {
		if (snr_old>snr)
			return snr_old - snr;
		else
			return snr - snr_old;
	}
	*/

	unsigned int getDeltaSNR() {
		int s = snr_history_average();
		if (snr_old>s)
			return snr_old - s;
		else
			return s - snr_old;
	}
};

#endif
