/*

  Copyright (C) 2000, The MITRE Corporation

  Use of this software is subject to the terms of the GNU General
  Public License version 2.

  Please read the file LICENSE for the exact terms.

*/

/*
 * Author: Mike Butler, mgb@mitre.org
 *
 * $Id: UtDebug.h,v 1.1.1.1 2003/10/24 10:34:57 br1 Exp $
 *
 * 04-Nov-97 [mgb] Added globbing and "AllKeys" map
 */

/* Routines for debugging...
 * Debug("Foo") will return true if debugging of "Foo" is on.
 */

#ifndef Debug_h
#define Debug_h
#include <UtString.h> /* Our string class */

class Debug {
  friend ostream &operator<<(ostream &os, const Debug &d);
  friend istream &operator>>(istream &is, const Debug &d);
private:
  String cKey;
public:
  operator bool();
  Debug(const String &key, const bool &value);
  Debug(const String &key = "");
  static bool Load(const String &file);
  static bool Update();
  static void Clear();
  static ostream &DumpAll(ostream &os);
  static String Debug::Dump();

  // Depricated.  Use clear! 
  static void PurgeAllMemory() { Clear(); }

};

#endif // Debug_h
