/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xatom.h"
#include "Xproto.h"
#include "misc.h"
#include "miscstruct.h"
#include "font.h"
#include "fontstruct.h"
#include "scrnintstr.h"

#include "Agent.h"

#include "Display.h"
#include "Font.h"
#include "Error.h"

#include <stdio.h>
#include "resource.h"

/*FIXME: Remember compiling without cache macros*/

/*
#define NXAGENT_FONTCACHE_DEBUG
*/
#ifdef NXAGENT_FONTMATCH

#ifdef NXAGENT_RECONNECT
static void nxagentCleanCacheAfterReConnect(void);
static Bool nxagentFontsCreation(void);
static void nxagentFontReConnect(FontPtr, XID, pointer);
static int reconnectFlexibility;
RESTYPE RT_NX_FONT;
#endif

typedef struct _nxagentFontRec
{
  char *name;
  int  status;
} nxagentFontRec, *nxagentFontRecPtr;


typedef struct _nxagentFontList {
  nxagentFontRecPtr *list;
  int lenght;
  int listSize;
} nxagentFontList, *nxagentFontListPtr;


#ifdef NXAGENT_FONTEXCLUDE
char *excludeList[] = {"-ult1mo",(char*)NULL};
#endif


nxagentFontList nxagentRemoteFontList = {NULL, (int)0, (int)0};

#endif

int nxagentFontPrivateIndex;

#ifdef NXAGENT_FONTCACHE

typedef struct _nxCacheFontEntry {
/*   char *name; */
  Atom atom;
  XFontStruct *font_struct;
  char *name;
} nxCacheFontEntryRec, *nxCacheFontEntryRecPtr;

static struct _nxagentFontCache {
  nxCacheFontEntryRecPtr *entry;
  int index;
  int size;
} nxagentFontCache = {NULL, (int)0, (int)0};

/* this is used if nxagentFullGeneration in CloseDisplay */
void nxagentFreeFontCache(void)
{
  int i;
#ifdef NXAGENT_FONTCACHE_DEBUG
  fprintf(stderr, "Font: Freeing nxagent font cache\n");
#endif
  if (nxagentFontCache.index == 0)
    return;

#ifdef NXAGENT_FONTCACHE_DEBUG
  fprintf(stderr, "Font: Freeing nxagent font cache, there are [%d] entries.\n",nxagentFontCache.index);
#endif
  for (i = 0; i < nxagentFontCache.index; i++)
  {
#ifdef NXAGENT_FONTCACHE_DEBUG
        fprintf(stderr, "Font: Freeing nxagent font cache entry [%d] entry pointer is [%p], name [%s]\n",
                 i, nxagentFontCache.entry[i], nxagentFontCache.entry[i]->name);
#endif
        XFreeFont(nxagentDisplay, nxagentFontCache.entry[i]->font_struct);
	xfree(nxagentFontCache.entry[i]->name);
	xfree(nxagentFontCache.entry[i]);
  }
  xfree(nxagentFontCache.entry);
  nxagentFontCache.entry = NULL;
  nxagentFontCache.index = 0;
  nxagentFontCache.size = 0;
#ifdef NXAGENT_FONTCACHE_DEBUG
  fprintf(stderr, "Font: nxagent font cache fully freed\n");
#endif
  return;
}

#endif /* NXAGENT_FONTCACHE */



#ifdef NXAGENT_FONTMATCH
void nxagentListRemoteFonts(const char *searchPattern, const int maxNames)
{
  int i,j,q,pos;
  char **xList;
  int  xLen = 0;

    if (nxagentFontFind(searchPattern, &pos))
    {
       if (nxagentRemoteFontList.list[pos]->status >= maxNames)
       {
#ifdef NXAGENT_FONTMATCH_DEBUG
         fprintf(stderr, "Font: nxagent remote list [%s] request [%d] elements status is [%d] elements.\n", searchPattern,maxNames,nxagentRemoteFontList.list[pos]->status );
#endif
          return;
       }
    }

  xList = XListFonts(nxagentDisplay,searchPattern, maxNames, &xLen);

#ifdef NXAGENT_FONTMATCH_DEBUG
  fprintf(stderr, "Font: nxagent remote list [%s] has %d elements.\n", searchPattern, xLen);
#endif

/* add the ListFont request pattern to the list with the last maxnames quantity requested */

  nxagentListRemoteAddName(searchPattern, maxNames);

  for (i = 0; i < xLen; i++)
  {
     q = 1;
#ifdef NXAGENT_FONTEXCLUDE
     j = 0;
     while (excludeList[j])
     {
       if (strncasecmp(excludeList[j], xList[i],strlen(excludeList[j])) == 0)
       {
         q = 0;

#ifdef NXAGENT_FONTMATCH_DEBUG
         fprintf(stderr, "Font: nxagent remote list [%s] excluded.\n", xList[i]);
#endif
         break;
       }
       j++;
     }
#endif
     nxagentListRemoteAddName(xList[i], q);
  }

  XFreeFontNames(xList);

# ifdef NXAGENT_FONTMATCH_DEBUG_no
  fprintf(stderr, "Font: Printing remote font list.\n");
  for (i = 0; i < nxagentRemoteFontList.lenght; i++)
    {
      fprintf(stderr, "Font# %d, \"%s\"\n", i, nxagentRemoteFontList.list[i]->name);
    }
  fprintf(stderr, "Font: End of list\n");
# endif

}

void nxagentListRemoteAddName(const char *name, int status)
{
int pos;
    if (nxagentFontFind(name, &pos))
    {
       if (nxagentRemoteFontList.list[pos]->status < status)
       {
         nxagentRemoteFontList.list[pos]->status = status;
# ifdef NXAGENT_FONTMATCH_DEBUG
         fprintf(stderr, "Font: Font# %d, [%s] change status to %s\n", pos, nxagentRemoteFontList.list[pos]->name,nxagentRemoteFontList.list[pos]->status?"OK":"deleted");
#endif
       }
       return;
    }
    if (nxagentRemoteFontList.lenght == nxagentRemoteFontList.listSize)
    {
       nxagentRemoteFontList.list=xrealloc(nxagentRemoteFontList.list,sizeof(nxagentFontRecPtr) * (nxagentRemoteFontList.listSize + 1000));
       if (nxagentRemoteFontList.list == NULL)
       {
           FatalError("Font: remote list memory re-allocation failed!.\n");
/*           exit(0);*/
       }
       nxagentRemoteFontList.listSize += 1000;
    }
    if (pos < nxagentRemoteFontList.lenght)
    {
# ifdef NXAGENT_FONTMATCH_DEBUG
      fprintf(stderr, "Font: Going to move list from %p to %p len = %d!.\n",&nxagentRemoteFontList.list[pos],&nxagentRemoteFontList.list[pos+1],(nxagentRemoteFontList.lenght - pos)*sizeof(nxagentFontRecPtr));
#endif
      memmove(&nxagentRemoteFontList.list[pos+1],&nxagentRemoteFontList.list[pos],(nxagentRemoteFontList.lenght - pos)*sizeof(nxagentFontRecPtr));
    }
    if ((nxagentRemoteFontList.list[pos] = xalloc(sizeof(nxagentFontRec))))
    {
      nxagentRemoteFontList.list[pos]->name = xalloc(strlen(name) +1);
      if (nxagentRemoteFontList.list[pos]->name == NULL)
      {
         fprintf(stderr, "Font: remote list name memory allocation failed!.\n");
	 return;
      }
    }
    else
    {
       fprintf(stderr, "Font: remote list record memory allocation failed!.\n");
       return;
    }
    strcpy(nxagentRemoteFontList.list[pos]->name,name);
    nxagentRemoteFontList.list[pos]->status = status;
    nxagentRemoteFontList.lenght++;
# ifdef NXAGENT_FONTMATCH_DEBUG
      fprintf(stderr, "Font: remote font list added [%s] in position [%d] as %s !.\n",name,pos, status?"OK":"deleted");
      fprintf(stderr, "Font: remote font list total len is [%d] Size is [%d] !.\n",nxagentRemoteFontList.lenght,nxagentRemoteFontList.listSize);
#endif
}


Bool nxagentFontFind(const char *name, int *pos)
{
 int low,high,res,iter,lpos;

 if (!nxagentRemoteFontList.lenght)
 {
    *pos=0;
    return False;
 }
 low = 0;
 high = nxagentRemoteFontList.lenght - 1;
 iter = 0;
 res = 1;
 lpos = nxagentRemoteFontList.lenght;
 while (low <= high )
 {
   *pos = (high + low)/2;
   iter ++;
   res = strcasecmp(nxagentRemoteFontList.list[*pos]->name,name);
   if (res > 0)
   {
      high = *pos - 1;
      lpos = *pos;
      continue;
   }
   else if (res < 0)
   {
      low = *pos + 1;
      lpos = low;
      continue;
   }
   break;
 }
 *pos = (res == 0)?*pos:lpos;
# ifdef NXAGENT_FONTMATCH_DEBUG
  if (res == 0)
    fprintf(stderr, "Font: font found in %d iterations in pos = %d\n",iter,*pos);
  else
    fprintf(stderr, "Font: not font found in %d iterations insertion pos is = %d\n",iter,*pos);
#endif
 return (res == 0);

}


Bool nxagentFontLookUp(const char *name)
{
  int i;
  if (name)
    if (!strlen(name))
       return 0;
  if (nxagentFontFind(name, &i))
    return (nxagentRemoteFontList.list[i]->status > 0);
  else
    return 0;
}


#endif /* NXAGENT_FONTMATCH */


Bool nxagentRealizeFont(pScreen, pFont)
    ScreenPtr pScreen;
    FontPtr pFont;
{
  pointer priv;
  Atom name_atom, value_atom;
  int nprops;
  FontPropPtr props;
  int i;
  char *name;
  char *origName = (char*) pScreen;

  FontSetPrivate(pFont, nxagentFontPrivateIndex, NULL);

  if (requestingClient && XpClientIsPrintClient(requestingClient, NULL))
    return True;

  name_atom = MakeAtom("FONT", 4, True);
  value_atom = 0L;

  nprops = pFont->info.nprops;
  props = pFont->info.props;

  for (i = 0; i < nprops; i++)
    if ((Atom)props[i].name == name_atom) {
      value_atom = props[i].value;
      break;
    }

  if (!value_atom) return False;

  name = (char *)NameForAtom(value_atom);

#ifdef NXAGENT_FONTCACHE_DEBUG
  fprintf(stderr, "Font: nxagentRealizeFont, realizing font: %s\n", name);
  fprintf(stderr, "                                 atom: %ld\n", value_atom);
  fprintf(stderr, "Font: Cache dump:\n");
  for (i = 0; i < nxagentFontCache.index; i++)
  {
      fprintf(stderr, "nxagentFontCache.entry[%d]->name: %s font_struct at %p\n",
	      i, nxagentFontCache.entry[i]->name, nxagentFontCache.entry[i]->font_struct);
/*      fprintf(stderr, "nxagentFontCache.entry[%d]: %p\n",
	      i, nxagentFontCache.entry[i]);*/
  }
#endif

  if (!name) return False;

  if ((strcasecmp(origName, name) != 0) && !strchr(origName,'*'))
  {
#ifdef NXAGENT_FONTMATCH_DEBUG
     fprintf(stderr, "Font: Changing font name to realize from [%s] to [%s]\n", name, origName);
#endif
     name = origName;
  }
  priv = (pointer)xalloc(sizeof(nxagentPrivFont));
  FontSetPrivate(pFont, nxagentFontPrivateIndex, priv);
# ifdef NXAGENT_RECONNECT
  nxagentFontPriv(pFont) -> mirrorID = 0;
# endif

#ifdef NXAGENT_FONTCACHE

  for (i = 0; i < nxagentFontCache.index; i++)
  {
/*      if (value_atom == nxagentFontCache.entry[i]->atom)*/
     if (strcasecmp(nxagentFontCache.entry[i]->name, name) == 0)
     {
#ifdef NXAGENT_FONTCACHE_DEBUG
	fprintf(stderr, "Font: nxagentFontCache hit [%s] = [%s]!\n",nxagentFontCache.entry[i]->name,name);
#endif
	break;
     }
  }
  if (i < nxagentFontCache.index)
  {
      nxagentFontPriv(pFont)->font_struct = nxagentFontCache.entry[i]->font_struct;
      strcpy(nxagentFontPriv(pFont)->fontName, name);
  }
  else
  {

#ifdef NXAGENT_FONTCACHE_DEBUG
      fprintf(stderr, "Font: nxagentFontCache fail.\n");
#endif

      if (nxagentFontCache.index == nxagentFontCache.size)
      {
        nxagentFontCache.entry = xrealloc(nxagentFontCache.entry, sizeof(nxCacheFontEntryRecPtr) * (nxagentFontCache.size + 100));
        if (nxagentFontCache.entry == NULL)
        {
           FatalError("Font: cache list memory re-allocation failed!.\n");
/*           exit(0);*/
        }
        nxagentFontCache.size += 100;
     }
     nxagentFontCache.entry[nxagentFontCache.index] = xalloc(sizeof(nxCacheFontEntryRec));
     if (nxagentFontCache.entry[nxagentFontCache.index] == NULL)
     {
        return False;
/*        nxagentExitHandler("Font: Memory allocation error in nxagent font cache code (#1)");*/
     }
     nxagentFontCache.entry[nxagentFontCache.index]->name = xalloc(strlen(name) + 1);
     if (nxagentFontCache.entry[nxagentFontCache.index]->name == NULL)
     {
        return False;
     }

#ifdef NXAGENT_FONTMATCH_DEBUG
      fprintf(stderr, "Font: going to realize font [%s],[%s] on real X server.\n", name, origName);
#endif

     nxagentFontPriv(pFont)->font_struct = XLoadQueryFont(nxagentDisplay, name);
     strcpy(nxagentFontPriv(pFont)->fontName, name);
     if (nxagentFontPriv(pFont)->font_struct != NULL)
     {
       nxagentFontCache.entry[i]->atom = value_atom;
       strcpy(nxagentFontCache.entry[i]->name, name);
       nxagentFontCache.entry[i]->font_struct = nxagentFontPriv(pFont)->font_struct;
       nxagentFontCache.index++;

#      ifdef NXAGENT_RECONNECT
       nxagentFontPriv(pFont) -> mirrorID = FakeClientID(0);
       AddResource( nxagentFontPriv(pFont) -> mirrorID, RT_NX_FONT, pFont);
#      endif

#ifdef NXAGENT_FONTCACHE_DEBUG
       fprintf(stderr, "Font: nxagentFontCache adds font [%s] in pos. [%d].\n", name, nxagentFontCache.index - 1);
#endif
     }
  }
#else /* NXAGENT_FONTCACHE */
  nxagentFontPriv(pFont)->font_struct = XLoadQueryFont(nxagentDisplay, name);
# ifdef NXAGENT_RECONNECT
  nxagentFontPriv(pFont) -> mirrorID = FakeClientID(0);
  AddResource(nxagentFontPriv(pFont) -> mirrorID, RT_NX_FONT, pFont);
# endif

#endif /* NXAGENT_FONTCACHE */

#ifdef NXAGENT_FONTMATCH
#ifdef NXAGENT_FONTMATCH_DEBUG
  if (nxagentFontPriv(pFont)->font_struct == NULL)
  {
    if (nxagentFontLookUp(name) == False)
    {
      fprintf(stderr, "Font: nxagentRealizeFont failed with font Font=%s, not in our remote list\n",name);
    }
    else
    {
      fprintf(stderr, "Font: nxagentRealizeFont failed with font Font=%s but the font is in our remote list\n",name);
    }
  }
  else
      fprintf(stderr, "Font: nxagentRealizeFont OK realizing font Font=%s\n",name);
#endif
#endif
  return (nxagentFontPriv(pFont)->font_struct != NULL);
}


Bool nxagentUnrealizeFont(pScreen, pFont)
    ScreenPtr pScreen;
    FontPtr pFont;
{

  if (nxagentFontPriv(pFont))
  {
    if (nxagentFontStruct(pFont))
#ifdef NXAGENT_FONTCACHE
    {
       int i;
       for (i = 0; i < nxagentFontCache.index; i++)
       {
         /*if (nxagentFontCache.entry[i]->font_struct->fid == nxagentFont(pFont))*/
         if(nxagentFontCache.entry[i]->font_struct == nxagentFontStruct(pFont))
         {
#ifdef NXAGENT_FONTCACHE_DEBUG
           fprintf(stderr, "Font: nxagentUnrealizeFont not freeing font in cache.\n");
#endif
           break;
         }
       }
       if (i == nxagentFontCache.index)
       {
         /* this font is not cached */
#ifdef NXAGENT_FONTCACHE_DEBUG
         fprintf(stderr, "Font: nxagentUnrealizeFont freeing font not in cache: %d\n",
         nxagentFontCache.entry[i]->atom);
#endif
#ifdef NXAGENT_FONTCACHE_DEBUG
           fprintf(stderr, "Font: nxagentUnrealizeFont freeing font.\n");
#endif
         XFreeFont(nxagentDisplay, nxagentFontStruct(pFont));
       }
     }
#else
#ifdef NXAGENT_FONTCACHE_DEBUG
    fprintf(stderr, "Font: nxagentUnrealizeFont freeing font.\n");
#endif
    XFreeFont(nxagentDisplay, nxagentFontStruct(pFont));

#endif /* NXAGENT_FONTCACHE */
#   ifdef NXAGENT_RECONNECT
    if (nxagentFontPriv(pFont) -> mirrorID)
      FreeResource(nxagentFontPriv(pFont) -> mirrorID, RT_NONE);
#   endif
    xfree(nxagentFontPriv(pFont));
    FontSetPrivate(pFont, nxagentFontPrivateIndex, NULL);
  }
  return True;
}

#ifdef NXAGENT_RECONNECT

int nxagentDestroyNewFontResourceType(pointer p, XID id)
{
  #ifdef TEST
  fprintf(stderr, "nxagentDestroyNewFontResourceType: Destroying mirror id [%ld] for font at [%p].\n",
              nxagentFontPriv((FontPtr) p) -> mirrorID, (void *) p);
  #endif

  nxagentFontPriv((FontPtr) p) -> mirrorID = None;

  return 1;
}

XFontStruct* LoadBestQueryFont(Display* dpy, char *fontName)
{
  XFontStruct *font_struct;

  fprintf(stderr, "nxagentFontReConnect: Failed to load font %s - substitued with %s\n",
	           fontName, 
		   "fixed");
  font_struct = XLoadQueryFont(dpy, "fixed");
  return font_struct;
}

static void nxagentFontReConnect(FontPtr pFont, XID param1, pointer param2)
{
  int i;
  nxagentPrivFont *privFont;
  Bool *pBool = (Bool*)param2;

  if (pFont == NULL || !*pBool)
    return;

  privFont = nxagentFontPriv(pFont);
  
#ifdef NXAGENT_RECONNECT_FONT_DEBUG
  fprintf(stderr, "nxagentFontReConnect: pFont %p - XID %lx - name %s\n", 
		  pFont, 
		  (privFont -> font_struct) ? nxagentFont(pFont) : 0, 
		  privFont -> fontName);
#endif
  
  for (i = 0; i < nxagentFontCache.index; i++)
  {
    if (strcasecmp(nxagentFontCache.entry[i] -> name, privFont -> fontName) == 0)
    {
#ifdef NXAGENT_RECONNECT_FONT_DEBUG
      fprintf(stderr, "\tfound in cache");
#endif

      if (!nxagentFontCache.entry[i] -> font_struct)
      {
#ifdef NXAGENT_RECONNECT_FONT_DEBUG
        fprintf(stderr, " --- font struct not valid\n");
#endif
        break;
      }

      nxagentFontStruct(pFont) = nxagentFontCache.entry[i]->font_struct;
      return;
    }
  }

  if (i == nxagentFontCache.index)
  {
    FatalError("nxagentFontReConnect: font not found in cache.");
  }

  privFont -> font_struct = XLoadQueryFont(nxagentDisplay, privFont -> fontName);

  if ((privFont -> font_struct == NULL) && reconnectFlexibility)
  {
    privFont -> font_struct = LoadBestQueryFont(nxagentDisplay, privFont -> fontName);
  }

  if (privFont->font_struct != NULL)
  {
#ifdef NXAGENT_RECONNECT_FONT_DEBUG
    fprintf(stderr, "\tXID %lx\n", privFont -> font_struct -> fid);
#endif
    
    nxagentFontCache.entry[i] -> font_struct = privFont -> font_struct;
  }
  else
  {
    extern char *nxagentReconnectMSG;

#ifdef NXAGENT_RECONNECT_FONT_DEBUG
    fprintf(stderr, "nxagentFontReConnect: failed\n");
#endif

    nxagentReconnectMSG = "Couldn't reconnect Font";
    *pBool = False;
  }
  
  return;
}

#define CACHE_ENTRY(A) (nxagentFontCache.entry[A])
#define CACHE_FSTRUCT(A) (CACHE_ENTRY(A) -> font_struct)
#define CACHE_INDEX (nxagentFontCache.index)

static void nxagentFreeCacheBeforeReConnect(void)
{
  int i;

#ifdef NXAGENT_RECONNECT_FONT_DEBUG
  printFontCacheDump("nxagentFreeCacheBeforeReConnect");
#endif
  
  for (i = 0; i < CACHE_INDEX; i++)
  {
    if (CACHE_FSTRUCT(i))
    {
      /* FIXME: Perhaps we have to free some memory ? */
      CACHE_FSTRUCT(i) = NULL;
    }
  }
}

static void nxagentCleanCacheAfterReConnect(void)
{
  int i, j;
  int real_size = CACHE_INDEX;
  nxCacheFontEntryRecPtr swapEntryPtr;

#ifdef NXAGENT_RECONNECT_FONT_DEBUG
  printFontCacheDump("nxagentCleanCacheAfterReConnect");
#endif
  
  for (i = 0; i < CACHE_INDEX; i++)
  {
    if( CACHE_FSTRUCT(i) == NULL)
    {
      XFree(CACHE_ENTRY(i) -> name);
      real_size--;
    }
  }

  for (i = 0; i < real_size; i++)
  {
      /* Find - first bad occurrence if exist. */
      while ((i < real_size) && CACHE_FSTRUCT(i)) i++;

      /* Really nothing more to do. */
      if (i == real_size)
	break;

      /* 
       * Find - first good occurrence (moving backward from right end) entry in
       *        order to replace the bad one. 
       */
      for (j = CACHE_INDEX - 1; CACHE_FSTRUCT(j) == NULL; j--);

      /*
       * Now we can swap the two entry
       * and reduce the Cache index
       */
      swapEntryPtr = CACHE_ENTRY(i);
      CACHE_ENTRY(i) = CACHE_ENTRY(j);
      CACHE_ENTRY(j) = swapEntryPtr;
  }

  CACHE_INDEX = real_size;
}

#ifdef NXAGENT_RECONNECT_FONT_DEBUG
static void printFontCacheDump(char* msg)
{
  int i;
  
  fprintf(stderr, "%s - begin -\n", msg);
  for (i = 0; i < CACHE_INDEX; i++)
  {
    if (CACHE_FSTRUCT(i))
      fprintf(stderr, "\tXID %lx - %s\n", 
              CACHE_FSTRUCT(i) -> fid,
	      CACHE_ENTRY(i) -> name);
    else
      fprintf(stderr, "\tdestroyed   - %s\n", 
		      CACHE_ENTRY(i) -> name);
  }
  fprintf(stderr, "%s - end   -\n", msg);
}
#endif

#undef CACHE_ENTRY
#undef CACHE_INDEX

Bool nxagentReCreateFonts(void*p0)
{
  reconnectFlexibility = *(int*)p0;

#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_FONT_DEBUG)
  fprintf(stderr, "nxagentReCreateFonts\n");
#endif

  if(!nxagentFontsCreation())
    return False;

  nxagentCleanCacheAfterReConnect();

  return True;
}

Bool nxagentDisconnectFonts(void)
{
#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_FONT_DEBUG)
  fprintf(stderr, "nxagentDisconnectFonts\n");
#endif

  nxagentFreeCacheBeforeReConnect();

  return True;
}

static Bool nxagentFontsCreation(void)
{
  int cid;
  Bool fontSuccess = True;

#ifdef NXAGENT_RECONNECT_FONT_DEBUG
  fprintf(stderr, "nxagentFontsCreation:\n");
#endif

  for(cid = 0; cid < MAXCLIENTS; cid++)
  {
    if( clients[cid] && fontSuccess )
    {
      FindClientResourcesByType(clients[cid], 
		                RT_NX_FONT, 
				(FindResType)nxagentFontReConnect, 
		                &fontSuccess);
    }
  }
  return fontSuccess;
}

#endif

