/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "FillPoly.h"

#include "ClientCache.h"

#include "EncodeBuffer.h"
#include "DecodeBuffer.h"

//
// Set the verbosity level.
//

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG
#undef  DUMP

//
// Here are the methods to handle messages' content.
//

int FillPolyStore::parseIdentity(Message *message, const unsigned char *buffer,
                                     unsigned int size, int bigEndian) const
{
  FillPolyMessage *fillPoly = (FillPolyMessage *) message;

  //
  // Here is the fingerprint.
  //

  fillPoly -> drawable = GetULONG(buffer + 4, bigEndian);
  fillPoly -> gcontext = GetULONG(buffer + 8, bigEndian);

  fillPoly -> shape = *(buffer + 12);
  fillPoly -> mode  = *(buffer + 13);

  #ifdef DEBUG
  *logofs << name() << ": Parsed Identity for message at " << this << ".\n" << logofs_flush;
  #endif

  return true;
}

int FillPolyStore::unparseIdentity(const Message *message, unsigned char *buffer,
                                       unsigned int size, int bigEndian) const
{
  FillPolyMessage *fillPoly = (FillPolyMessage *) message;

  //
  // Fill all the message's fields.
  //

  PutULONG(fillPoly -> drawable, buffer + 4, bigEndian);
  PutULONG(fillPoly -> gcontext, buffer + 8, bigEndian);

  *(buffer + 12) = fillPoly -> shape;
  *(buffer + 13) = fillPoly -> mode;

  #ifdef DEBUG
  *logofs << name() << ": Unparsed identity for message at " << this << ".\n" << logofs_flush;
  #endif

  return true;
}

void FillPolyStore::dumpIdentity(const Message *message) const
{
  #ifdef DUMP

  FillPolyMessage *fillPoly = (FillPolyMessage *) message;

  *logofs << name() << ": Identity drawable " << fillPoly -> drawable
                    << ", gcontext " << fillPoly -> gcontext << ", shape "
                    << fillPoly -> shape << ", mode " << fillPoly -> mode
                    << fillPoly -> size_ << ".\n" << logofs_flush;
  #endif
}

void FillPolyStore::identityChecksum(const Message *message, const unsigned char *buffer,
                                         unsigned int size, int bigEndian) const
{
  //
  // Fields shape, mode.
  //

  if (control -> isProtoStep3() == 1)
  {
    md5_append(md5_state_, buffer + 12, 2);
  }
}

void FillPolyStore::updateIdentity(EncodeBuffer &encodeBuffer, const Message *message,
                                       const Message *cachedMessage,
                                           ChannelCache *channelCache) const
{
  FillPolyMessage *fillPoly       = (FillPolyMessage *) message;
  FillPolyMessage *cachedFillPoly = (FillPolyMessage *) cachedMessage;

  ClientCache *clientCache = (ClientCache *) channelCache;

  #ifdef TEST
  *logofs << name() << ": Encoding value " << fillPoly -> drawable
          << " as drawable field.\n" << logofs_flush;
  #endif

  encodeBuffer.encodeXidValue(fillPoly -> drawable,
                     cachedFillPoly -> drawable, clientCache -> drawableCache);

  cachedFillPoly -> drawable = fillPoly -> drawable;

  #ifdef TEST
  *logofs << name() << ": Encoding value " << fillPoly -> gcontext
          << " as gcontext field.\n" << logofs_flush;
  #endif

  encodeBuffer.encodeXidValue(fillPoly -> gcontext,
                     cachedFillPoly -> gcontext, clientCache -> gcCache);

  cachedFillPoly -> gcontext = fillPoly -> gcontext;
}

void FillPolyStore::updateIdentity(DecodeBuffer &decodeBuffer, const Message *message,
                                       ChannelCache *channelCache) const
{
  FillPolyMessage *fillPoly = (FillPolyMessage *) message;

  ClientCache *clientCache = (ClientCache *) channelCache;

  unsigned int value;

  decodeBuffer.decodeXidValue(value, fillPoly -> drawable,
                     clientCache -> drawableCache);

  fillPoly -> drawable = value;

  #ifdef DEBUG
  *logofs << name() << ": Decoded value " << fillPoly -> drawable
          << " as drawable field.\n" << logofs_flush;
  #endif

  decodeBuffer.decodeXidValue(value, fillPoly -> gcontext,
                     clientCache -> gcCache);

  fillPoly -> gcontext = value;

  #ifdef DEBUG
  *logofs << name() << ": Decoded value " << fillPoly -> gcontext
          << " as gcontext field.\n" << logofs_flush;
  #endif
}


