/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "GenericReadBuffer.h"

#include "GenericChannel.h"

int GenericReadBuffer::locateMessage(const unsigned char *start,
                                         const unsigned char *end,
                                             unsigned int &controlLength,
                                                 unsigned int &dataLength,
                                                     unsigned int &trailerLength)
{
  //
  // Note that we don't care about host
  // endianess in generic channels.
  //

  unsigned int size = end - start;

  if (size == 0)
  {
    return 0;
  }

  dataLength = size;

  controlLength = 0;
  trailerLength = 0;

  return 1;
}
