/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2006 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

//
// Include the template for
// this message class.
//

#include "RenderCompositeGlyphs.h"

//
// Set the verbosity level.
//

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

#include MESSAGE_TAGS

//
// Message handling methods.
//

MESSAGE_BEGIN_ENCODE_SIZE
{
  ClientCache *clientCache = (ClientCache *) channelCache;

  #ifdef DEBUG
  *logofs << name() << ": Encoding value "
          << ((size - MESSAGE_OFFSET) >> 2) << ".\n"
          << logofs_flush;
  #endif

  encodeBuffer.encodeCachedValue((size - MESSAGE_OFFSET) >> 2, 16,
                     clientCache -> renderLengthCache, 5);

  #ifdef TEST
  *logofs << name() << ": Encoded size with value "
          << size << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_ENCODE_SIZE

MESSAGE_BEGIN_DECODE_SIZE
{
  ClientCache *clientCache = (ClientCache *) channelCache;

  decodeBuffer.decodeCachedValue(size, 16,
                     clientCache -> renderLengthCache, 5);

  #ifdef DEBUG
  *logofs << name() << ": Decoded value " << size
          << ".\n" << logofs_flush;
  #endif

  size = MESSAGE_OFFSET + (size << 2);

  buffer = writeBuffer -> addMessage(size);

  #ifdef TEST
  *logofs << name() << ": Decoded size with value "
          << size << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_DECODE_SIZE

MESSAGE_BEGIN_ENCODE_MESSAGE
{
  ClientCache *clientCache = (ClientCache *) channelCache;

  encodeBuffer.encodeCachedValue(*(buffer + 4), 8,
                     clientCache -> renderOpCache);

  encodeBuffer.encodeXidValue(GetULONG(buffer + 8, bigEndian),
                     clientCache -> renderSrcPictureCache);

  encodeBuffer.encodeXidValue(GetULONG(buffer + 12, bigEndian),
                     clientCache -> renderDstPictureCache);

  encodeBuffer.encodeCachedValue(GetULONG(buffer + 16, bigEndian), 32,
                     clientCache -> renderFormatCache);

  encodeBuffer.encodeCachedValue(GetULONG(buffer + 20, bigEndian), 29,
                     clientCache -> renderGlyphSetCache);

  encodeBuffer.encodeDiffCachedValue(GetUINT(buffer + 24, bigEndian),
                     clientCache -> renderLastX, 16,
                         clientCache -> renderXCache, 11);

  encodeBuffer.encodeDiffCachedValue(GetUINT(buffer + 26, bigEndian),
                     clientCache -> renderLastY, 16,
                         clientCache -> renderYCache, 11);

  #ifdef TEST
  *logofs << name() << ": Encoded message. Type is "
          << (unsigned int) *(buffer + 1) << " size is "
          << size << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_ENCODE_MESSAGE

MESSAGE_BEGIN_DECODE_MESSAGE
{
  ClientCache *clientCache = (ClientCache *) channelCache;

  unsigned int value;

  *(buffer + 1) = type;

  decodeBuffer.decodeCachedValue(*(buffer + 4), 8,
                     clientCache -> renderOpCache);

  decodeBuffer.decodeXidValue(value,
                     clientCache -> renderSrcPictureCache);

  PutULONG(value, buffer + 8, bigEndian);

  decodeBuffer.decodeXidValue(value,
                     clientCache -> renderDstPictureCache);

  PutULONG(value, buffer + 12, bigEndian);

  decodeBuffer.decodeCachedValue(value, 32,
                     clientCache -> renderFormatCache);

  PutULONG(value, buffer + 16, bigEndian);

  decodeBuffer.decodeCachedValue(value, 29,
                     clientCache -> renderGlyphSetCache);

  PutULONG(value, buffer + 20, bigEndian);

  decodeBuffer.decodeDiffCachedValue(value,
                     clientCache -> renderLastX, 16,
                         clientCache -> renderXCache, 11);

  PutUINT(clientCache -> renderLastX, buffer + 24, bigEndian);

  decodeBuffer.decodeDiffCachedValue(value,
                     clientCache -> renderLastY, 16,
                         clientCache -> renderYCache, 11);

  PutUINT(clientCache -> renderLastY, buffer + 26, bigEndian);

  #ifdef TEST
  *logofs << name() << ": Decoded message. Type is "
          << (unsigned int) type << " size is " << size
          << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_DECODE_MESSAGE

MESSAGE_BEGIN_ENCODE_DATA
{
  if (size > MESSAGE_OFFSET)
  {
    encodeCharData(encodeBuffer, buffer, MESSAGE_OFFSET,
                       size, bigEndian, channelCache);
  }

  #ifdef TEST
  *logofs << name() << ": Encoded " << size - MESSAGE_OFFSET
          << " bytes of text data.\n" << logofs_flush;
  #endif
}
MESSAGE_END_ENCODE_DATA

MESSAGE_BEGIN_DECODE_DATA
{
  if (size > MESSAGE_OFFSET)
  {
    decodeCharData(decodeBuffer, buffer, MESSAGE_OFFSET,
                       size, bigEndian, channelCache);
  }

  #ifdef TEST
  *logofs << name() << ": Decoded " << size - MESSAGE_OFFSET
          << " bytes of data.\n" << logofs_flush;
  #endif
}
MESSAGE_END_DECODE_DATA

MESSAGE_BEGIN_PARSE_IDENTITY
{
  RenderExtensionMessage *renderExtension = (RenderExtensionMessage *) message;

  renderExtension -> data.composite_glyphs.type = *(buffer + 1);
  renderExtension -> data.composite_glyphs.op   = *(buffer + 4);

  renderExtension -> data.composite_glyphs.src_id = GetULONG(buffer + 8,  bigEndian);
  renderExtension -> data.composite_glyphs.dst_id = GetULONG(buffer + 12, bigEndian);

  renderExtension -> data.composite_glyphs.format = GetULONG(buffer + 16, bigEndian);
  renderExtension -> data.composite_glyphs.set_id = GetULONG(buffer + 20, bigEndian);

  renderExtension -> data.composite_glyphs.src_x = GetUINT(buffer + 24, bigEndian);
  renderExtension -> data.composite_glyphs.src_y = GetUINT(buffer + 26, bigEndian);

  //
  // Determine the base size of the glyphs.
  //

  unsigned int base;

  switch (*(buffer + 1))
  {
    case X_RenderCompositeGlyphs32:
    {
      base = 4;

      break;
    }
    case X_RenderCompositeGlyphs16:
    {
      base = 2;

      break;
    }
    default:
    {
      base = 1;

      break;
    }
  }

  //
  // Clean the padding bytes in the data
  // payload.
  //

  unsigned char *next = (unsigned char *) buffer + 28;
  unsigned char *end  = (unsigned char *) buffer + size;

  while (next + 8 < end)
  {
    unsigned char *elt = next;

    next += 8;

    unsigned int len = *elt;

    #ifdef TEST
    *logofs << name() << ": Cleaning " << 3 << " bytes of element "
            << "pad at offset " << elt + 1 - buffer << ".\n"
            << logofs_flush;
    #endif

    CleanData(elt + 1, 3);

    if (len == 0xff)
    {
      #ifdef TEST
      *logofs << name() << ": Got a glyphset change for element "
              << "at offset " << elt - buffer << ".\n"
              << logofs_flush;
      #endif

      next += 4;
    }
    else
    {
      #ifdef TEST
      *logofs << name() << ": Got a string of length " << len
              << " for element at offset " << elt - buffer
              << " with base " << base << ".\n"
              << logofs_flush;
      #endif

      unsigned int bytes = len * base;

      next += bytes;

      if (bytes & 3)
      {
        unsigned int pad = 4 - (bytes & 3);

        if (next + pad <= end)
	{
          #ifdef TEST
          *logofs << name() << ": Cleaning " << pad << " bytes "
                  << "of string pad at offset " << next - buffer
                  << ".\n" << logofs_flush;
          #endif

          CleanData(next, pad);
        }
        //#ifdef TEST
        else
        {
          *logofs << name() << ": WARNING! Not cleaning the string "
                  << "pad with size " << size << " pad " << pad
                  << " and offset " << next - buffer << ".\n"
                  << logofs_flush;
        }
        //#endif

        next += pad;
      }
    }

    #ifdef TEST
    *logofs << name() << ": Next offset is now "
            << next - buffer << ".\n"
            << logofs_flush;
    #endif
  }

  #ifdef TEST
  *logofs << name() << ": Parsed identity. Type is "
          << (unsigned int) renderExtension -> data.composite_glyphs.type
          << " size is " << renderExtension -> size_ << " identity size "
          << renderExtension -> i_size_ << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_PARSE_IDENTITY

MESSAGE_BEGIN_UNPARSE_IDENTITY
{
  RenderExtensionMessage *renderExtension = (RenderExtensionMessage *) message;

  *(buffer + 1) = renderExtension -> data.composite_glyphs.type;
  *(buffer + 4) = renderExtension -> data.composite_glyphs.op;

  PutULONG(renderExtension -> data.composite_glyphs.src_id, buffer + 8,  bigEndian);
  PutULONG(renderExtension -> data.composite_glyphs.dst_id, buffer + 12, bigEndian);

  PutULONG(renderExtension -> data.composite_glyphs.format, buffer + 16, bigEndian);
  PutULONG(renderExtension -> data.composite_glyphs.set_id, buffer + 20, bigEndian);

  PutUINT(renderExtension -> data.composite_glyphs.src_x, buffer + 24, bigEndian);
  PutUINT(renderExtension -> data.composite_glyphs.src_y, buffer + 26, bigEndian);

  #ifdef TEST
  *logofs << name() << ": Unparsed identity. Type is "
          << (unsigned int) renderExtension -> data.composite_glyphs.type
          << " size is " << renderExtension -> size_  << " identity size "
          << renderExtension -> i_size_ <<  ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_UNPARSE_IDENTITY

MESSAGE_BEGIN_IDENTITY_CHECKSUM
{
  //
  // Include minor opcode, size and
  // the composite operator in the
  // identity.
  //

  md5_append(md5_state, buffer + 1, 4);

  //
  // Include the format.
  //

  md5_append(md5_state, buffer + 16, 4);

  //
  // Include the source x and y fields.
  //
/*
FIXME: The source x and y should not be included
       in the checksum.
*/
/*
  md5_append(md5_state, buffer + 24, 4);
*/
}
MESSAGE_END_IDENTITY_CHECKSUM

MESSAGE_BEGIN_ENCODE_UPDATE
{
  RenderExtensionMessage *renderExtension       = (RenderExtensionMessage *) message;
  RenderExtensionMessage *cachedRenderExtension = (RenderExtensionMessage *) cachedMessage;

  ClientCache *clientCache = (ClientCache *) channelCache;

  encodeBuffer.encodeXidValue(renderExtension -> data.composite_glyphs.src_id,
                     clientCache -> renderSrcPictureCache);

  cachedRenderExtension -> data.composite_glyphs.src_id =
              renderExtension -> data.composite_glyphs.src_id;

  encodeBuffer.encodeXidValue(renderExtension -> data.composite_glyphs.dst_id,
                     clientCache -> renderDstPictureCache);

  cachedRenderExtension -> data.composite_glyphs.dst_id =
              renderExtension -> data.composite_glyphs.dst_id;

  encodeBuffer.encodeCachedValue(renderExtension -> data.composite_glyphs.set_id, 29,
                     clientCache -> renderGlyphSetCache);

  cachedRenderExtension -> data.composite_glyphs.set_id =
              renderExtension -> data.composite_glyphs.set_id;

  //
  // Src X and Y.
  //

  //
  // The source x and y coordinates are
  // encoded as differerences in respect
  // to the previous cached value.
  //

  unsigned int value;
  unsigned int previous;

  value    = renderExtension -> data.composite_glyphs.src_x;
  previous = cachedRenderExtension -> data.composite_glyphs.src_x;

  encodeBuffer.encodeDiffCachedValue(value, previous, 16,
                     clientCache -> renderXCache, 11);

  cachedRenderExtension -> data.composite_glyphs.src_x = value;

  value    = renderExtension -> data.composite_glyphs.src_y;
  previous = cachedRenderExtension -> data.composite_glyphs.src_y;

  encodeBuffer.encodeDiffCachedValue(value, previous, 16,
                     clientCache -> renderYCache, 11);

  cachedRenderExtension -> data.composite_glyphs.src_y = value;

  #ifdef TEST
  *logofs << name() << ": Encoded update. Type is "
          << (unsigned int) renderExtension -> data.composite_glyphs.type
          << " size is " << renderExtension -> size_ << ".\n"
          << logofs_flush;
  #endif
}
MESSAGE_END_ENCODE_UPDATE

MESSAGE_BEGIN_DECODE_UPDATE
{
  RenderExtensionMessage *renderExtension = (RenderExtensionMessage *) message;

  ClientCache *clientCache = (ClientCache *) channelCache;

  decodeBuffer.decodeXidValue(renderExtension -> data.composite_glyphs.src_id,
                     clientCache -> renderSrcPictureCache);

  decodeBuffer.decodeXidValue(renderExtension -> data.composite_glyphs.dst_id,
                     clientCache -> renderDstPictureCache);

  decodeBuffer.decodeCachedValue(renderExtension -> data.composite_glyphs.set_id, 29,
                     clientCache -> renderGlyphSetCache);

  //
  // Src X and Y.
  //

  unsigned int value;
  unsigned int previous;

  previous = renderExtension -> data.composite_glyphs.src_x;

  decodeBuffer.decodeDiffCachedValue(value, previous, 16,
                     clientCache -> renderXCache, 11);

  renderExtension -> data.composite_glyphs.src_x = value;

  previous = renderExtension -> data.composite_glyphs.src_y;

  decodeBuffer.decodeDiffCachedValue(value, previous, 16,
                     clientCache -> renderYCache, 11);

  renderExtension -> data.composite_glyphs.src_y = value;

  #ifdef TEST
  *logofs << name() << ": Decoded update. Type is "
          << (unsigned int) renderExtension -> data.composite_glyphs.type
          << " size is " << renderExtension -> size_ << ".\n"
          << logofs_flush;
  #endif
}
MESSAGE_END_DECODE_UPDATE
