#include <dlfcn.h>
#include <npapi.h>
#include <npupp.h>
#include <string.h> //strchr

#include <assert.h>

#include "NetscapePluginFactory.h"
#include "NetscapePlugin.h"

class KWIQBridgeApp;

#if defined(DEBUG)
#include <stdio.h>
#define ERROR(formatAndArgs...) fprintf(stderr, formatAndArgs)
#else
#define ERROR(formatAndArgs...)
#endif


extern "C" {
#ifdef XP_UNIX
NPError 
NPN_GetValue(NPP instance, NPNVariable variable, void *value)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return NPERR_INVALID_PARAM;
    if (!value) return NPERR_INVALID_PARAM;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return NPERR_NO_ERROR;

}
#endif /* XP_UNIX */


void 
NPN_Version(int* plugin_major, int* plugin_minor, int* netscape_major, int* netscape_minor)
{
        g_warning("%s", __PRETTY_FUNCTION__);
    *netscape_major = NP_VERSION_MAJOR;
    *netscape_minor = NP_VERSION_MINOR;
}

NPError	
NPN_GetURLNotify(NPP instance, const char* url, const char* target, void* notifyData)
{    
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return NPERR_INVALID_PARAM;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return NPERR_NO_ERROR;
}

NPError	
NPN_GetURL(NPP instance, const char* url, const char* target)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return NPERR_INVALID_PARAM;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return NPERR_NO_ERROR;
}

NPError	NPN_PostURLNotify(NPP instance, 
			  const char* url,
			  const char* target, 
			  uint32 len,
			  const char* buf, 
			  NPBool file,
			  void* notifyData)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return NPERR_INVALID_PARAM;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return NPERR_NO_ERROR;
}

NPError
NPN_PostURL(NPP instance, 
	    const char* url,
	    const char* target, 
	    uint32 len,
	    const char* buf, 
	    NPBool file)
{
    g_warning("%s", __PRETTY_FUNCTION__);

    if (!instance) return NPERR_INVALID_PARAM;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return NPERR_NO_ERROR;
}

NPError
NPN_RequestRead(NPStream* stream, NPByteRange* rangeList)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!stream) return NPERR_INVALID_PARAM;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(stream->ndata);
    return NPERR_NO_ERROR;
}

NPError
NPN_NewStream(NPP instance, NPMIMEType type, const char* target, NPStream** stream)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return NPERR_INVALID_PARAM;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return NPERR_NO_ERROR;
}

int32 
NPN_Write(NPP instance, NPStream* stream, int32 len, void* buffer)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return len;
    if (!stream) return len;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return len;
}


NPError 
NPN_DestroyStream(NPP instance, NPStream* stream, NPReason reason)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return NPERR_INVALID_PARAM;
    if (!stream) return NPERR_INVALID_PARAM;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return NPERR_NO_ERROR;
}

void 
NPN_Status(NPP instance, const char* message)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    g_warning("%s:  %s", __PRETTY_FUNCTION__, message);
}

const char* 
NPN_UserAgent(NPP instance)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    if (!instance) return NULL;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);
    return "this";
}

void* 
NPN_MemAlloc(uint32 size)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    return new char[size];

}

void 
NPN_MemFree(void* ptr)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    assert(ptr);
    delete [] ((char*)ptr);
}

uint32 
NPN_MemFlush(uint32 size)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    return 0;
}

void 
NPN_ReloadPlugins(NPBool reloadPages)
{
    g_warning("%s", __PRETTY_FUNCTION__);
}

JRIEnv* 
NPN_GetJavaEnv(void)
{
    g_warning("%s", __PRETTY_FUNCTION__);
    return 0;
}

jref 
NPN_GetJavaPeer(NPP instance)
{
    g_warning("%s", __PRETTY_FUNCTION__);

    if (!instance) return (jref)0;

    KWIQBridgeApp *self = static_cast<KWIQBridgeApp*>(instance->ndata);

    return (jref) 0;
}

typedef char* (*NP_GetMIMEDescriptionFunc)(void);
typedef NPError (*NP_InitializeFunc)(NPNetscapeFuncs*, NPPluginFuncs*);
typedef NPError (*NP_ShutdownFunc)(void);
typedef NPError (*NP_GetValueFunc)(void*, unsigned NPPVariable, void*);

}







class NetscapePluginLibrary {
public:
    NetscapePluginLibrary(NPNetscapeFuncs* nsTable, void* dlhandle);
    ~NetscapePluginLibrary();

    NetscapePlugin* createPlugin();

    NP_GetValueFunc getValue;
    NPPluginFuncs pluginFuncs;

private:
    void *handle;
    gchar *mimeType;
    gchar *ext;
    gchar *descr;

    NP_GetMIMEDescriptionFunc getMIMEDescription;
    NP_InitializeFunc initialize;
    NP_ShutdownFunc shutdown;
    friend class NetscapePluginFactory;
};

NetscapePluginLibrary::NetscapePluginLibrary(NPNetscapeFuncs* nsTable, void* dlhandle)
    : handle(dlhandle)
      ,getMIMEDescription(0)
      ,initialize(0)
      ,shutdown(0)
      ,getValue(0)
      ,mimeType(NULL)
      ,ext(NULL)
      ,descr(NULL)
{
    assert(handle);
    assert(nsTable);

    const char* error = NULL;
    int suc = 1;

    initialize = (NP_InitializeFunc) dlsym(handle, "NP_Initialize");    
    suc =  ((error=dlerror())== NULL);

    if (suc) {
	getMIMEDescription = (NP_GetMIMEDescriptionFunc) dlsym(handle, "NP_GetMIMEDescription");
	suc = ((error=dlerror())== NULL);
    }

    if (suc) {
	shutdown = (NP_ShutdownFunc) dlsym(handle, "NP_Shutdown");
	suc =  ((error=dlerror())== NULL);
    }

    if (suc) {
	getValue = (NP_GetValueFunc) dlsym(handle, "NP_GetValue");
	suc =  ((error=dlerror())== NULL);
    }

    if (!suc){    
	ERROR("Function mapping error: %s\n", error);
	return;
    }

    if (!getMIMEDescription) {
	ERROR("Symbol NP_GetMIMEDescription == NULL, while it shouldn't\n");
	suc = 0;
    }
    if (!initialize) { 
	ERROR("Symbol NP_Initialize == NULL, while it shouldn't\n");
	suc = 0;
    }

    if (!suc){
	return;
    }
    
    pluginFuncs.size = sizeof(pluginFuncs);
    initialize(nsTable, &pluginFuncs);

    const char *mimedescr;
    const char *mime_end;
    const char *ext_end;
    mimedescr = getMIMEDescription();
    if (!mimedescr || mimedescr[0] == '\0' ) {
	ERROR("MIME description empty");
	return;
    }

    mime_end = strchr(mimedescr, ':');
    if (mime_end) { 
	mimeType = g_strndup(mimedescr, mime_end - mimedescr);

	ext_end = strchr(mime_end+1, ':');
	if (ext_end) {
	    /* example: "application/x-simple-plugin:smp:Simple LiveConnect Sample Plug-in" */
	    ext = g_strndup(mime_end+1, ext_end - (mime_end+1));

	    if (ext_end[1] !='\0') 
		descr = g_strdup(ext_end+1);
	} else {
	    /* assume example: "application/x-simple-plugin:smp" */
	    ext = g_strdup(mime_end+1);
	}
    } else {
	/* assume the whole mimedescr as mimetype*/
	mimeType = g_strdup(mimedescr);
    }	

}

NetscapePluginLibrary::~NetscapePluginLibrary()
{
    if (mimeType) g_free(mimeType);
    if (ext) g_free(ext);
    if (descr) g_free(descr);

    if (shutdown) 
	shutdown();

    dlclose(handle);    
}

NetscapePlugin* NetscapePluginLibrary::createPlugin()
{
    NetscapePlugin* p = new NetscapePlugin(&pluginFuncs);

    return p;
}


NetscapePluginFactory::NetscapePluginFactory(const gchar* sharedlib)
    :lib(0)
{
    assert(sharedlib);

    nsTable.size = sizeof(nsTable);
    nsTable.version = (NP_VERSION_MAJOR << 8) + (NP_VERSION_MINOR);
    nsTable.geturl = (NPN_GetURLUPP) NPN_GetURL;
    nsTable.posturl = (NPN_PostURLUPP) NPN_PostURL;
    nsTable.requestread = (NPN_RequestReadUPP) NPN_RequestRead;
    nsTable.newstream = (NPN_NewStreamUPP) NPN_NewStream;
    nsTable.write = (NPN_WriteUPP) NPN_Write;
    nsTable.destroystream = (NPN_DestroyStreamUPP) NPN_DestroyStream;
    nsTable.status = (NPN_StatusUPP) NPN_Status;
    nsTable.uagent = (NPN_UserAgentUPP) NPN_UserAgent;
    nsTable.memalloc =     (NPN_MemAllocUPP) NPN_MemAlloc;
    nsTable.memfree = (NPN_MemFreeUPP) NPN_MemFree;
    nsTable.memflush = (NPN_MemFlushUPP) NPN_MemFlush;
    nsTable.reloadplugins = (NPN_ReloadPluginsUPP) NPN_ReloadPlugins;
    nsTable.getJavaEnv = (NPN_GetJavaEnvUPP) NPN_GetJavaEnv;
    nsTable.getJavaPeer = (NPN_GetJavaPeerUPP) NPN_GetJavaPeer;
    nsTable.geturlnotify = (NPN_GetURLNotifyUPP) NPN_GetURLNotify;
    nsTable.posturlnotify = (NPN_PostURLNotifyUPP) NPN_PostURLNotify;
#ifdef XP_UNIX
    nsTable.getvalue = (NPN_GetValueUPP) NPN_GetValue;
#endif /* XP_UNIX */

    void *handle;
    handle = dlopen(sharedlib, RTLD_LAZY);
    if (handle == NULL) {
	ERROR("%s\n", dlerror());	
    } else {
	lib = new NetscapePluginLibrary(&nsTable, handle);
    }
}

NetscapePluginFactory::~NetscapePluginFactory()
{
    delete lib;
}

KWIQPlugin* NetscapePluginFactory::createPlugin(const gchar *mime,gchar**argn, gchar**argv, KWIQBridgeApp* plug)
{
    if (!lib) return 0;

    NetscapePlugin *p = lib->createPlugin();
    p->setParams(argv,argn);
    p->setMimeType(mime);
    p->create(plug);

    return p;
}

const gchar* NetscapePluginFactory::mimeType() const
{
    if (lib)
	return lib->mimeType;

    return 0;
}

extern "C"{
void destroy_key(gpointer data)
{
    assert(data);
    g_free((gchar*) data);
}

void destroy_value(gpointer data)
{
    assert(data);
	
    NetscapePluginFactory* self = static_cast<NetscapePluginFactory*>(data);
    delete self;
}
}

struct HashTableSingle{
    GHashTable* facs;
    HashTableSingle() { 
	facs = g_hash_table_new_full(g_str_hash,
				     g_direct_equal,
				     (GDestroyNotify) destroy_key,
				     (GDestroyNotify) destroy_value);

    }
    ~HashTableSingle() {
	g_hash_table_destroy(facs);
    }
	
};

NetscapePluginFactory& NetscapePluginFactoryS( const gchar* sharedlib)
{
    static HashTableSingle f;

    NetscapePluginFactory* fac = static_cast<NetscapePluginFactory*>(g_hash_table_lookup(f.facs, sharedlib));

    if (!fac) {     
	fac = new NetscapePluginFactory(sharedlib);
	g_hash_table_insert(f.facs, g_strdup(sharedlib), fac);
    }

    return *fac;
}
