#define WNCK_I_KNOW_THIS_IS_UNSTABLE

/* This file is largely copied from the libwnck example code */

#include "config.h"

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <libwnck/libwnck.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>

#include "global.h"

#include "options.h"
#include "choices.h"

char *app_dir = NULL;

static GdkWindow *socket = NULL;	/* NULL => Not an applet */

static WnckScreen *screen = NULL;

static GtkWidget *pager = NULL;

static Option n_rows;

/* Read the contents of this property. g_free() the result. */
static char *read_property(GdkWindow *window, GdkAtom prop,
			   GdkAtom type, gint *out_length)
{
	gint	grab_len = 4096;
	gint	length;
	guchar	*data;

	while (1)
	{
		if (!(gdk_property_get(window, prop, type, 0, grab_len,
				FALSE, NULL, NULL, &length, &data) && data))
			return NULL;	/* Error? */

		if (length >= grab_len)
		{
			/* Didn't get all of it - try again */
			grab_len <<= 1;
			g_free(data);
			continue;
		}

		*out_length = length;

		return data;
	}
}

static char *read_string(GdkWindow *window, GdkAtom prop)
{
	gint  len;
	gchar *data;

	data = read_property(window, prop,
			gdk_atom_intern("STRING", FALSE), &len);
	
	if (!data)
		return NULL;

	data = g_realloc(data, len + 1);
	data[len] = '\0';
	return data;
}

static void position(GtkMenu *menu, gint *x, gint *y, gboolean *push_in,
		     gpointer user_data)
{
	GtkRequisition req;
	int  margin = 2;
	int screen_width, screen_height;
	char *pos = (char *) user_data;
	char *comma;

	*push_in = TRUE;

	gdk_window_get_pointer(NULL, x, y, NULL);

	screen_width = gdk_screen_width();
	screen_height = gdk_screen_height();

	if (pos)
	{
		comma = strchr(pos, ',');
		if (comma)
			margin = atoi(comma + 1);
	}

	gtk_widget_size_request(GTK_WIDGET(menu), &req);

	if (!pos)
	{
		*x -= req.width / 2;
		*y -= 32;
		goto out;
	}
	
	if (pos[0] == 'T')
	{
		*y = margin;
		*x -= req.width / 4;
	}
	else if (pos[0] == 'B')
	{
		*y = screen_height - margin - req.height;
		*x -= req.width / 4;
	}
	else if (pos[0] == 'L')
	{
		*x = margin;
		*y -= 16;
	}
	else
	{
		*x = screen_width - margin - req.width;
		*y -= 16;
	}

	g_free(pos);

out:
	*x = CLAMP(*x, 4, screen_width - 4 - req.width);
	*y = CLAMP(*y, 4, screen_height - 4 - req.height);
}

static void show_help(void)
{
	char *argv[3] = {"rox", NULL, NULL};
	GError *error = NULL;

	argv[1] = g_strconcat(getenv("APP_DIR"), "/Help", NULL);
	g_spawn_async(NULL, argv, NULL, G_SPAWN_SEARCH_PATH,
			NULL, NULL, NULL, &error);
	g_free(argv[2]);

	if (error)
	{
		GtkWidget *box;
		box = gtk_message_dialog_new(NULL, 0, GTK_MESSAGE_ERROR,
					GTK_BUTTONS_OK, "%s", error->message);
		gtk_dialog_run(GTK_DIALOG(box));
		gtk_widget_destroy(box);
		g_error_free(error);
	}
}

static gboolean button_event(GtkWidget *widget,
			     GdkEventButton *event,
			     gpointer user_data)
{
	if (event->button == 3)
	{
		GtkWidget *menu;
		GtkWidget *item;
		GList	*wins;
		gchar   *pos = NULL;

		if (socket)
		{
			pos = read_string(socket,
				gdk_atom_intern("_ROX_PANEL_MENU_POS",
						FALSE));
		}

		wins = wnck_screen_get_windows_stacked(screen);
		menu = wnck_create_window_menu(wins);
		
		item = gtk_menu_item_new();
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_widget_show(item);

		item = gtk_menu_item_new_with_label("Help");
		gtk_signal_connect(GTK_OBJECT(item), "activate",
				GTK_SIGNAL_FUNC(show_help), NULL);
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_widget_show(item);

		item = gtk_menu_item_new_with_label("Options");
		gtk_signal_connect(GTK_OBJECT(item), "activate",
				GTK_SIGNAL_FUNC(options_show), NULL);
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_widget_show(item);

		item = gtk_menu_item_new_with_label("Quit");
		gtk_signal_connect(GTK_OBJECT(item), "activate",
				GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_widget_show(item);

		gtk_menu_popup(GTK_MENU(menu), NULL, NULL,
				position, pos,
				event->button, event->time);
		return 1;
	}

	return 0;
}

static void options_changed(void)
{
	if (n_rows.has_changed)
		wnck_pager_set_n_rows(WNCK_PAGER(pager), n_rows.int_value);
}

int main(int argc, char **argv)
{
	GtkWidget  *toplevel, *frame;

	app_dir = g_strdup(getenv("APP_DIR"));
	if (!app_dir)
		g_error("APP_DIR environment variable was unset!\n"
			"Use the AppRun script to invoke " PROJECT "...\n");

	gtk_init(&argc, &argv);

	choices_init();
	options_init();
	option_add_int(&n_rows, "n_rows", 2);

	option_add_notify(options_changed);

	/* Send errors to stdout. Prevents bugs in OpenOffice flooding the
	 * error stream.
	 */
	dup2(1, 2);

	screen = wnck_screen_get_default();

	/* because the pager doesn't respond to signals at the moment */
	wnck_screen_force_update(screen);

	if (argc == 2)
	{
		gint32 xid;

		xid = atol(argv[1]);
		toplevel = gtk_plug_new(xid);
		gtk_widget_set_size_request(toplevel, 100, 20);
		socket = gdk_window_foreign_new(xid);
	}
	else
	{
		GdkPixbuf *pixbuf;
		gchar *file;

		toplevel = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_stick(GTK_WINDOW(toplevel));
		gtk_window_set_title(GTK_WINDOW(toplevel), "Pager");

		file = g_build_filename(app_dir, ".DirIcon", NULL);
		pixbuf = gdk_pixbuf_new_from_file(file, NULL);
		if (pixbuf)
		{
			gtk_window_set_icon(GTK_WINDOW(toplevel), pixbuf);
			gdk_pixbuf_unref(pixbuf);
		}
		g_free(file);
	}

	g_signal_connect(toplevel, "destroy",
			 G_CALLBACK(gtk_main_quit), NULL);

	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
	gtk_container_add(GTK_CONTAINER(toplevel), frame);  
	
	pager = wnck_pager_new(screen);
	wnck_pager_set_n_rows(WNCK_PAGER(pager), n_rows.int_value);
	gtk_container_add(GTK_CONTAINER(frame), pager);

	g_signal_connect(pager, "button-press-event",
			G_CALLBACK(button_event), NULL);

	gtk_widget_show_all(toplevel);

	gtk_main();

	return 0;
}
