/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of the Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "exceptiondialog.h"

#include <qtopia/qpeapplication.h>


ExceptionDialog::ExceptionDialog( QWidget *parent, const char *name, bool modal, WFlags f )
    : ExceptionDialogBase( parent, name, modal, f ),
    mButton( Cancel )
{
}

ExceptionDialog::Button ExceptionDialog::exec()
{
#ifdef QTOPIA_PHONE
    int ret = QPEApplication::execDialog( this );
#else
    int ret = ExceptionDialogBase::exec();
#endif
    if ( ret )
	return mButton;
    else
	return Cancel;
}

ExceptionDialog::Button ExceptionDialog::result()
{
    return mButton;
}

void ExceptionDialog::buttonClicked( int button )
{
    //if ( button == btnGroup->id( btnCurrent ) ) {
    switch ( button ) {
	case 0:
	    mButton = Current;
	    accept();
	    break;
	case 1:
	    mButton = All;
	    accept();
	    break;
	case 2:
	    mButton = Following;
	    accept();
	    break;
	default:
	    mButton = Cancel;
	    reject();
	    break;
    }
}

