#!/usr/bin/env python
#
import gtk,os,getpass,sys
from xml.dom import minidom, Node

class usbconfig:
	DEF_PAD = 5
	FUNCTION_TYPE="net"
	STORAGE_DEVICE = "/dev/hda1"
	STORAGE_OPTS = ["/dev/hda1","/dev/mmcda1"]	

	if os.name == "nt":
		USB_TYPE_FILE = "C:\\python24\\pdaxrom\\misc\\usbd.ftype"
		USB_STORAGE_TYPE_FILE = "C:\\python24\\pdaxrom\\misc\\usbdstorage.conf"
		USB_NETWORK_CONF_FILE ="C:\\python24\\pdaxrom\\misc\\usbdnet.conf"
		CFG_FILENAME = ".\\usbconfig.cfg"
	else:
		USB_TYPE_FILE = "/etc/hotplug/usbd.ftype"
		USB_STORAGE_TYPE_FILE = "/etc/hotplug/usbdstorage.conf"
		USB_NETWORK_CONF_FILE ="/etc/hotplug/usbdnet.conf"
		CFG_FILENAME = os.environ['HOME'] + "/Choices/usbconfig.cfg"

	def __init__(self):
		if (getpass.getuser().lower() != "root"):
			Warningdialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"You need to be root in order to run this program.")
			Warningdialog.run()
			Warningdialog.destroy()
			sys.exit()
		self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
	        self.window.set_title("USB function")
	        self.window.set_border_width(5)
		self.window.set_position(gtk.WIN_POS_CENTER)
	        self.window.set_resizable(gtk.FALSE)
	        self.window.connect("delete_event", gtk.main_quit)
	        self.window.connect("destroy", gtk.main_quit)

		MainBox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
		self.window.add(MainBox)
		
	        mainframe = gtk.Frame("USB function")
		MainBox.pack_start(mainframe, gtk.TRUE, gtk.TRUE, self.DEF_PAD)
		
		vbox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
		vbox.set_border_width(self.DEF_PAD)
	        mainframe.add(vbox)

	#Serial
	        self.serial_button = gtk.RadioButton(None, "Serial")
	        self.serial_button.connect("toggled", self.change_usbtype, "serial")
		vbox.pack_start(self.serial_button, gtk.FALSE, gtk.TRUE, 0)

	#Network
	        self.network_button = gtk.RadioButton(self.serial_button, "Network")
	        self.network_button.connect("toggled", self.change_usbtype, "net")
	        vbox.pack_start(self.network_button, gtk.FALSE, gtk.TRUE, self.DEF_PAD)
		
		# IP Address		
		hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
		vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, 0)
       
	        self.network_ip = gtk.Entry(0)
	        self.network_ip.set_text("192.168.129.201")
	        self.network_ip.set_size_request(160,30)
		hbox.pack_end(self.network_ip, gtk.FALSE, gtk.TRUE, 0)

	        label = gtk.Label("IP:")
	        hbox.pack_end(label, gtk.FALSE, gtk.TRUE, 0)


		# IP Netmask
		hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
		vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, 0)
       
	        self.network_netmask = gtk.Entry(0)
	        self.network_netmask.set_text("255.255.255.0")
	        self.network_netmask.set_size_request(160,30)
		hbox.pack_end(self.network_netmask, gtk.FALSE, gtk.TRUE, 0)

	        label = gtk.Label("Netmask:")
	        hbox.pack_end(label, gtk.FALSE, gtk.TRUE, 0)

		# IP gateway
		hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
		vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, 0)
       
	        self.network_gw = gtk.Entry(0)
	        self.network_gw.set_size_request(160,30)
		hbox.pack_end(self.network_gw, gtk.FALSE, gtk.TRUE, 0)

	        label = gtk.Label("Gateway:")
	        hbox.pack_end(label, gtk.FALSE, gtk.TRUE, 0)

		# IP DNS
		hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
		vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, 0)
       
	        self.network_dns = gtk.Entry(0)
	        self.network_dns.set_size_request(160,30)
		hbox.pack_end(self.network_dns, gtk.FALSE, gtk.TRUE, 0)

	        label = gtk.Label("DNS:")
	        hbox.pack_end(label, gtk.FALSE, gtk.TRUE, 0)
	#Storage

		hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
		vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        self.storage_button = gtk.RadioButton(self.serial_button, "Storage")
	        self.storage_button.connect("toggled", self.change_usbtype, "storage")
		hbox.pack_start(self.storage_button, gtk.FALSE, gtk.TRUE, 0)
		
		self.storage_type_menu = gtk.combo_box_new_text()
        	self.storage_type_menu.append_text("Compact Flash (CF)")
        	self.storage_type_menu.append_text("Secure Digital (SD)")
	        self.storage_type_menu.connect('changed', self.change_storage_type)
		self.storage_type_menu.set_size_request(180,30)

		hbox.pack_end(self.storage_type_menu, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

	        bbox = gtk.HButtonBox ()
	        MainBox.pack_start(bbox, gtk.FALSE, gtk.FALSE, 0)
	        bbox.set_layout(gtk.BUTTONBOX_END)

	        cancel_button = gtk.Button("Cancel",gtk.STOCK_CANCEL)
	        cancel_button.connect("clicked", gtk.main_quit)
	        bbox.add(cancel_button)

	        okbutton = gtk.Button("Ok",gtk.STOCK_OK)
	        okbutton.connect("clicked", self.close_and_update)
	        bbox.add(okbutton)
	        okbutton.set_flags(gtk.CAN_DEFAULT)
	        okbutton.grab_default()

		self.load_prefs();

		if self.FUNCTION_TYPE == "net":
			self.network_button.set_active(gtk.TRUE)
		elif self.FUNCTION_TYPE == "storage":
			self.storage_button.set_active(gtk.TRUE)
		elif self.FUNCTION_TYPE == "serial":
			self.change_usbtype(None,"serial")
			self.serial_button.set_active(gtk.TRUE)
		
		if (self.STORAGE_DEVICE == "/dev/mmcda1"):
			self.storage_type_menu.set_active(1)
		else:
			self.storage_type_menu.set_active(0)
		self.window.show_all()

	def change_usbtype(self, widget, data=None):
		if (data == "net"):
			self.storage_type_menu.set_sensitive(gtk.FALSE)
			self.network_ip.set_sensitive(gtk.TRUE)
			self.network_netmask.set_sensitive(gtk.TRUE)
			self.network_gw.set_sensitive(gtk.TRUE)
			self.network_dns.set_sensitive(gtk.TRUE)
			self.FUNCTION_TYPE = data
		elif(data == "storage"):
			self.storage_type_menu.set_sensitive(gtk.TRUE)
			self.network_ip.set_sensitive(gtk.FALSE)
			self.network_netmask.set_sensitive(gtk.FALSE)
			self.network_gw.set_sensitive(gtk.FALSE)
			self.network_dns.set_sensitive(gtk.FALSE)
			self.FUNCTION_TYPE = data
		elif(data == "serial"):
			self.network_ip.set_sensitive(gtk.FALSE)
			self.network_netmask.set_sensitive(gtk.FALSE)
			self.network_gw.set_sensitive(gtk.FALSE)
			self.network_dns.set_sensitive(gtk.FALSE)
			self.storage_type_menu.set_sensitive(gtk.FALSE)
			self.FUNCTION_TYPE = data
		return True

	def change_storage_type(self, combobox):
		self.STORAGE_DEVICE = self.STORAGE_OPTS[combobox.get_active()]
		return True

	def close_and_update(self,widget):
		if (self.FUNCTION_TYPE == "net"):
			f=open(self.USB_NETWORK_CONF_FILE, "w")
			writestr = ""
			writestr = writestr + "IP=" + self.network_ip.get_text() + "\n"
			writestr = writestr + "NETMASK=" + self.network_netmask.get_text() + "\n";
			writestr = writestr + "GATEWAY=" + self.network_gw.get_text() + "\n";
			writestr = writestr + "DNS=" + self.network_dns.get_text() + "\n";
			writestr = writestr + "DHCPS=yes\n";
			writestr = writestr + "DHCPC=no\n";
			f.write(writestr)
			f.close()
		elif (self.FUNCTION_TYPE == "storage"):
			f=open(self.USB_STORAGE_TYPE_FILE, "w")
			f.write(self.STORAGE_DEVICE+ "\n")
			f.close()
		f=open(self.USB_TYPE_FILE, "w")
		f.write(self.FUNCTION_TYPE + "\n")
		f.close()
		
		self.save_prefs()
		os.system("/etc/usbcontrol " + self.FUNCTION_TYPE)
		gtk.main_quit()

	def load_prefs(self):
		if os.path.isfile(self.CFG_FILENAME):
			try:
				xmldoc = minidom.parse(self.CFG_FILENAME)
			except:
				return False
			else:
				tags = xmldoc.getElementsByTagName("USBCONFIGSETTINGS");
				for tag in tags:			
					usbtypes = tag.getElementsByTagName("TYPE")
					for usbtype in usbtypes:
						self.FUNCTION_TYPE = usbtype.getAttribute("type")
						
					usbnetworks = tag.getElementsByTagName("USBNETWORK")
					for usbnetwork in usbnetworks:
						self.network_ip.set_text(usbnetwork.getAttribute("ip"))
						self.network_netmask.set_text(usbnetwork.getAttribute("netmask"))
						self.network_gw.set_text(usbnetwork.getAttribute("gateway"))
						self.network_dns.set_text(usbnetwork.getAttribute("dns"))
					
					usbstorages = tag.getElementsByTagName("USBSTORAGE")
					for usbstorage in usbstorages:
						self.STORAGE_DEVICE = usbstorage.getAttribute("USBSTORAGEDEVICE")
				return True
		else:
			return False

	def save_prefs(self,widget=None):
		conf_tree = minidom.Document()
		conf_tree.appendChild(conf_tree.createComment("pdaXrom settings file"))
		root_node = conf_tree.createElement("USBCONFIGSETTINGS")

		node = conf_tree.createElement("TYPE")
		node.setAttribute("type", self.FUNCTION_TYPE)
		root_node.appendChild(node)

		node = conf_tree.createElement("USBNETWORK")
		node.setAttribute("ip", self.network_ip.get_text())
		node.setAttribute("netmask", self.network_netmask.get_text())
		node.setAttribute("gateway", self.network_gw.get_text())
		node.setAttribute("dns", self.network_dns.get_text())
		root_node.appendChild(node)

		node = conf_tree.createElement("USBSTORAGE")
		node.setAttribute("USBSTORAGEDEVICE", self.STORAGE_DEVICE)
		root_node.appendChild(node)

		conf_tree.appendChild(root_node)
		FD = open(self.CFG_FILENAME, "w")
		FD.write(conf_tree.toprettyxml())
		FD.close()

	def main(self):
		gtk.main()

if __name__ == "__main__":
	usbconfig = usbconfig()
	usbconfig.main()
	
