#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <stdio.h>
#include <sys/param.h>

#define USB_TYPE_FILE		"/etc/hotplug/usbd.ftype"
#define USB_STORAGE_TYPE_FILE	"/etc/hotplug/usbdstorage.conf"
#define USB_NETWORK_CONF_FILE	"/etc/hotplug/usbdnet.conf"

#define CF_DEVICE		"/dev/hda1"
#define SD_DEVICE		"/dev/mmcd/disc0/part1"

int curr_func = 0;

void
on_applyButton_released                (GtkButton       *button,
                                        gpointer         user_data)
{
    char cname[MAXPATHLEN];
    FILE *fconf;

    sprintf(cname,"%s/Choices/usbd.conf",g_get_home_dir());
    fconf = fopen(cname, "wb");
    if (fconf) {
	fprintf(fconf, "function %d\n", curr_func);
	fprintf(fconf, "ip %s\n", gtk_entry_get_text(GTK_WIDGET( lookup_widget (GTK_WIDGET (button), "ipEntry"))));
	fprintf(fconf, "gw %s\n", gtk_entry_get_text(GTK_WIDGET( lookup_widget (GTK_WIDGET (button), "gwEntry"))));
	fprintf(fconf, "dns %s\n", gtk_entry_get_text(GTK_WIDGET( lookup_widget (GTK_WIDGET (button), "dnsEntry"))));
	fprintf(fconf, "device %d\n", gtk_combo_box_get_active(GTK_WIDGET( lookup_widget (GTK_WIDGET (button), "diskEntry"))));
	fclose(fconf);
    }

    if (curr_func == 1) {
	fconf = fopen(USB_NETWORK_CONF_FILE, "wb");
	if (fconf) {
	    fprintf(fconf, "IP=%s\n", gtk_entry_get_text(GTK_WIDGET( lookup_widget (GTK_WIDGET (button), "ipEntry"))));
	    fprintf(fconf, "NETMASK=255.255.255.0\n");
	    fprintf(fconf, "GATEWAY=%s\n", gtk_entry_get_text(GTK_WIDGET( lookup_widget (GTK_WIDGET (button), "gwEntry"))));
	    fprintf(fconf, "DNS=%s\n", gtk_entry_get_text(GTK_WIDGET( lookup_widget (GTK_WIDGET (button), "dnsEntry"))));
	    fprintf(fconf, "DHCPS=yes\n");
	    fprintf(fconf, "DHCPC=no\n");
	    fclose(fconf);
	}
    } else if (curr_func == 2) {
	fconf = fopen(USB_STORAGE_TYPE_FILE, "wb");
	if (fconf) {
	    switch( gtk_combo_box_get_active(GTK_WIDGET( lookup_widget (GTK_WIDGET (button), "diskEntry"))) ) {
		case 0:
		    fprintf(fconf, CF_DEVICE "\n");
		    break;
		case 1:
		    fprintf(fconf, SD_DEVICE "\n");
		    break;
		default:
		    fprintf(fconf, CF_DEVICE "\n");
		    break;
	    }
	    fclose(fconf);
	}
    }
    
    fconf = fopen(USB_TYPE_FILE, "wb");
    if (fconf) {
	switch(curr_func) {
	    case 0:
		fprintf(fconf, "serial\n");
		system("/etc/usbcontrol serial");
		break;
	    case 1:
		fprintf(fconf, "net\n");
		system("/etc/usbcontrol net");
		break;
	    case 2:
		fprintf(fconf, "storage\n");
		system("/etc/usbcontrol storage");
		break;
	    default:
		fprintf(fconf, "net\n");
		system("/etc/usbcontrol net");
		break;
	}
	fclose(fconf);
    }
    
    gtk_main_quit();
}

void
setCurFunc				(GtkWidget *widget, int n)
{
    curr_func = n;
    switch (n) {
	case 0:
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "ipEntry")), FALSE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "gwEntry")), FALSE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "dnsEntry")), FALSE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "diskEntry")), FALSE);
	    break;
	case 1:
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "ipEntry")), TRUE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "gwEntry")), TRUE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "dnsEntry")), TRUE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "diskEntry")), FALSE);
	    break;
	case 2:
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "ipEntry")), FALSE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "gwEntry")), FALSE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "dnsEntry")), FALSE);
	    gtk_widget_set_sensitive( GTK_WIDGET( lookup_widget ( widget, "diskEntry")), TRUE);
	    break;
	default:
	    break;
    }
}

void
on_radiobutton1_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    setCurFunc(GTK_WIDGET (togglebutton), 0);
}


void
on_radiobutton2_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    setCurFunc(GTK_WIDGET (togglebutton), 1);
}


void
on_radiobutton3_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    setCurFunc(GTK_WIDGET (togglebutton), 2);
}

