/*
    Name:       const.c
    Purpose:    Builtin constants for wxBasic
    Author:     David Cuny
    Copyright:  (c) 2002 David Cuny <dcuny@lanset.com>
    Licence:    LGPL
*/

/* wrap a constant pointer */
void wCreatePtrConst( char *name, int classIndex, int pointer )
{
    int  handle;

    /* wrap the pointer */
    handle = (int)wAddObject( classIndex, pointer );

    /* create as a normal constant */
    wCreateNumConst( name, handle );
}

/* initialize the builtin constants */
void wInitConsts() {

    /* common */

    wCreateNumConst( "True",   !0 );
    wCreateNumConst( "False",  0 );
    wCreateNumConst( "NULL",   0 );

#ifdef __WXBASIC__
    wCreateStrConst( "WXBASIC_VERSION",                 W_RELEASE );
    wCreateStrConst( "WXBASIC_DATE",                    W_DATEOF );
#endif


#ifdef __WXWIN__

    /* string constants */
    wCreateStrConst( "wxALL_FILES_PATTERN",             wxALL_FILES_PATTERN );
    wCreateStrConst( "wxALL_FILES",                     wxALL_FILES );

    /* enums from DEFS.H */

    wCreateNumConst( "wxUNKNOWN_PLATFORM",              wxUNKNOWN_PLATFORM );
    wCreateNumConst( "wxCURSES",                        wxCURSES );
    wCreateNumConst( "wxXVIEW_X",                       wxXVIEW_X );
    wCreateNumConst( "wxMOTIF_X",                       wxMOTIF_X );
    wCreateNumConst( "wxCOSE_X",                        wxCOSE_X );
    wCreateNumConst( "wxNEXTSTEP",                      wxNEXTSTEP );
    wCreateNumConst( "wxBEOS",                          wxBEOS );
    wCreateNumConst( "wxGTK",                           wxGTK );
    wCreateNumConst( "wxGTK_WIN32",                     wxGTK_WIN32 );
    wCreateNumConst( "wxGTK_OS2",                       wxGTK_OS2 );
    wCreateNumConst( "wxGTK_BEOS",                      wxGTK_BEOS );
    wCreateNumConst( "wxGEOS",                          wxGEOS );
    wCreateNumConst( "wxOS2_PM",                        wxOS2_PM );
    wCreateNumConst( "wxWINDOWS",                       wxWINDOWS );
    wCreateNumConst( "wxPENWINDOWS",                    wxPENWINDOWS );
    wCreateNumConst( "wxWINDOWS_NT",                    wxWINDOWS_NT );
    wCreateNumConst( "wxWIN32S",                        wxWIN32S );
    wCreateNumConst( "wxWIN95",                         wxWIN95 );
    wCreateNumConst( "wxWIN386",                        wxWIN386 );
    wCreateNumConst( "wxMGL_UNIX",                      wxMGL_UNIX );
    wCreateNumConst( "wxMGL_X",                         wxMGL_X );
    wCreateNumConst( "wxMGL_WIN32",                     wxMGL_WIN32 );
    wCreateNumConst( "wxMGL_OS2",                       wxMGL_OS2 );
    wCreateNumConst( "wxWINDOWS_OS2",                   wxWINDOWS_OS2 );
    wCreateNumConst( "wxUNIX",                          wxUNIX );
    wCreateNumConst( "wxCENTRE",                        wxCENTRE );
    wCreateNumConst( "wxCENTER",                        wxCENTER );
    wCreateNumConst( "wxHORIZONTAL",                    wxHORIZONTAL );
    wCreateNumConst( "wxVERTICAL",                      wxVERTICAL );
    wCreateNumConst( "wxBOTH",                          wxBOTH );
    wCreateNumConst( "wxLEFT",                          wxLEFT );
    wCreateNumConst( "wxRIGHT",                         wxRIGHT );
    wCreateNumConst( "wxUP",                            wxUP );
    wCreateNumConst( "wxDOWN",                          wxDOWN );
    wCreateNumConst( "wxTOP",                           wxTOP );
    wCreateNumConst( "wxBOTTOM",                        wxBOTTOM );
    wCreateNumConst( "wxNORTH",                         wxNORTH );
    wCreateNumConst( "wxSOUTH",                         wxSOUTH );
    wCreateNumConst( "wxWEST",                          wxWEST );
    wCreateNumConst( "wxEAST",                          wxEAST );
    wCreateNumConst( "wxALL",                           wxALL );
    wCreateNumConst( "wxALIGN_NOT",                     wxALIGN_NOT );
    wCreateNumConst( "wxALIGN_CENTER_HORIZONTAL",       wxALIGN_CENTER_HORIZONTAL );
    wCreateNumConst( "wxALIGN_CENTRE_HORIZONTAL",       wxALIGN_CENTRE_HORIZONTAL );
    wCreateNumConst( "wxALIGN_LEFT",                    wxALIGN_LEFT );
    wCreateNumConst( "wxALIGN_TOP",                     wxALIGN_TOP );
    wCreateNumConst( "wxALIGN_RIGHT",                   wxALIGN_RIGHT );
    wCreateNumConst( "wxALIGN_BOTTOM",                  wxALIGN_BOTTOM );
    wCreateNumConst( "wxALIGN_CENTER_VERTICAL",         wxALIGN_CENTER_VERTICAL );
    wCreateNumConst( "wxALIGN_CENTRE_VERTICAL",         wxALIGN_CENTRE_VERTICAL );
    wCreateNumConst( "wxALIGN_CENTER",                  wxALIGN_CENTER );
    wCreateNumConst( "wxALIGN_CENTRE",                  wxALIGN_CENTRE );
    wCreateNumConst( "wxSTRETCH_NOT",                   wxSTRETCH_NOT );
    wCreateNumConst( "wxSHRINK",                        wxSHRINK );
    wCreateNumConst( "wxGROW",                          wxGROW );
    wCreateNumConst( "wxEXPAND",                        wxEXPAND );
    wCreateNumConst( "wxSHAPED",                        wxSHAPED );
    wCreateNumConst( "wxADJUST_MINSIZE",                wxADJUST_MINSIZE );
    wCreateNumConst( "wxDEFAULT",                       wxDEFAULT );
    wCreateNumConst( "wxDECORATIVE",                    wxDECORATIVE );
    wCreateNumConst( "wxROMAN",                         wxROMAN );
    wCreateNumConst( "wxSCRIPT",                        wxSCRIPT );
    wCreateNumConst( "wxSWISS",                         wxSWISS );
    wCreateNumConst( "wxMODERN",                        wxMODERN );
    wCreateNumConst( "wxTELETYPE",                      wxTELETYPE );
    wCreateNumConst( "wxVARIABLE",                      wxVARIABLE );
    wCreateNumConst( "wxFIXED",                         wxFIXED );
    wCreateNumConst( "wxNORMAL",                        wxNORMAL );
    wCreateNumConst( "wxLIGHT",                         wxLIGHT );
    wCreateNumConst( "wxBOLD",                          wxBOLD );
    wCreateNumConst( "wxITALIC",                        wxITALIC );
    wCreateNumConst( "wxSLANT",                         wxSLANT );
    wCreateNumConst( "wxSOLID",                         wxSOLID );
    wCreateNumConst( "wxDOT",                           wxDOT );
    wCreateNumConst( "wxLONG_DASH",                     wxLONG_DASH );
    wCreateNumConst( "wxSHORT_DASH",                    wxSHORT_DASH );
    wCreateNumConst( "wxDOT_DASH",                      wxDOT_DASH );
    wCreateNumConst( "wxUSER_DASH",                     wxUSER_DASH );
    wCreateNumConst( "wxTRANSPARENT",                   wxTRANSPARENT );
    wCreateNumConst( "wxSTIPPLE",                       wxSTIPPLE );
    wCreateNumConst( "wxBDIAGONAL_HATCH",               wxBDIAGONAL_HATCH );
    wCreateNumConst( "wxCROSSDIAG_HATCH",               wxCROSSDIAG_HATCH );
    wCreateNumConst( "wxFDIAGONAL_HATCH",               wxFDIAGONAL_HATCH );
    wCreateNumConst( "wxCROSS_HATCH",                   wxCROSS_HATCH );
    wCreateNumConst( "wxHORIZONTAL_HATCH",              wxHORIZONTAL_HATCH );
    wCreateNumConst( "wxVERTICAL_HATCH",                wxVERTICAL_HATCH );
    wCreateNumConst( "wxJOIN_BEVEL",                    wxJOIN_BEVEL );
    wCreateNumConst( "wxJOIN_MITER",                    wxJOIN_MITER );
    wCreateNumConst( "wxJOIN_ROUND",                    wxJOIN_ROUND );
    wCreateNumConst( "wxCAP_ROUND",                     wxCAP_ROUND );
    wCreateNumConst( "wxCAP_PROJECTING",                wxCAP_PROJECTING );
    wCreateNumConst( "wxCAP_BUTT",                      wxCAP_BUTT );
    wCreateNumConst( "wxCLEAR",                         wxCLEAR );
    wCreateNumConst( "wxXOR",                           wxXOR );
    wCreateNumConst( "wxINVERT",                        wxINVERT );
    wCreateNumConst( "wxOR_REVERSE",                    wxOR_REVERSE );
    wCreateNumConst( "wxAND_REVERSE",                   wxAND_REVERSE );
    wCreateNumConst( "wxCOPY",                          wxCOPY );
    wCreateNumConst( "wxAND",                           wxAND );
    wCreateNumConst( "wxAND_INVERT",                    wxAND_INVERT );
    wCreateNumConst( "wxNO_OP",                         wxNO_OP );
    wCreateNumConst( "wxNOR",                           wxNOR );
    wCreateNumConst( "wxEQUIV",                         wxEQUIV );
    wCreateNumConst( "wxSRC_INVERT",                    wxSRC_INVERT );
    wCreateNumConst( "wxOR_INVERT",                     wxOR_INVERT );
    wCreateNumConst( "wxNAND",                          wxNAND );
    wCreateNumConst( "wxOR",                            wxOR );
    wCreateNumConst( "wxSET",                           wxSET );
    wCreateNumConst( "wxDF_INVALID",                    wxDF_INVALID );
    wCreateNumConst( "wxDF_TEXT",                       wxDF_TEXT );
    wCreateNumConst( "wxDF_BITMAP",                     wxDF_BITMAP );
    wCreateNumConst( "wxDF_METAFILE",                   wxDF_METAFILE );
    wCreateNumConst( "wxDF_SYLK",                       wxDF_SYLK );
    wCreateNumConst( "wxDF_DIF",                        wxDF_DIF );
    wCreateNumConst( "wxDF_TIFF",                       wxDF_TIFF );
    wCreateNumConst( "wxDF_OEMTEXT",                    wxDF_OEMTEXT );
    wCreateNumConst( "wxDF_DIB",                        wxDF_DIB );
    wCreateNumConst( "wxDF_PALETTE",                    wxDF_PALETTE );
    wCreateNumConst( "wxDF_PENDATA",                    wxDF_PENDATA );
    wCreateNumConst( "wxDF_RIFF",                       wxDF_RIFF );
    wCreateNumConst( "wxDF_WAVE",                       wxDF_WAVE );
    wCreateNumConst( "wxDF_UNICODETEXT",                wxDF_UNICODETEXT );
    wCreateNumConst( "wxDF_ENHMETAFILE",                wxDF_ENHMETAFILE );
    wCreateNumConst( "wxDF_FILENAME",                   wxDF_FILENAME );
    wCreateNumConst( "wxDF_LOCALE",                     wxDF_LOCALE );
    wCreateNumConst( "wxDF_PRIVATE",                    wxDF_PRIVATE );
    wCreateNumConst( "wxDF_MAX",                        wxDF_MAX );
    wCreateNumConst( "WXK_BACK",                        WXK_BACK );
    wCreateNumConst( "WXK_TAB",                         WXK_TAB );
    wCreateNumConst( "WXK_RETURN",                      WXK_RETURN );
    wCreateNumConst( "WXK_ESCAPE",                      WXK_ESCAPE );
    wCreateNumConst( "WXK_SPACE",                       WXK_SPACE );
    wCreateNumConst( "WXK_DELETE",                      WXK_DELETE );
    wCreateNumConst( "WXK_START",                       WXK_START );
    wCreateNumConst( "WXK_LBUTTON",                     WXK_LBUTTON );
    wCreateNumConst( "WXK_RBUTTON",                     WXK_RBUTTON );
    wCreateNumConst( "WXK_CANCEL",                      WXK_CANCEL );
    wCreateNumConst( "WXK_MBUTTON",                     WXK_MBUTTON );
    wCreateNumConst( "WXK_CLEAR",                       WXK_CLEAR );
    wCreateNumConst( "WXK_SHIFT",                       WXK_SHIFT );
    wCreateNumConst( "WXK_ALT",                         WXK_ALT );
    wCreateNumConst( "WXK_CONTROL",                     WXK_CONTROL );
    wCreateNumConst( "WXK_MENU",                        WXK_MENU );
    wCreateNumConst( "WXK_PAUSE",                       WXK_PAUSE );
    wCreateNumConst( "WXK_CAPITAL",                     WXK_CAPITAL );
    wCreateNumConst( "WXK_PRIOR",                       WXK_PRIOR );
    wCreateNumConst( "WXK_NEXT",                        WXK_NEXT );
    wCreateNumConst( "WXK_END",                         WXK_END );
    wCreateNumConst( "WXK_HOME",                        WXK_HOME );
    wCreateNumConst( "WXK_LEFT",                        WXK_LEFT );
    wCreateNumConst( "WXK_UP",                          WXK_UP );
    wCreateNumConst( "WXK_RIGHT",                       WXK_RIGHT );
    wCreateNumConst( "WXK_DOWN",                        WXK_DOWN );
    wCreateNumConst( "WXK_SELECT",                      WXK_SELECT );
    wCreateNumConst( "WXK_PRINT",                       WXK_PRINT );
    wCreateNumConst( "WXK_EXECUTE",                     WXK_EXECUTE );
    wCreateNumConst( "WXK_SNAPSHOT",                    WXK_SNAPSHOT );
    wCreateNumConst( "WXK_INSERT",                      WXK_INSERT );
    wCreateNumConst( "WXK_HELP",                        WXK_HELP );
    wCreateNumConst( "WXK_NUMPAD0",                     WXK_NUMPAD0 );
    wCreateNumConst( "WXK_NUMPAD1",                     WXK_NUMPAD1 );
    wCreateNumConst( "WXK_NUMPAD2",                     WXK_NUMPAD2 );
    wCreateNumConst( "WXK_NUMPAD3",                     WXK_NUMPAD3 );
    wCreateNumConst( "WXK_NUMPAD4",                     WXK_NUMPAD4 );
    wCreateNumConst( "WXK_NUMPAD5",                     WXK_NUMPAD5 );
    wCreateNumConst( "WXK_NUMPAD6",                     WXK_NUMPAD6 );
    wCreateNumConst( "WXK_NUMPAD7",                     WXK_NUMPAD7 );
    wCreateNumConst( "WXK_NUMPAD8",                     WXK_NUMPAD8 );
    wCreateNumConst( "WXK_NUMPAD9",                     WXK_NUMPAD9 );
    wCreateNumConst( "WXK_MULTIPLY",                    WXK_MULTIPLY );
    wCreateNumConst( "WXK_ADD",                         WXK_ADD );
    wCreateNumConst( "WXK_SEPARATOR",                   WXK_SEPARATOR );
    wCreateNumConst( "WXK_SUBTRACT",                    WXK_SUBTRACT );
    wCreateNumConst( "WXK_DECIMAL",                     WXK_DECIMAL );
    wCreateNumConst( "WXK_DIVIDE",                      WXK_DIVIDE );
    wCreateNumConst( "WXK_F1",                          WXK_F1 );
    wCreateNumConst( "WXK_F2",                          WXK_F2 );
    wCreateNumConst( "WXK_F3",                          WXK_F3 );
    wCreateNumConst( "WXK_F4",                          WXK_F4 );
    wCreateNumConst( "WXK_F5",                          WXK_F5 );
    wCreateNumConst( "WXK_F6",                          WXK_F6 );
    wCreateNumConst( "WXK_F7",                          WXK_F7 );
    wCreateNumConst( "WXK_F8",                          WXK_F8 );
    wCreateNumConst( "WXK_F9",                          WXK_F9 );
    wCreateNumConst( "WXK_F10",                         WXK_F10 );
    wCreateNumConst( "WXK_F11",                         WXK_F11 );
    wCreateNumConst( "WXK_F12",                         WXK_F12 );
    wCreateNumConst( "WXK_F13",                         WXK_F13 );
    wCreateNumConst( "WXK_F14",                         WXK_F14 );
    wCreateNumConst( "WXK_F15",                         WXK_F15 );
    wCreateNumConst( "WXK_F16",                         WXK_F16 );
    wCreateNumConst( "WXK_F17",                         WXK_F17 );
    wCreateNumConst( "WXK_F18",                         WXK_F18 );
    wCreateNumConst( "WXK_F19",                         WXK_F19 );
    wCreateNumConst( "WXK_F20",                         WXK_F20 );
    wCreateNumConst( "WXK_F21",                         WXK_F21 );
    wCreateNumConst( "WXK_F22",                         WXK_F22 );
    wCreateNumConst( "WXK_F23",                         WXK_F23 );
    wCreateNumConst( "WXK_F24",                         WXK_F24 );
    wCreateNumConst( "WXK_NUMLOCK",                     WXK_NUMLOCK );
    wCreateNumConst( "WXK_SCROLL",                      WXK_SCROLL );
    wCreateNumConst( "WXK_PAGEUP",                      WXK_PAGEUP );
    wCreateNumConst( "WXK_PAGEDOWN",                    WXK_PAGEDOWN );
    wCreateNumConst( "WXK_NUMPAD_SPACE",                WXK_NUMPAD_SPACE );
    wCreateNumConst( "WXK_NUMPAD_TAB",                  WXK_NUMPAD_TAB );
    wCreateNumConst( "WXK_NUMPAD_ENTER",                WXK_NUMPAD_ENTER );
    wCreateNumConst( "WXK_NUMPAD_F1",                   WXK_NUMPAD_F1 );
    wCreateNumConst( "WXK_NUMPAD_F2",                   WXK_NUMPAD_F2 );
    wCreateNumConst( "WXK_NUMPAD_F3",                   WXK_NUMPAD_F3 );
    wCreateNumConst( "WXK_NUMPAD_F4",                   WXK_NUMPAD_F4 );
    wCreateNumConst( "WXK_NUMPAD_HOME",                 WXK_NUMPAD_HOME );
    wCreateNumConst( "WXK_NUMPAD_LEFT",                 WXK_NUMPAD_LEFT );
    wCreateNumConst( "WXK_NUMPAD_UP",                   WXK_NUMPAD_UP );
    wCreateNumConst( "WXK_NUMPAD_RIGHT",                WXK_NUMPAD_RIGHT );
    wCreateNumConst( "WXK_NUMPAD_DOWN",                 WXK_NUMPAD_DOWN );
    wCreateNumConst( "WXK_NUMPAD_PRIOR",                WXK_NUMPAD_PRIOR );
    wCreateNumConst( "WXK_NUMPAD_PAGEUP",               WXK_NUMPAD_PAGEUP );
    wCreateNumConst( "WXK_NUMPAD_NEXT",                 WXK_NUMPAD_NEXT );
    wCreateNumConst( "WXK_NUMPAD_PAGEDOWN",             WXK_NUMPAD_PAGEDOWN );
    wCreateNumConst( "WXK_NUMPAD_END",                  WXK_NUMPAD_END );
    wCreateNumConst( "WXK_NUMPAD_BEGIN",                WXK_NUMPAD_BEGIN );
    wCreateNumConst( "WXK_NUMPAD_INSERT",               WXK_NUMPAD_INSERT );
    wCreateNumConst( "WXK_NUMPAD_DELETE",               WXK_NUMPAD_DELETE );
    wCreateNumConst( "WXK_NUMPAD_EQUAL",                WXK_NUMPAD_EQUAL );
    wCreateNumConst( "WXK_NUMPAD_MULTIPLY",             WXK_NUMPAD_MULTIPLY );
    wCreateNumConst( "WXK_NUMPAD_ADD",                  WXK_NUMPAD_ADD );
    wCreateNumConst( "WXK_NUMPAD_SEPARATOR",            WXK_NUMPAD_SEPARATOR );
    wCreateNumConst( "WXK_NUMPAD_SUBTRACT",             WXK_NUMPAD_SUBTRACT );
    wCreateNumConst( "WXK_NUMPAD_DECIMAL",              WXK_NUMPAD_DECIMAL );
    wCreateNumConst( "WXK_NUMPAD_DIVIDE",               WXK_NUMPAD_DIVIDE );
    wCreateNumConst( "wxPAPER_NONE",                    wxPAPER_NONE );
    wCreateNumConst( "wxPAPER_LETTER",                  wxPAPER_LETTER );
    wCreateNumConst( "wxPAPER_LEGAL",                   wxPAPER_LEGAL );
    wCreateNumConst( "wxPAPER_A4",                      wxPAPER_A4 );
    wCreateNumConst( "wxPAPER_CSHEET",                  wxPAPER_CSHEET );
    wCreateNumConst( "wxPAPER_DSHEET",                  wxPAPER_DSHEET );
    wCreateNumConst( "wxPAPER_ESHEET",                  wxPAPER_ESHEET );
    wCreateNumConst( "wxPAPER_LETTERSMALL",             wxPAPER_LETTERSMALL );
    wCreateNumConst( "wxPAPER_TABLOID",                 wxPAPER_TABLOID );
    wCreateNumConst( "wxPAPER_LEDGER",                  wxPAPER_LEDGER );
    wCreateNumConst( "wxPAPER_STATEMENT",               wxPAPER_STATEMENT );
    wCreateNumConst( "wxPAPER_EXECUTIVE",               wxPAPER_EXECUTIVE );
    wCreateNumConst( "wxPAPER_A3",                      wxPAPER_A3 );
    wCreateNumConst( "wxPAPER_A4SMALL",                 wxPAPER_A4SMALL );
    wCreateNumConst( "wxPAPER_A5",                      wxPAPER_A5 );
    wCreateNumConst( "wxPAPER_B4",                      wxPAPER_B4 );
    wCreateNumConst( "wxPAPER_B5",                      wxPAPER_B5 );
    wCreateNumConst( "wxPAPER_FOLIO",                   wxPAPER_FOLIO );
    wCreateNumConst( "wxPAPER_QUARTO",                  wxPAPER_QUARTO );
    wCreateNumConst( "wxPAPER_10X14",                   wxPAPER_10X14 );
    wCreateNumConst( "wxPAPER_11X17",                   wxPAPER_11X17 );
    wCreateNumConst( "wxPAPER_NOTE",                    wxPAPER_NOTE );
    wCreateNumConst( "wxPAPER_ENV_9",                   wxPAPER_ENV_9 );
    wCreateNumConst( "wxPAPER_ENV_10",                  wxPAPER_ENV_10 );
    wCreateNumConst( "wxPAPER_ENV_11",                  wxPAPER_ENV_11 );
    wCreateNumConst( "wxPAPER_ENV_12",                  wxPAPER_ENV_12 );
    wCreateNumConst( "wxPAPER_ENV_14",                  wxPAPER_ENV_14 );
    wCreateNumConst( "wxPAPER_ENV_DL",                  wxPAPER_ENV_DL );
    wCreateNumConst( "wxPAPER_ENV_C5",                  wxPAPER_ENV_C5 );
    wCreateNumConst( "wxPAPER_ENV_C3",                  wxPAPER_ENV_C3 );
    wCreateNumConst( "wxPAPER_ENV_C4",                  wxPAPER_ENV_C4 );
    wCreateNumConst( "wxPAPER_ENV_C6",                  wxPAPER_ENV_C6 );
    wCreateNumConst( "wxPAPER_ENV_C65",                 wxPAPER_ENV_C65 );
    wCreateNumConst( "wxPAPER_ENV_B4",                  wxPAPER_ENV_B4 );
    wCreateNumConst( "wxPAPER_ENV_B5",                  wxPAPER_ENV_B5 );
    wCreateNumConst( "wxPAPER_ENV_B6",                  wxPAPER_ENV_B6 );
    wCreateNumConst( "wxPAPER_ENV_ITALY",               wxPAPER_ENV_ITALY );
    wCreateNumConst( "wxPAPER_ENV_MONARCH",             wxPAPER_ENV_MONARCH );
    wCreateNumConst( "wxPAPER_ENV_PERSONAL",            wxPAPER_ENV_PERSONAL );
    wCreateNumConst( "wxPAPER_FANFOLD_US",              wxPAPER_FANFOLD_US );
    wCreateNumConst( "wxPAPER_FANFOLD_STD_GERMAN",      wxPAPER_FANFOLD_STD_GERMAN );
    wCreateNumConst( "wxPAPER_FANFOLD_LGL_GERMAN",      wxPAPER_FANFOLD_LGL_GERMAN );
    wCreateNumConst( "wxPAPER_ISO_B4",                  wxPAPER_ISO_B4 );
    wCreateNumConst( "wxPAPER_JAPANESE_POSTCARD",       wxPAPER_JAPANESE_POSTCARD );
    wCreateNumConst( "wxPAPER_9X11",                    wxPAPER_9X11 );
    wCreateNumConst( "wxPAPER_10X11",                   wxPAPER_10X11 );
    wCreateNumConst( "wxPAPER_15X11",                   wxPAPER_15X11 );
    wCreateNumConst( "wxPAPER_ENV_INVITE",              wxPAPER_ENV_INVITE );
    wCreateNumConst( "wxPAPER_LETTER_EXTRA",            wxPAPER_LETTER_EXTRA );
    wCreateNumConst( "wxPAPER_LEGAL_EXTRA",             wxPAPER_LEGAL_EXTRA );
    wCreateNumConst( "wxPAPER_TABLOID_EXTRA",           wxPAPER_TABLOID_EXTRA );
    wCreateNumConst( "wxPAPER_A4_EXTRA",                wxPAPER_A4_EXTRA );
    wCreateNumConst( "wxPAPER_LETTER_TRANSVERSE",       wxPAPER_LETTER_TRANSVERSE );
    wCreateNumConst( "wxPAPER_A4_TRANSVERSE",           wxPAPER_A4_TRANSVERSE );
    wCreateNumConst( "wxPAPER_LETTER_EXTRA_TRANSVERSE", wxPAPER_LETTER_EXTRA_TRANSVERSE );
    wCreateNumConst( "wxPAPER_A_PLUS",                  wxPAPER_A_PLUS );
    wCreateNumConst( "wxPAPER_B_PLUS",                  wxPAPER_B_PLUS );
    wCreateNumConst( "wxPAPER_LETTER_PLUS",             wxPAPER_LETTER_PLUS );
    wCreateNumConst( "wxPAPER_A4_PLUS",                 wxPAPER_A4_PLUS );
    wCreateNumConst( "wxPAPER_A5_TRANSVERSE",           wxPAPER_A5_TRANSVERSE );
    wCreateNumConst( "wxPAPER_B5_TRANSVERSE",           wxPAPER_B5_TRANSVERSE );
    wCreateNumConst( "wxPAPER_A3_EXTRA",                wxPAPER_A3_EXTRA );
    wCreateNumConst( "wxPAPER_A5_EXTRA",                wxPAPER_A5_EXTRA );
    wCreateNumConst( "wxPAPER_B5_EXTRA",                wxPAPER_B5_EXTRA );
    wCreateNumConst( "wxPAPER_A2",                      wxPAPER_A2 );
    wCreateNumConst( "wxPAPER_A3_TRANSVERSE",           wxPAPER_A3_TRANSVERSE );
    wCreateNumConst( "wxPAPER_A3_EXTRA_TRANSVERSE",     wxPAPER_A3_EXTRA_TRANSVERSE );
    wCreateNumConst( "wxDUPLEX_SIMPLEX",                wxDUPLEX_SIMPLEX );
    wCreateNumConst( "wxDUPLEX_HORIZONTAL",             wxDUPLEX_HORIZONTAL );
    wCreateNumConst( "wxDUPLEX_VERTICAL",               wxDUPLEX_VERTICAL );
    wCreateNumConst( "wxPRINT_MODE_NONE",               wxPRINT_MODE_NONE );
    wCreateNumConst( "wxPRINT_MODE_PREVIEW",            wxPRINT_MODE_PREVIEW );
    wCreateNumConst( "wxPRINT_MODE_FILE",               wxPRINT_MODE_FILE );
    wCreateNumConst( "wxPRINT_MODE_PRINTER",            wxPRINT_MODE_PRINTER );


    /* #defines from DEFS.H */

    wCreateNumConst( "wxBIG_ENDIAN",                    wxBIG_ENDIAN );
    wCreateNumConst( "wxLITTLE_ENDIAN",                 wxLITTLE_ENDIAN );
    wCreateNumConst( "wxPDP_ENDIAN",                    wxPDP_ENDIAN );
    wCreateNumConst( "wxBYTE_ORDER",                    wxBYTE_ORDER );
    wCreateNumConst( "wxCENTER_FRAME",                  wxCENTER_FRAME );
    wCreateNumConst( "wxCENTRE_ON_SCREEN",              wxCENTRE_ON_SCREEN );
    wCreateNumConst( "wxCENTER_ON_SCREEN",              wxCENTER_ON_SCREEN );
    wCreateNumConst( "wxVSCROLL",                       wxVSCROLL );
    wCreateNumConst( "wxHSCROLL",                       wxHSCROLL );
    wCreateNumConst( "wxCAPTION",                       wxCAPTION );
    wCreateNumConst( "wxDOUBLE_BORDER",                 wxDOUBLE_BORDER );
    wCreateNumConst( "wxSUNKEN_BORDER",                 wxSUNKEN_BORDER );
    wCreateNumConst( "wxRAISED_BORDER",                 wxRAISED_BORDER );
    wCreateNumConst( "wxBORDER",                        wxBORDER );
    wCreateNumConst( "wxSIMPLE_BORDER",                 wxSIMPLE_BORDER );
    wCreateNumConst( "wxSTATIC_BORDER",                 wxSTATIC_BORDER );
    wCreateNumConst( "wxTRANSPARENT_WINDOW",            wxTRANSPARENT_WINDOW );
    wCreateNumConst( "wxNO_BORDER",                     wxNO_BORDER );
    wCreateNumConst( "wxUSER_COLOURS",                  wxUSER_COLOURS );
    wCreateNumConst( "wxNO_3D",                         wxNO_3D );
    wCreateNumConst( "wxCLIP_CHILDREN",                 wxCLIP_CHILDREN );
    wCreateNumConst( "wxCLIP_SIBLINGS",                 wxCLIP_SIBLINGS );
    wCreateNumConst( "wxTAB_TRAVERSAL",                 wxTAB_TRAVERSAL );
    wCreateNumConst( "wxWANTS_CHARS",                   wxWANTS_CHARS );
    wCreateNumConst( "wxRETAINED",                      wxRETAINED );
    wCreateNumConst( "wxBACKINGSTORE",                  wxBACKINGSTORE );
    wCreateNumConst( "wxNO_FULL_REPAINT_ON_RESIZE",     wxNO_FULL_REPAINT_ON_RESIZE );
    wCreateNumConst( "wxWS_EX_VALIDATE_RECURSIVELY",    wxWS_EX_VALIDATE_RECURSIVELY );
    wCreateNumConst( "wxSTAY_ON_TOP",                   wxSTAY_ON_TOP );
    wCreateNumConst( "wxICONIZE",                       wxICONIZE );
    wCreateNumConst( "wxMINIMIZE",                      wxMINIMIZE );
    wCreateNumConst( "wxMAXIMIZE",                      wxMAXIMIZE );
    wCreateNumConst( "wxSYSTEM_MENU",                   wxSYSTEM_MENU );
    wCreateNumConst( "wxMINIMIZE_BOX",                  wxMINIMIZE_BOX );
    wCreateNumConst( "wxMAXIMIZE_BOX",                  wxMAXIMIZE_BOX );
    wCreateNumConst( "wxTINY_CAPTION_HORIZ",            wxTINY_CAPTION_HORIZ );
    wCreateNumConst( "wxTINY_CAPTION_VERT",             wxTINY_CAPTION_VERT );
    wCreateNumConst( "wxRESIZE_BORDER",                 wxRESIZE_BORDER );
    wCreateNumConst( "wxDIALOG_NO_PARENT",              wxDIALOG_NO_PARENT );
    wCreateNumConst( "wxFRAME_NO_TASKBAR",              wxFRAME_NO_TASKBAR );
    wCreateNumConst( "wxFRAME_TOOL_WINDOW",             wxFRAME_TOOL_WINDOW );
    wCreateNumConst( "wxRESIZE_BOX",                    wxRESIZE_BOX );
    wCreateNumConst( "wxTHICK_FRAME",                   wxTHICK_FRAME );
    wCreateNumConst( "wxDIALOG_MODAL",                  wxDIALOG_MODAL );
    wCreateNumConst( "wxDIALOG_MODELESS",               wxDIALOG_MODELESS );
    wCreateNumConst( "wxFRAME_FLOAT_ON_PARENT",         wxFRAME_FLOAT_ON_PARENT );
    wCreateNumConst( "wxFRAME_EX_CONTEXTHELP",          wxFRAME_EX_CONTEXTHELP );
    wCreateNumConst( "wxDIALOG_EX_CONTEXTHELP",         wxDIALOG_EX_CONTEXTHELP );
    wCreateNumConst( "wxFRAME_NO_WINDOW_MENU",          wxFRAME_NO_WINDOW_MENU );
    wCreateNumConst( "wxDEFAULT_FRAME_STYLE",           wxDEFAULT_FRAME_STYLE );
    wCreateNumConst( "wxDEFAULT_DIALOG_STYLE",          wxDEFAULT_DIALOG_STYLE );
    wCreateNumConst( "wxED_CLIENT_MARGIN",              wxED_CLIENT_MARGIN );
    wCreateNumConst( "wxED_BUTTONS_BOTTOM",             wxED_BUTTONS_BOTTOM );
    wCreateNumConst( "wxED_BUTTONS_RIGHT",              wxED_BUTTONS_RIGHT );
    wCreateNumConst( "wxED_STATIC_LINE",                wxED_STATIC_LINE );
    wCreateNumConst( "wxEXT_DIALOG_STYLE",              wxEXT_DIALOG_STYLE );
    wCreateNumConst( "wxTB_HORIZONTAL",                 wxTB_HORIZONTAL );
    wCreateNumConst( "wxTB_VERTICAL",                   wxTB_VERTICAL );
    wCreateNumConst( "wxTB_3DBUTTONS",                  wxTB_3DBUTTONS );
    wCreateNumConst( "wxTB_FLAT",                       wxTB_FLAT );
    wCreateNumConst( "wxTB_DOCKABLE",                   wxTB_DOCKABLE );
    wCreateNumConst( "wxMB_DOCKABLE",                   wxMB_DOCKABLE );
    wCreateNumConst( "wxMENU_TEAROFF",                  wxMENU_TEAROFF );
    wCreateNumConst( "wxCOLOURED",                      wxCOLOURED );
    wCreateNumConst( "wxFIXED_LENGTH",                  wxFIXED_LENGTH );
    wCreateNumConst( "wxLB_SORT",                       wxLB_SORT );
    wCreateNumConst( "wxLB_SINGLE",                     wxLB_SINGLE );
    wCreateNumConst( "wxLB_MULTIPLE",                   wxLB_MULTIPLE );
    wCreateNumConst( "wxLB_EXTENDED",                   wxLB_EXTENDED );
    wCreateNumConst( "wxLB_OWNERDRAW",                  wxLB_OWNERDRAW );
    wCreateNumConst( "wxLB_NEEDED_SB",                  wxLB_NEEDED_SB );
    wCreateNumConst( "wxLB_ALWAYS_SB",                  wxLB_ALWAYS_SB );
    wCreateNumConst( "wxLB_HSCROLL",                    wxLB_HSCROLL );
    wCreateNumConst( "wxTE_READONLY",                   wxTE_READONLY );
    wCreateNumConst( "wxTE_MULTILINE",                  wxTE_MULTILINE );
    wCreateNumConst( "wxTE_PROCESS_TAB",                wxTE_PROCESS_TAB );
    wCreateNumConst( "wxTE_RICH",                       wxTE_RICH );
    wCreateNumConst( "wxTE_NO_VSCROLL",                 wxTE_NO_VSCROLL );
    wCreateNumConst( "wxTE_AUTO_SCROLL",                wxTE_AUTO_SCROLL );
    wCreateNumConst( "wxPROCESS_ENTER",                 wxPROCESS_ENTER );
    wCreateNumConst( "wxPASSWORD",                      wxPASSWORD );
    wCreateNumConst( "wxTE_PROCESS_ENTER",              wxTE_PROCESS_ENTER );
    wCreateNumConst( "wxTE_PASSWORD",                   wxTE_PASSWORD );
    wCreateNumConst( "wxCB_SIMPLE",                     wxCB_SIMPLE );
    wCreateNumConst( "wxCB_SORT",                       wxCB_SORT );
    wCreateNumConst( "wxCB_READONLY",                   wxCB_READONLY );
    wCreateNumConst( "wxCB_DROPDOWN",                   wxCB_DROPDOWN );
    wCreateNumConst( "wxRA_SPECIFY_COLS",               wxRA_SPECIFY_COLS );
    wCreateNumConst( "wxRA_SPECIFY_ROWS",               wxRA_SPECIFY_ROWS );
    wCreateNumConst( "wxRA_HORIZONTAL",                 wxRA_HORIZONTAL );
    wCreateNumConst( "wxRA_VERTICAL",                   wxRA_VERTICAL );
    wCreateNumConst( "wxRB_GROUP",                      wxRB_GROUP );
    wCreateNumConst( "wxGA_HORIZONTAL",                 wxGA_HORIZONTAL );
    wCreateNumConst( "wxGA_VERTICAL",                   wxGA_VERTICAL );
    wCreateNumConst( "wxGA_PROGRESSBAR",                wxGA_PROGRESSBAR );
    wCreateNumConst( "wxGA_SMOOTH",                     wxGA_SMOOTH );
    wCreateNumConst( "wxSL_HORIZONTAL",                 wxSL_HORIZONTAL );
    wCreateNumConst( "wxSL_VERTICAL",                   wxSL_VERTICAL );
    wCreateNumConst( "wxSL_NOTIFY_DRAG",                wxSL_NOTIFY_DRAG );
    wCreateNumConst( "wxSL_AUTOTICKS",                  wxSL_AUTOTICKS );
    wCreateNumConst( "wxSL_LABELS",                     wxSL_LABELS );
    wCreateNumConst( "wxSL_LEFT",                       wxSL_LEFT );
    wCreateNumConst( "wxSL_TOP",                        wxSL_TOP );
    wCreateNumConst( "wxSL_RIGHT",                      wxSL_RIGHT );
    wCreateNumConst( "wxSL_BOTTOM",                     wxSL_BOTTOM );
    wCreateNumConst( "wxSL_BOTH",                       wxSL_BOTH );
    wCreateNumConst( "wxSL_SELRANGE",                   wxSL_SELRANGE );
    wCreateNumConst( "wxSB_HORIZONTAL",                 wxSB_HORIZONTAL );
    wCreateNumConst( "wxSB_VERTICAL",                   wxSB_VERTICAL );
    wCreateNumConst( "wxBU_AUTODRAW",                   wxBU_AUTODRAW );
    wCreateNumConst( "wxBU_NOAUTODRAW",                 wxBU_NOAUTODRAW );
    wCreateNumConst( "wxBU_LEFT",                       wxBU_LEFT );
    wCreateNumConst( "wxBU_TOP",                        wxBU_TOP );
    wCreateNumConst( "wxBU_RIGHT",                      wxBU_RIGHT );
    wCreateNumConst( "wxBU_BOTTOM",                     wxBU_BOTTOM );
    wCreateNumConst( "wxTR_HAS_BUTTONS",                wxTR_HAS_BUTTONS );
    wCreateNumConst( "wxTR_EDIT_LABELS",                wxTR_EDIT_LABELS );
    wCreateNumConst( "wxTR_LINES_AT_ROOT",              wxTR_LINES_AT_ROOT );
    wCreateNumConst( "wxTR_SINGLE",                     wxTR_SINGLE );
    wCreateNumConst( "wxTR_MULTIPLE",                   wxTR_MULTIPLE );
    wCreateNumConst( "wxTR_EXTENDED",                   wxTR_EXTENDED );
    wCreateNumConst( "wxTR_HAS_VARIABLE_ROW_HEIGHT",    wxTR_HAS_VARIABLE_ROW_HEIGHT );
    wCreateNumConst( "wxTR_NO_LINES",                   wxTR_NO_LINES );
    wCreateNumConst( "wxTR_MAC_BUTTONS",                wxTR_MAC_BUTTONS );
    wCreateNumConst( "wxTR_ROW_LINES",                  wxTR_ROW_LINES );
    wCreateNumConst( "wxLC_VRULES",                     wxLC_VRULES );
    wCreateNumConst( "wxLC_HRULES",                     wxLC_HRULES );
    wCreateNumConst( "wxLC_ICON",                       wxLC_ICON );
    wCreateNumConst( "wxLC_SMALL_ICON",                 wxLC_SMALL_ICON );
    wCreateNumConst( "wxLC_LIST",                       wxLC_LIST );
    wCreateNumConst( "wxLC_REPORT",                     wxLC_REPORT );
    wCreateNumConst( "wxLC_ALIGN_TOP",                  wxLC_ALIGN_TOP );
    wCreateNumConst( "wxLC_ALIGN_LEFT",                 wxLC_ALIGN_LEFT );
    wCreateNumConst( "wxLC_AUTOARRANGE",                wxLC_AUTOARRANGE );
    wCreateNumConst( "wxLC_USER_TEXT",                  wxLC_USER_TEXT );
    wCreateNumConst( "wxLC_EDIT_LABELS",                wxLC_EDIT_LABELS );
    wCreateNumConst( "wxLC_NO_HEADER",                  wxLC_NO_HEADER );
    wCreateNumConst( "wxLC_NO_SORT_HEADER",             wxLC_NO_SORT_HEADER );
    wCreateNumConst( "wxLC_SINGLE_SEL",                 wxLC_SINGLE_SEL );
    wCreateNumConst( "wxLC_SORT_ASCENDING",             wxLC_SORT_ASCENDING );
    wCreateNumConst( "wxLC_SORT_DESCENDING",            wxLC_SORT_DESCENDING );
    wCreateNumConst( "wxLC_MASK_TYPE",                  wxLC_MASK_TYPE );
    wCreateNumConst( "wxLC_MASK_ALIGN",                 wxLC_MASK_ALIGN );
    wCreateNumConst( "wxLC_MASK_SORT",                  wxLC_MASK_SORT );
    wCreateNumConst( "wxSP_HORIZONTAL",                 wxSP_HORIZONTAL );
    wCreateNumConst( "wxSP_VERTICAL",                   wxSP_VERTICAL );
    wCreateNumConst( "wxSP_ARROW_KEYS",                 wxSP_ARROW_KEYS );
    wCreateNumConst( "wxSP_WRAP",                       wxSP_WRAP );
    wCreateNumConst( "wxSP_NOBORDER",                   wxSP_NOBORDER );
    wCreateNumConst( "wxSP_NOSASH",                     wxSP_NOSASH );
    wCreateNumConst( "wxSP_BORDER",                     wxSP_BORDER );
    wCreateNumConst( "wxSP_PERMIT_UNSPLIT",             wxSP_PERMIT_UNSPLIT );
    wCreateNumConst( "wxSP_LIVE_UPDATE",                wxSP_LIVE_UPDATE );
    wCreateNumConst( "wxSP_3DSASH",                     wxSP_3DSASH );
    wCreateNumConst( "wxSP_3DBORDER",                   wxSP_3DBORDER );
    wCreateNumConst( "wxSP_FULLSASH",                   wxSP_FULLSASH );
    wCreateNumConst( "wxSP_3D",                         wxSP_3D );
    wCreateNumConst( "wxTC_MULTILINE",                  wxTC_MULTILINE );
    wCreateNumConst( "wxTC_RIGHTJUSTIFY",               wxTC_RIGHTJUSTIFY );
    wCreateNumConst( "wxTC_FIXEDWIDTH",                 wxTC_FIXEDWIDTH );
    wCreateNumConst( "wxTC_OWNERDRAW",                  wxTC_OWNERDRAW );
    wCreateNumConst( "wxNB_FIXEDWIDTH",                 wxNB_FIXEDWIDTH );
    wCreateNumConst( "wxNB_LEFT",                       wxNB_LEFT );
    wCreateNumConst( "wxNB_RIGHT",                      wxNB_RIGHT );
    wCreateNumConst( "wxNB_BOTTOM",                     wxNB_BOTTOM );
    wCreateNumConst( "wxST_SIZEGRIP",                   wxST_SIZEGRIP );
    wCreateNumConst( "wxST_NO_AUTORESIZE",              wxST_NO_AUTORESIZE );
    wCreateNumConst( "wxLI_HORIZONTAL",                 wxLI_HORIZONTAL );
    wCreateNumConst( "wxLI_VERTICAL",                   wxLI_VERTICAL );
    wCreateNumConst( "wxPD_CAN_ABORT",                  wxPD_CAN_ABORT );
    wCreateNumConst( "wxPD_APP_MODAL",                  wxPD_APP_MODAL );
    wCreateNumConst( "wxPD_AUTO_HIDE",                  wxPD_AUTO_HIDE );
    wCreateNumConst( "wxPD_ELAPSED_TIME",               wxPD_ELAPSED_TIME );
    wCreateNumConst( "wxPD_ESTIMATED_TIME",             wxPD_ESTIMATED_TIME );
    wCreateNumConst( "wxPD_REMAINING_TIME",             wxPD_REMAINING_TIME );
    wCreateNumConst( "wxHW_SCROLLBAR_NEVER",            wxHW_SCROLLBAR_NEVER );
    wCreateNumConst( "wxHW_SCROLLBAR_AUTO",             wxHW_SCROLLBAR_AUTO );
    wCreateNumConst( "wxCAL_SUNDAY_FIRST",              wxCAL_SUNDAY_FIRST );
    wCreateNumConst( "wxCAL_MONDAY_FIRST",              wxCAL_MONDAY_FIRST );
    wCreateNumConst( "wxCAL_SHOW_HOLIDAYS",             wxCAL_SHOW_HOLIDAYS );
    wCreateNumConst( "wxCAL_NO_YEAR_CHANGE",            wxCAL_NO_YEAR_CHANGE );
    wCreateNumConst( "wxCAL_NO_MONTH_CHANGE",           wxCAL_NO_MONTH_CHANGE );
    wCreateNumConst( "wxOK",                            wxOK );
    wCreateNumConst( "wxYES_NO",                        wxYES_NO );
    wCreateNumConst( "wxCANCEL",                        wxCANCEL );
    wCreateNumConst( "wxYES",                           wxYES );
    wCreateNumConst( "wxNO",                            wxNO );
    wCreateNumConst( "wxNO_DEFAULT",                    wxNO_DEFAULT );
    wCreateNumConst( "wxYES_DEFAULT",                   wxYES_DEFAULT );
    wCreateNumConst( "wxICON_EXCLAMATION",              wxICON_EXCLAMATION );
    wCreateNumConst( "wxICON_HAND",                     wxICON_HAND );
    wCreateNumConst( "wxICON_WARNING",                  wxICON_WARNING );
    wCreateNumConst( "wxICON_ERROR",                    wxICON_ERROR );
    wCreateNumConst( "wxICON_QUESTION",                 wxICON_QUESTION );
    wCreateNumConst( "wxICON_INFORMATION",              wxICON_INFORMATION );
    wCreateNumConst( "wxICON_STOP",                     wxICON_STOP );
    wCreateNumConst( "wxICON_ASTERISK",                 wxICON_ASTERISK );
    wCreateNumConst( "wxICON_MASK",                     wxICON_MASK );
    wCreateNumConst( "wxFORWARD",                       wxFORWARD );
    wCreateNumConst( "wxBACKWARD",                      wxBACKWARD );
    wCreateNumConst( "wxRESET",                         wxRESET );
    wCreateNumConst( "wxHELP",                          wxHELP );
    wCreateNumConst( "wxMORE",                          wxMORE );
    wCreateNumConst( "wxSETUP",                         wxSETUP );
    wCreateNumConst( "wxID_SEPARATOR",                  wxID_SEPARATOR );
    wCreateNumConst( "wxID_LOWEST",                     wxID_LOWEST );
    wCreateNumConst( "wxID_OPEN",                       wxID_OPEN );
    wCreateNumConst( "wxID_CLOSE",                      wxID_CLOSE );
    wCreateNumConst( "wxID_NEW",                        wxID_NEW );
    wCreateNumConst( "wxID_SAVE",                       wxID_SAVE );
    wCreateNumConst( "wxID_SAVEAS",                     wxID_SAVEAS );
    wCreateNumConst( "wxID_REVERT",                     wxID_REVERT );
    wCreateNumConst( "wxID_EXIT",                       wxID_EXIT );
    wCreateNumConst( "wxID_UNDO",                       wxID_UNDO );
    wCreateNumConst( "wxID_REDO",                       wxID_REDO );
    wCreateNumConst( "wxID_HELP",                       wxID_HELP );
    wCreateNumConst( "wxID_PRINT",                      wxID_PRINT );
    wCreateNumConst( "wxID_PRINT_SETUP",                wxID_PRINT_SETUP );
    wCreateNumConst( "wxID_PREVIEW",                    wxID_PREVIEW );
    wCreateNumConst( "wxID_ABOUT",                      wxID_ABOUT );
    wCreateNumConst( "wxID_HELP_CONTENTS",              wxID_HELP_CONTENTS );
    wCreateNumConst( "wxID_HELP_COMMANDS",              wxID_HELP_COMMANDS );
    wCreateNumConst( "wxID_HELP_PROCEDURES",            wxID_HELP_PROCEDURES );
    wCreateNumConst( "wxID_HELP_CONTEXT",               wxID_HELP_CONTEXT );
    wCreateNumConst( "wxID_CUT",                        wxID_CUT );
    wCreateNumConst( "wxID_COPY",                       wxID_COPY );
    wCreateNumConst( "wxID_PASTE",                      wxID_PASTE );
    wCreateNumConst( "wxID_CLEAR",                      wxID_CLEAR );
    wCreateNumConst( "wxID_FIND",                       wxID_FIND );
    wCreateNumConst( "wxID_DUPLICATE",                  wxID_DUPLICATE );
    wCreateNumConst( "wxID_SELECTALL",                  wxID_SELECTALL );
    wCreateNumConst( "wxID_FILE1",                      wxID_FILE1 );
    wCreateNumConst( "wxID_FILE2",                      wxID_FILE2 );
    wCreateNumConst( "wxID_FILE3",                      wxID_FILE3 );
    wCreateNumConst( "wxID_FILE4",                      wxID_FILE4 );
    wCreateNumConst( "wxID_FILE5",                      wxID_FILE5 );
    wCreateNumConst( "wxID_FILE6",                      wxID_FILE6 );
    wCreateNumConst( "wxID_FILE7",                      wxID_FILE7 );
    wCreateNumConst( "wxID_FILE8",                      wxID_FILE8 );
    wCreateNumConst( "wxID_FILE9",                      wxID_FILE9 );
    wCreateNumConst( "wxID_OK",                         wxID_OK );
    wCreateNumConst( "wxID_CANCEL",                     wxID_CANCEL );
    wCreateNumConst( "wxID_APPLY",                      wxID_APPLY );
    wCreateNumConst( "wxID_YES",                        wxID_YES );
    wCreateNumConst( "wxID_NO",                         wxID_NO );
    wCreateNumConst( "wxID_STATIC",                     wxID_STATIC );
    wCreateNumConst( "wxID_FORWARD",                    wxID_FORWARD );
    wCreateNumConst( "wxID_BACKWARD",                   wxID_BACKWARD );
    wCreateNumConst( "wxID_DEFAULT",                    wxID_DEFAULT );
    wCreateNumConst( "wxID_MORE",                       wxID_MORE );
    wCreateNumConst( "wxID_SETUP",                      wxID_SETUP );
    wCreateNumConst( "wxID_RESET",                      wxID_RESET );
    wCreateNumConst( "wxID_CONTEXT_HELP",               wxID_CONTEXT_HELP );
    wCreateNumConst( "wxID_YESTOALL",                   wxID_YESTOALL );
    wCreateNumConst( "wxID_NOTOALL",                    wxID_NOTOALL );
    wCreateNumConst( "wxID_ABORT",                      wxID_ABORT );
    wCreateNumConst( "wxID_RETRY",                      wxID_RETRY );
    wCreateNumConst( "wxID_IGNORE",                     wxID_IGNORE );
    wCreateNumConst( "wxID_FILEDLGG",                   wxID_FILEDLGG );
    wCreateNumConst( "wxID_HIGHEST",                    wxID_HIGHEST );
    wCreateNumConst( "wxSIZE_AUTO_WIDTH",               wxSIZE_AUTO_WIDTH );
    wCreateNumConst( "wxSIZE_AUTO_HEIGHT",              wxSIZE_AUTO_HEIGHT );
    wCreateNumConst( "wxSIZE_AUTO",                     wxSIZE_AUTO );
    wCreateNumConst( "wxSIZE_USE_EXISTING",             wxSIZE_USE_EXISTING );
    wCreateNumConst( "wxSIZE_ALLOW_MINUS_ONE",          wxSIZE_ALLOW_MINUS_ONE );
    wCreateNumConst( "wxSIZE_NO_ADJUSTMENTS",           wxSIZE_NO_ADJUSTMENTS );
    wCreateNumConst( "wxFLOOD_SURFACE",                 wxFLOOD_SURFACE );
    wCreateNumConst( "wxFLOOD_BORDER",                  wxFLOOD_BORDER );
    wCreateNumConst( "wxODDEVEN_RULE",                  wxODDEVEN_RULE );
    wCreateNumConst( "wxWINDING_RULE",                  wxWINDING_RULE );
    wCreateNumConst( "wxTOOL_TOP",                      wxTOOL_TOP );
    wCreateNumConst( "wxTOOL_BOTTOM",                   wxTOOL_BOTTOM );
    wCreateNumConst( "wxTOOL_LEFT",                     wxTOOL_LEFT );
    wCreateNumConst( "wxTOOL_RIGHT",                    wxTOOL_RIGHT );
    wCreateNumConst( "wxMM_TEXT",                       wxMM_TEXT );
    wCreateNumConst( "wxMM_LOMETRIC",                   wxMM_LOMETRIC );
    wCreateNumConst( "wxMM_HIMETRIC",                   wxMM_HIMETRIC );
    wCreateNumConst( "wxMM_LOENGLISH",                  wxMM_LOENGLISH );
    wCreateNumConst( "wxMM_HIENGLISH",                  wxMM_HIENGLISH );
    wCreateNumConst( "wxMM_TWIPS",                      wxMM_TWIPS );
    wCreateNumConst( "wxMM_ISOTROPIC",                  wxMM_ISOTROPIC );
    wCreateNumConst( "wxMM_ANISOTROPIC",                wxMM_ANISOTROPIC );
    wCreateNumConst( "wxMM_POINTS",                     wxMM_POINTS );
    wCreateNumConst( "wxMM_METRIC",                     wxMM_METRIC );
    wCreateNumConst( "wxPORTRAIT",                      wxPORTRAIT );
    wCreateNumConst( "wxLANDSCAPE",                     wxLANDSCAPE );
    wCreateNumConst( "wxPRINT_QUALITY_HIGH",            wxPRINT_QUALITY_HIGH );
    wCreateNumConst( "wxPRINT_QUALITY_MEDIUM",          wxPRINT_QUALITY_MEDIUM );
    wCreateNumConst( "wxPRINT_QUALITY_LOW",             wxPRINT_QUALITY_LOW );
    wCreateNumConst( "wxPRINT_QUALITY_DRAFT",           wxPRINT_QUALITY_DRAFT );

    /* from EVENTS.H */
    wCreateNumConst( "wxEVT_COMMAND_BUTTON_CLICKED",    wxEVT_COMMAND_BUTTON_CLICKED );
    wCreateNumConst( "wxEVT_COMMAND_CHECKBOX_CLICKED",  wxEVT_COMMAND_CHECKBOX_CLICKED );
    wCreateNumConst( "wxEVT_COMMAND_CHOICE_SELECTED",   wxEVT_COMMAND_CHOICE_SELECTED );
    wCreateNumConst( "wxEVT_COMMAND_LISTBOX_SELECTED",  wxEVT_COMMAND_LISTBOX_SELECTED );
    wCreateNumConst( "wxEVT_COMMAND_LISTBOX_DOUBLECLICKED", wxEVT_COMMAND_LISTBOX_DOUBLECLICKED );
    wCreateNumConst( "wxEVT_COMMAND_CHECKLISTBOX_TOGGLED", wxEVT_COMMAND_CHECKLISTBOX_TOGGLED );
    wCreateNumConst( "wxEVT_COMMAND_TEXT_UPDATED",      wxEVT_COMMAND_TEXT_UPDATED );
    wCreateNumConst( "wxEVT_COMMAND_TEXT_ENTER",        wxEVT_COMMAND_TEXT_ENTER );
    wCreateNumConst( "wxEVT_COMMAND_MENU_SELECTED",     wxEVT_COMMAND_MENU_SELECTED );
    wCreateNumConst( "wxEVT_COMMAND_SLIDER_UPDATED",    wxEVT_COMMAND_SLIDER_UPDATED );
    wCreateNumConst( "wxEVT_COMMAND_RADIOBOX_SELECTED", wxEVT_COMMAND_RADIOBOX_SELECTED );
    wCreateNumConst( "wxEVT_COMMAND_RADIOBUTTON_SELECTED", wxEVT_COMMAND_RADIOBUTTON_SELECTED );
    wCreateNumConst( "wxEVT_COMMAND_SCROLLBAR_UPDATED", wxEVT_COMMAND_SCROLLBAR_UPDATED );
    wCreateNumConst( "wxEVT_COMMAND_VLBOX_SELECTED",    wxEVT_COMMAND_VLBOX_SELECTED );
    wCreateNumConst( "wxEVT_COMMAND_COMBOBOX_SELECTED", wxEVT_COMMAND_COMBOBOX_SELECTED );
    wCreateNumConst( "wxEVT_COMMAND_TOOL_RCLICKED",     wxEVT_COMMAND_TOOL_RCLICKED );
    wCreateNumConst( "wxEVT_COMMAND_TOOL_ENTER",        wxEVT_COMMAND_TOOL_ENTER );
    wCreateNumConst( "wxEVT_COMMAND_SPINCTRL_UPDATED",  wxEVT_COMMAND_SPINCTRL_UPDATED );
    wCreateNumConst( "wxEVT_SOCKET",                    wxEVT_SOCKET );
    wCreateNumConst( "wxEVT_TIMER",                     wxEVT_TIMER  );
    wCreateNumConst( "wxEVT_LEFT_DOWN",                 wxEVT_LEFT_DOWN );
    wCreateNumConst( "wxEVT_LEFT_UP",                   wxEVT_LEFT_UP );
    wCreateNumConst( "wxEVT_MIDDLE_DOWN",               wxEVT_MIDDLE_DOWN );
    wCreateNumConst( "wxEVT_MIDDLE_UP",                 wxEVT_MIDDLE_UP );
    wCreateNumConst( "wxEVT_RIGHT_DOWN",                wxEVT_RIGHT_DOWN );
    wCreateNumConst( "wxEVT_RIGHT_UP",                  wxEVT_RIGHT_UP );
    wCreateNumConst( "wxEVT_MOTION",                    wxEVT_MOTION );
    wCreateNumConst( "wxEVT_ENTER_WINDOW",              wxEVT_ENTER_WINDOW );
    wCreateNumConst( "wxEVT_LEAVE_WINDOW",              wxEVT_LEAVE_WINDOW );
    wCreateNumConst( "wxEVT_LEFT_DCLICK",               wxEVT_LEFT_DCLICK );
    wCreateNumConst( "wxEVT_MIDDLE_DCLICK",             wxEVT_MIDDLE_DCLICK );
    wCreateNumConst( "wxEVT_RIGHT_DCLICK",              wxEVT_RIGHT_DCLICK );
    wCreateNumConst( "wxEVT_SET_FOCUS",                 wxEVT_SET_FOCUS );
    wCreateNumConst( "wxEVT_KILL_FOCUS",                wxEVT_KILL_FOCUS );
    wCreateNumConst( "wxEVT_MOUSEWHEEL",                wxEVT_MOUSEWHEEL );
    wCreateNumConst( "wxEVT_NC_LEFT_DOWN",              wxEVT_NC_LEFT_DOWN );
    wCreateNumConst( "wxEVT_NC_LEFT_UP",                wxEVT_NC_LEFT_UP );
    wCreateNumConst( "wxEVT_NC_MIDDLE_DOWN",            wxEVT_NC_MIDDLE_DOWN );
    wCreateNumConst( "wxEVT_NC_MIDDLE_UP",              wxEVT_NC_MIDDLE_UP );
    wCreateNumConst( "wxEVT_NC_RIGHT_DOWN",             wxEVT_NC_RIGHT_DOWN );
    wCreateNumConst( "wxEVT_NC_RIGHT_UP",               wxEVT_NC_RIGHT_UP );
    wCreateNumConst( "wxEVT_NC_MOTION",                 wxEVT_NC_MOTION );
    wCreateNumConst( "wxEVT_NC_ENTER_WINDOW",           wxEVT_NC_ENTER_WINDOW );
    wCreateNumConst( "wxEVT_NC_LEAVE_WINDOW",           wxEVT_NC_LEAVE_WINDOW );
    wCreateNumConst( "wxEVT_NC_LEFT_DCLICK",            wxEVT_NC_LEFT_DCLICK );
    wCreateNumConst( "wxEVT_NC_MIDDLE_DCLICK",          wxEVT_NC_MIDDLE_DCLICK );
    wCreateNumConst( "wxEVT_NC_RIGHT_DCLICK",           wxEVT_NC_RIGHT_DCLICK );
    wCreateNumConst( "wxEVT_CHAR",                      wxEVT_CHAR );
    wCreateNumConst( "wxEVT_CHAR_HOOK",                 wxEVT_CHAR_HOOK );
    wCreateNumConst( "wxEVT_NAVIGATION_KEY",            wxEVT_NAVIGATION_KEY );
    wCreateNumConst( "wxEVT_KEY_DOWN",                  wxEVT_KEY_DOWN );
    wCreateNumConst( "wxEVT_KEY_UP",                    wxEVT_KEY_UP );
    wCreateNumConst( "wxEVT_SET_CURSOR",                wxEVT_SET_CURSOR );
    wCreateNumConst( "wxEVT_SCROLL_TOP",                wxEVT_SCROLL_TOP );
    wCreateNumConst( "wxEVT_SCROLL_BOTTOM",             wxEVT_SCROLL_BOTTOM );
    wCreateNumConst( "wxEVT_SCROLL_LINEUP",             wxEVT_SCROLL_LINEUP );
    wCreateNumConst( "wxEVT_SCROLL_LINEDOWN",           wxEVT_SCROLL_LINEDOWN );
    wCreateNumConst( "wxEVT_SCROLL_PAGEUP",             wxEVT_SCROLL_PAGEUP );
    wCreateNumConst( "wxEVT_SCROLL_PAGEDOWN",           wxEVT_SCROLL_PAGEDOWN );
    wCreateNumConst( "wxEVT_SCROLL_THUMBTRACK",         wxEVT_SCROLL_THUMBTRACK );
    wCreateNumConst( "wxEVT_SCROLL_THUMBRELEASE",       wxEVT_SCROLL_THUMBRELEASE );
    wCreateNumConst( "wxEVT_SCROLLWIN_TOP",             wxEVT_SCROLLWIN_TOP );
    wCreateNumConst( "wxEVT_SCROLLWIN_BOTTOM",          wxEVT_SCROLLWIN_BOTTOM );
    wCreateNumConst( "wxEVT_SCROLLWIN_LINEUP",          wxEVT_SCROLLWIN_LINEUP );
    wCreateNumConst( "wxEVT_SCROLLWIN_LINEDOWN",        wxEVT_SCROLLWIN_LINEDOWN );
    wCreateNumConst( "wxEVT_SCROLLWIN_PAGEUP",          wxEVT_SCROLLWIN_PAGEUP );
    wCreateNumConst( "wxEVT_SCROLLWIN_PAGEDOWN",        wxEVT_SCROLLWIN_PAGEDOWN );
    wCreateNumConst( "wxEVT_SCROLLWIN_THUMBTRACK",      wxEVT_SCROLLWIN_THUMBTRACK );
    wCreateNumConst( "wxEVT_SCROLLWIN_THUMBRELEASE",    wxEVT_SCROLLWIN_THUMBRELEASE );
    wCreateNumConst( "wxEVT_SIZE",                      wxEVT_SIZE );
    wCreateNumConst( "wxEVT_MOVE",                      wxEVT_MOVE );
    wCreateNumConst( "wxEVT_CLOSE_WINDOW",              wxEVT_CLOSE_WINDOW );
    wCreateNumConst( "wxEVT_END_SESSION",               wxEVT_END_SESSION );
    wCreateNumConst( "wxEVT_QUERY_END_SESSION",         wxEVT_QUERY_END_SESSION );
    wCreateNumConst( "wxEVT_ACTIVATE_APP",              wxEVT_ACTIVATE_APP );
    wCreateNumConst( "wxEVT_POWER",                     wxEVT_POWER );
    wCreateNumConst( "wxEVT_ACTIVATE",                  wxEVT_ACTIVATE );
    wCreateNumConst( "wxEVT_CREATE",                    wxEVT_CREATE );
    wCreateNumConst( "wxEVT_DESTROY",                   wxEVT_DESTROY );
    wCreateNumConst( "wxEVT_SHOW",                      wxEVT_SHOW );
    wCreateNumConst( "wxEVT_ICONIZE",                   wxEVT_ICONIZE );
    wCreateNumConst( "wxEVT_MAXIMIZE",                  wxEVT_MAXIMIZE );
    wCreateNumConst( "wxEVT_MOUSE_CAPTURE_CHANGED",     wxEVT_MOUSE_CAPTURE_CHANGED );
    wCreateNumConst( "wxEVT_PAINT",                     wxEVT_PAINT );
    wCreateNumConst( "wxEVT_ERASE_BACKGROUND",          wxEVT_ERASE_BACKGROUND );
    wCreateNumConst( "wxEVT_NC_PAINT",                  wxEVT_NC_PAINT );
    wCreateNumConst( "wxEVT_PAINT_ICON",                wxEVT_PAINT_ICON );
    wCreateNumConst( "wxEVT_MENU_CHAR",                 wxEVT_MENU_CHAR );
    wCreateNumConst( "wxEVT_MENU_INIT",                 wxEVT_MENU_INIT );
    wCreateNumConst( "wxEVT_MENU_HIGHLIGHT",            wxEVT_MENU_HIGHLIGHT );
    wCreateNumConst( "wxEVT_POPUP_MENU_INIT",           wxEVT_POPUP_MENU_INIT );
    wCreateNumConst( "wxEVT_CONTEXT_MENU",              wxEVT_CONTEXT_MENU );
    wCreateNumConst( "wxEVT_SYS_COLOUR_CHANGED",        wxEVT_SYS_COLOUR_CHANGED );
    wCreateNumConst( "wxEVT_SETTING_CHANGED",           wxEVT_SETTING_CHANGED );
    wCreateNumConst( "wxEVT_QUERY_NEW_PALETTE",         wxEVT_QUERY_NEW_PALETTE );
    wCreateNumConst( "wxEVT_PALETTE_CHANGED",           wxEVT_PALETTE_CHANGED );
    wCreateNumConst( "wxEVT_JOY_BUTTON_DOWN",           wxEVT_JOY_BUTTON_DOWN );
    wCreateNumConst( "wxEVT_JOY_BUTTON_UP",             wxEVT_JOY_BUTTON_UP );
    wCreateNumConst( "wxEVT_JOY_MOVE",                  wxEVT_JOY_MOVE );
    wCreateNumConst( "wxEVT_JOY_ZMOVE",                 wxEVT_JOY_ZMOVE );
    wCreateNumConst( "wxEVT_DROP_FILES",                wxEVT_DROP_FILES );
    wCreateNumConst( "wxEVT_DRAW_ITEM",                 wxEVT_DRAW_ITEM );
    wCreateNumConst( "wxEVT_MEASURE_ITEM",              wxEVT_MEASURE_ITEM );
    wCreateNumConst( "wxEVT_COMPARE_ITEM",              wxEVT_COMPARE_ITEM );
    wCreateNumConst( "wxEVT_INIT_DIALOG",               wxEVT_INIT_DIALOG );
    wCreateNumConst( "wxEVT_IDLE",                      wxEVT_IDLE );
    wCreateNumConst( "wxEVT_UPDATE_UI",                 wxEVT_UPDATE_UI );
    wCreateNumConst( "wxEVT_COMMAND_LEFT_CLICK",        wxEVT_COMMAND_LEFT_CLICK );
    wCreateNumConst( "wxEVT_COMMAND_LEFT_DCLICK",       wxEVT_COMMAND_LEFT_DCLICK );
    wCreateNumConst( "wxEVT_COMMAND_RIGHT_CLICK",       wxEVT_COMMAND_RIGHT_CLICK );
    wCreateNumConst( "wxEVT_COMMAND_RIGHT_DCLICK",      wxEVT_COMMAND_RIGHT_DCLICK );
    wCreateNumConst( "wxEVT_COMMAND_SET_FOCUS",         wxEVT_COMMAND_SET_FOCUS );
    wCreateNumConst( "wxEVT_COMMAND_KILL_FOCUS",        wxEVT_COMMAND_KILL_FOCUS );
    wCreateNumConst( "wxEVT_COMMAND_ENTER",             wxEVT_COMMAND_ENTER );
    wCreateNumConst( "wxEVT_HELP",                      wxEVT_HELP );
    wCreateNumConst( "wxEVT_DETAILED_HELP",             wxEVT_DETAILED_HELP );
    wCreateNumConst( "wxEVT_COMMAND_TOOL_CLICKED",      wxEVT_COMMAND_TOOL_CLICKED );

    /* From GDICMN.H */
    wCreateNumConst( "wxBITMAP_TYPE_INVALID",           wxBITMAP_TYPE_INVALID );
    wCreateNumConst( "wxBITMAP_TYPE_BMP",               wxBITMAP_TYPE_BMP );
    wCreateNumConst( "wxBITMAP_TYPE_BMP_RESOURCE",      wxBITMAP_TYPE_BMP_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_RESOURCE",          wxBITMAP_TYPE_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_ICO",               wxBITMAP_TYPE_ICO );
    wCreateNumConst( "wxBITMAP_TYPE_ICO_RESOURCE",      wxBITMAP_TYPE_ICO_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_CUR",               wxBITMAP_TYPE_CUR );
    wCreateNumConst( "wxBITMAP_TYPE_CUR_RESOURCE",      wxBITMAP_TYPE_CUR_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_XBM",               wxBITMAP_TYPE_XBM );
    wCreateNumConst( "wxBITMAP_TYPE_XBM_DATA",          wxBITMAP_TYPE_XBM_DATA );
    wCreateNumConst( "wxBITMAP_TYPE_XPM",               wxBITMAP_TYPE_XPM );
    wCreateNumConst( "wxBITMAP_TYPE_XPM_DATA",          wxBITMAP_TYPE_XPM_DATA );
    wCreateNumConst( "wxBITMAP_TYPE_TIF",               wxBITMAP_TYPE_TIF );
    wCreateNumConst( "wxBITMAP_TYPE_TIF_RESOURCE",      wxBITMAP_TYPE_TIF_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_GIF",               wxBITMAP_TYPE_GIF );
    wCreateNumConst( "wxBITMAP_TYPE_GIF_RESOURCE",      wxBITMAP_TYPE_GIF_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_PNG",               wxBITMAP_TYPE_PNG );
    wCreateNumConst( "wxBITMAP_TYPE_PNG_RESOURCE",      wxBITMAP_TYPE_PNG_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_JPEG",              wxBITMAP_TYPE_JPEG );
    wCreateNumConst( "wxBITMAP_TYPE_JPEG_RESOURCE",     wxBITMAP_TYPE_JPEG_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_PNM",               wxBITMAP_TYPE_PNM );
    wCreateNumConst( "wxBITMAP_TYPE_PNM_RESOURCE",      wxBITMAP_TYPE_PNM_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_PCX",               wxBITMAP_TYPE_PCX );
    wCreateNumConst( "wxBITMAP_TYPE_PCX_RESOURCE",      wxBITMAP_TYPE_PCX_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_PICT",              wxBITMAP_TYPE_PICT );
    wCreateNumConst( "wxBITMAP_TYPE_PICT_RESOURCE",     wxBITMAP_TYPE_PICT_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_ICON",              wxBITMAP_TYPE_ICON );
    wCreateNumConst( "wxBITMAP_TYPE_ICON_RESOURCE",     wxBITMAP_TYPE_ICON_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_MACCURSOR",         wxBITMAP_TYPE_MACCURSOR );
    wCreateNumConst( "wxBITMAP_TYPE_MACCURSOR_RESOURCE",wxBITMAP_TYPE_MACCURSOR_RESOURCE );
    wCreateNumConst( "wxBITMAP_TYPE_ANY",               wxBITMAP_TYPE_ANY );
    wCreateNumConst( "wxCURSOR_NONE",                   wxCURSOR_NONE );
    wCreateNumConst( "wxCURSOR_ARROW",                  wxCURSOR_ARROW );
    wCreateNumConst( "wxCURSOR_BULLSEYE",               wxCURSOR_BULLSEYE );
    wCreateNumConst( "wxCURSOR_CHAR",                   wxCURSOR_CHAR );
    wCreateNumConst( "wxCURSOR_CROSS",                  wxCURSOR_CROSS );
    wCreateNumConst( "wxCURSOR_HAND",                   wxCURSOR_HAND );
    wCreateNumConst( "wxCURSOR_IBEAM",                  wxCURSOR_IBEAM );
    wCreateNumConst( "wxCURSOR_LEFT_BUTTON",            wxCURSOR_LEFT_BUTTON );
    wCreateNumConst( "wxCURSOR_MAGNIFIER",              wxCURSOR_MAGNIFIER );
    wCreateNumConst( "wxCURSOR_MIDDLE_BUTTON",          wxCURSOR_MIDDLE_BUTTON );
    wCreateNumConst( "wxCURSOR_NO_ENTRY",               wxCURSOR_NO_ENTRY );
    wCreateNumConst( "wxCURSOR_PAINT_BRUSH",            wxCURSOR_PAINT_BRUSH );
    wCreateNumConst( "wxCURSOR_PENCIL",                 wxCURSOR_PENCIL );
    wCreateNumConst( "wxCURSOR_POINT_LEFT",             wxCURSOR_POINT_LEFT );
    wCreateNumConst( "wxCURSOR_POINT_RIGHT",            wxCURSOR_POINT_RIGHT );
    wCreateNumConst( "wxCURSOR_QUESTION_ARROW",         wxCURSOR_QUESTION_ARROW );
    wCreateNumConst( "wxCURSOR_RIGHT_BUTTON",           wxCURSOR_RIGHT_BUTTON );
    wCreateNumConst( "wxCURSOR_SIZENESW",               wxCURSOR_SIZENESW );
    wCreateNumConst( "wxCURSOR_SIZENS",                 wxCURSOR_SIZENS );
    wCreateNumConst( "wxCURSOR_SIZENWSE",               wxCURSOR_SIZENWSE );
    wCreateNumConst( "wxCURSOR_SIZEWE",                 wxCURSOR_SIZEWE );
    wCreateNumConst( "wxCURSOR_SIZING",                 wxCURSOR_SIZING );
    wCreateNumConst( "wxCURSOR_SPRAYCAN",               wxCURSOR_SPRAYCAN );
    wCreateNumConst( "wxCURSOR_WAIT",                   wxCURSOR_WAIT );
    wCreateNumConst( "wxCURSOR_WATCH",                  wxCURSOR_WATCH );
    wCreateNumConst( "wxCURSOR_BLANK",                  wxCURSOR_BLANK );
    wCreateNumConst( "wxCURSOR_ARROWWAIT",              wxCURSOR_ARROWWAIT );
    wCreateNumConst( "wxCURSOR_MAX",                    wxCURSOR_MAX );

    /* from GENERIC/SASHWIN.H */
    wCreateNumConst( "wxSASH_DRAG_NONE",                wxSASH_DRAG_NONE );
    wCreateNumConst( "wxSASH_DRAG_DRAGGING",            wxSASH_DRAG_DRAGGING );
    wCreateNumConst( "wxSASH_DRAG_LEFT_DOWN",           wxSASH_DRAG_LEFT_DOWN );
    wCreateNumConst( "wxSASH_TOP",                      wxSASH_TOP );
    wCreateNumConst( "wxSASH_RIGHT",                    wxSASH_RIGHT );
    wCreateNumConst( "wxSASH_BOTTOM",                   wxSASH_BOTTOM );
    wCreateNumConst( "wxSASH_LEFT",                     wxSASH_LEFT );
    wCreateNumConst( "wxSASH_NONE",                     wxSASH_NONE );


    /* from FILEDLG.H */
    wCreateNumConst( "wxOPEN",                          wxOPEN );
    wCreateNumConst( "wxSAVE",                          wxSAVE );
    wCreateNumConst( "wxOVERWIRTE_PROMPT",              wxOVERWRITE_PROMPT );
    wCreateNumConst( "wxREADONLY",                      wxHIDE_READONLY );
    wCreateNumConst( "wxFILE_MUST_EXIST",               wxFILE_MUST_EXIST );
    wCreateNumConst( "wxMULTIPLE",                      wxMULTIPLE );
    wCreateNumConst( "wxCHANGE_DIR",                    wxCHANGE_DIR );


    /* from GDICMN.CPP */
    wCreatePtrConst( "wxNORMAL_FONT",        _wxFont,    (int)wxNORMAL_FONT );
    wCreatePtrConst( "wxSMALL_FONT",         _wxFont,    (int)wxSMALL_FONT );
    wCreatePtrConst( "wxITALIC_FONT",        _wxFont,    (int)wxITALIC_FONT );
    wCreatePtrConst( "wxSWISS_FONT",         _wxFont,    (int)wxSWISS_FONT );

    wCreatePtrConst( "wxRED_PEN",           _wxPen,     (int)wxRED_PEN );
    wCreatePtrConst( "wxCYAN_PEN",          _wxPen,     (int)wxCYAN_PEN );
    wCreatePtrConst( "wxGREEN_PEN",         _wxPen,     (int)wxGREEN_PEN );
    wCreatePtrConst( "wxBLACK_PEN",         _wxPen,     (int)wxBLACK_PEN );
    wCreatePtrConst( "wxWHITE_PEN",         _wxPen,     (int)wxWHITE_PEN );
    wCreatePtrConst( "wxTRANSPARENT_PEN",   _wxPen,     (int)wxTRANSPARENT_PEN );
    wCreatePtrConst( "wxBLACK_DASHED_PEN",  _wxPen,     (int)wxBLACK_DASHED_PEN );
    wCreatePtrConst( "wxGREY_PEN",          _wxPen,     (int)wxGREY_PEN );
    wCreatePtrConst( "wxMEDIUM_GREY_PEN",   _wxPen,     (int)wxMEDIUM_GREY_PEN );
    wCreatePtrConst( "wxLIGHT_GREY_PEN",    _wxPen,     (int)wxLIGHT_GREY_PEN );

    wCreatePtrConst( "wxBLUE_BRUSH",        _wxBrush,   (int)wxBLUE_BRUSH );
    wCreatePtrConst( "wxGREEN_BRUSH",       _wxBrush,   (int)wxGREEN_BRUSH );
    wCreatePtrConst( "wxWHITE_BRUSH",       _wxBrush,   (int)wxWHITE_BRUSH );
    wCreatePtrConst( "wxBLACK_BRUSH",       _wxBrush,   (int)wxBLACK_BRUSH );
    wCreatePtrConst( "wxTRANSPARENT_BRUSH", _wxBrush,   (int)wxTRANSPARENT_BRUSH );
    wCreatePtrConst( "wxCYAN_BRUSH",        _wxBrush,   (int)wxCYAN_BRUSH );
    wCreatePtrConst( "wxRED_BRUSH",         _wxBrush,   (int)wxRED_BRUSH );
    wCreatePtrConst( "wxGREY_BRUSH",        _wxBrush,   (int)wxGREY_BRUSH );
    wCreatePtrConst( "wxMEDIUM_GREY_BRUSH", _wxBrush,   (int)wxMEDIUM_GREY_BRUSH );
    wCreatePtrConst( "wxLIGHT_GREY_BRUSH",  _wxBrush,   (int)wxLIGHT_GREY_BRUSH );

    wCreatePtrConst( "wxBLACK",             _wxColour,  (int)wxBLACK );
    wCreatePtrConst( "wxWHITE",             _wxColour,  (int)wxWHITE );
    wCreatePtrConst( "wxRED",               _wxColour,  (int)wxRED );
    wCreatePtrConst( "wxBLUE",              _wxColour,  (int)wxBLUE );
    wCreatePtrConst( "wxGREEN",             _wxColour,  (int)wxGREEN );
    wCreatePtrConst( "wxCYAN",              _wxColour,  (int)wxCYAN );
    wCreatePtrConst( "wxLIGHT_GREY",        _wxColour,  (int)wxLIGHT_GREY );
    wCreatePtrConst( "wxSTANDARD_CURSOR",   _wxCursor,  (int)wxSTANDARD_CURSOR );
    wCreatePtrConst( "wxHOURGLASS_CURSOR",  _wxCursor,  (int)wxHOURGLASS_CURSOR );
    wCreatePtrConst( "wxCROSS_CURSOR",      _wxCursor,  (int)wxCROSS_CURSOR );

    /* From GL.H */
    wCreateNumConst("GL_VERSION_1_1",           GL_VERSION_1_1);
    wCreateNumConst("GL_ACCUM",                 GL_ACCUM);
    wCreateNumConst("GL_LOAD",                  GL_LOAD);
    wCreateNumConst("GL_RETURN",                GL_RETURN);
    wCreateNumConst("GL_MULT",                  GL_MULT);
    wCreateNumConst("GL_NEVER",                 GL_NEVER);
    wCreateNumConst("GL_LESS",                  GL_LESS);
    wCreateNumConst("GL_EQUAL",                 GL_EQUAL);
    wCreateNumConst("GL_LEQUAL",                GL_LEQUAL);
    wCreateNumConst("GL_GREATER",               GL_GREATER);
    wCreateNumConst("GL_NOTEQUAL",              GL_NOTEQUAL);
    wCreateNumConst("GL_GEQUAL",                GL_GEQUAL);
    wCreateNumConst("GL_ALWAYS",                GL_ALWAYS);
    wCreateNumConst("GL_CURRENT_BIT",           GL_CURRENT_BIT);
    wCreateNumConst("GL_POINT_BIT",             GL_POINT_BIT);
    wCreateNumConst("GL_LINE_BIT",              GL_LINE_BIT);
    wCreateNumConst("GL_POLYGON_BIT",           GL_POLYGON_BIT);
    wCreateNumConst("GL_POLYGON_STIPPLE_BIT",   GL_POLYGON_STIPPLE_BIT);
    wCreateNumConst("GL_PIXEL_MODE_BIT",        GL_PIXEL_MODE_BIT);
    wCreateNumConst("GL_LIGHTING_BIT",          GL_LIGHTING_BIT);
    wCreateNumConst("GL_FOG_BIT",               GL_FOG_BIT);
    wCreateNumConst("GL_DEPTH_BUFFER_BIT",      GL_DEPTH_BUFFER_BIT);
    wCreateNumConst("GL_ACCUM_BUFFER_BIT",      GL_ACCUM_BUFFER_BIT);
    wCreateNumConst("GL_STENCIL_BUFFER_BIT",    GL_STENCIL_BUFFER_BIT);
    wCreateNumConst("GL_VIEWPORT_BIT",          GL_VIEWPORT_BIT);
    wCreateNumConst("GL_TRANSFORM_BIT",         GL_TRANSFORM_BIT);
    wCreateNumConst("GL_ENABLE_BIT",            GL_ENABLE_BIT);
    wCreateNumConst("GL_COLOR_BUFFER_BIT",      GL_COLOR_BUFFER_BIT);
    wCreateNumConst("GL_HINT_BIT",              GL_HINT_BIT);
    wCreateNumConst("GL_EVAL_BIT",              GL_EVAL_BIT);
    wCreateNumConst("GL_LIST_BIT",              GL_LIST_BIT);
    wCreateNumConst("GL_TEXTURE_BIT",           GL_TEXTURE_BIT);
    wCreateNumConst("GL_SCISSOR_BIT",           GL_SCISSOR_BIT);
    wCreateNumConst("GL_ALL_ATTRIB_BITS",       GL_ALL_ATTRIB_BITS);
    wCreateNumConst("GL_POINTS",                GL_POINTS);
    wCreateNumConst("GL_LINES",                 GL_LINES);
    wCreateNumConst("GL_LINE_LOOP",             GL_LINE_LOOP);
    wCreateNumConst("GL_LINE_STRIP",            GL_LINE_STRIP);
    wCreateNumConst("GL_TRIANGLES",             GL_TRIANGLES);
    wCreateNumConst("GL_TRIANGLE_STRIP",        GL_TRIANGLE_STRIP);
    wCreateNumConst("GL_TRIANGLE_FAN",          GL_TRIANGLE_FAN);
    wCreateNumConst("GL_QUADS",                 GL_QUADS);
    wCreateNumConst("GL_QUAD_STRIP",            GL_QUAD_STRIP);
    wCreateNumConst("GL_POLYGON",               GL_POLYGON);
    wCreateNumConst("GL_ZERO",                  GL_ZERO);
    wCreateNumConst("GL_ONE",                   GL_ONE);
    wCreateNumConst("GL_SRC_COLOR",             GL_SRC_COLOR);
    wCreateNumConst("GL_ONE_MINUS_SRC_COLOR",   GL_ONE_MINUS_SRC_COLOR);
    wCreateNumConst("GL_SRC_ALPHA",             GL_SRC_ALPHA);
    wCreateNumConst("GL_ONE_MINUS_SRC_ALPHA",   GL_ONE_MINUS_SRC_ALPHA);
    wCreateNumConst("GL_DST_ALPHA",             GL_DST_ALPHA);
    wCreateNumConst("GL_ONE_MINUS_DST_ALPHA",   GL_ONE_MINUS_DST_ALPHA);
    wCreateNumConst("GL_DST_COLOR",             GL_DST_COLOR);
    wCreateNumConst("GL_ONE_MINUS_DST_COLOR",   GL_ONE_MINUS_DST_COLOR);
    wCreateNumConst("GL_SRC_ALPHA_SATURATE",    GL_SRC_ALPHA_SATURATE);
    wCreateNumConst("GL_TRUE",                  GL_TRUE);
    wCreateNumConst("GL_FALSE",                 GL_FALSE);
    wCreateNumConst("GL_CLIP_PLANE0",           GL_CLIP_PLANE0);
    wCreateNumConst("GL_CLIP_PLANE1",           GL_CLIP_PLANE1);
    wCreateNumConst("GL_CLIP_PLANE2",           GL_CLIP_PLANE2);
    wCreateNumConst("GL_CLIP_PLANE3",           GL_CLIP_PLANE3);
    wCreateNumConst("GL_CLIP_PLANE4",           GL_CLIP_PLANE4);
    wCreateNumConst("GL_CLIP_PLANE5",           GL_CLIP_PLANE5);
    wCreateNumConst("GL_BYTE",                  GL_BYTE);
    wCreateNumConst("GL_UNSIGNED_BYTE",         GL_UNSIGNED_BYTE);
    wCreateNumConst("GL_SHORT",                 GL_SHORT);
    wCreateNumConst("GL_UNSIGNED_SHORT",        GL_UNSIGNED_SHORT);
    wCreateNumConst("GL_INT",                   GL_INT);
    wCreateNumConst("GL_UNSIGNED_INT",          GL_UNSIGNED_INT);
    wCreateNumConst("GL_FLOAT",                 GL_FLOAT);
    wCreateNumConst("GL_2_BYTES",               GL_2_BYTES);
    wCreateNumConst("GL_3_BYTES",               GL_3_BYTES);
    wCreateNumConst("GL_4_BYTES",               GL_4_BYTES);
    wCreateNumConst("GL_DOUBLE",                GL_DOUBLE);
    wCreateNumConst("GL_NONE",                  GL_NONE);
    wCreateNumConst("GL_FRONT_LEFT",            GL_FRONT_LEFT);
    wCreateNumConst("GL_FRONT_RIGHT",           GL_FRONT_RIGHT);
    wCreateNumConst("GL_BACK_LEFT",             GL_BACK_LEFT);
    wCreateNumConst("GL_BACK_RIGHT",            GL_BACK_RIGHT);
    wCreateNumConst("GL_FRONT",                 GL_FRONT);
    wCreateNumConst("GL_BACK",                  GL_BACK);
    wCreateNumConst("GL_LEFT",                  GL_LEFT);
    wCreateNumConst("GL_RIGHT",                 GL_RIGHT);
    wCreateNumConst("GL_FRONT_AND_BACK",        GL_FRONT_AND_BACK);
    wCreateNumConst("GL_AUX0",                  GL_AUX0);
    wCreateNumConst("GL_AUX1",                  GL_AUX1);
    wCreateNumConst("GL_AUX2",                  GL_AUX2);
    wCreateNumConst("GL_AUX3",                  GL_AUX3);
    wCreateNumConst("GL_NO_ERROR",              GL_NO_ERROR);
    wCreateNumConst("GL_INVALID_ENUM",          GL_INVALID_ENUM);
    wCreateNumConst("GL_INVALID_VALUE",         GL_INVALID_VALUE);
    wCreateNumConst("GL_INVALID_OPERATION",     GL_INVALID_OPERATION);
    wCreateNumConst("GL_STACK_OVERFLOW",        GL_STACK_OVERFLOW);
    wCreateNumConst("GL_STACK_UNDERFLOW",       GL_STACK_UNDERFLOW);
    wCreateNumConst("GL_OUT_OF_MEMORY",         GL_OUT_OF_MEMORY);
    wCreateNumConst("GL_2D",                    GL_2D);
    wCreateNumConst("GL_3D",                    GL_3D);
    wCreateNumConst("GL_3D_COLOR",              GL_3D_COLOR);
    wCreateNumConst("GL_3D_COLOR_TEXTURE",      GL_3D_COLOR_TEXTURE);
    wCreateNumConst("GL_4D_COLOR_TEXTURE",      GL_4D_COLOR_TEXTURE);
    wCreateNumConst("GL_PASS_THROUGH_TOKEN",    GL_PASS_THROUGH_TOKEN);
    wCreateNumConst("GL_POINT_TOKEN",           GL_POINT_TOKEN);
    wCreateNumConst("GL_LINE_TOKEN",            GL_LINE_TOKEN);
    wCreateNumConst("GL_POLYGON_TOKEN",         GL_POLYGON_TOKEN);
    wCreateNumConst("GL_BITMAP_TOKEN",          GL_BITMAP_TOKEN);
    wCreateNumConst("GL_DRAW_PIXEL_TOKEN",      GL_DRAW_PIXEL_TOKEN);
    wCreateNumConst("GL_COPY_PIXEL_TOKEN",      GL_COPY_PIXEL_TOKEN);
    wCreateNumConst("GL_LINE_RESET_TOKEN",      GL_LINE_RESET_TOKEN);
    wCreateNumConst("GL_EXP",                   GL_EXP);
    wCreateNumConst("GL_EXP2",                  GL_EXP2);
    wCreateNumConst("GL_CW",                    GL_CW);
    wCreateNumConst("GL_CCW",                   GL_CCW);
    wCreateNumConst("GL_COEFF",                 GL_COEFF);
    wCreateNumConst("GL_ORDER",                 GL_ORDER);
    wCreateNumConst("GL_DOMAIN",                GL_DOMAIN);
    wCreateNumConst("GL_CURRENT_COLOR",         GL_CURRENT_COLOR);
    wCreateNumConst("GL_CURRENT_INDEX",         GL_CURRENT_INDEX);
    wCreateNumConst("GL_CURRENT_NORMAL",        GL_CURRENT_NORMAL);
    wCreateNumConst("GL_CURRENT_TEXTURE_COORDS", GL_CURRENT_TEXTURE_COORDS);
    wCreateNumConst("GL_CURRENT_RASTER_COLOR",  GL_CURRENT_RASTER_COLOR);
    wCreateNumConst("GL_CURRENT_RASTER_INDEX",  GL_CURRENT_RASTER_INDEX);
    wCreateNumConst("GL_CURRENT_RASTER_TEXTURE_COORDS", GL_CURRENT_RASTER_TEXTURE_COORDS);
    wCreateNumConst("GL_CURRENT_RASTER_POSITION",       GL_CURRENT_RASTER_POSITION);
    wCreateNumConst("GL_CURRENT_RASTER_POSITION_VALID", GL_CURRENT_RASTER_POSITION_VALID);
    wCreateNumConst("GL_CURRENT_RASTER_DISTANCE",       GL_CURRENT_RASTER_DISTANCE);
    wCreateNumConst("GL_POINT_SMOOTH",          GL_POINT_SMOOTH);
    wCreateNumConst("GL_POINT_SIZE",            GL_POINT_SIZE);
    wCreateNumConst("GL_POINT_SIZE_RANGE",      GL_POINT_SIZE_RANGE);
    wCreateNumConst("GL_POINT_SIZE_GRANULARITY",GL_POINT_SIZE_GRANULARITY);
    wCreateNumConst("GL_LINE_SMOOTH",           GL_LINE_SMOOTH);
    wCreateNumConst("GL_LINE_WIDTH",            GL_LINE_WIDTH);
    wCreateNumConst("GL_LINE_WIDTH_RANGE",      GL_LINE_WIDTH_RANGE);
    wCreateNumConst("GL_LINE_WIDTH_GRANULARITY",GL_LINE_WIDTH_GRANULARITY);
    wCreateNumConst("GL_LINE_STIPPLE",          GL_LINE_STIPPLE);
    wCreateNumConst("GL_LINE_STIPPLE_PATTERN",  GL_LINE_STIPPLE_PATTERN);
    wCreateNumConst("GL_LINE_STIPPLE_REPEAT",   GL_LINE_STIPPLE_REPEAT);
    wCreateNumConst("GL_LIST_MODE",             GL_LIST_MODE);
    wCreateNumConst("GL_MAX_LIST_NESTING",      GL_MAX_LIST_NESTING);
    wCreateNumConst("GL_LIST_BASE",             GL_LIST_BASE);
    wCreateNumConst("GL_LIST_INDEX",            GL_LIST_INDEX);
    wCreateNumConst("GL_POLYGON_MODE",          GL_POLYGON_MODE);
    wCreateNumConst("GL_POLYGON_SMOOTH",        GL_POLYGON_SMOOTH);
    wCreateNumConst("GL_POLYGON_STIPPLE",       GL_POLYGON_STIPPLE);
    wCreateNumConst("GL_EDGE_FLAG",             GL_EDGE_FLAG);
    wCreateNumConst("GL_CULL_FACE",             GL_CULL_FACE);
    wCreateNumConst("GL_CULL_FACE_MODE",        GL_CULL_FACE_MODE);
    wCreateNumConst("GL_FRONT_FACE",            GL_FRONT_FACE);
    wCreateNumConst("GL_LIGHTING",              GL_LIGHTING);
    wCreateNumConst("GL_LIGHT_MODEL_LOCAL_VIEWER",  GL_LIGHT_MODEL_LOCAL_VIEWER);
    wCreateNumConst("GL_LIGHT_MODEL_TWO_SIDE",      GL_LIGHT_MODEL_TWO_SIDE);
    wCreateNumConst("GL_LIGHT_MODEL_AMBIENT",       GL_LIGHT_MODEL_AMBIENT);
    wCreateNumConst("GL_SHADE_MODEL",           GL_SHADE_MODEL);
    wCreateNumConst("GL_COLOR_MATERIAL_FACE",   GL_COLOR_MATERIAL_FACE);
    wCreateNumConst("GL_COLOR_MATERIAL_PARAMETER",  GL_COLOR_MATERIAL_PARAMETER);
    wCreateNumConst("GL_COLOR_MATERIAL",        GL_COLOR_MATERIAL);
    wCreateNumConst("GL_FOG",                   GL_FOG);
    wCreateNumConst("GL_FOG_INDEX",             GL_FOG_INDEX);
    wCreateNumConst("GL_FOG_DENSITY",           GL_FOG_DENSITY);
    wCreateNumConst("GL_FOG_START",             GL_FOG_START);
    wCreateNumConst("GL_FOG_END",               GL_FOG_END);
    wCreateNumConst("GL_FOG_MODE",              GL_FOG_MODE);
    wCreateNumConst("GL_FOG_COLOR",             GL_FOG_COLOR);
    wCreateNumConst("GL_DEPTH_RANGE",           GL_DEPTH_RANGE);
    wCreateNumConst("GL_DEPTH_TEST",            GL_DEPTH_TEST);
    wCreateNumConst("GL_DEPTH_WRITEMASK",       GL_DEPTH_WRITEMASK);
    wCreateNumConst("GL_DEPTH_CLEAR_VALUE",     GL_DEPTH_CLEAR_VALUE);
    wCreateNumConst("GL_DEPTH_FUNC",            GL_DEPTH_FUNC);
    wCreateNumConst("GL_ACCUM_CLEAR_VALUE",     GL_ACCUM_CLEAR_VALUE);
    wCreateNumConst("GL_STENCIL_TEST",          GL_STENCIL_TEST);
    wCreateNumConst("GL_STENCIL_CLEAR_VALUE",   GL_STENCIL_CLEAR_VALUE);
    wCreateNumConst("GL_STENCIL_FUNC",          GL_STENCIL_FUNC);
    wCreateNumConst("GL_STENCIL_VALUE_MASK",    GL_STENCIL_VALUE_MASK);
    wCreateNumConst("GL_STENCIL_FAIL",          GL_STENCIL_FAIL);
    wCreateNumConst("GL_STENCIL_PASS_DEPTH_FAIL",   GL_STENCIL_PASS_DEPTH_FAIL);
    wCreateNumConst("GL_STENCIL_PASS_DEPTH_PASS",   GL_STENCIL_PASS_DEPTH_PASS);
    wCreateNumConst("GL_STENCIL_REF",           GL_STENCIL_REF);
    wCreateNumConst("GL_STENCIL_WRITEMASK",     GL_STENCIL_WRITEMASK);
    wCreateNumConst("GL_MATRIX_MODE",           GL_MATRIX_MODE);
    wCreateNumConst("GL_NORMALIZE",             GL_NORMALIZE);
    wCreateNumConst("GL_VIEWPORT",              GL_VIEWPORT);
    wCreateNumConst("GL_MODELVIEW_STACK_DEPTH", GL_MODELVIEW_STACK_DEPTH);
    wCreateNumConst("GL_PROJECTION_STACK_DEPTH",GL_PROJECTION_STACK_DEPTH);
    wCreateNumConst("GL_TEXTURE_STACK_DEPTH",   GL_TEXTURE_STACK_DEPTH);
    wCreateNumConst("GL_MODELVIEW_MATRIX",      GL_MODELVIEW_MATRIX);
    wCreateNumConst("GL_PROJECTION_MATRIX",     GL_PROJECTION_MATRIX);
    wCreateNumConst("GL_TEXTURE_MATRIX",        GL_TEXTURE_MATRIX);
    wCreateNumConst("GL_ATTRIB_STACK_DEPTH",    GL_ATTRIB_STACK_DEPTH);
    wCreateNumConst("GL_CLIENT_ATTRIB_STACK_DEPTH",     GL_CLIENT_ATTRIB_STACK_DEPTH);
    wCreateNumConst("GL_ALPHA_TEST",            GL_ALPHA_TEST);
    wCreateNumConst("GL_ALPHA_TEST_FUNC",       GL_ALPHA_TEST_FUNC);
    wCreateNumConst("GL_ALPHA_TEST_REF",        GL_ALPHA_TEST_REF);
    wCreateNumConst("GL_DITHER",                GL_DITHER);
    wCreateNumConst("GL_BLEND_DST",             GL_BLEND_DST);
    wCreateNumConst("GL_BLEND_SRC",             GL_BLEND_SRC);
    wCreateNumConst("GL_BLEND",                 GL_BLEND);
    wCreateNumConst("GL_LOGIC_OP_MODE",         GL_LOGIC_OP_MODE);
    wCreateNumConst("GL_INDEX_LOGIC_OP",        GL_INDEX_LOGIC_OP);
    wCreateNumConst("GL_COLOR_LOGIC_OP",        GL_COLOR_LOGIC_OP);
    wCreateNumConst("GL_AUX_BUFFERS",           GL_AUX_BUFFERS);
    wCreateNumConst("GL_DRAW_BUFFER",           GL_DRAW_BUFFER);
    wCreateNumConst("GL_READ_BUFFER",           GL_READ_BUFFER);
    wCreateNumConst("GL_SCISSOR_BOX",           GL_SCISSOR_BOX);
    wCreateNumConst("GL_SCISSOR_TEST",          GL_SCISSOR_TEST);
    wCreateNumConst("GL_INDEX_CLEAR_VALUE",     GL_INDEX_CLEAR_VALUE);
    wCreateNumConst("GL_INDEX_WRITEMASK",       GL_INDEX_WRITEMASK);
    wCreateNumConst("GL_COLOR_CLEAR_VALUE",     GL_COLOR_CLEAR_VALUE);
    wCreateNumConst("GL_COLOR_WRITEMASK",       GL_COLOR_WRITEMASK);
    wCreateNumConst("GL_INDEX_MODE",            GL_INDEX_MODE);
    wCreateNumConst("GL_RGBA_MODE",             GL_RGBA_MODE);
    wCreateNumConst("GL_DOUBLEBUFFER",          GL_DOUBLEBUFFER);
    wCreateNumConst("GL_STEREO",                GL_STEREO);
    wCreateNumConst("GL_RENDER_MODE",           GL_RENDER_MODE);
    wCreateNumConst("GL_PERSPECTIVE_CORRECTION_HINT",   GL_PERSPECTIVE_CORRECTION_HINT);
    wCreateNumConst("GL_POINT_SMOOTH_HINT",     GL_POINT_SMOOTH_HINT);
    wCreateNumConst("GL_LINE_SMOOTH_HINT",      GL_LINE_SMOOTH_HINT);
    wCreateNumConst("GL_POLYGON_SMOOTH_HINT",   GL_POLYGON_SMOOTH_HINT);
    wCreateNumConst("GL_FOG_HINT",              GL_FOG_HINT);
    wCreateNumConst("GL_TEXTURE_GEN_S",         GL_TEXTURE_GEN_S);
    wCreateNumConst("GL_TEXTURE_GEN_T",         GL_TEXTURE_GEN_T);
    wCreateNumConst("GL_TEXTURE_GEN_R",         GL_TEXTURE_GEN_R);
    wCreateNumConst("GL_TEXTURE_GEN_Q",         GL_TEXTURE_GEN_Q);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_I",      GL_PIXEL_MAP_I_TO_I);
    wCreateNumConst("GL_PIXEL_MAP_S_TO_S",      GL_PIXEL_MAP_S_TO_S);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_R",      GL_PIXEL_MAP_I_TO_R);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_G",      GL_PIXEL_MAP_I_TO_G);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_B",      GL_PIXEL_MAP_I_TO_B);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_A",      GL_PIXEL_MAP_I_TO_A);
    wCreateNumConst("GL_PIXEL_MAP_R_TO_R",      GL_PIXEL_MAP_R_TO_R);
    wCreateNumConst("GL_PIXEL_MAP_G_TO_G",      GL_PIXEL_MAP_G_TO_G);
    wCreateNumConst("GL_PIXEL_MAP_B_TO_B",      GL_PIXEL_MAP_B_TO_B);
    wCreateNumConst("GL_PIXEL_MAP_A_TO_A",      GL_PIXEL_MAP_A_TO_A);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_I_SIZE", GL_PIXEL_MAP_I_TO_I_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_S_TO_S_SIZE", GL_PIXEL_MAP_S_TO_S_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_R_SIZE", GL_PIXEL_MAP_I_TO_R_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_G_SIZE", GL_PIXEL_MAP_I_TO_G_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_B_SIZE", GL_PIXEL_MAP_I_TO_B_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_I_TO_A_SIZE", GL_PIXEL_MAP_I_TO_A_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_R_TO_R_SIZE", GL_PIXEL_MAP_R_TO_R_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_G_TO_G_SIZE", GL_PIXEL_MAP_G_TO_G_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_B_TO_B_SIZE", GL_PIXEL_MAP_B_TO_B_SIZE);
    wCreateNumConst("GL_PIXEL_MAP_A_TO_A_SIZE", GL_PIXEL_MAP_A_TO_A_SIZE);
    wCreateNumConst("GL_UNPACK_SWAP_BYTES",     GL_UNPACK_SWAP_BYTES);
    wCreateNumConst("GL_UNPACK_LSB_FIRST",      GL_UNPACK_LSB_FIRST);
    wCreateNumConst("GL_UNPACK_ROW_LENGTH",     GL_UNPACK_ROW_LENGTH);
    wCreateNumConst("GL_UNPACK_SKIP_ROWS",      GL_UNPACK_SKIP_ROWS);
    wCreateNumConst("GL_UNPACK_SKIP_PIXELS",    GL_UNPACK_SKIP_PIXELS);
    wCreateNumConst("GL_UNPACK_ALIGNMENT",      GL_UNPACK_ALIGNMENT);
    wCreateNumConst("GL_PACK_SWAP_BYTES",       GL_PACK_SWAP_BYTES);
    wCreateNumConst("GL_PACK_LSB_FIRST",        GL_PACK_LSB_FIRST);
    wCreateNumConst("GL_PACK_ROW_LENGTH",       GL_PACK_ROW_LENGTH);
    wCreateNumConst("GL_PACK_SKIP_ROWS",        GL_PACK_SKIP_ROWS);
    wCreateNumConst("GL_PACK_SKIP_PIXELS",      GL_PACK_SKIP_PIXELS);
    wCreateNumConst("GL_PACK_ALIGNMENT",        GL_PACK_ALIGNMENT);
    wCreateNumConst("GL_MAP_COLOR",             GL_MAP_COLOR);
    wCreateNumConst("GL_MAP_STENCIL",           GL_MAP_STENCIL);
    wCreateNumConst("GL_INDEX_SHIFT",           GL_INDEX_SHIFT);
    wCreateNumConst("GL_INDEX_OFFSET",          GL_INDEX_OFFSET);
    wCreateNumConst("GL_RED_SCALE",             GL_RED_SCALE);
    wCreateNumConst("GL_RED_BIAS",              GL_RED_BIAS);
    wCreateNumConst("GL_ZOOM_X",                GL_ZOOM_X);
    wCreateNumConst("GL_ZOOM_Y",                GL_ZOOM_Y);
    wCreateNumConst("GL_GREEN_SCALE",           GL_GREEN_SCALE);
    wCreateNumConst("GL_GREEN_BIAS",            GL_GREEN_BIAS);
    wCreateNumConst("GL_BLUE_SCALE",            GL_BLUE_SCALE);
    wCreateNumConst("GL_BLUE_BIAS",             GL_BLUE_BIAS);
    wCreateNumConst("GL_ALPHA_SCALE",           GL_ALPHA_SCALE);
    wCreateNumConst("GL_ALPHA_BIAS",            GL_ALPHA_BIAS);
    wCreateNumConst("GL_DEPTH_SCALE",           GL_DEPTH_SCALE);
    wCreateNumConst("GL_DEPTH_BIAS",            GL_DEPTH_BIAS);
    wCreateNumConst("GL_MAX_EVAL_ORDER",        GL_MAX_EVAL_ORDER);
    wCreateNumConst("GL_MAX_LIGHTS",            GL_MAX_LIGHTS);
    wCreateNumConst("GL_MAX_CLIP_PLANES",       GL_MAX_CLIP_PLANES);
    wCreateNumConst("GL_MAX_TEXTURE_SIZE",      GL_MAX_TEXTURE_SIZE);
    wCreateNumConst("GL_MAX_PIXEL_MAP_TABLE",   GL_MAX_PIXEL_MAP_TABLE);
    wCreateNumConst("GL_MAX_ATTRIB_STACK_DEPTH",    GL_MAX_ATTRIB_STACK_DEPTH);
    wCreateNumConst("GL_MAX_MODELVIEW_STACK_DEPTH", GL_MAX_MODELVIEW_STACK_DEPTH);
    wCreateNumConst("GL_MAX_NAME_STACK_DEPTH",      GL_MAX_NAME_STACK_DEPTH);
    wCreateNumConst("GL_MAX_PROJECTION_STACK_DEPTH",GL_MAX_PROJECTION_STACK_DEPTH);
    wCreateNumConst("GL_MAX_TEXTURE_STACK_DEPTH",   GL_MAX_TEXTURE_STACK_DEPTH);
    wCreateNumConst("GL_MAX_VIEWPORT_DIMS",         GL_MAX_VIEWPORT_DIMS);
    wCreateNumConst("GL_MAX_CLIENT_ATTRIB_STACK_DEPTH", GL_MAX_CLIENT_ATTRIB_STACK_DEPTH);
    wCreateNumConst("GL_SUBPIXEL_BITS",         GL_SUBPIXEL_BITS);
    wCreateNumConst("GL_INDEX_BITS",            GL_INDEX_BITS);
    wCreateNumConst("GL_RED_BITS",              GL_RED_BITS);
    wCreateNumConst("GL_GREEN_BITS",            GL_GREEN_BITS);
    wCreateNumConst("GL_BLUE_BITS",             GL_BLUE_BITS);
    wCreateNumConst("GL_ALPHA_BITS",            GL_ALPHA_BITS);
    wCreateNumConst("GL_DEPTH_BITS",            GL_DEPTH_BITS);
    wCreateNumConst("GL_STENCIL_BITS",          GL_STENCIL_BITS);
    wCreateNumConst("GL_ACCUM_RED_BITS",        GL_ACCUM_RED_BITS);
    wCreateNumConst("GL_ACCUM_GREEN_BITS",      GL_ACCUM_GREEN_BITS);
    wCreateNumConst("GL_ACCUM_BLUE_BITS",       GL_ACCUM_BLUE_BITS);
    wCreateNumConst("GL_ACCUM_ALPHA_BITS",      GL_ACCUM_ALPHA_BITS);
    wCreateNumConst("GL_NAME_STACK_DEPTH",      GL_NAME_STACK_DEPTH);
    wCreateNumConst("GL_AUTO_NORMAL",           GL_AUTO_NORMAL);
    wCreateNumConst("GL_MAP1_COLOR_4",          GL_MAP1_COLOR_4);
    wCreateNumConst("GL_MAP1_INDEX",            GL_MAP1_INDEX);
    wCreateNumConst("GL_MAP1_NORMAL",           GL_MAP1_NORMAL);
    wCreateNumConst("GL_MAP1_TEXTURE_COORD_1",  GL_MAP1_TEXTURE_COORD_1);
    wCreateNumConst("GL_MAP1_TEXTURE_COORD_2",  GL_MAP1_TEXTURE_COORD_2);
    wCreateNumConst("GL_MAP1_TEXTURE_COORD_3",  GL_MAP1_TEXTURE_COORD_3);
    wCreateNumConst("GL_MAP1_TEXTURE_COORD_4",  GL_MAP1_TEXTURE_COORD_4);
    wCreateNumConst("GL_MAP1_VERTEX_3",         GL_MAP1_VERTEX_3);
    wCreateNumConst("GL_MAP1_VERTEX_4",         GL_MAP1_VERTEX_4);
    wCreateNumConst("GL_MAP2_COLOR_4",          GL_MAP2_COLOR_4);
    wCreateNumConst("GL_MAP2_INDEX",            GL_MAP2_INDEX);
    wCreateNumConst("GL_MAP2_NORMAL",           GL_MAP2_NORMAL);
    wCreateNumConst("GL_MAP2_TEXTURE_COORD_1",  GL_MAP2_TEXTURE_COORD_1);
    wCreateNumConst("GL_MAP2_TEXTURE_COORD_2",  GL_MAP2_TEXTURE_COORD_2);
    wCreateNumConst("GL_MAP2_TEXTURE_COORD_3",  GL_MAP2_TEXTURE_COORD_3);
    wCreateNumConst("GL_MAP2_TEXTURE_COORD_4",  GL_MAP2_TEXTURE_COORD_4);
    wCreateNumConst("GL_MAP2_VERTEX_3",         GL_MAP2_VERTEX_3);
    wCreateNumConst("GL_MAP2_VERTEX_4",         GL_MAP2_VERTEX_4);
    wCreateNumConst("GL_MAP1_GRID_DOMAIN",      GL_MAP1_GRID_DOMAIN);
    wCreateNumConst("GL_MAP1_GRID_SEGMENTS",    GL_MAP1_GRID_SEGMENTS);
    wCreateNumConst("GL_MAP2_GRID_DOMAIN",      GL_MAP2_GRID_DOMAIN);
    wCreateNumConst("GL_MAP2_GRID_SEGMENTS",    GL_MAP2_GRID_SEGMENTS);
    wCreateNumConst("GL_TEXTURE_1D",            GL_TEXTURE_1D);
    wCreateNumConst("GL_TEXTURE_2D",            GL_TEXTURE_2D);
    wCreateNumConst("GL_FEEDBACK_BUFFER_POINTER",   GL_FEEDBACK_BUFFER_POINTER);
    wCreateNumConst("GL_FEEDBACK_BUFFER_SIZE",      GL_FEEDBACK_BUFFER_SIZE);
    wCreateNumConst("GL_FEEDBACK_BUFFER_TYPE",      GL_FEEDBACK_BUFFER_TYPE);
    wCreateNumConst("GL_SELECTION_BUFFER_POINTER",  GL_SELECTION_BUFFER_POINTER);
    wCreateNumConst("GL_SELECTION_BUFFER_SIZE",     GL_SELECTION_BUFFER_SIZE);
    wCreateNumConst("GL_TEXTURE_WIDTH",             GL_TEXTURE_WIDTH);
    wCreateNumConst("GL_TEXTURE_HEIGHT",            GL_TEXTURE_HEIGHT);
    wCreateNumConst("GL_TEXTURE_INTERNAL_FORMAT",   GL_TEXTURE_INTERNAL_FORMAT);
    wCreateNumConst("GL_TEXTURE_BORDER_COLOR",      GL_TEXTURE_BORDER_COLOR);
    wCreateNumConst("GL_TEXTURE_BORDER",            GL_TEXTURE_BORDER);
    wCreateNumConst("GL_DONT_CARE",                 GL_DONT_CARE);
    wCreateNumConst("GL_FASTEST",                   GL_FASTEST);
    wCreateNumConst("GL_NICEST",                    GL_NICEST);
    wCreateNumConst("GL_LIGHT0",                    GL_LIGHT0);
    wCreateNumConst("GL_LIGHT1",                    GL_LIGHT1);
    wCreateNumConst("GL_LIGHT2",                    GL_LIGHT2);
    wCreateNumConst("GL_LIGHT3",                    GL_LIGHT3);
    wCreateNumConst("GL_LIGHT4",                    GL_LIGHT4);
    wCreateNumConst("GL_LIGHT5",      GL_LIGHT5);
    wCreateNumConst("GL_LIGHT6",      GL_LIGHT6);
    wCreateNumConst("GL_LIGHT7",      GL_LIGHT7);
    wCreateNumConst("GL_AMBIENT",      GL_AMBIENT);
    wCreateNumConst("GL_DIFFUSE",      GL_DIFFUSE);
    wCreateNumConst("GL_SPECULAR",      GL_SPECULAR);
    wCreateNumConst("GL_POSITION",      GL_POSITION);
    wCreateNumConst("GL_SPOT_DIRECTION",      GL_SPOT_DIRECTION);
    wCreateNumConst("GL_SPOT_EXPONENT",      GL_SPOT_EXPONENT);
    wCreateNumConst("GL_SPOT_CUTOFF",      GL_SPOT_CUTOFF);
    wCreateNumConst("GL_CONSTANT_ATTENUATION",      GL_CONSTANT_ATTENUATION);
    wCreateNumConst("GL_LINEAR_ATTENUATION",      GL_LINEAR_ATTENUATION);
    wCreateNumConst("GL_QUADRATIC_ATTENUATION",      GL_QUADRATIC_ATTENUATION);
    wCreateNumConst("GL_COMPILE",      GL_COMPILE);
    wCreateNumConst("GL_COMPILE_AND_EXECUTE",      GL_COMPILE_AND_EXECUTE);
    wCreateNumConst("GL_CLEAR",      GL_CLEAR);
    wCreateNumConst("GL_AND",      GL_AND);
    wCreateNumConst("GL_AND_REVERSE",      GL_AND_REVERSE);
    wCreateNumConst("GL_COPY",      GL_COPY);
    wCreateNumConst("GL_AND_INVERTED",      GL_AND_INVERTED);
    wCreateNumConst("GL_NOOP",      GL_NOOP);
    wCreateNumConst("GL_XOR",      GL_XOR);
    wCreateNumConst("GL_OR",      GL_OR);
    wCreateNumConst("GL_NOR",      GL_NOR);
    wCreateNumConst("GL_EQUIV",      GL_EQUIV);
    wCreateNumConst("GL_INVERT",      GL_INVERT);
    wCreateNumConst("GL_OR_REVERSE",      GL_OR_REVERSE);
    wCreateNumConst("GL_COPY_INVERTED",      GL_COPY_INVERTED);
    wCreateNumConst("GL_OR_INVERTED",      GL_OR_INVERTED);
    wCreateNumConst("GL_NAND",      GL_NAND);
    wCreateNumConst("GL_SET",      GL_SET);
    wCreateNumConst("GL_EMISSION",      GL_EMISSION);
    wCreateNumConst("GL_SHININESS",      GL_SHININESS);
    wCreateNumConst("GL_AMBIENT_AND_DIFFUSE",      GL_AMBIENT_AND_DIFFUSE);
    wCreateNumConst("GL_COLOR_INDEXES",      GL_COLOR_INDEXES);
    wCreateNumConst("GL_MODELVIEW",      GL_MODELVIEW);
    wCreateNumConst("GL_PROJECTION",      GL_PROJECTION);
    wCreateNumConst("GL_TEXTURE",      GL_TEXTURE);
    wCreateNumConst("GL_COLOR",      GL_COLOR);
    wCreateNumConst("GL_DEPTH",      GL_DEPTH);
    wCreateNumConst("GL_STENCIL",      GL_STENCIL);
    wCreateNumConst("GL_COLOR_INDEX",      GL_COLOR_INDEX);
    wCreateNumConst("GL_STENCIL_INDEX",      GL_STENCIL_INDEX);
    wCreateNumConst("GL_DEPTH_COMPONENT",      GL_DEPTH_COMPONENT);
    wCreateNumConst("GL_RED",      GL_RED);
    wCreateNumConst("GL_GREEN",      GL_GREEN);
    wCreateNumConst("GL_BLUE",      GL_BLUE);
    wCreateNumConst("GL_ALPHA",      GL_ALPHA);
    wCreateNumConst("GL_RGB",      GL_RGB);
    wCreateNumConst("GL_RGBA",      GL_RGBA);
    wCreateNumConst("GL_LUMINANCE",      GL_LUMINANCE);
    wCreateNumConst("GL_LUMINANCE_ALPHA",      GL_LUMINANCE_ALPHA);
    wCreateNumConst("GL_BITMAP",      GL_BITMAP);
    wCreateNumConst("GL_POINT",      GL_POINT);
    wCreateNumConst("GL_LINE",      GL_LINE);
    wCreateNumConst("GL_FILL",      GL_FILL);
    wCreateNumConst("GL_RENDER",      GL_RENDER);
    wCreateNumConst("GL_FEEDBACK",      GL_FEEDBACK);
    wCreateNumConst("GL_SELECT",      GL_SELECT);
    wCreateNumConst("GL_FLAT",      GL_FLAT);
    wCreateNumConst("GL_SMOOTH",      GL_SMOOTH);
    wCreateNumConst("GL_KEEP",      GL_KEEP);
    wCreateNumConst("GL_REPLACE",      GL_REPLACE);
    wCreateNumConst("GL_INCR",      GL_INCR);
    wCreateNumConst("GL_DECR",      GL_DECR);
    wCreateNumConst("GL_VENDOR",      GL_VENDOR);
    wCreateNumConst("GL_RENDERER",      GL_RENDERER);
    wCreateNumConst("GL_VERSION",      GL_VERSION);
    wCreateNumConst("GL_EXTENSIONS",      GL_EXTENSIONS);
    wCreateNumConst("GL_S",      GL_S);
    wCreateNumConst("GL_T",      GL_T);
    wCreateNumConst("GL_R",      GL_R);
    wCreateNumConst("GL_Q",      GL_Q);
    wCreateNumConst("GL_MODULATE",      GL_MODULATE);
    wCreateNumConst("GL_DECAL",      GL_DECAL);
    wCreateNumConst("GL_TEXTURE_ENV_MODE",      GL_TEXTURE_ENV_MODE);
    wCreateNumConst("GL_TEXTURE_ENV_COLOR",      GL_TEXTURE_ENV_COLOR);
    wCreateNumConst("GL_TEXTURE_ENV",      GL_TEXTURE_ENV);
    wCreateNumConst("GL_EYE_LINEAR",      GL_EYE_LINEAR);
    wCreateNumConst("GL_OBJECT_LINEAR",      GL_OBJECT_LINEAR);
    wCreateNumConst("GL_SPHERE_MAP",      GL_SPHERE_MAP);
    wCreateNumConst("GL_TEXTURE_GEN_MODE",      GL_TEXTURE_GEN_MODE);
    wCreateNumConst("GL_OBJECT_PLANE",      GL_OBJECT_PLANE);
    wCreateNumConst("GL_EYE_PLANE",      GL_EYE_PLANE);
    wCreateNumConst("GL_NEAREST",      GL_NEAREST);
    wCreateNumConst("GL_LINEAR",      GL_LINEAR);
    wCreateNumConst("GL_NEAREST_MIPMAP_NEAREST",      GL_NEAREST_MIPMAP_NEAREST);
    wCreateNumConst("GL_LINEAR_MIPMAP_NEAREST",      GL_LINEAR_MIPMAP_NEAREST);
    wCreateNumConst("GL_NEAREST_MIPMAP_LINEAR",      GL_NEAREST_MIPMAP_LINEAR);
    wCreateNumConst("GL_LINEAR_MIPMAP_LINEAR",      GL_LINEAR_MIPMAP_LINEAR);
    wCreateNumConst("GL_TEXTURE_MAG_FILTER",      GL_TEXTURE_MAG_FILTER);
    wCreateNumConst("GL_TEXTURE_MIN_FILTER",      GL_TEXTURE_MIN_FILTER);
    wCreateNumConst("GL_TEXTURE_WRAP_S",      GL_TEXTURE_WRAP_S);
    wCreateNumConst("GL_TEXTURE_WRAP_T",      GL_TEXTURE_WRAP_T);
    wCreateNumConst("GL_CLAMP",      GL_CLAMP);
    wCreateNumConst("GL_REPEAT",      GL_REPEAT);
    wCreateNumConst("GL_CLIENT_PIXEL_STORE_BIT",      GL_CLIENT_PIXEL_STORE_BIT);
    wCreateNumConst("GL_CLIENT_VERTEX_ARRAY_BIT",      GL_CLIENT_VERTEX_ARRAY_BIT);
    // wCreateNumConst("GL_CLIENT_ALL_ATTRIB_BITS",      GL_CLIENT_ALL_ATTRIB_BITS);
    wCreateNumConst("GL_POLYGON_OFFSET_FACTOR",      GL_POLYGON_OFFSET_FACTOR);
    wCreateNumConst("GL_POLYGON_OFFSET_UNITS",      GL_POLYGON_OFFSET_UNITS);
    wCreateNumConst("GL_POLYGON_OFFSET_POINT",      GL_POLYGON_OFFSET_POINT);
    wCreateNumConst("GL_POLYGON_OFFSET_LINE",      GL_POLYGON_OFFSET_LINE);
    wCreateNumConst("GL_POLYGON_OFFSET_FILL",      GL_POLYGON_OFFSET_FILL);
    wCreateNumConst("GL_ALPHA4",      GL_ALPHA4);
    wCreateNumConst("GL_ALPHA8",      GL_ALPHA8);
    wCreateNumConst("GL_ALPHA12",      GL_ALPHA12);
    wCreateNumConst("GL_ALPHA16",      GL_ALPHA16);
    wCreateNumConst("GL_LUMINANCE4",      GL_LUMINANCE4);
    wCreateNumConst("GL_LUMINANCE8",      GL_LUMINANCE8);
    wCreateNumConst("GL_LUMINANCE12",      GL_LUMINANCE12);
    wCreateNumConst("GL_LUMINANCE16",      GL_LUMINANCE16);
    wCreateNumConst("GL_LUMINANCE4_ALPHA4",      GL_LUMINANCE4_ALPHA4);
    wCreateNumConst("GL_LUMINANCE6_ALPHA2",      GL_LUMINANCE6_ALPHA2);
    wCreateNumConst("GL_LUMINANCE8_ALPHA8",      GL_LUMINANCE8_ALPHA8);
    wCreateNumConst("GL_LUMINANCE12_ALPHA4",      GL_LUMINANCE12_ALPHA4);
    wCreateNumConst("GL_LUMINANCE12_ALPHA12",      GL_LUMINANCE12_ALPHA12);
    wCreateNumConst("GL_LUMINANCE16_ALPHA16",      GL_LUMINANCE16_ALPHA16);
    wCreateNumConst("GL_INTENSITY",      GL_INTENSITY);
    wCreateNumConst("GL_INTENSITY4",      GL_INTENSITY4);
    wCreateNumConst("GL_INTENSITY8",      GL_INTENSITY8);
    wCreateNumConst("GL_INTENSITY12",      GL_INTENSITY12);
    wCreateNumConst("GL_INTENSITY16",      GL_INTENSITY16);
    wCreateNumConst("GL_R3_G3_B2",      GL_R3_G3_B2);
    wCreateNumConst("GL_RGB4",      GL_RGB4);
    wCreateNumConst("GL_RGB5",      GL_RGB5);
    wCreateNumConst("GL_RGB8",      GL_RGB8);
    wCreateNumConst("GL_RGB10",      GL_RGB10);
    wCreateNumConst("GL_RGB12",      GL_RGB12);
    wCreateNumConst("GL_RGB16",      GL_RGB16);
    wCreateNumConst("GL_RGBA2",      GL_RGBA2);
    wCreateNumConst("GL_RGBA4",      GL_RGBA4);
    wCreateNumConst("GL_RGB5_A1",      GL_RGB5_A1);
    wCreateNumConst("GL_RGBA8",      GL_RGBA8);
    wCreateNumConst("GL_RGB10_A2",      GL_RGB10_A2);
    wCreateNumConst("GL_RGBA12",      GL_RGBA12);
    wCreateNumConst("GL_RGBA16",      GL_RGBA16);
    wCreateNumConst("GL_TEXTURE_RED_SIZE",      GL_TEXTURE_RED_SIZE);
    wCreateNumConst("GL_TEXTURE_GREEN_SIZE",      GL_TEXTURE_GREEN_SIZE);
    wCreateNumConst("GL_TEXTURE_BLUE_SIZE",      GL_TEXTURE_BLUE_SIZE);
    wCreateNumConst("GL_TEXTURE_ALPHA_SIZE",      GL_TEXTURE_ALPHA_SIZE);
    wCreateNumConst("GL_TEXTURE_LUMINANCE_SIZE",      GL_TEXTURE_LUMINANCE_SIZE);
    wCreateNumConst("GL_TEXTURE_INTENSITY_SIZE",      GL_TEXTURE_INTENSITY_SIZE);
    wCreateNumConst("GL_PROXY_TEXTURE_1D",      GL_PROXY_TEXTURE_1D);
    wCreateNumConst("GL_PROXY_TEXTURE_2D",      GL_PROXY_TEXTURE_2D);
    wCreateNumConst("GL_TEXTURE_PRIORITY",      GL_TEXTURE_PRIORITY);
    wCreateNumConst("GL_TEXTURE_RESIDENT",      GL_TEXTURE_RESIDENT);
    wCreateNumConst("GL_TEXTURE_BINDING_1D",      GL_TEXTURE_BINDING_1D);
    wCreateNumConst("GL_TEXTURE_BINDING_2D",      GL_TEXTURE_BINDING_2D);
    wCreateNumConst("GL_VERTEX_ARRAY",      GL_VERTEX_ARRAY);
    wCreateNumConst("GL_NORMAL_ARRAY",      GL_NORMAL_ARRAY);
    wCreateNumConst("GL_COLOR_ARRAY",      GL_COLOR_ARRAY);
    wCreateNumConst("GL_INDEX_ARRAY",      GL_INDEX_ARRAY);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY",      GL_TEXTURE_COORD_ARRAY);
    wCreateNumConst("GL_EDGE_FLAG_ARRAY",      GL_EDGE_FLAG_ARRAY);
    wCreateNumConst("GL_VERTEX_ARRAY_SIZE",      GL_VERTEX_ARRAY_SIZE);
    wCreateNumConst("GL_VERTEX_ARRAY_TYPE",      GL_VERTEX_ARRAY_TYPE);
    wCreateNumConst("GL_VERTEX_ARRAY_STRIDE",      GL_VERTEX_ARRAY_STRIDE);
    wCreateNumConst("GL_NORMAL_ARRAY_TYPE",      GL_NORMAL_ARRAY_TYPE);
    wCreateNumConst("GL_NORMAL_ARRAY_STRIDE",      GL_NORMAL_ARRAY_STRIDE);
    wCreateNumConst("GL_COLOR_ARRAY_SIZE",      GL_COLOR_ARRAY_SIZE);
    wCreateNumConst("GL_COLOR_ARRAY_TYPE",      GL_COLOR_ARRAY_TYPE);
    wCreateNumConst("GL_COLOR_ARRAY_STRIDE",      GL_COLOR_ARRAY_STRIDE);
    wCreateNumConst("GL_INDEX_ARRAY_TYPE",      GL_INDEX_ARRAY_TYPE);
    wCreateNumConst("GL_INDEX_ARRAY_STRIDE",      GL_INDEX_ARRAY_STRIDE);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_SIZE",      GL_TEXTURE_COORD_ARRAY_SIZE);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_TYPE",      GL_TEXTURE_COORD_ARRAY_TYPE);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_STRIDE",      GL_TEXTURE_COORD_ARRAY_STRIDE);
    wCreateNumConst("GL_EDGE_FLAG_ARRAY_STRIDE",      GL_EDGE_FLAG_ARRAY_STRIDE);
    wCreateNumConst("GL_VERTEX_ARRAY_POINTER",      GL_VERTEX_ARRAY_POINTER);
    wCreateNumConst("GL_NORMAL_ARRAY_POINTER",      GL_NORMAL_ARRAY_POINTER);
    wCreateNumConst("GL_COLOR_ARRAY_POINTER",      GL_COLOR_ARRAY_POINTER);
    wCreateNumConst("GL_INDEX_ARRAY_POINTER",      GL_INDEX_ARRAY_POINTER);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_POINTER",      GL_TEXTURE_COORD_ARRAY_POINTER);
    wCreateNumConst("GL_EDGE_FLAG_ARRAY_POINTER",      GL_EDGE_FLAG_ARRAY_POINTER);
    wCreateNumConst("GL_V2F",      GL_V2F);
    wCreateNumConst("GL_V3F",      GL_V3F);
    wCreateNumConst("GL_C4UB_V2F",      GL_C4UB_V2F);
    wCreateNumConst("GL_C4UB_V3F",      GL_C4UB_V3F);
    wCreateNumConst("GL_C3F_V3F",      GL_C3F_V3F);
    wCreateNumConst("GL_N3F_V3F",      GL_N3F_V3F);
    wCreateNumConst("GL_C4F_N3F_V3F",      GL_C4F_N3F_V3F);
    wCreateNumConst("GL_T2F_V3F",      GL_T2F_V3F);
    wCreateNumConst("GL_T4F_V4F",      GL_T4F_V4F);
    wCreateNumConst("GL_T2F_C4UB_V3F",      GL_T2F_C4UB_V3F);
    wCreateNumConst("GL_T2F_C3F_V3F",      GL_T2F_C3F_V3F);
    wCreateNumConst("GL_T2F_N3F_V3F",      GL_T2F_N3F_V3F);
    wCreateNumConst("GL_T2F_C4F_N3F_V3F",      GL_T2F_C4F_N3F_V3F);
    wCreateNumConst("GL_T4F_C4F_N3F_V4F",      GL_T4F_C4F_N3F_V4F);
    wCreateNumConst("GL_EXT_vertex_array",      GL_EXT_vertex_array);
    // wCreateNumConst("GL_WIN_swap_hint",      GL_WIN_swap_hint);
    wCreateNumConst("GL_EXT_bgra",      GL_EXT_bgra);
    wCreateNumConst("GL_EXT_paletted_texture",      GL_EXT_paletted_texture);
    wCreateNumConst("GL_VERTEX_ARRAY_EXT",      GL_VERTEX_ARRAY_EXT);
    wCreateNumConst("GL_NORMAL_ARRAY_EXT",      GL_NORMAL_ARRAY_EXT);
    wCreateNumConst("GL_COLOR_ARRAY_EXT",      GL_COLOR_ARRAY_EXT);
    wCreateNumConst("GL_INDEX_ARRAY_EXT",      GL_INDEX_ARRAY_EXT);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_EXT",      GL_TEXTURE_COORD_ARRAY_EXT);
    wCreateNumConst("GL_EDGE_FLAG_ARRAY_EXT",      GL_EDGE_FLAG_ARRAY_EXT);
    wCreateNumConst("GL_VERTEX_ARRAY_SIZE_EXT",      GL_VERTEX_ARRAY_SIZE_EXT);
    wCreateNumConst("GL_VERTEX_ARRAY_TYPE_EXT",      GL_VERTEX_ARRAY_TYPE_EXT);
    wCreateNumConst("GL_VERTEX_ARRAY_STRIDE_EXT",      GL_VERTEX_ARRAY_STRIDE_EXT);
    wCreateNumConst("GL_VERTEX_ARRAY_COUNT_EXT",      GL_VERTEX_ARRAY_COUNT_EXT);
    wCreateNumConst("GL_NORMAL_ARRAY_TYPE_EXT",      GL_NORMAL_ARRAY_TYPE_EXT);
    wCreateNumConst("GL_NORMAL_ARRAY_STRIDE_EXT",      GL_NORMAL_ARRAY_STRIDE_EXT);
    wCreateNumConst("GL_NORMAL_ARRAY_COUNT_EXT",      GL_NORMAL_ARRAY_COUNT_EXT);
    wCreateNumConst("GL_COLOR_ARRAY_SIZE_EXT",      GL_COLOR_ARRAY_SIZE_EXT);
    wCreateNumConst("GL_COLOR_ARRAY_TYPE_EXT",      GL_COLOR_ARRAY_TYPE_EXT);
    wCreateNumConst("GL_COLOR_ARRAY_STRIDE_EXT",      GL_COLOR_ARRAY_STRIDE_EXT);
    wCreateNumConst("GL_COLOR_ARRAY_COUNT_EXT",      GL_COLOR_ARRAY_COUNT_EXT);
    wCreateNumConst("GL_INDEX_ARRAY_TYPE_EXT",      GL_INDEX_ARRAY_TYPE_EXT);
    wCreateNumConst("GL_INDEX_ARRAY_STRIDE_EXT",      GL_INDEX_ARRAY_STRIDE_EXT);
    wCreateNumConst("GL_INDEX_ARRAY_COUNT_EXT",      GL_INDEX_ARRAY_COUNT_EXT);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_SIZE_EXT",      GL_TEXTURE_COORD_ARRAY_SIZE_EXT);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_TYPE_EXT",      GL_TEXTURE_COORD_ARRAY_TYPE_EXT);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_STRIDE_EXT",      GL_TEXTURE_COORD_ARRAY_STRIDE_EXT);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_COUNT_EXT",      GL_TEXTURE_COORD_ARRAY_COUNT_EXT);
    wCreateNumConst("GL_EDGE_FLAG_ARRAY_STRIDE_EXT",      GL_EDGE_FLAG_ARRAY_STRIDE_EXT);
    wCreateNumConst("GL_EDGE_FLAG_ARRAY_COUNT_EXT",      GL_EDGE_FLAG_ARRAY_COUNT_EXT);
    wCreateNumConst("GL_VERTEX_ARRAY_POINTER_EXT",      GL_VERTEX_ARRAY_POINTER_EXT);
    wCreateNumConst("GL_NORMAL_ARRAY_POINTER_EXT",      GL_NORMAL_ARRAY_POINTER_EXT);
    wCreateNumConst("GL_COLOR_ARRAY_POINTER_EXT",      GL_COLOR_ARRAY_POINTER_EXT);
    wCreateNumConst("GL_INDEX_ARRAY_POINTER_EXT",      GL_INDEX_ARRAY_POINTER_EXT);
    wCreateNumConst("GL_TEXTURE_COORD_ARRAY_POINTER_EXT",      GL_TEXTURE_COORD_ARRAY_POINTER_EXT);
    wCreateNumConst("GL_EDGE_FLAG_ARRAY_POINTER_EXT",      GL_EDGE_FLAG_ARRAY_POINTER_EXT);
    // wCreateNumConst("GL_DOUBLE_EXT",      GL_DOUBLE_EXT);
    wCreateNumConst("GL_BGR_EXT",      GL_BGR_EXT);
    wCreateNumConst("GL_BGRA_EXT",      GL_BGRA_EXT);
    // wCreateNumConst("GL_COLOR_TABLE_FORMAT_EXT",      GL_COLOR_TABLE_FORMAT_EXT);
    // wCreateNumConst("GL_COLOR_TABLE_WIDTH_EXT",      GL_COLOR_TABLE_WIDTH_EXT);
    // wCreateNumConst("GL_COLOR_TABLE_RED_SIZE_EXT",      GL_COLOR_TABLE_RED_SIZE_EXT);
    // wCreateNumConst("GL_COLOR_TABLE_GREEN_SIZE_EXT",      GL_COLOR_TABLE_GREEN_SIZE_EXT);
    // wCreateNumConst("GL_COLOR_TABLE_BLUE_SIZE_EXT",      GL_COLOR_TABLE_BLUE_SIZE_EXT);
    // wCreateNumConst("GL_COLOR_TABLE_ALPHA_SIZE_EXT",      GL_COLOR_TABLE_ALPHA_SIZE_EXT);
    // wCreateNumConst("GL_COLOR_TABLE_LUMINANCE_SIZE_EXT",      GL_COLOR_TABLE_LUMINANCE_SIZE_EXT);
    // wCreateNumConst("GL_COLOR_TABLE_INTENSITY_SIZE_EXT",      GL_COLOR_TABLE_INTENSITY_SIZE_EXT);
    wCreateNumConst("GL_COLOR_INDEX1_EXT",      GL_COLOR_INDEX1_EXT);
    wCreateNumConst("GL_COLOR_INDEX2_EXT",      GL_COLOR_INDEX2_EXT);
    wCreateNumConst("GL_COLOR_INDEX4_EXT",      GL_COLOR_INDEX4_EXT);
    wCreateNumConst("GL_COLOR_INDEX8_EXT",      GL_COLOR_INDEX8_EXT);
    wCreateNumConst("GL_COLOR_INDEX12_EXT",      GL_COLOR_INDEX12_EXT);
    wCreateNumConst("GL_COLOR_INDEX16_EXT",      GL_COLOR_INDEX16_EXT);
    wCreateNumConst("GL_LOGIC_OP",      GL_LOGIC_OP);
    wCreateNumConst("GL_TEXTURE_COMPONENTS",      GL_TEXTURE_COMPONENTS);

#endif

}
