#include <qslider.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qdir.h>
#include <qdatetime.h>
#include <qlineedit.h>
#include <qmessagebox.h>

#include <unistd.h>

#include "looknfeel.h"
#include "config.h"

looknfeel::looknfeel(QWidget *parent, const char *name):
    looknfeelBase(parent, name)
{
    Config *conf = new Config("looknfeel");
    conf->setGroup("Desktop");
    pict_path->setText(conf->readEntry("bgimage", ""));
    pict_combo->setCurrentItem(conf->readNumEntry("imagetype", 0));
    conf->setGroup("Panel");
    panel_combo->setCurrentItem(conf->readNumEntry("orientation", 0));
    delete conf;
}

void looknfeel::apply()
{
    Config *conf = new Config("looknfeel");
    conf->setGroup("Desktop");
    conf->writeEntry("bgimage", pict_path->text());
    conf->writeEntry("imagetype", pict_combo->currentItem());
    if (!pict_path->text().isEmpty()) {
        QFile f1(QDir::homeDirPath() + "/.matchbox/mb-desktop-background");
	f1.open(IO_WriteOnly);
	QString l1 = "--bg img-" + pict_combo->currentText() +":" + pict_path->text();
	f1.writeBlock(l1, l1.length());
	f1.close();
    } else {
	unlink(QDir::homeDirPath() + "/.matchbox/mb-desktop-background");
    }

    conf->setGroup("Panel");
    conf->writeEntry("orientation", panel_combo->currentItem());
    QFile f(QDir::homeDirPath() + "/.matchbox/mb-panel-orientation");
    f.open(IO_WriteOnly);
    QString l = "--orientation " + panel_combo->currentText();
    f.writeBlock(l, l.length());
    f.close();
    delete conf;
    QMessageBox::information(this, tr("Look & Feel"), tr("Restart XServer for new settings."));
}

void looknfeel::pict_open()
{
    QString fn = QFileDialog::getOpenFileName( QString::null, "Images (*.jpg *.png)", this );
    if ( !fn.isEmpty() ) {
	pict_path->setText(fn);
    }
}
