#include <qprocess.h>
#include <qapplication.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qtextview.h>
#include <qtabwidget.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstring.h>
#include <stdlib.h>
#include "qpkg.h"
#include "config.h"

qpkg::qpkg( QWidget *parent, const char *name )
    : qpkgBase( parent, name ), ipkgRunning(false)
{
    proc = new QProcess( this );
    connect( proc, SIGNAL(readyReadStdout()),
	    this, SLOT(readFromStdout()) );
    connect( proc, SIGNAL(processExited()),
	    this, SLOT(ipkgFinished()) );

    ipkg_listview->clear();
    updateListView("/");
    updateListView("/mnt/card");
    updateListView("/mnt/cf");
    updateListView("/mnt/net");
    updateListView("/mnt/user");
    updateNewListView();
    
    Config *conf = new Config("Packager");
    conf->setGroup("Feeds");
    int numf = conf->readNumEntry("NumFeeds", 0);
    if (numf) {
	FeedListBox->clear();
	for (int i = 0; i < numf; i++) {
	    QString xxx = "Feed"+ QString::number(i);
	    QString feedstr = conf->readEntry(xxx);
	    FeedListBox->insertItem(feedstr);
	}
	conf->setGroup("Default");
	numf = conf->readNumEntry("CurrentFeed");
	FeedListBox->setCurrentItem(numf);
    }
    delete conf;
    update_iconf();
}

qpkg::~qpkg()
{
    Config *conf = new Config("Packager");
    conf->setGroup("Default");
    conf->writeEntry("CurrentFeed", FeedListBox->currentItem());
    conf->setGroup("Feeds");
    conf->clearGroup();
    conf->writeEntry("NumFeeds", FeedListBox->count());
    for (unsigned int i=0; i<FeedListBox->count(); i++) {
	QString xxx = "Feed"+ QString::number(i);
        conf->writeEntry(xxx, FeedListBox->text(i));
    }
    delete conf;
}

void qpkg::install_ipkg()
{
    if (ipkgRunning) return;
    QString fn = QFileDialog::getOpenFileName( QString::null, /*QString::null*/"Packages (*.ipk *.deb)", this );
    if ( !fn.isEmpty() ) {
        //qDebug("package: " + fn);
	proc->clearArguments();
	proc->addArgument( "ipkg-install" );
	proc->addArgument( dest_box->currentText());
	proc->addArgument( fn );
	ipkgRunning = true;
	if ( !proc->start() ) {
	    QMessageBox::critical( 0,
		tr("Fatal error"),
		tr("Could not start the ipkg command."),
		tr("Quit") );
	    ipkgRunning = false;
	    return;
	}
	install_button->setEnabled(false);
	go_button->setEnabled(false);
	reload_button->setEnabled(false);
	dest_box->setEnabled(false);
    }
}

void qpkg::netinstall_ipkg()
{
    if (ipkgRunning) return;
    QListViewItem *item = new_listview->currentItem();
    if (!item) {
	QMessageBox::information(0, tr("Warning!"), tr("No package selected."), QMessageBox::Ok);
	return;
    }
    proc->clearArguments();
    proc->addArgument( "ipkg-install" );
    proc->addArgument( dest_box->currentText());
    proc->addArgument( item->text(0) );
    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::go_ipkg()
{
    switch(tab_window->currentPageIndex()) {
	case 0: remove_ipkg(); break;
	case 1: netinstall_ipkg(); break;
	default: break;
    }
}

void qpkg::remove_ipkg()
{
    if (ipkgRunning) return;
    QListViewItem *item = ipkg_listview->currentItem();
    if (!item) {
	QMessageBox::information(0, tr("Warning!"), tr("No package selected."), QMessageBox::Ok);
	return;
    }
    
    QMessageBox mb(tr("Package manager"), tr("Remove package "+item->text(1)+"?"), 
		    QMessageBox::NoIcon, QMessageBox::Yes, QMessageBox::No | QMessageBox::Default, 0);
    if ( mb.exec() != QMessageBox::Yes ) return;
    
    //qDebug(item->text(0) + " : " + item->text(1) + " : " + item->text(2));
    proc->clearArguments();
    proc->addArgument( "ipkg-uninstall" );
    proc->addArgument( item->text(0) );
    proc->addArgument( item->text(1) );
    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::readFromStdout()
{
    log_view->append( proc->readStdout() );
}

void qpkg::ipkgFinished()
{
    system("killall -HUP matchbox-desktop");
    system("killall -HUP mb-applet-menu-launcher");
    ipkgRunning = false;
    ipkg_listview->clear();
    updateListView("/");
    updateListView("/mnt/card");
    updateListView("/mnt/cf");
    updateListView("/mnt/net");
    updateListView("/mnt/user");
    new_listview->clear();
    updateNewListView();
    install_button->setEnabled(true);
    go_button->setEnabled(true);
    reload_button->setEnabled(true);
    dest_box->setEnabled(true);
}

void qpkg::updateListView(QString path)
{
    QFile f( QString( path + "/usr/lib/ipkg/status").latin1() );
    if (!f.exists()) {
	//qDebug("!status");
	return;
    }
    f.open( IO_ReadOnly );
    QString str="", pkg_str="", ver_str="", dst_str="";
    bool found = false;
    int pos;
    while(!f.atEnd()) {
	f.readLine(str, 80);
	if ((pos = str.find("Package:",0)) >= 0) {
	    if (found) {
		new QListViewItem(ipkg_listview, dst_str, pkg_str, ver_str);
	    }
	    pkg_str = str.right(str.length() - pos - 9);
	    pkg_str.truncate(pkg_str.length() - 1);
	    found = true;
	} else if ((pos = str.find("Version:",0)) >= 0) {
	    ver_str = str.right(str.length() - pos - 9);
	    ver_str.truncate(ver_str.length() - 1);
	} else if ((pos = str.find("Root:",0)) >= 0) {
	    dst_str = str.right(str.length() - pos - 6);
	    dst_str.truncate(dst_str.length() - 1);
	}
    }
    if (found) {
	found = false;
	new QListViewItem(ipkg_listview, dst_str, pkg_str, ver_str);
    }
    f.close();
}

bool qpkg::checkInst(QString &str)
{
    QListViewItem *item = ipkg_listview->firstChild();
    while (item) {
	if (str == item->text(1)) return true;
	item = item->nextSibling();
    }
    return false;
}

void qpkg::updateNewListView()
{
    system("ipkg info>/tmp/qpkg_packages.123");
    QFile f( QString("/tmp/qpkg_packages.123").latin1() );
    if (!f.exists()) {
	//qDebug("!status ap");
	return;
    }
    f.open( IO_ReadOnly );
    QString str="", pkg_str="", ver_str="", desc_str="", deps_str="";
    bool found = false;
    int pos;
    while(!f.atEnd()) {
	f.readLine(str, 80);
	if ((pos = str.find("Package:",0)) >= 0) {
	    if (found) {
		if (!checkInst(pkg_str))
		    new QListViewItem(new_listview, pkg_str, ver_str, desc_str, deps_str);
		pkg_str=""; 
		ver_str="";
		desc_str="";
		deps_str="";
	    }
	    pkg_str = str.right(str.length() - pos - 9);
	    pkg_str.truncate(pkg_str.length() - 1);
	    found = true;
	} else if ((pos = str.find("Version:",0)) >= 0) {
	    ver_str = str.right(str.length() - pos - 9);
	    ver_str.truncate(ver_str.length() - 1);
	} else if ((pos = str.find("Description:",0)) >= 0) {
	    desc_str = str.right(str.length() - pos - 13);
	    desc_str.truncate(desc_str.length() - 1);
	} else if ((pos = str.find("Depends:",0)) >= 0) {
	    deps_str = str.right(str.length() - pos - 9);
	    deps_str.truncate(deps_str.length() - 1);
	}
    }
    if (found) {
	found = false;
	if (!checkInst(pkg_str))
	    new QListViewItem(new_listview, pkg_str, ver_str, desc_str, deps_str);
    }
    f.close();
    system("rm -f /tmp/qpkg_packages.123");
}

void qpkg::reload_ipkg()
{
//    qDebug("-- "+QString::number(tab_window->currentPageIndex()));
    if (ipkgRunning) return;
    proc->clearArguments();
    proc->addArgument( "ipkg" );
    proc->addArgument( "update" );
    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::add_feed()
{
    FeedListBox->insertItem(NewFeedLineEdit->text());
    NewFeedLineEdit->setText("");
    FeedListBox->setCurrentItem(FeedListBox->count()-1);
    update_iconf();
}

void qpkg::remove_feed()
{
    FeedListBox->removeItem(FeedListBox->currentItem());
    update_iconf();
}

void qpkg::update_iconf()
{
    QFile options("/etc/ipkg.conf");
    if ( options.open(IO_WriteOnly) ) {
	QTextStream opt(&options);
	for (unsigned int i=0; i<FeedListBox->count(); i++) {
	    opt << "src feed" << i << " " << FeedListBox->text(i) << "\n";
	}
	opt << "dest root /\n";
	opt << "dest tmpinst /home/tmp/ipkg/inst\n";
    }
}

//void qpkg::use_feed(const QString &str)
//{
//    update_iconf();
//}
