#!/bin/bash

# Copyright (C) 2004 LiNuCe, Marseille, FRANCE
#
# Ce programme est un logiciel libre. Vous pouvez le redistribuer
# et/ou le modifier sous les termes de la license GNU GPL telle
# qu'elle est publie par la FSF (Free Software Foundation), en
# utilisant la version 2 de cette licence ou, selon votre choix,
# toute autre version plus rcente.

if [ $UID -ne 0 ]; then
	echo "M'excuter en tant que super-utilisateur ROOT !"
	exit 1
fi

set -e -x

cwd=$PWD
source $cwd/build.conf

[ ! -d "$pkg" ] && exit 1

pushd $pkg
	chown root.root -R . 
	chown root.bin  -R usr/bin
	makepkg -l y -c n $cwd/$pkgname-$version-$arch-$build.tgz
popd

rm -rf $pkg

echo "Paquetage cre."
echo "Vous pouvez l'installer en utilisant installpkg $pkgname-$version-$arch-$build.tgz"
exit 0
