/*****************************************************************************
 * deinterlace.c: Deinterlace routines
 *****************************************************************************
 * $Id: deinterlace.c,v 1.6 2004/09/18 16:46:55 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * Original code:
 *
 * Copyright (C) 2001 the xine project
 *
 * Deinterlace routines by Miguel Freitas
 * based of DScaler project sources (deinterlace.sourceforge.net)
 *
 * Currently only available for Xv driver and MMX extensions
 *
 *****************************************************************************/
#include <stdio.h>
#include <string.h>
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "deinterlace.h"
#include "strtab.h"
#include "colorspace.h"
#include "vop.h"

static struct STRTAB deinterlaces[] = {
  {DEINTERLACE_NONE, "none"},
#ifdef ARCH_X86
  {DEINTERLACE_BOB, "deintbob"},
  {DEINTERLACE_WEAVE, "deintweave"},
  {DEINTERLACE_GREEDY, "deintgreedy"},
  {DEINTERLACE_ONEFIELD, "deintonefield"},
#endif
  {DEINTERLACE_LINEARBLEND, "deintlb"},
  {-1, NULL}
};

void set_deinterlace_vop(enum deinterlace e) {
  static int prev=DEINTERLACE_NONE;
  if(prev!=DEINTERLACE_NONE)
    deactivate_vop(int_to_str(prev,deinterlaces));
  if(e!=DEINTERLACE_NONE)
    activate_vop(int_to_str(e,deinterlaces));
  prev=e;
}
