/*****************************************************************************
 * memcpy.h: functions and definitions of the MMX/MMX2/SSE optimized versions
 * of memcpy
 *****************************************************************************
 * $Id: memcpy.h,v 1.5 2004/11/22 21:06:27 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * Original code:
 * 
 * Copyright (C) 2000-2001 the xine project
 * 
 * This file is part of xine, a unix video player.
 * 
 *****************************************************************************/
#ifndef _MEMCPY_H_
#define _MEMCPY_H_

/* optimized/fast memcpy */
extern void *(* fast_memcpy)(void *to, const void *from, size_t len);
/*
void *linux_kernel_memcpy(void *to, const void *from, size_t len);
void *mmx_memcpy(void *to, const void *from, size_t len);
void *mmx2_memcpy(void *to, const void *from, size_t len);
void *sse_memcpy(void *to, const void *from, size_t len);
*/
/* benchmark available memcpy methods */
void probe_fast_memcpy(int method);

enum {
  MEMCPY_PROBE = 0,
  MEMCPY_GLIBC,
  MEMCPY_KERNEL,
  MEMCPY_FPU_512,
  MEMCPY_FPU_1K,
  MEMCPY_FPU_2K,
  MEMCPY_FPU_4K,
  MEMCPY_FPU_8K,
  MEMCPY_FPU_16K,
  MEMCPY_FPU_32K,
  MEMCPY_MMX,
  MEMCPY_MMX_512,
  MEMCPY_MMX_1K,
  MEMCPY_MMX_2K,
  MEMCPY_MMX_4K,
  MEMCPY_MMX_8K,
  MEMCPY_MMX_16K,
  MEMCPY_MMX_32K,
  MEMCPY_MMXEXT,
  MEMCPY_MMXEXT_1K,
  MEMCPY_MMXEXT_2K,
  MEMCPY_MMXEXT_4K,
  MEMCPY_MMXEXT_8K,
  MEMCPY_MMXEXT_16K,
  MEMCPY_MMXEXT_32K,
  MEMCPY_MMXEXT_64K,
  MEMCPY_SSE,
  MEMCPY_SSE_1K,
  MEMCPY_SSE_2K,
  MEMCPY_SSE_4K,
  MEMCPY_SSE_8K,
  MEMCPY_SSE_16K,
  MEMCPY_SSE_32K,
  MEMCPY_SSE_64K
};

#endif // _MEMCPY_H_
