/*****************************************************************************
 * $Id: mixer-sun.c,v 1.4 2004/11/04 21:34:05 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include "config.h"
#ifdef HAVE_SUNAUDIO
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/audioio.h>
#include <fcntl.h>
#include "mixer.h"
extern int debug;

/* man audio */
#define NB_DEVICES 4
static char *device_list[NB_DEVICES] = {"inputs.line",
    	         "inputs.dac", "record.volume", "output.master"};
static int nchans[NB_DEVICES], volume[NB_DEVICES];
static int dev[NB_DEVICES]={-1,-1,-1,-1},devmute[NB_DEVICES]={-1,-1,-1,-1},devrecsrc;

static char* devaudioname(struct mixer_devinfo *dinfos, int k) {
    static char name[60];
    char *mclass=dinfos[dinfos[k].mixer_class].label.name;
    if(dinfos[k].prev!=-1) {
	mixer_devinfo_t *d=&dinfos[k];
	do {
	    d=&dinfos[d->prev];
	} while(d->prev!=-1);
	sprintf(name,"%s.%s.%s",mclass,d->label.name,dinfos[k].label.name);
    } else
	sprintf(name,"%s.%s",mclass,dinfos[k].label.name);
    return name;
}


static char *filename="/dev/mixer";
static int mix;
static int sunaudio_open(void) {
  mixer_devinfo_t dinfo, *dinfos;
  int ndev,i;
  if(mixer_tvchan) device_list[MIXER_CHAN_TV]=mixer_tvchan;
  if(mixer_pcmchan) device_list[MIXER_CHAN_PCM]=mixer_pcmchan;
  if(mixer_dev) filename=mixer_dev;
  if (-1 == (mix = open (filename, O_RDWR)))  {
     perror ("mixer open");
     return -1;
   }
   for(ndev = 0; ; ndev++) {
     dinfo.index = ndev;
     if (ioctl(mix, AUDIO_MIXER_DEVINFO, &dinfo) < 0)
       break;
   }
   dinfos=malloc(ndev*sizeof(mixer_devinfo_t));
  for(i=0;i<ndev;i++) {
      dinfos[i].index = i;
      ioctl(mix, AUDIO_MIXER_DEVINFO, &dinfos[i]);
  }
  for(i=0;i<ndev;i++) {
      char *name=devaudioname(dinfos,i);
      int j;
      for(j=0;j<NB_DEVICES;j++) {
	  char name2[50];
	  if(!strcmp(name,device_list[j]))
	      dev[j]=i;
	  sprintf(name2,"%s.mute",device_list[j]);
	  if(!strcmp(name,name2))
	      devmute[j]=i;
      }
      if(!strcmp(name,"record.source"))
	 devrecsrc=i;
  }
  for(i=0;i<NB_DEVICES;i++) {
      mixer_ctrl_t c;
      if(dev[i]==-1) continue;
       c.dev=dev[i];
       c.type=AUDIO_MIXER_VALUE;
       c.un.value.num_channels=2;
       if(ioctl(mix,AUDIO_MIXER_READ,&c)<0) {
	  c.un.value.num_channels=1;
	  if(ioctl(mix,AUDIO_MIXER_READ,&c)<0) {
	     perror("AUDIO_MIXER_READ");
	     dev[i]=-1;
	     continue;
	   }
       }
       nchans[i]=c.un.value.num_channels;
       volume[i]=c.un.value.level[0]*100/255;
       printf("%s --> %d vol=%d\n", device_list[i],dev[i],volume[i]);
       printf("%s.mute --> %d\n", device_list[i],devmute[i]);
  }
  printf("record.source --> %d\n",devrecsrc);
  free(dinfos);
  return 0;
}

static void sunaudio_close(void) {
  close(mix);
}

static void sunaudio_mute (int chan, int muted) {
  mixer_ctrl_t c;
  if(devmute[chan]==-1) return;
  c.dev=devmute[chan];
  c.type=AUDIO_MIXER_ENUM;
  c.un.ord=muted;
  if(ioctl(mix,AUDIO_MIXER_WRITE,&c)<0) {
      perror("AUDIO_MIXER_WRITE");
      return;
   }
}

static int sunaudio_get_volume (int chan) {
   if(dev[chan]==-1) return 0;
   return volume[chan];
}

static void sunaudio_set_volume (int chan, int val) {
   mixer_ctrl_t c;
   int i;
   if(dev[chan]==-1) return;
   c.dev=dev[chan];
   c.type=AUDIO_MIXER_VALUE;
   c.un.value.num_channels=nchans[chan];
   for(i=0;i<nchans[chan];i++) c.un.value.level[i]=val*255/100;
   if(ioctl(mix,AUDIO_MIXER_WRITE,&c)<0) {
      perror("AUDIO_MIXER_WRITE");
      return;
   }
   volume[chan]=val;
}

static void sunaudio_capture(void) {
}
static void sunaudio_uncapture (void) {
}

struct MIXER mixer_sunaudio = {
  "sunaudio",
  sunaudio_open,
  sunaudio_close,
  sunaudio_mute,
  sunaudio_get_volume,
  sunaudio_set_volume,
  sunaudio_capture,
  sunaudio_uncapture
};
#endif
