/*****************************************************************************
 * mixer.h: sound mixer control functions
 *****************************************************************************
 * $Id: mixer.h,v 1.8 2004/09/09 17:55:25 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * Original code:
 *
 *  (c) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/
#ifndef _MIXER_H_
#define _MIXER_H_

/********* for the applications *********************/
extern char *mixer_dev, *mixer_tvchan, *mixer_pcmchan;
extern int restoresnd;
void mixer_init (void);
void mixer_close (void);
int mixer_get_volume (void);
void mixer_set_volume (int val);
void mixer_set_mute(int val);
void mixer_set_mode(int mode);
int mixer_get_mode(void);
void disable_mixer(char *driver);
#define MIXER_MODE_TVLINE  1  /* TV unmute  */
#define MIXER_MODE_PCM     2  /* PCM unmute */
#define MIXER_MODE_CAPTURE 3  /* TV unmute and recorded */
#define MIXER_MODE_TV2PCM  4  /* TV mute, PCM unmute, TV recorded*/

/****** for the drivers *****************************/
struct MIXER
{
  char *name;
  int (*open) ();
  void (*close) ();
  void (*mute) (int chan, int muted);
  int (*get_volume) (int chan);
  void (*set_volume) (int chan, int val);
  void (*capture) (void);
  void (*uncapture) (void);
};
#define MIXER_CHAN_TV  0
#define MIXER_CHAN_PCM 1
#define MIXER_CHAN_CAPTURE 2
#endif // _MIXER_H_
