/* XMMS Pipe Control Plugin
 * This is Jeremy Schaeffer's version
 * Use "make xmmspipe-js" to compile it
 */
/*
Copyright (C) 2002 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>

#include <string.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <pthread.h>

//xmms includes
#include <xmms/plugin.h>
#include <xmms/xmmsctrl.h>
#include <xmms/configfile.h>

//for select
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

//for open
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>

//for errno
#include <errno.h>

//for atoi
#include <stdlib.h>

//timer/sleep functions
#include <time.h>
#include <sys/time.h>

#include "version.h"
#include "xmmspipe-js.h"

//from xmms.c
gboolean playlist_load(gchar * filename);
gboolean playlist_save(gchar * filename);

//from widget.h
void lock_widget_list(GList * wlist);
void unlock_widget_list(GList * wlist);

//from main.c
void mainwin_general_menu_callback(gpointer cb_data, guint action, GtkWidget * w);
enum
{
	MAINWIN_GENERAL_ABOUT, MAINWIN_GENERAL_PLAYFILE, MAINWIN_GENERAL_PLAYDIRECTORY,
	MAINWIN_GENERAL_PLAYLOCATION, MAINWIN_GENERAL_FILEINFO,
	MAINWIN_GENERAL_SHOWMWIN, MAINWIN_GENERAL_SHOWPLWIN,
	MAINWIN_GENERAL_SHOWEQWIN, MAINWIN_GENERAL_PREV, MAINWIN_GENERAL_PLAY,
	MAINWIN_GENERAL_PAUSE, MAINWIN_GENERAL_STOP, MAINWIN_GENERAL_NEXT,
	MAINWIN_GENERAL_STOPFADE, MAINWIN_GENERAL_BACK5SEC,
	MAINWIN_GENERAL_FWD5SEC, MAINWIN_GENERAL_START, MAINWIN_GENERAL_BACK10,
	MAINWIN_GENERAL_FWD10, MAINWIN_GENERAL_JTT, MAINWIN_GENERAL_JTF,
	MAINWIN_GENERAL_EXIT
};

enum {
    button_max = 31
};

static GtkWidget *conf_dialog, *about_win;
static pthread_t rm_thread;
static pthread_t vol_thread;
static pthread_t cst_thread;

static int quitpipe[2] = {-1, -1};

static void init();
static void cleanup();
gboolean checkifpipeok(char *pipefile, int *pipei, int *pipeo);
static void printxmmsdata( int tpipe, gboolean upd );
static void *mainloop();
gboolean getxmmsdata( XmmsChange *changedata);
static void *fadevolup();
static void *fadevoldown();
static void *calticks();
static void *cuestop();
static void *cuestart();
static void *cuenext();
void xmmspipeabout(void);
void xmmspipeconfig(void);
void xmmspipesave_config(gchar * configfile);
void xmmspiperead_config(gchar * configfile);
void xmmspipe_config_ok(GtkWidget *wid, gpointer data);
void xmmspipe_config_save(GtkWidget *wid, gpointer data);
void xmmspipe_calticks(GtkWidget *wid, gpointer data);
void xmmspipe_readover(void);

XmmsPipeStatus xpstat = {
	FALSE,
	FALSE,
	FALSE,
	FALSE,
};

XmmsPipeValues xpval = {
	TRUE,
	TRUE,
	FALSE,
	FALSE,
	0,
	1,
	100,
	0,
	0,
	0,
	0,
	0,
	"OK",
	""
};

XmmsPipePipes xpipe = {
	{-1, -1},
	{-1, -1},
	{-1, -1},
	NULL,
	NULL,
	NULL,
	NULL,
	FALSE,
	FALSE,
	TRUE
};


XmmsData xmmstat = {
	0,
	0,
	0,
	0,
	-1,
	-1,
	0,
	0,
	0,
	0,
	0,
	0,
	"",
	"",
	""
};

ConfigWidgetValues gtkval;

GeneralPlugin rm_gp =
{
	NULL,
	NULL,
	0,
	PLUGIN_NAME,
	init,
	xmmspipeabout,
	xmmspipeconfig,
	cleanup
};

extern GList *mainwin_wlist;

void xmmspipeabout(void)
{
	GtkWidget *button, *label, *bigbox, *buttonbox;

	if(about_win)
		return;
	about_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(about_win), ("About"));
	gtk_window_set_policy(GTK_WINDOW(about_win), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(about_win), GTK_WIN_POS_MOUSE);

	bigbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(about_win), bigbox);

	label = gtk_label_new(PLUGIN_NAME);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
	gtk_container_add(GTK_CONTAINER(bigbox), label);

	buttonbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox), GTK_BUTTONBOX_DEFAULT_STYLE);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(buttonbox), 5);
	gtk_box_pack_start(GTK_BOX(bigbox), buttonbox, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(about_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &about_win);
	button = gtk_button_new_with_label("Check.");
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer) about_win);
	gtk_box_pack_start(GTK_BOX ((buttonbox)), button, FALSE, TRUE, 5);
	gtk_widget_show_all(about_win);
}

void xmmspipeconfig(void)
{
 	GtkWidget 	*ok_button, *apply_button, *cancel_button, *buttonbox,
			*bigbox, *textframe, *ctable, *inputfilelabel, *ackfilelabel,
			*statusfilelabel, *ackreturnlabel, *fadespeedlabel, *fadelevellabel,
			*cuefadestartlabel, *cuefadestoplabel, *calfadebutton, *idfilelabel;

        GtkAdjustment *fadesprange, *fadelvlrange, *cuefadestart, *cuefadestop;

	if (conf_dialog) return;
	conf_dialog = gtk_window_new(GTK_WINDOW_DIALOG);

	gtk_window_set_title(GTK_WINDOW(conf_dialog), ("XMMSPipe Setup"));
	gtk_window_set_policy(GTK_WINDOW(conf_dialog), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(conf_dialog), GTK_WIN_POS_MOUSE);
	gtk_container_set_border_width(GTK_CONTAINER(conf_dialog), 5);
	gtk_signal_connect(GTK_OBJECT(conf_dialog), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &conf_dialog);

	bigbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER (GTK_WINDOW(conf_dialog)), bigbox);

	textframe = gtk_frame_new ("Config:");
	gtk_container_add(GTK_CONTAINER(bigbox), textframe);
	ctable = gtk_table_new(14, 4, FALSE);
	gtk_container_add(GTK_CONTAINER(textframe), ctable);

	inputfilelabel = gtk_label_new("Input Pipe File:");
	gtk_label_set_justify(GTK_LABEL(inputfilelabel), GTK_JUSTIFY_LEFT);
	gtk_table_attach_defaults(GTK_TABLE(ctable),inputfilelabel, 0, 1, 0, 1);
	gtkval.inputfiletxt = gtk_entry_new();
	 gtk_entry_set_text(GTK_ENTRY(gtkval.inputfiletxt), xpipe.ipipestr);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.inputfiletxt , 1, 4, 0, 1);

	gtkval.idfileauto = gtk_check_button_new_with_label("Write to ID File at Launch");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtkval.idfileauto) , xpipe.setupid );
        gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.idfileauto , 0, 4, 1, 2);

	idfilelabel = gtk_label_new("ID File:");
	gtk_table_attach_defaults(GTK_TABLE(ctable),idfilelabel, 0, 1, 2, 3);
	gtkval.idfiletxt = gtk_entry_new();
	 gtk_entry_set_text(GTK_ENTRY(gtkval.idfiletxt), xpipe.idfile);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.idfiletxt , 1, 4, 2, 3);

	gtkval.statusfileauto = gtk_check_button_new_with_label("Start Status Pipe at Launch");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtkval.statusfileauto) , xpipe.spipestart );
        gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.statusfileauto , 0, 4, 3, 4);

	statusfilelabel = gtk_label_new("Status Pipe File:");
	gtk_table_attach_defaults(GTK_TABLE(ctable),statusfilelabel, 0, 1, 4, 5);
	gtkval.statusfiletxt = gtk_entry_new();
	 gtk_entry_set_text(GTK_ENTRY(gtkval.statusfiletxt), xpipe.spipestr);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.statusfiletxt , 1, 4, 4, 5);

	gtkval.ackfileauto = gtk_check_button_new_with_label("Start Ack Pipe at Launch");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtkval.ackfileauto) , xpipe.opipestart );
        gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.ackfileauto , 0, 4, 5, 6);

	ackfilelabel = gtk_label_new("Ack Pipe File:");
	gtk_table_attach_defaults(GTK_TABLE(ctable),ackfilelabel, 0, 1, 6, 7);
	gtkval.ackfiletxt = gtk_entry_new();
	 gtk_entry_set_text(GTK_ENTRY(gtkval.ackfiletxt), xpipe.opipestr);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.ackfiletxt , 1, 4, 6, 7);

	ackreturnlabel = gtk_label_new("Ack Return String:");
	gtk_table_attach_defaults(GTK_TABLE(ctable),ackreturnlabel, 0, 1, 7, 8);
	gtkval.ackstring = gtk_entry_new();
	 gtk_entry_set_text(GTK_ENTRY(gtkval.ackstring), xpval.ackas);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.ackstring , 1, 4, 7, 8);

	fadesprange = (GtkAdjustment *) gtk_adjustment_new( xpval.fadespeed , 1, 10, 1, 1, 0);
	fadelvlrange = (GtkAdjustment *) gtk_adjustment_new( xpval.fadelevel , 0, 100, 1, 10, 0);

	fadespeedlabel = gtk_label_new("Fade Speed:");
	gtk_table_attach_defaults(GTK_TABLE(ctable),fadespeedlabel , 0, 1, 8, 9);
        gtkval.fadespeed = gtk_spin_button_new(fadesprange, 1, 0);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.fadespeed , 1, 2, 8, 9);
	fadelevellabel = gtk_label_new("Fade Level:");
	gtk_table_attach_defaults(GTK_TABLE(ctable),fadelevellabel , 2, 3, 8, 9);
	gtkval.fadelevel = gtk_spin_button_new( fadelvlrange, 1, 0);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.fadelevel , 3, 4, 8, 9);

	gtkval.cueplay = gtk_radio_button_new_with_label (NULL, "Cue Mode Immidate Play");
        gtkval.cuepause = gtk_radio_button_new_with_label(gtk_radio_button_group (GTK_RADIO_BUTTON(gtkval.cueplay)), "Cue Mode Immidate Pause");
        gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.cueplay , 0, 2, 9, 10);
        gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.cuepause , 2, 4, 9, 10);
	if (xpval.cuemode) {
          gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtkval.cuepause) , TRUE );
	} else {
          gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtkval.cueplay) , TRUE );
	}

	gtkval.cuefade = gtk_toggle_button_new_with_label("Fade Volume on Cue Start / Stop");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtkval.cuefade) , xpval.cuefade );
        gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.cuefade , 0, 4, 10, 11);

	cuefadestart = (GtkAdjustment *) gtk_adjustment_new( xpval.cuestarttime , 0, 10, 1, 1, 0);
	cuefadestop = (GtkAdjustment *) gtk_adjustment_new( xpval.cuestoptime , 0, 10, 1, 1, 0);

	cuefadestartlabel = gtk_label_new("Skip sec on Cue Start:");
	gtk_table_attach_defaults(GTK_TABLE(ctable),cuefadestartlabel , 0, 1, 11, 12);
        gtkval.cuestart = gtk_spin_button_new(cuefadestart, 1, 0);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.cuestart , 1, 2, 11, 12);
	cuefadestoplabel = gtk_label_new("Skip sec on Cue Stop:");
	gtk_table_attach_defaults(GTK_TABLE(ctable),cuefadestoplabel , 2, 3, 11, 12);
	gtkval.cuestop = gtk_spin_button_new(cuefadestop, 1, 0);
	gtk_table_attach_defaults(GTK_TABLE(ctable),gtkval.cuestop , 3, 4, 11, 12);

	calfadebutton = gtk_button_new_with_label("Calibrate Fade Speed");
        gtk_table_attach_defaults(GTK_TABLE(ctable), calfadebutton, 0, 4, 12, 13);
	gtk_signal_connect_object(GTK_OBJECT(calfadebutton), "clicked", GTK_SIGNAL_FUNC (xmmspipe_calticks), NULL);

	buttonbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(buttonbox), 5);
	gtk_box_pack_start(GTK_BOX(bigbox), buttonbox, FALSE, FALSE, 0);
	ok_button = gtk_button_new_with_label("Ok");
	apply_button = gtk_button_new_with_label("Apply");
	cancel_button = gtk_button_new_with_label("Cancel");

	gtk_signal_connect_object(GTK_OBJECT(cancel_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), (gpointer) conf_dialog);
	gtk_signal_connect_object(GTK_OBJECT(apply_button), "clicked", GTK_SIGNAL_FUNC (xmmspipe_config_save), NULL);
	gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked", GTK_SIGNAL_FUNC (xmmspipe_config_ok), NULL);

	GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(cancel_button, GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(apply_button, GTK_CAN_DEFAULT);

	gtk_box_pack_start(GTK_BOX(buttonbox), ok_button, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(buttonbox), apply_button, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(buttonbox), cancel_button, TRUE, TRUE, 0);

	gtk_widget_show_all(conf_dialog);
}

void xmmspipe_config_ok(GtkWidget *wid, gpointer data)
{
        xmmspipe_readover();
	gtk_widget_destroy(conf_dialog);
	conf_dialog = NULL;
	return;
}

void xmmspipe_config_save(GtkWidget *wid, gpointer data)
{
     gchar *topenfile;
     xmmspipe_readover();
     topenfile = g_strconcat(g_get_home_dir(), "/.xmms/xmmspipe.conf",  NULL);
     xmmspipesave_config(topenfile);
     g_free(topenfile);
}

void xmmspipe_calticks(GtkWidget *wid, gpointer data)
{
 xpstat.abortfade = FALSE;
 if (!xpstat.involfade) pthread_create(&vol_thread, NULL, calticks, NULL);
}

void xmmspipe_readover(void)
{
 gchar *inputfile, *ackfile, *statusfile, *ackas, *idfile;

 inputfile = gtk_entry_get_text(GTK_ENTRY(gtkval.inputfiletxt));
 ackfile = gtk_entry_get_text(GTK_ENTRY(gtkval.ackfiletxt));
 statusfile = gtk_entry_get_text(GTK_ENTRY(gtkval.statusfiletxt));
 ackas = gtk_entry_get_text(GTK_ENTRY(gtkval.ackstring));
 idfile = gtk_entry_get_text(GTK_ENTRY(gtkval.idfiletxt));

 if (strcmp(inputfile, xpipe.ipipestr)) {
  gchar *topenfile;
  g_free(xpipe.ipipestr);
  xpipe.ipipestr = g_strdup(inputfile);
  write(quitpipe[1], "Q", 1);
  pthread_join(rm_thread, NULL);
  close(xpipe.ipipe[0]);
  close(xpipe.ipipe[1]);
   topenfile = g_strdup_printf( "%s.%i", xpipe.ipipestr, rm_gp.xmms_session);
   if(!checkifpipeok(topenfile, &xpipe.ipipe[0],  &xpipe.ipipe[1])) perror("Input pipe create error!!");
   free(topenfile);
  checkifpipeok(xpipe.ipipestr, &xpipe.ipipe[0], &xpipe.ipipe[1]);
  pthread_create(&rm_thread, NULL, mainloop, NULL);
 }

 if (strcmp(ackfile, xpipe.opipestr)) {
  g_free(xpipe.opipestr);
  xpipe.opipestr = g_strdup(ackfile);
  if (xpipe.opipe[0] != -1) {
   gchar *topenfile;
   close(xpipe.opipe[0]);
   close(xpipe.opipe[1]);
   topenfile = g_strdup_printf( "%s.%i", xpipe.opipestr, rm_gp.xmms_session);
   if(!checkifpipeok(topenfile, &xpipe.opipe[0],  &xpipe.opipe[1])) perror("Ack pipe error!!");
   free(topenfile);
  }
 }

 if (strcmp(statusfile, xpipe.spipestr)) {
  g_free(xpipe.spipestr);
  xpipe.spipestr = g_strdup(statusfile);
  if (xpipe.spipe[0] != -1) {
   gchar *topenfile;
   close(xpipe.spipe[0]);
   close(xpipe.spipe[1]);
   topenfile = g_strdup_printf( "%s.%i", xpipe.spipestr, rm_gp.xmms_session);
   if(!checkifpipeok(topenfile, &xpipe.spipe[0],  &xpipe.spipe[1])) perror("Status pipe error!!");
   free(topenfile);
  }
 }

 if (strcmp(ackas, xpval.ackas)) {
  strcpy(xpval.ackas, ackas);
 }

 if (strcmp(idfile, xpipe.idfile)) {
  g_free(xpipe.idfile);
  xpipe.idfile = g_strdup(idfile);
 }

 xpval.fadespeed = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gtkval.fadespeed));
 xpval.fadelevel = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gtkval.fadelevel));
 xpval.cuestarttime = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gtkval.cuestart));
 xpval.cuestoptime = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gtkval.cuestop));

 xpipe.spipestart = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gtkval.statusfileauto));
 xpipe.opipestart = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gtkval.ackfileauto));
 xpipe.setupid = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gtkval.idfileauto));
 xpval.cuefade = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gtkval.cuefade));
 xpval.cuemode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gtkval.cuepause));

 return;
}

void xmmspipesave_config(gchar * configfile)
{
 ConfigFile *config;
	if ((config = xmms_cfg_open_file(configfile)) == NULL) config = xmms_cfg_new();
	xmms_cfg_write_string (config, "pipe", "inputpipe", xpipe.ipipestr);
	xmms_cfg_write_string (config, "pipe", "ackpipe", xpipe.opipestr);
	xmms_cfg_write_boolean (config, "pipe", "ackpipeon", xpipe.opipestart);
	xmms_cfg_write_string (config, "pipe", "statuspipe", xpipe.spipestr);
	xmms_cfg_write_boolean (config, "pipe", "statuspipeon", xpipe.spipestart);
	xmms_cfg_write_string (config, "ackpipe", "ackas", xpval.ackas);
	xmms_cfg_write_boolean (config, "cue", "mode", xpval.cuemode);
	xmms_cfg_write_boolean (config, "cue", "fade", xpval.cuefade);
	xmms_cfg_write_int (config, "cue", "jump", xpval.cuestarttime);
	xmms_cfg_write_int (config, "cue", "stops", xpval.cuestoptime);
	xmms_cfg_write_int (config, "fade", "speed", xpval.fadespeed);
	xmms_cfg_write_int (config, "fade", "level", xpval.fadelevel);
	xmms_cfg_write_int (config, "status", "mode", xpval.statusmode);
	xmms_cfg_write_double (config, "fade", "calticks", xpval.tickcal);
	xmms_cfg_write_boolean (config, "id", "setupid", xpipe.setupid);
	xmms_cfg_write_string (config, "id", "idfile", xpipe.idfile);
	xmms_cfg_write_file (config, configfile);
	xmms_cfg_free(config);
	return;
}

void xmmspiperead_config(gchar * configfile)
{
	ConfigFile *config;
	gchar *ackas;
	if ((config = xmms_cfg_open_file (configfile)) != NULL)
	{
		xmms_cfg_read_string (config, "pipe", "inputpipe", &xpipe.ipipestr);
		xmms_cfg_read_string (config, "pipe", "ackpipe", &xpipe.opipestr);
		xmms_cfg_read_boolean (config, "pipe", "ackpipeon", &xpipe.opipestart);
		xmms_cfg_read_string (config, "pipe", "statuspipe", &xpipe.spipestr);
		xmms_cfg_read_boolean (config, "pipe", "statuspipeon", &xpipe.spipestart);
		xmms_cfg_read_string (config, "ackpipe", "ackas", &ackas);
		strcpy(xpval.ackas, ackas);
		xmms_cfg_read_boolean (config, "cue", "mode", &xpval.cuemode);
		xmms_cfg_read_boolean (config, "cue", "fade", &xpval.cuefade);
		xmms_cfg_read_int (config, "cue", "jump", &xpval.cuestarttime);
		xmms_cfg_read_int (config, "cue", "stops", &xpval.cuestoptime);
		xmms_cfg_read_int (config, "fade", "speed", &xpval.fadespeed);
		xmms_cfg_read_int (config, "fade", "level", &xpval.fadelevel);
		xmms_cfg_read_int (config, "status", "mode", &xpval.statusmode);
		xmms_cfg_read_double (config, "fade", "calticks", &xpval.tickcal);
		xmms_cfg_read_boolean (config, "id", "setupid", &xpipe.setupid);
		xmms_cfg_read_string (config, "id", "idfile", &xpipe.idfile);
	}
 return;
}

gboolean getxmmsdata( XmmsChange *changedata)
{
 gboolean changes = FALSE;
 XmmsData rawdata = {0,0,0,0,-1,-1,0,0,0,0,0,0,"","",""};

 rawdata.playlist_length = xmms_remote_get_playlist_length(rm_gp.xmms_session);

  if (rawdata.playlist_length > 0) {
   rawdata.otime = xmms_remote_get_output_time(rm_gp.xmms_session) / 1000 ;
   rawdata.playlist_pos = xmms_remote_get_playlist_pos(rm_gp.xmms_session);
   rawdata.playtime = xmms_remote_get_playlist_time(rm_gp.xmms_session, rawdata.playlist_pos) / 1000;
   strcpy(rawdata.playfile, xmms_remote_get_playlist_file(rm_gp.xmms_session, rawdata.playlist_pos));
   strcpy(rawdata.playtitle, xmms_remote_get_playlist_title(rm_gp.xmms_session, rawdata.playlist_pos));
   xmms_remote_get_info(rm_gp.xmms_session, &rawdata.rate, &rawdata.freq, &rawdata.nch);
   if (xmms_remote_is_playing(rm_gp.xmms_session)) {
    if (xmms_remote_is_paused(rm_gp.xmms_session)) {
     strcpy(rawdata.stat, "Paused");
     xmmstat.paused = TRUE;
     xmmstat.playing = TRUE;
    } else {
     strcpy(rawdata.stat, "Playing");
     xmmstat.playing = TRUE;
     xmmstat.paused = FALSE;
    }
   } else {
     strcpy(rawdata.stat, "Stopped");
     xmmstat.playing = FALSE;
     xmmstat.paused = FALSE;
   }
  }
  xmms_remote_get_volume(rm_gp.xmms_session, &rawdata.lvolume, &rawdata.rvolume);
  rawdata.balance = xmms_remote_get_balance(rm_gp.xmms_session);

  if ( rawdata.otime != xmmstat.otime ) {
   xmmstat.otime = rawdata.otime;
   if (changedata != NULL) changedata->otime = TRUE;
   changes = TRUE;
  }

  if ( rawdata.playtime != xmmstat.playtime ) {
   xmmstat.playtime = rawdata.playtime;
   if (changedata != NULL) changedata->playtime = TRUE;
   changes = TRUE;
  }

  if ( rawdata.playlist_length != xmmstat.playlist_length ) {
   xmmstat.playlist_length = rawdata.playlist_length;
   if (changedata != NULL) changedata->playlist_length = TRUE;
   changes = TRUE;
  }

  if ( rawdata.playlist_pos != xmmstat.playlist_pos ) {
   xmmstat.playlist_pos = rawdata.playlist_pos;
   if (changedata != NULL) changedata->playlist_pos = TRUE;
   changes = TRUE;
  }

  if ( rawdata.rate != xmmstat.rate ) {
   xmmstat.rate = rawdata.rate;
   if (changedata != NULL) changedata->rate = TRUE;
   changes = TRUE;
  }

  if ( rawdata.freq != xmmstat.freq ) {
   xmmstat.freq = rawdata.freq;
   if (changedata != NULL) changedata->freq = TRUE;
   changes = TRUE;
  }

  if ( rawdata.nch != xmmstat.nch ) {
   xmmstat.nch = rawdata.nch;
   if (changedata != NULL) changedata->nch = TRUE;
   changes = TRUE;
  }

  if ( rawdata.lvolume != xmmstat.lvolume ) {
   xmmstat.lvolume = rawdata.lvolume;
   if (changedata != NULL) changedata->lvolume = TRUE;
   changes = TRUE;
  }

  if ( rawdata.rvolume != xmmstat.rvolume ) {
   xmmstat.rvolume = rawdata.rvolume;
   if (changedata != NULL) changedata->rvolume = TRUE;
   changes = TRUE;
  }

  if ( rawdata.balance != xmmstat.balance ) {
   xmmstat.balance = rawdata.balance;
   if (changedata != NULL) changedata->balance = TRUE;
   changes = TRUE;
  }

  if (strcmp(xmmstat.playfile, rawdata.playfile)) {
   strcpy(xmmstat.playfile, rawdata.playfile);
   if (changedata != NULL) changedata->playfile = TRUE;
   changes = TRUE;
  }

  if (strcmp(xmmstat.playtitle, rawdata.playtitle)) {
   strcpy(xmmstat.playtitle, rawdata.playtitle);
   if (changedata != NULL) changedata->playtitle = TRUE;
   changes = TRUE;
  }

  if (strcmp(xmmstat.stat, rawdata.stat)) {
   strcpy(xmmstat.stat, rawdata.stat);
   if (changedata != NULL) changedata->stat = TRUE;
   changes = TRUE;
  }

 return changes;
}

static void open_jump_window()
{
    lock_widget_list(mainwin_wlist);
    mainwin_general_menu_callback(0, MAINWIN_GENERAL_JTF, 0);
    unlock_widget_list(mainwin_wlist);
}

static void jump_to(char *searchstr)
{
    int oldpos = xmms_remote_get_playlist_pos(rm_gp.xmms_session);
    int i;
    int playlist_length = xmms_remote_get_playlist_length(rm_gp.xmms_session);
    char *s, *s1, *s2;
    GList *foundlist = NULL, *here = NULL;

    s2 = g_strdup(searchstr);
    for (s = s2; *s; s++) {
	*s = tolower(*s);
    }
    for (i=0; i<playlist_length; i++) {
	s1 = g_strdup(xmms_remote_get_playlist_title(rm_gp.xmms_session, i));
	for (s = s1; *s; s++) {
	    *s = tolower(*s);
	}
	if (strstr(s1, s2)) {
	    foundlist = g_list_append(foundlist, GINT_TO_POINTER(i));
	    if (oldpos == i) here = g_list_last(foundlist);
	}
	free(s1);
    }
    free(s2);

    if (here) {
	if (here->next) {
	    xmms_remote_set_playlist_pos(rm_gp.xmms_session, GPOINTER_TO_INT(here->next->data));
	} else {
	    xmms_remote_set_playlist_pos(rm_gp.xmms_session, GPOINTER_TO_INT(foundlist->data));
	}
    } else if (foundlist) {
	xmms_remote_set_playlist_pos(rm_gp.xmms_session, GPOINTER_TO_INT(foundlist->data));
    }
    g_list_free(foundlist);
}

static void handle_string(char *s)
{
    gchar **arg;
    gint i;
    gchar *ackstr;
    struct stat stbuf;

     if (!strcmp(xpval.ackas,"ECHO")) {
      ackstr = g_strdup(s);
     } else {
      ackstr = g_strdup(xpval.ackas);
     }
     if (strlen(ackstr)) g_strconcat(ackstr,"\n",NULL);

     arg = g_strsplit(s, " ", 3);

     //fprintf(stderr, "s = %s, %s %s %s \n", s, arg[0], arg[1], arg[2]);

    if (!strcmp(arg[0], "playlist")) {
     if (arg[1]) {
	if (!strcmp(arg[1], "set_position")) {
	  if (arg[2]) {
	    i = atoi(arg[2]);
	    if (i >= 1 && i <= xmmstat.playlist_length) {
		xmms_remote_set_playlist_pos(rm_gp.xmms_session, i - 1);
	    }
	  }
	}
        if (!strcmp(arg[1], "delete")) {
	  if (arg[2]) {
	    i = atoi(arg[2]);
	    if (i >= 1 && i <= xmmstat.playlist_length) {
		xmms_remote_playlist_delete(rm_gp.xmms_session, i - 1);
	    }
	  }
	}
        if (!strcmp(arg[1], "delete_current")) {
	 if (xmmstat.playlist_length > 0) {
	    i = xmms_remote_get_playlist_pos(rm_gp.xmms_session);
	    xmms_remote_playlist_delete(rm_gp.xmms_session, i);
	 }
	}
        if (!strcmp(arg[1], "prev")) {
	 if ( xmmstat.playlist_length != 0 ) xmms_remote_playlist_prev(rm_gp.xmms_session);
	}
        if (!strcmp(arg[1], "next")) {
	 if ( xmmstat.playlist_length != 0 ) xmms_remote_playlist_next(rm_gp.xmms_session);
	}
	if (!strcmp(arg[0], "jump")) {
	 if (arg[2]) {
	  if ( xmmstat.playlist_length != 0 ) jump_to(arg[2]);
	 }
	}
        if (!strcmp(arg[1], "clear")) {
	 if ( xmmstat.playlist_length != 0 ) xmms_remote_playlist_clear(rm_gp.xmms_session);
	}
        if (!strcmp(arg[1], "add")) {
	 if (arg[2]) {
	     if (!stat(arg[2], &stbuf)) {
	      GList *songlist = NULL;
	      songlist = g_list_append(songlist, arg[2]);
	      xmms_remote_playlist_add(rm_gp.xmms_session, songlist);
	      g_list_free(songlist);
	     }
	 }
	}
	if (!strcmp(arg[1], "load")) if (arg[2]) { if (!stat(arg[2], &stbuf)) playlist_load(arg[2]); }
        if (!strcmp(arg[1], "save")) if (arg[2]) { if (!stat(arg[2], &stbuf)) playlist_save(arg[2]); }
        if (!strcmp(arg[1], "jump_window")) open_jump_window();

      if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
     }
    }

    if (!strcmp(arg[0], "cue")) {
     if (arg[1]) {
      if (!strcmp(arg[1], "mode")) {
       if (!strcmp(arg[2], "play")) xpval.cuemode = FALSE;
       if (!strcmp(arg[2], "pause")) xpval.cuemode = TRUE;
      }
      if (!strcmp(arg[1], "fade")) {
       if (!strcmp(arg[2], "off")) xpval.cuefade = FALSE;
       if (!strcmp(arg[2], "on")) xpval.cuefade = TRUE;
      }
      if (!strcmp(arg[1], "watch")) {
       if (!strcmp(arg[2], "off")) xpval.cuewatching = FALSE;
       if (!strcmp(arg[2], "on")) xpval.cuewatching = TRUE;
      }
      if (!strcmp(arg[1], "starttime")) {
       if (arg[2]) xpval.cuestarttime = atoi(arg[2]);
      }
      if (!strcmp(arg[1], "endtime")) {
       if (arg[2]) xpval.cuestoptime = atoi(arg[2]);
      }
      if (!strcmp(arg[1], "next")) {
       if (arg[2]) {
        if (!stat(arg[2], &stbuf)) {
         xpstat.stopcue = FALSE;
	 strcpy(xpval.next, arg[2]);
         if (!xpstat.incue) {
	  pthread_attr_t attr;
	  pthread_attr_init(&attr);
	  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	  pthread_create(&cst_thread, &attr, cuenext, NULL);
	 }
	}
       }
      }
      if (!strcmp(arg[1], "play")) {
       xpstat.stopcue = FALSE;
       if (!xpstat.incue) {
          pthread_attr_t attr;
	  pthread_attr_init(&attr);
	  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	  pthread_create(&cst_thread, &attr, cuestart, NULL);
       }
      }
      if (!strcmp(arg[1], "stop")) {
       xpstat.stopcue = FALSE;
       if (!xpstat.incue) {
          pthread_attr_t attr;
	  pthread_attr_init(&attr);
	  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	  pthread_create(&cst_thread, &attr, cuestop, NULL);
       }
      }
      if (!strcmp(arg[1], "cancel")) xpstat.stopcue = TRUE;
      if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
     }
    }
    if (!strcmp(arg[0], "play")) {
     if ( xmmstat.playlist_length != 0 ) {
      xmms_remote_play(rm_gp.xmms_session);
     }
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "pause")) {
	if ( xmmstat.playlist_length != 0 ) {
         if (xmmstat.playing) {
          if (xmmstat.paused) {
	     xmms_remote_play(rm_gp.xmms_session);
	    } else {
	     xmms_remote_pause(rm_gp.xmms_session);
	    }
           } else {
            xmms_remote_play(rm_gp.xmms_session);
            for(;;) {if (xmmstat.playing) break;}
	    xmms_remote_pause(rm_gp.xmms_session);
	   }
	 }
      if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "play_pause")) {
	if ( xmmstat.playlist_length != 0 ) {
	 if (xmms_remote_is_playing(rm_gp.xmms_session))
	    xmms_remote_pause(rm_gp.xmms_session);
	 else
	    xmms_remote_play(rm_gp.xmms_session);
	}
        if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }

    if (!strcmp(arg[0], "stop")) {
     xmms_remote_stop(rm_gp.xmms_session);
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "mute")) {
	if (xpval.mute_flag) {
	    xpval.mute_flag = FALSE;
	    xmms_remote_set_volume(rm_gp.xmms_session, xpval.last_vl, xpval.last_vr);
	} else {
	    xpval.mute_flag = TRUE;
	    xmms_remote_get_volume(rm_gp.xmms_session, &xpval.last_vl, &xpval.last_vr);
	    xmms_remote_set_volume(rm_gp.xmms_session, 0, 0);
	}
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "jump_to_time")) {
     if (arg[1]) xmms_remote_jump_to_time(rm_gp.xmms_session, atoi(arg[1]));
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "add_volume")) {
	if (arg[1]) {
	    gint l, r;
	    if (xpval.mute_flag) {
		xpval.mute_flag = FALSE;
		xmms_remote_set_volume(rm_gp.xmms_session, xpval.last_vl, xpval.last_vr);
	    } else {
		xmms_remote_get_volume(rm_gp.xmms_session, &xpval.last_vl, &xpval.last_vr);
	    }
	    l = atoi(arg[1]);
	    if (arg[2]) {
             r = atoi(arg[2]);
	    } else {
             r = l;
	    }
	    xpval.last_vl += l;
	    xpval.last_vr += r;
	    if (xpval.last_vl < 0) xpval.last_vl = 0;
	    if (xpval.last_vr < 0) xpval.last_vr = 0;
	    if (xpval.last_vl > 100) xpval.last_vl = 100;
	    if (xpval.last_vr > 100) xpval.last_vr = 100;
	    xmms_remote_set_volume(rm_gp.xmms_session, xpval.last_vl, xpval.last_vr);
	}
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "balance")) {
	if (arg[1]) {
	    i = atoi(arg[1]);
	    if (i < -100) i = -100;
	    if (i > 100) i = 100;
	    xmms_remote_set_balance(rm_gp.xmms_session, i);
	}
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "volume")) {
	if (arg[1]) {
	    gint l, r;
	    if (xpval.mute_flag) {
		xpval.mute_flag = FALSE;
		xmms_remote_set_volume(rm_gp.xmms_session, xpval.last_vl, xpval.last_vr);
	    }
	    l = atoi(arg[1]);
	    if (arg[2]) {
             r = atoi(arg[2]);
	    } else {
             r = l;
	    }
	    xpval.last_vl = l;
	    xpval.last_vr = r;
	    if (xpval.last_vl < 0) xpval.last_vl = 0;
	    if (xpval.last_vr < 0) xpval.last_vr = 0;
	    if (xpval.last_vl > 100) xpval.last_vl = 100;
	    if (xpval.last_vr > 100) xpval.last_vr = 100;
	    xmms_remote_set_volume(rm_gp.xmms_session, xpval.last_vl, xpval.last_vr);
	}
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }

    if (!strcmp(arg[0], "quit")) {
	xmms_remote_quit(rm_gp.xmms_session);
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "repeat")) {
      if (arg[1]) {
       if (!strcmp(arg[1], "on")) {
        if (xmms_remote_is_repeat(rm_gp.xmms_session) == FALSE) xmms_remote_toggle_repeat(rm_gp.xmms_session);
       }
       if (!strcmp(arg[1], "off")) {
        if (xmms_remote_is_repeat(rm_gp.xmms_session) == TRUE) xmms_remote_toggle_repeat(rm_gp.xmms_session);
       }
       if (!strcmp(arg[1], "toggle")) {
	xmms_remote_toggle_repeat(rm_gp.xmms_session);
       }
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
      }
    }
    if (!strcmp(arg[0], "shuffle")) {
    if (arg[1]) {
       if (!strcmp(arg[1], "on")) {
        if (xmms_remote_is_shuffle(rm_gp.xmms_session) == FALSE) xmms_remote_toggle_shuffle(rm_gp.xmms_session);
       }
       if (!strcmp(arg[1], "off")) {
        if (xmms_remote_is_shuffle(rm_gp.xmms_session) == TRUE) xmms_remote_toggle_shuffle(rm_gp.xmms_session);
       }
       if (!strcmp(arg[1], "toggle")) {
	xmms_remote_toggle_shuffle(rm_gp.xmms_session);
       }
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
      }
    }
    if (!strcmp(arg[0], "window")) {
     if (arg[1]) {
      if (!strcmp(arg[1], "main") || !strcmp(arg[1], "all")) {
       if (!strcmp(arg[2], "show")) xmms_remote_main_win_toggle(rm_gp.xmms_session,TRUE);
       if (!strcmp(arg[2], "hide")) xmms_remote_main_win_toggle(rm_gp.xmms_session,FALSE);
       if (!strcmp(arg[2], "toggle")) {
 	if (xmms_remote_is_main_win(rm_gp.xmms_session) == TRUE ) {
	 xmms_remote_main_win_toggle(rm_gp.xmms_session,FALSE);
	} else {
	 xmms_remote_main_win_toggle(rm_gp.xmms_session,TRUE);
	}
       }
      }
      if (!strcmp(arg[1], "eq") || !strcmp(arg[1], "all")) {
       if (!strcmp(arg[2], "show")) xmms_remote_eq_win_toggle(rm_gp.xmms_session,TRUE);
       if (!strcmp(arg[2], "hide")) xmms_remote_eq_win_toggle(rm_gp.xmms_session,FALSE);
       if (!strcmp(arg[2], "toggle")) {
 	if (xmms_remote_is_eq_win(rm_gp.xmms_session) == TRUE ) {
	 xmms_remote_eq_win_toggle(rm_gp.xmms_session,FALSE);
	} else {
	 xmms_remote_eq_win_toggle(rm_gp.xmms_session,TRUE);
	}
       }
      }
      if (!strcmp(arg[1], "play") || !strcmp(arg[1], "all")) {
       if (!strcmp(arg[2], "show")) xmms_remote_pl_win_toggle(rm_gp.xmms_session,TRUE);
       if (!strcmp(arg[2], "hide")) xmms_remote_pl_win_toggle(rm_gp.xmms_session,FALSE);
       if (!strcmp(arg[2], "toggle")) {
 	if (xmms_remote_is_pl_win(rm_gp.xmms_session) == TRUE ) {
	 xmms_remote_pl_win_toggle(rm_gp.xmms_session,FALSE);
	} else {
	 xmms_remote_pl_win_toggle(rm_gp.xmms_session,TRUE);
	}
       }
      }
     }
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "fade")) {
     if (arg[1]) {
      if (!strcmp(arg[1], "speed")) { if (arg[2]) xpval.fadespeed = atoi(arg[2]); }
      if (!strcmp(arg[1], "level")) { if (arg[2]) xpval.fadelevel = atoi(arg[2]); }
      if (!strcmp(arg[1], "stop")) xpstat.abortfade = TRUE;
      if (!strcmp(arg[1], "calibrate")){
        xpstat.abortfade = FALSE;
       if (!xpstat.involfade) {
          pthread_attr_t attr;
	  pthread_attr_init(&attr);
	  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	  pthread_create(&vol_thread, &attr, calticks, NULL);
       }
      }
      if (!strcmp(arg[1], "up")) {
        xpstat.abortfade = FALSE;
       if (!xpstat.involfade) {
          pthread_attr_t attr;
	  pthread_attr_init(&attr);
	  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	  pthread_create(&vol_thread, &attr, fadevolup, NULL);
       }
      }
      if (!strcmp(arg[1], "down")) {
        xpstat.abortfade = FALSE;
       if (!xpstat.involfade) {
          pthread_attr_t attr;
	  pthread_attr_init(&attr);
	  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	  pthread_create(&vol_thread, &attr, fadevoldown, NULL);
       }
      }
     }
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "status")) {
     gboolean tclose = FALSE;
     gboolean topen = FALSE;
     if (arg[1]) {
      if (!strcmp(arg[1], "pipefile")) {
       if (arg[2]) {
       if (xpipe.spipe[1] != -1) { tclose = TRUE; topen = TRUE; }
	g_free(xpipe.spipestr);
	xpipe.spipestr = g_strdup(arg[2]);
       }
      }
       // 0 = outpipe, fancy; 1 = outpipe, raw; 2 = spipe, raw
      if (!strcmp(arg[1], "mode")) {
       if (!strcmp(arg[2], "fancy")) xpval.statusmode = 0;
       if (!strcmp(arg[2], "raw")) xpval.statusmode = 1;
       if (!strcmp(arg[2], "pipe")) xpval.statusmode = 2;
      }
      if (!strcmp(arg[1], "flush")) {
       if ( xpval.statusmode == 0 ) printxmmsdata(xpipe.opipe[1],FALSE) ;
       if ( xpval.statusmode == 1 ) printxmmsdata(xpipe.opipe[1],FALSE) ;
       if ( xpval.statusmode == 2 ) {
         if ( xpipe.spipe[1] ) printxmmsdata(xpipe.spipe[1],FALSE) ;
       }
      }
      if (!strcmp(arg[1], "once")) {
       if ( xpval.statusmode == 0 ) printxmmsdata(xpipe.opipe[1],FALSE) ;
       if ( xpval.statusmode == 1 ) printxmmsdata(xpipe.opipe[1],TRUE) ;
       if ( xpval.statusmode == 2 ) {
         if ( xpipe.spipe[1] ) printxmmsdata(xpipe.spipe[1],TRUE) ;
       }
      }
      if (!strcmp(arg[1], "start")) topen = TRUE;
      if (!strcmp(arg[1], "stop")) tclose = TRUE;
      if (!strcmp(arg[1], "autostart")) {
       if (!strcmp(arg[2], "off")) xpipe.spipestart = FALSE;
       if (!strcmp(arg[2], "on")) xpipe.spipestart = TRUE;
      }
     }
     if (tclose) {
       close(xpipe.spipe[0]);
       close(xpipe.spipe[1]);
     }
     if (topen) {
      gchar *topenfile;
      topenfile = g_strdup_printf( "%s.%i", xpipe.spipestr, rm_gp.xmms_session);
      if(!checkifpipeok(topenfile, &xpipe.spipe[0],  &xpipe.spipe[1])) perror("Status pipe error!!");
      free(topenfile);
      xpval.statusmode = 2;
     }
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }

    if (!strcmp(arg[0], "ack")) {
     gboolean tclose = FALSE;
     gboolean topen = FALSE;
     if (arg[1]) {
      if (!strcmp(arg[1], "pipefile")) {
       if (arg[2]) {
        if (xpipe.opipe[1] != -1) { tclose = TRUE; topen = TRUE; }
	g_free(xpipe.opipestr);
	xpipe.opipestr = g_strdup(arg[2]);
       }
      }
      if (!strcmp(arg[1], "start")) topen = TRUE;
      if (!strcmp(arg[1], "stop")) tclose = TRUE;
      if (!strcmp(arg[1], "echo")) strcpy(xpval.ackas ,"ECHO");

      if (!strcmp(arg[1], "return")) {
       if (arg[2]) strcpy(xpval.ackas, arg[2]);
      }
      if (!strcmp(arg[1], "autostart")) {
       if (!strcmp(arg[2], "off")) xpipe.opipestart = FALSE;
       if (!strcmp(arg[2], "on")) xpipe.opipestart = TRUE;
      }
     }
     if (tclose) {
       close(xpipe.opipe[0]);
       close(xpipe.opipe[1]);
     }
     if (topen) {
      gchar *topenfile;
      topenfile = g_strdup_printf( "%s.%i", xpipe.opipestr, rm_gp.xmms_session);
      if(!checkifpipeok(topenfile, &xpipe.opipe[0],  &xpipe.opipe[1])) perror("Ack pipe error!!");
      free(topenfile);
     }
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
    if (!strcmp(arg[0], "saveconfig")) {
     gchar *topenfile;
     topenfile = g_strconcat(g_get_home_dir(), "/.xmms/xmmspipe.conf",  NULL);
     xmmspipesave_config(topenfile);
     g_free(topenfile);
    }
 if (!strcmp(arg[0], "id")) {
    if (arg[1]) {
      if (!strcmp(arg[1], "file")) {
       if (arg[2]) {
	g_free(xpipe.idfile);
	xpipe.idfile = g_strdup(arg[2]);
       }
       if (!strcmp(arg[2], "off")) xpipe.setupid = FALSE;
       if (!strcmp(arg[2], "on")) xpipe.setupid = TRUE;
      }
     if (xpipe.opipe[1] != -1) { if (strlen(ackstr)) write(xpipe.opipe[1], ackstr, strlen(ackstr)); }
    }
 }
 g_free(ackstr);
 g_strfreev(arg);

}

static void printxmmsdata( int tpipe, gboolean upd )
{
 char buffer[1024];
 gboolean changed;
 XmmsChange newchange = { FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE };
 if (tpipe == -1) return;
 changed = getxmmsdata(&newchange);

 if ( xpval.statusmode == 0 ) {
  sprintf(buffer, "XMMS Verson :%i Plugin Version: %s Session : %i\n", xmmstat.version, VERSION_STRING, xmmstat.session);
  write(tpipe, buffer, strlen(buffer));
  sprintf(buffer, "Playlist Length: %i Playlist Posision : %i\n", xmmstat.playlist_length, xmmstat.playlist_pos);
  write(tpipe, buffer, strlen(buffer));
  sprintf(buffer, "Playing File: %s\n", xmmstat.playfile);
  write(tpipe, buffer, strlen(buffer));
  sprintf(buffer, "Playing Title: %s\n", xmmstat.playtitle);
  write(tpipe, buffer, strlen(buffer));
  sprintf(buffer, "Status: %s Song Time: %i Played Time: %i\n", xmmstat.stat, xmmstat.playtime, xmmstat.otime);
  write(tpipe, buffer, strlen(buffer));
  sprintf(buffer, "Rate: %i Frequncy: %i Channels: %i\n", xmmstat.rate, xmmstat.freq, xmmstat.nch);
  write(tpipe, buffer, strlen(buffer));
  sprintf(buffer, "Left Volume: %i Right Volume: %i Balance: %i\n", xmmstat.lvolume, xmmstat.rvolume, xmmstat.balance);
  write(tpipe, buffer, strlen(buffer));
 } else {
  if ( upd && !changed ) return;

  if (!upd) {
   sprintf(buffer, "session:%i\nplugin:%s\nversion:%i\n", xmmstat.session, VERSION_STRING, xmmstat.version);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.otime ) {
   sprintf(buffer, "otime:%i\n", xmmstat.otime);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.playtime ) {
   sprintf(buffer, "playtime:%i\n", xmmstat.playtime);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.playlist_length ) {
   sprintf(buffer, "playlist_length:%i\n", xmmstat.playlist_length);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.playlist_pos ) {
   sprintf(buffer, "playlist_pos:%i\n", xmmstat.playlist_pos);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.rate ) {
   sprintf(buffer, "rate:%i\n", xmmstat.rate);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.freq ) {
   sprintf(buffer, "freq:%i\n", xmmstat.freq);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.nch ) {
   sprintf(buffer, "nch:%i\n", xmmstat.nch);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.lvolume ) {
   sprintf(buffer, "lvolume:%i\n", xmmstat.lvolume);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.rvolume ) {
   sprintf(buffer, "rvolume:%i\n", xmmstat.rvolume);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.balance ) {
   sprintf(buffer, "balance:%i\n", xmmstat.balance);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.playfile ) {
   sprintf(buffer, "playfile:%s\n", xmmstat.playfile);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.playtitle ) {
   sprintf(buffer, "playtitle:%s\n", xmmstat.playtitle);
   write(tpipe, buffer, strlen(buffer));
  }

  if ( !upd || newchange.stat ) {
   sprintf(buffer, "stat:%s\n", xmmstat.stat);
   write(tpipe, buffer, strlen(buffer));
  }
 }
}

static void *cuenext( )
{
 GList *songlist = NULL;
 struct timespec reqtime;
 struct timespec acttime;
 xpstat.incue = TRUE;
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "cuenext:start\n", 14);

  reqtime.tv_sec = 0;
  reqtime.tv_nsec = 1000000;

  if (xmmstat.playing && !xmmstat.paused) {
    if (xpval.cuefade) fadevoldown();
    xmms_remote_stop(rm_gp.xmms_session);
    for (;;) { nanosleep(&reqtime,&acttime); if (!xmmstat.playing) break; }
  }

  xmms_remote_playlist_clear(rm_gp.xmms_session);
  songlist = g_list_append(songlist, xpval.next);
  xmms_remote_playlist_add(rm_gp.xmms_session, songlist);
  g_list_free(songlist);


  xmms_remote_play(rm_gp.xmms_session);
  for (;;) { nanosleep(&reqtime,&acttime); if (xmmstat.playing) break; }
  if (xpval.cuestarttime != 0) xmms_remote_jump_to_time(rm_gp.xmms_session, xpval.cuestarttime);
  if (xpval.cuemode) {
   xmms_remote_pause(rm_gp.xmms_session);
  } else {
   if (xpval.cuefade) fadevolup();
  }

 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "cuenext:done\n", 13);
 xpstat.stopcue = FALSE;
 xpstat.incue = FALSE;
 return NULL;
}

static void *cuestart()
{
 xpstat.incue = TRUE;
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "cuestart:start\n", 15);
 xmms_remote_play(rm_gp.xmms_session);
 if (xpval.cuefade) fadevolup();
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "cuestart:done\n", 14);
 xpstat.stopcue = FALSE;
 xpstat.incue = FALSE;
 return NULL;
}

static void *cuestop()
{
 xpstat.incue = TRUE;
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "cuestop:start\n", 14);
 if (xpval.cuefade) fadevoldown();
 xmms_remote_stop(rm_gp.xmms_session);
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "cuestop:done\n", 13);
 xpstat.stopcue = FALSE;
 xpstat.incue = FALSE;
 return NULL;
}


static void *calticks()
{
unsigned int sllvl;
unsigned int srlvl;
unsigned int lvl = 100;
struct timeval starttime;
struct timeval endtime;
struct timespec reqtime;
struct timespec acttime;
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "fade:start\n", 11);
  reqtime.tv_sec = 0;
  reqtime.tv_nsec = 40000000;

 xmms_remote_get_volume(rm_gp.xmms_session, &sllvl, &srlvl);
 xmms_remote_set_volume(rm_gp.xmms_session, 0, 0);

 gettimeofday(&starttime,NULL);

 for(;;) {
   xmms_remote_set_volume(rm_gp.xmms_session, lvl, lvl);
   if ( lvl == 0 ) break;
   lvl--;
   if (xpstat.abortfade) break;
   nanosleep(&reqtime,&acttime);
   if (xpstat.abortfade) break;
  }

 gettimeofday(&endtime,NULL);
 xpval.tickcal = (((((endtime.tv_sec - starttime.tv_sec) * 1000000) + (starttime.tv_usec - endtime.tv_usec)) / 100) - (reqtime.tv_nsec / 1000)) * 1000;
 xmms_remote_set_volume(rm_gp.xmms_session, sllvl, srlvl);
 xpstat.abortfade = FALSE;
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "fade:done\n", 10);
 return NULL;
}

static void *fadevolup()
{
 int llvl;
 int rlvl;
 int lvl;
 float flvl;
 float fspeed = xpval.fadespeed;
 float flevel = xpval.fadelevel;
 struct timespec reqtime;
 struct timespec acttime;
 xpstat.involfade = TRUE;
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "fade:start\n", 11);
 xmms_remote_get_volume(rm_gp.xmms_session, &llvl, &rlvl);
 if ( llvl == rlvl ) {
  lvl = llvl;
 } else {
  if ( llvl > rlvl ) {
   lvl = ((llvl - rlvl) / 2) + rlvl;
  } else {
   lvl = ((rlvl - llvl) / 2) + llvl;
  }
 }
 if (!(lvl > xpval.fadelevel)) {
  reqtime.tv_sec = 0;
  flvl = lvl;
  reqtime.tv_nsec = (1000000000 * (fspeed / (flevel - flvl))) - xpval.tickcal;
  if (reqtime.tv_nsec < 1) reqtime.tv_nsec = 1;
  for(;;) {
   xmms_remote_set_volume(rm_gp.xmms_session, lvl, lvl);
   if ( lvl == xpval.fadelevel ) break;
   lvl++;
   if (xpstat.abortfade) break;
   nanosleep(&reqtime,&acttime);
   if (xpstat.abortfade) break;
   if (xpstat.stopcue) break;
  }
 }
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "fade:done\n", 10);
 xpstat.abortfade = FALSE;
 xpstat.involfade = FALSE;
 return NULL;
}

static void *fadevoldown()
{
 int llvl;
 int rlvl;
 int lvl;
 float flvl;
 float fspeed = xpval.fadespeed;
 struct timespec reqtime;
 struct timespec acttime;
 xpstat.involfade = TRUE;
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "fade:start\n", 11);
 xmms_remote_get_volume(rm_gp.xmms_session, &llvl, &rlvl);
 if ( llvl == rlvl ) {
  lvl = llvl;
 } else {
  if ( llvl > rlvl ) {
   lvl = ((llvl - rlvl) / 2) + rlvl;
  } else {
   lvl = ((rlvl - llvl) / 2) + llvl;
  }
 }
 if (lvl > 0) {
  reqtime.tv_sec = 0;
  flvl = lvl;
  reqtime.tv_nsec = (1000000000 * (fspeed / flvl)) - xpval.tickcal;
  if (reqtime.tv_nsec < 1) reqtime.tv_nsec = 1;
  for(;;) {
   xmms_remote_set_volume(rm_gp.xmms_session, lvl, lvl);
   if ( lvl == 0 ) break;
   lvl--;
   if (xpstat.abortfade) break;
   nanosleep(&reqtime,&acttime);
   if (xpstat.abortfade) break;
   if (xpstat.stopcue) break;
  }
 }
 if (xpipe.spipe[1] != -1) write(xpipe.spipe[1], "fade:done\n", 10);
 xpstat.abortfade = FALSE;
 xpstat.involfade = FALSE;
 return NULL;
}

static void *mainloop()
{
    gchar commandstr[2048];
    gint status;
    gint maxfd;
    gint remain;
    gint fadecal = 0;
    fd_set set;
    struct timeval timeout;

    timeout.tv_sec = 0;
    timeout.tv_usec = 1000;

    xmmstat.session = rm_gp.xmms_session;
    xmmstat.version = xmms_remote_get_version(rm_gp.xmms_session);

    maxfd = quitpipe[0] > xpipe.ipipe[0] ? quitpipe[0] : xpipe.ipipe[0];

    FD_ZERO(&set);
    for(;;) {
	FD_SET(xpipe.ipipe[0], &set);
	FD_SET(quitpipe[0], &set);
	status = select(maxfd + 1, &set, NULL, NULL, &timeout);
	if (status == -1) break;
        if (status) {
	 if (FD_ISSET(quitpipe[0], &set)) {
	     //signal from parent thread to quit
	     break;
	 }
	 if (FD_ISSET(xpipe.ipipe[0], &set)) {
	    status = read(xpipe.ipipe[0], commandstr, 2048);
	    if (status == -1) {
		perror("Read from Pipe Error");
	    } else {
	        strchr(commandstr, '\n')[0] = '\0';
		handle_string(commandstr);
	    }
	 }
	} else {
  	  if (xpipe.spipe[1] != -1) {
 	   printxmmsdata( xpipe.spipe[1] , TRUE );
	  } else {
	   getxmmsdata(NULL);
	  }
	  if (xpval.cuewatching) {
	   if (xpval.cuefade) fadecal = xpval.fadespeed;
	   if (xmmstat.playing && !xmmstat.paused) {
	    remain = (xmmstat.playtime - xmmstat.otime) - ((xpval.cuestoptime + fadecal) + 1);
	    if (remain <= 0) {
	     xpstat.stopcue = FALSE;
	     if (!xpstat.incue) pthread_create(&cst_thread, NULL, cuestop, NULL);
	    }
	   }
	  }
	}
    }
    return NULL;
}

static void init()
{

    gchar *topenfile;

    topenfile = g_strconcat(g_get_home_dir(), "/.xmms/xmmspipe.conf",  NULL);

    xmmspiperead_config(topenfile);

    if (xpipe.ipipestr == NULL) xpipe.ipipestr = g_strconcat("/tmp/xmmspipe-inpipe_",g_get_user_name(),  NULL);
    if (xpipe.opipestr == NULL) xpipe.opipestr = g_strconcat("/tmp/xmmspipe-ackpipe_",g_get_user_name(),  NULL);
    if (xpipe.spipestr == NULL) xpipe.spipestr = g_strconcat("/tmp/xmmspipe-statpipe_",g_get_user_name(),  NULL);
    if (xpipe.idfile == NULL) xpipe.idfile = g_strdup("/tmp/xmms-pipe.id");


    topenfile = g_strdup_printf( "%s.%i", xpipe.ipipestr, rm_gp.xmms_session);

    if(!checkifpipeok(topenfile, &xpipe.ipipe[0],  &xpipe.ipipe[1])) {
     perror("Input pipe error!!");
     free(topenfile);
     exit(1);
    }

   if (xpipe.opipestart) {
    topenfile = g_strdup_printf( "%s.%i", xpipe.opipestr, rm_gp.xmms_session);
    if(!checkifpipeok(topenfile, &xpipe.opipe[0],  &xpipe.opipe[1])) perror("Ack pipe error!!");
    free(topenfile);
   }

   if (xpipe.spipestart) {
    topenfile = g_strdup_printf( "%s.%i", xpipe.spipestr, rm_gp.xmms_session);
    if(!checkifpipeok(topenfile, &xpipe.spipe[0],  &xpipe.spipe[1])) perror("Status pipe error!!");
    free(topenfile);
    xpval.statusmode = 2;
   }

    if (xpipe.setupid) {
     FILE *id;
     id = fopen(xpipe.idfile, "w+");
     fprintf(id, "%s.%i\n", xpipe.ipipestr, rm_gp.xmms_session);
     fclose(id);
    }
    g_free(topenfile);
    pipe(quitpipe);

    pthread_create(&rm_thread, NULL, mainloop, NULL);

}

static void cleanup()
{
    xpstat.abortfade = TRUE;
    write(quitpipe[1], "Q", 1);
    pthread_join(rm_thread, NULL);
    if (xpipe.ipipe[0] != -1) close(xpipe.ipipe[0]);
    if (xpipe.ipipe[1] != -1) close(xpipe.ipipe[1]);
    if (xpipe.opipe[0] != -1) close(xpipe.opipe[0]);
    if (xpipe.opipe[1] != -1) close(xpipe.opipe[1]);
    if (xpipe.spipe[0] != -1) close(xpipe.spipe[0]);
    if (xpipe.spipe[1] != -1) close(xpipe.spipe[1]);
    close(quitpipe[0]);
    close(quitpipe[1]);
    g_free(xpipe.idfile);
    g_free(xpipe.ipipestr);
    g_free(xpipe.opipestr);
    g_free(xpipe.spipestr);
    return;
}

GeneralPlugin *get_gplugin_info(void)
{
    return &rm_gp;
}

gboolean checkifpipeok(char *pipefile, int *pipei, int *pipeo)
{
    int status;
    struct stat stbuf;
    //create the pipe if necessary
    status = mkfifo(pipefile, 0700);
    if (status == -1 && errno != EEXIST) {
        fprintf(stderr, "xmmspipe error: %s mkfifo error\n", pipefile);
	return FALSE;
    }
    //check it's a named pipe
    status = stat(pipefile, &stbuf);
    if (status == -1) {
	fprintf(stderr, "xmmspipe error: %s has stat error\n", pipefile);
	return FALSE;
    }
    if (!S_ISFIFO(stbuf.st_mode)) {
	fprintf(stderr, "xmmspipe error: %s is not a named pipe\n", pipefile);
	return FALSE;
    }
     *pipei = open(pipefile, O_RDONLY | O_NONBLOCK);
     if (*pipei == -1) return FALSE;
     *pipeo = open(pipefile, O_WRONLY | O_NONBLOCK);
     if (*pipeo == -1) return FALSE;

     printf("Init xmmspipe using : %s\n", pipefile );
return TRUE;
}
