--[[-------------------------------------------------------------------
Pocketop Driver

9600 baud, 8N1

Pocketop sends scancode on keydown and scancode & 0x80 on keyup. If
the keyup is the last keyup (there are no more keys down) the keyup
byte is repeated.

-----------

Copyright (c) 2005, David J. Kessler <dkessler@kopsisengineering.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-------------------------------------------------------------------]]--

-- Basic information about this driver
description = "Pocketop IR Keyboard Driver"
version = "0.2"

-- Modifier key information
scancode_fn = 0x3C
scancode_punc = 0x76
scancode_num = 0x6E
scancode_shiftl = 0x65
scancode_shiftr = 0x7D
scancode_caps = 0x77
has_num_lock = 1
has_punc_lock = 0
has_fn_lock = 0

-- Scancode maps
map_normal = {
	   ZK_Q; 0; ZK_Z; 0; 0; 0; ZK_A;
	0; ZK_W; 0; ZK_X; 0; 0; 0; ZK_S;
	0; ZK_E; 0; ZK_C; 0; 0; 0; ZK_D;
	0; ZK_R; 0; ZK_V; 0; 0; 0; ZK_F;
	0; ZK_T; 0; ZK_B; 0; 0; 0; ZK_G;
	0; ZK_Y; 0; ZK_SPACE; 0; 0; 0; ZK_H;
	0; ZK_U; ZK_J; ZK_N; ZK_SPACE; 0; 0; 0;
	0; ZK_I; ZK_K; ZK_M; 0; 0; 0; 0;
	ZK_ACTIVITY; ZK_O; ZK_L; ZK_COMMA; ZK_LEFT; 0; 0; 0;
	ZK_F5; ZK_P; ZK_SEMICOLON; ZK_PERIOD; ZK_DOWN; 0; 0; 0;
	ZK_F6; ZK_MINUS; ZK_APOSTROPHE; ZK_UP; ZK_RIGHT; 0; 0; 0;
	ZK_F7; ZK_BACKSPACE; ZK_RETURN; ZK_DELETE; 0; 0; 0; 0;
	0; 0; 0; 0; 0; ZK_SHIFT; ZK_ALTL; 0;
	0; ZK_TAB; 0; 0; 0; ZK_CONTROLL; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; ZK_SHIFT; 0; 0}
  
map_shift = {
	   0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; ZK_LESS; 0; 0; 0; 0;
	0; 0; ZK_COLON; ZK_GREATER; 0; 0; 0; 0;
	0; ZK_UNDERSCORE; ZK_QUOTEDBL; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0}

map_punc = {
	   ZK_EXCLAIM; 0; 0; 0; 0; 0; ZK_GRAVE;
	0; ZK_AT; 0; 0; 0; 0; 0; ZK_TILDE;
	0; ZK_NUMBERSIGN; 0; 0; 0; 0; 0; ZK_SLASH;
	0; ZK_DOLLAR; 0; 0; 0; 0; 0; ZK_QUESTION;
	0; ZK_PERCENT; 0; 0; 0; 0; 0; ZK_BRACELEFT;
	0; 0; 0; 0; 0; 0; 0; ZK_BRACERIGHT;
	0; ZK_AMPERSAND; ZK_BRACKETLEFT; 0; 0; 0; 0; 0;
	0; ZK_ASTERISK; ZK_BRACKETRIGHT; 0; 0; 0; 0; 0;
	0; ZK_PARENLEFT; ZK_BACKSLASH; 0; 0; 0; 0; 0;
	0; ZK_PARENRIGHT; ZK_BAR; 0; 0; 0; 0; 0;
	0; ZK_PLUS; ZK_EQUAL; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0}

map_num = {
	   ZK_1; 0; 0; 0; 0; 0; 0;
	0; ZK_2; 0; 0; 0; 0; 0; 0;
	0; ZK_3; 0; 0; 0; 0; 0; 0;
	0; ZK_4; 0; 0; 0; 0; 0; 0;
	0; ZK_5; 0; 0; 0; 0; 0; 0;
	0; ZK_6; 0; 0; 0; 0; 0; 0;
	0; ZK_7; ZK_4; 0; 0; 0; 0; 0;
	0; ZK_8; ZK_5; ZK_1; 0; 0; 0; 0;
	0; ZK_9; ZK_6; ZK_2; ZK_PERIOD; 0; 0; 0;
	0; ZK_0; ZK_ASTERISK; ZK_3; ZK_PLUS; 0; 0; 0;
	0; ZK_SLASH; 0; ZK_MINUS; ZK_EQUAL; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0}

map_fn = {
	   0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; ZK_SIDECANCEL;
	0; 0; 0; 0; 0; 0; 0; ZK_DELETE;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; ZK_POWER; ZK_OK; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; ZK_ESCAPE; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0;
	0; 0; 0; 0; 0; 0; 0; 0}

last_keyup = 0

-- Function to convert a byte received from the kb to a scancode
function do_scancode ( s )
	key = s & 0x7f
	if s & 0x80 == 0x80 then
		key_down = 0
	else
		key_down = 1
	end

	-- filter final keyup signal
	if key_down == 0 then
		if key == last_keyup then
			last_keyup = 0
			return 0, key_down
		end
		last_keyup = key;
	end

	return key, key_down
end
