/* PDB2QLX converts the HP 200LX PDB database (phone book) in conjunction
 * with GDBIO so that the output can be used for Quick/LX. This enables
 * an "automatic address completion" feature in email clients such as Post/LX
 * or Goin' Postal.
 *
 * (c) 2003 by Daniel Hertrich http://www.daniel-hertrich.de/pdb2x
 *             Thanks to Grzegorz Wroblewski who helped to debug the program
 * 
 * needed: GDBIO (http://www.palmtop.net/super.html)
 *
 * usage:  prepare phone book file with
 *
 *           GDBIO C:\_DAT\PHONE.PDB > PHONE.CDF
 *
 *         use PHONE.CDF as input file for PDB2QLX and give
 *         two more arguments (described below). Redirect the 
 *         output into a file of your choice (preferrable 
 *         append it to c:\_dat\quick.dat and then run QSYNC):
 * 
 *           PDB2ADR PHONE.CDF E CATEGORY >> c:\_dat\quick.dat
 *           C:\QUICKLX\QSYNC
 *
 *         This will append all email addresses found in the phone book
 *         with the given category to the quick/lx dictionary file.
 *
 *         THE PARAMETERS E, C and CATEGORY:
 *  
 *         E is the number of the column of the CDF file which 
 *           holds the EMAIL ADDRESS of each entry 
 *
 *         C is the number of the column of the CDF file which
 *           holds the CATEGORY of each entry
 *           (set to 0 if you don't need category check)
 *           If you set a category, only entries matching the given
 *           category will be written into the output file. If 
 *           category check is disabled, all found addresses are
 *           processed by PDB2QLX.
 *
 *         CATEGORY: This is the name of the category which you want
 *           PDB2QLX to check for. The category has to be spelled
 *           *exactly* as it is spelled in the phone book, otherwise
 *           PDB2QLX will not recognize it (care about upper- and 
 *           lower case letters etc.). PDB2QLX checks only if the
 *           string given in CATEGORY is equal or A PART OF the category
 *           field of the input file. So if you have for example two
 *           different cagegories "my family" and "my wife's familiy",
 *           and you give "family" as the parameter CATEGORY, PDB2QLX 
 *           will process all entries from these TWO categories.
 *           Or if you have entries matching the categories "business"
 *           and "private", PDB2QLX will process them if you have either
 *           "business" or "private" given as CATEGORY.
 *           Set CATEGORY to "0" if you set C to "0" and don't want 
 *           to use the category check.
 *
 *
 */
 
#define VERSION "2.0"
#define YEAR "2003"
#define TOKLENGTH 80    // maximal length for a token, such as email, phone no, name of phone.cdf
#define LINELENGTH 1024 // maximal length of a line in cdf file
#define SMSNUMLEN 24    // maximal length of SMS phone numbers

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

FILE *fpi;
int EC, CC;
int linecount=0;
char testchar;
char line[LINELENGTH];
char name[TOKLENGTH];
char email[TOKLENGTH];
char phone[TOKLENGTH];
char category[TOKLENGTH];
char *dup, *dup2;

void hello(char *filename, int EC, int CC, char *cat);
void usage (void);
char *extr_cdf_col(char *cdfline, int c);
void makeqlx(int emailcol, int catcol, char *catcomp);

/* MAIN ============================================== */

int main(int argc, char *argv[])
{
  if (argc != 5) usage();

  EC = atoi(argv[2]);
  CC = atoi(argv[3]);

  hello(argv[1], EC, CC, argv[4]);
  
  if ((fpi=fopen(argv[1],"r"))!=NULL)
  {
    makeqlx(EC, CC, argv[4]);
    fclose(fpi);
  }
  else 
  {
    fprintf(stderr,"\n\aError opening input file \"%s\"!\nAbnormal program termination.\n\n",argv[1]);
    return(1);
  }
  return(0);
}



/* HELLO ============================================= */

void hello(char *filename, int EC, int CC, char *cat)
{
  if (filename == NULL)
  {
    filename="NO INPUT FILE NAME GIVEN!";
  }
  fprintf(stderr,"\n*** This is PDB2QLX, Version %s, (c) %s Daniel Hertrich\n",VERSION,YEAR);
  fprintf(stderr,"*** Input CDF file: %s\n",filename);
  fprintf(stderr,"*** Column used for EMAIL: %i \n", EC);
  fprintf(stderr,"*** Category check options: column %i, category %s\n", CC, cat);
  fprintf(stderr,"*** Please wait while processing input file.....\n\n");
}

/* USAGE =========================================== */

void usage (void)
{
  printf("\n*** This is PDB2QLX, Version %s, (c) %s Daniel Hertrich\n",VERSION,YEAR);
  printf("\a\n\nError!\nCall of PDB2QLX: \nPDB2QLX <input CDF file> <E> <C> <CATEGORY> > <output file>\n\n");
  printf("E: Email col, C: Category col.\n");
  printf("See pdb2qlx.c source file for details.\n");
  printf("Are you sure you called PDB2QLX with a CDF file as input? PDB2QLX doesn't\n");
  printf("work with original PDB files, you have to use GDBIO first! See .C file!\n\n");
  exit(1);
}


/* EXTR_CDF_COL ===================================== */
/* give parameters:
      1. copy of a line of a cdf file (made by gdbio)
      2. number of column you want to extract
   get back:
      pointer to string containing string of given column
*/

char *extr_cdf_col(char *cdfline, int c)
{
  static char token[TOKLENGTH];
  char *loc;
  char *temptok = malloc(LINELENGTH*sizeof(char));
  int i = 0;

  temptok[0]=0;
    
  for (i=0; i<c; i++)
  {
    if (i>0) cdfline=loc+3;
    loc=strstr(cdfline,"\",\"");
    if (loc != NULL)
    { 
      strncpy(temptok,cdfline,loc-cdfline);
      temptok[loc-cdfline]='\0';
    }
    else
    {
      fprintf(stderr,"ERROR! Contact Author! loc is NULL!, c is %i\nCDFLINE is: %s\nLINECOUNT: %i\n\a\a",c,cdfline,linecount);
      exit(1);
    }
  }
  strcpy(token,temptok);
  free(temptok);
  return(token);
}


/* MAKEQLX ======================================= */

void makeqlx(int emailcol, int catcol, char *catcomp)
{

  int i;

  while((testchar=fgetc(fpi))!= EOF)
  {
    linecount++;
    fgets(line, LINELENGTH, fpi);
    dup=strdup(line);
    dup2=strdup(line);
    strcpy(category,extr_cdf_col(dup,catcol));
    strcpy(email,extr_cdf_col(line,emailcol));
    free(dup);
    free(dup2);
    if ((strlen(email) > 0) && ((strstr(category, catcomp) != NULL) || catcol==0 ))
    {
      for (i=0; i<strlen(email); i++)
         email[i] = tolower(email[i]);
      printf("%s\n",email);
    }
  }
  
}

