/*****************************************************************************/
/*                                                                           */
/*   program          : POST2MBX.C                                           */
/*                                                                           */
/*   programmer       : D. Hertrich                                          */
/*                                                                           */
/*   date             : 12-JUL-05                                            */
/*                                                                           */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*****************************************************************************/

char *banner = "POST/LX to MBOX file converter 1.1 by D. Hertrich";



void main(int argc, char *argv[])
{
   
   char buf[1024], buf1[1024], *p=NULL, *dot=NULL, *bs=NULL;
   int first = 1;
   int in_header = 1;
   char from[512];
   char date[512];
   char f_out_name[256];

   FILE *f_in = NULL;
   FILE *f_out = NULL;
   FILE *f_temp = NULL;


   printf("%s\n", banner);

   if (argc !=2)
   {
      printf("Usage: POST2MBX infile.i\n\"infile.i\" may be a .i or .o Post/LX mailbox or folder file\n");
      exit(1);
   }

   f_in = fopen(argv[1],"rb");
   if (!f_in)
   {
      printf("ERROR: file %s does not exist\n", argv[1]);
      exit(1);
   }

   fgets(buf, 510, f_in);
   if (!((*buf == '-') && (buf[1] == '') && (buf[2] == '')))
   {
      printf("ERROR: %s is not a valid Post/LX inbox or outbox file!\n", argv[1]);
      exit(1);
   }
   fclose(f_in);
   f_in = fopen(argv[1],"rb");
   

   sprintf(f_out_name,"%s",argv[1]);
   p = f_out_name;
   while (*p)
   {
      p++;
      if ((*p) == '.') dot=p;
      if ((*p) == '\\') bs=p;
   }
   if ((dot && bs && dot > bs) || (dot && !bs)) p = dot;
   strcpy(p, ".mbx");
   
   printf("Output file name: %s\n", f_out_name);

   f_out = fopen(f_out_name,"wb");
   if (!f_out)
   {
      printf("ERROR: file %s could not be opened for writing\n", f_out_name);
      exit(1);
   }


   while (fgets(buf, 510, f_in))
   {

      if ((*buf == '-') && (buf[1] == '') && (buf[2] == ''))
      {
         printf(".");
         fflush(stdout);
         if (!first)
         {
            fclose(f_temp);
            f_temp = fopen("mboxtmp.~~~","rb");

/*         fprintf(f_out,"From %s %s\n", from, date);  */
           fprintf(f_out,"From dummy_post2mbx Thu Jul 14 23:23:36 2005\n");  

            while (fgets(buf1, 510, f_temp))
            {
               if (buf1[strlen(buf1)-2] == '\r')
               {
                  buf1[strlen(buf1)-2] = '\n';
                  buf1[strlen(buf1)-1] = '\0';
               }
               fprintf(f_out, "%s", buf1);
            }
            fclose(f_temp);
            fprintf(f_out, "\n");
         }

         f_temp = fopen("mboxtmp.~~~","wb");
         in_header = 1;



      }


      else
      {
         fprintf(f_temp, "%s", buf);

         if (in_header && !strncmp(buf, "Date: ", 6))
         {
            sprintf(date,"%s",buf);
            p = &date[0];
            while (*p != ' ') p++; p++;
            sprintf(date, "%s",p);
            p = &date[0];
            while (*p) p++; p--; p--; *p = '\0';
         }
         if (in_header && !strncmp(buf, "From: ", 6))
         {
            sprintf(from,"%s",buf);
            p = &from[0];
            while (*p != ' ') p++; p++;
            sprintf(from, "%s",p);
            p = &from[0];
            while (*p) p++; p--; p--; *p = '\0';
         }
         if (strlen(buf) < 3)
         {
            in_header = 0;
         }

      }




      first = 0;
   }

   fclose(f_temp);
   fclose(f_in);
   fclose(f_out);
   remove("mboxtmp.~~~");
   printf("\nDone. File %s written.\n", f_out_name);


}

/*****************************************************************************/
