/* ECHOT
 *
 * (c) 2001 by Daniel Hertrich. http://www.daniel-hertrich.de
 *
 * ECHOT replaces the DOS ECHO command and enhances it with a time stamp
 * for each line.
 *
 * simply use ECHOT similar to ECHO. 
 * Except that the string which shall be displayed MUST be given in
 * double quotes, except it is only one word. If you leave the quotes
 * away, only the first word will be displayed (until the first space).
 *
 * If you need to display a double quote, use the tag \" for it.
 * If you need to display a backslash   , use the tag \\ for it.
 *
 * Every displayed line will contain a time stamp at the beginning. 
 * Consider the line length is increased by 9 characters
 * by the time stamp ("hh:mm:ss ")
 *
 * Example:
 *
 * ECHOT "This line will be displayed by \"echot\""
 *
 * gives:
 *
 * 11:39:05 This line will be displayed by "echot"
 * 
 *
 * Redirecting the output to a text file (appending with ">>") echot can
 * be used to create detailed reports of batch file success / failures
 *
 */
 
#define VERSION "1.0"

#include <stdlib.h>
#include <time.h>

void usage (void);


time_t jetzt;
struct tm *ptr;
char zeit[12];

int main(int argc, char *argv[])
{
  if (argc != 2) usage(); 
  time(&jetzt);
  ptr = localtime(&jetzt);
  strftime(zeit, 80, "%H:%M:%S",ptr);      /* time string */

  printf("%s %s\n",zeit, argv[1]);
  return(0);
}



void usage (void)
{
  printf("\a\n\nECHOT version %s by Daniel Hertrich http://www.daniel-hertrich.de\n\
Use ECHOT this way:\n\
ECHOT \"string to be displayed after timestamp\"\n\n",VERSION);
  exit(1);
}


