#!/system/bin/sh

# Some special case stuff for running under emulation
qemu=`getprop ro.kernel.qemu`
case "$qemu" in
    "1" )
    ifconfig eth0 10.0.2.15 netmask 255.255.255.0 up
    route add default gw 10.0.2.2 dev eth0
    radio_ril=`getprop ro.kernel.android.ril`
    case "$radio_ril" in
        ttyS*) # a modem is emulated as a serial device
            ;;
        *) # no need for the radio interface daemon
            # telephony is entirely emulated in Java
            setprop ro.radio.noril yes
            stop ril-daemon
            ;;
    esac
    setprop net.eth0.dns1 10.0.2.3
    setprop net.gprs.local-ip 10.0.2.15
    setprop ro.radio.use-ppp no
    setprop ro.config.nocheckin yes
    setprop status.battery.state Slow
    setprop status.battery.level 5
    setprop status.battery.level_raw  50
    setprop status.battery.level_scale 9
    stop dund
    stop usbd

    # -Q is a special logcat option that forces the
    # program to check wether it runs on the emulator
    # if it does, it redirects its output to the device
    # named by the androidboot.console kernel option
    # if not, is simply exit immediately
    /system/bin/logcat -Q &
    ;;
esac
